/*
 * 쐬: 2004/01/05
 *
 */
package openolap.viewer.controller;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import openolap.viewer.common.CommonSettings;

/**
 */
public class Controller extends HttpServlet {

	// T[ubg̏
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	// T[ubg̏I
	public void destroy() {
	}

	// HTTPNGXgŎs鏈
	protected void processRequest(
		HttpServletRequest request,HttpServletResponse response) 
		throws ServletException,java.io.IOException {

		// 
		ServletContext context = getServletConfig().getServletContext();
		if ( context.getAttribute("apCommonSettings") == null ) {
			InitializeStatus.initApStatus(context);
		}

		// R[hݒ
		request.setCharacterEncoding("Shift_JIS");


		String page;
		try {
			// ĂяoƖI
			RequestHelper helper = new RequestHelper(request, response, getServletConfig());
			Command command = helper.getCommand();
	
			if (command == null) { throw new IllegalStateException(); }
			if (context == null) { throw new IllegalStateException();	}

			// ƖĂяo
			page = command.execute(helper, (CommonSettings) context.getAttribute("apCommonSettings"));
		} catch(Exception e) {
			e.printStackTrace();
			return;
		}
	
//System.out.println("controller page:" + page);
	
			//NGXgɑΉy[WɃfBXpb`
			if(page != null) {
				dispatch(request,response,page);
			}

	}

	// HTTP GET̏
	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {

		processRequest(request,response);
	}

	// HTTP POST̏
	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws ServletException, IOException {

		processRequest(request,response);
	}

	//	JSPւDispatcher
	protected void dispatch(
		HttpServletRequest request,
		HttpServletResponse response,
		String page) 
		throws ServletException,java.io.IOException {

		RequestDispatcher dispatcher = getServletContext().getRequestDispatcher(page);
		dispatcher.forward(request,response);
	}

}
