/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFGetAxisMemberInfoByAxisIDCommand.java
 *  F
 *
 *  쐬: 2004/02/13
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;

import javax.servlet.ServletException;

import openolap.viewer.Axis;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.DimensionMemberDAO;

/**
 *  NXFGetAxisMemberInfoByAxisIDCommand
 *  F
 */
public class GetAxisMemberInfoByAxisIDCommand implements Command {

	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

		Report report = (Report) helper.getRequest().getSession().getAttribute("report");
		String targetAxisID = (String) helper.getRequest().getParameter("axisID");
		if(Constants.MeasureID.equals(targetAxisID)) {	// oXMLȂ̂ŁAW[ł邱Ƃ͂肦Ȃ
			throw new IllegalArgumentException();
		}

		Axis axis = report.getAxisByID(targetAxisID);

		Connection conn = null;
		DAOFactory daoFactory = DAOFactory.getDAOFactory();

		try {
			conn = daoFactory.getConnection();
	
			helper.getResponse().setContentType("text/xml; charset=Shift_JIS");
			PrintWriter out = helper.getResponse().getWriter();
	
			// XML o
			out.println("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");	// XML wb_
			DimensionMemberDAO dimMemberDAO =  daoFactory.getDimensionMemberDAO(conn);
			dimMemberDAO.outputDimensionMemberAsXML(report, axis , false, out);	// fBVo[Xg

		} catch (SQLException e) {
			e.printStackTrace();
		} catch (Exception e) { 
			e.printStackTrace();
		} finally {
			if(conn != null){
				try {
					conn.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}

		return null;
	}

}
