/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFGetReportHeaderCommand.java
 *  F
 *
 *  쐬: 2004/02/15
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Messages;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.ReportDAO;

/**
 *  NXFGetReportHeaderCommand
 *  F
 */
public class GetReportHeaderCommand implements Command {

	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

			HttpServletRequest request = helper.getRequest();
			HttpSession session = helper.getRequest().getSession();

			String cubeSeq = request.getParameter("cubeSeq");
			String reportId = request.getParameter("seqId");

			if((cubeSeq == null) && (reportId == null) && (session.getAttribute("report") == null) ) { throw new IllegalStateException(); }
			if((cubeSeq != null) && (reportId != null)) { throw new IllegalStateException(); }

			Connection conn = null;
			DAOFactory daoFactory = DAOFactory.getDAOFactory();
			conn = daoFactory.getConnection();

			Report report = null;
			
			try {
				// ReportZbV֓o^
				ReportDAO reportDAO = daoFactory.getReportDAO(conn);
				if(request.getParameter("cubeSeq") != null) {
					report = reportDAO.getInitialReport(cubeSeq, commonSettings);
					session.setAttribute("report",report);
				} else if (request.getParameter("seqId") !=null) {
					report = reportDAO.getExistingReport(reportId, commonSettings);

					// L[u݂Ȃ
					if(report == null) {
						String errorMessage = Messages.getString("GetReportHeaderCommand.cubeNotExistMSG"); //$NON-NLS-1$
						helper.getRequest().setAttribute("errorMessage", errorMessage);
					}

					session.setAttribute("report",report);
				} else {
					if (session.getAttribute("report") != null) {
						report = (Report) session.getAttribute("report");
					} else {
						throw new IllegalStateException();
					}
				}
			} catch (SQLException e) {
				e.printStackTrace();				
			} catch (Exception e) {
				e.printStackTrace();
			}  finally {
				if(conn != null){
					try {
						conn.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
				}
			}


		return "/spread/spreadHeader.jsp";
	}

}
