/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFRegistSelecterInfoCommand.java
 *  F
 *
 *  쐬: 2004/01/09
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import openolap.viewer.Axis;
import openolap.viewer.Dimension;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;
import openolap.viewer.common.StringUtil;
import openolap.viewer.dao.*;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.DimensionDAO;
import openolap.viewer.dao.MeasureMemberDAO;

/**
 *  NXFRegistSelecterInfoCommand
 *  F
 */
public class RegistSelecterInfoCommand implements Command {

	private RequestHelper requestHelper = null;

	// ********** \bh **********

	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException {

			this.requestHelper = helper;

			DAOFactory daoFactory = DAOFactory.getDAOFactory();

			// ̃õZN^ɂiݏAh󋵂XV
			AxisDAO axisDAO = daoFactory.getAxisDAO(null);
			axisDAO.registSelectedMemberAndDrillStat(helper, commonSettings);

			// ̍i/hԂXV
			this.modifyAxisUsedSelecterCondition(helper);

			// fBṼo̕\^CvXV
			DimensionDAO dimensionDAO = daoFactory.getDimensionDAO(null);
			dimensionDAO.registDimensionMemberDispType(helper, commonSettings);

			// W[o[̃W[o[^CvݒXV		
			MeasureMemberDAO measureMemberDAO = daoFactory.getMeasureMemberDAO(null);
			measureMemberDAO.registMeasureMemberType(helper, commonSettings);

			// FݒXV
			ColorDAO colorDAO = daoFactory.getColorDAO(null);
			colorDAO.registColor(helper, commonSettings);

			return "/spread/SelecterFinalize.html";
	}

	// ********** private\bh **********

	// ɑ΂AZN^ɂi݂sꂽA͍i荞ݏ񂪍폜ꂽ(SoIꂽ)ݒ肷
	private void modifyAxisUsedSelecterCondition(RequestHelper helper) {

		HttpServletRequest request = helper.getRequest();
		Report report = (Report)helper.getRequest().getSession().getAttribute("report");		

		String axisID = null;
		for (int i = 0; i < report.getTotalDimensionNumber()+1; i++ ) {	// fBV{P(W[)s

			if (i == report.getTotalDimensionNumber()) {	// W[
				axisID = Constants.MeasureID;
			} else {										// fBV
				axisID = Integer.toString(i+1);				// ID1start̂߁A␳B
			}

			String selectedMemberAndDrillStat = (String)request.getParameter("dim" + axisID);	// NCAg̑MĂp[^擾
			ArrayList selectedMemberAndDrillStatList = StringUtil.splitString(selectedMemberAndDrillStat,",");
			Axis axis = report.getAxisByID(axisID);


			// ȏo߂
			int memberCount = 0;
			if (axisID == Constants.MeasureID) {
				memberCount = report.getTotalMeasureMemberNumber();
			} else {
				Connection conn = DAOFactory.getDAOFactory().getConnection();
				try {
					memberCount = DAOFactory.getDAOFactory().getDimensionMemberDAO(conn).getDimensionMemberNumber((Dimension)axis);
				} catch (SQLException e) {
					e.printStackTrace();
				} catch (Exception e) { 
					e.printStackTrace();
				} finally {
					if (conn != null) {
						try {
							conn.close();
						} catch (SQLException e) {
							e.printStackTrace();
						}
					}
				}
			}

			if (memberCount > selectedMemberAndDrillStatList.size()) {
				axis.setUsedSelecter(true);				// ɑ΂ăZN^ōi/hԂ̍XVsꂽ
			} else if (memberCount == selectedMemberAndDrillStatList.size()) {
				axis.setUsedSelecter(false);
			} else {
				throw new IllegalStateException();
			}

		}

	}

}
