/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFCellDataSQL.java
 *  F
 *
 *  쐬: 2004/02/01
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

import openolap.viewer.MeasureMember;
import openolap.viewer.Report;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;
import openolap.viewer.common.StringUtil;

/**
 *  NXFCellDataSQL
 *  F
 */
public class CellDataSQL {

	// ̃fBVɑΉFacte[ũJA擾ΏۃW[Xg
	private ArrayList colFactKeyColumnList = new ArrayList();			// 
	private ArrayList rowFactKeyColumnList = new ArrayList();			// s
	private ArrayList pageFactKeyColumnList = new ArrayList();		// y[W

	// Facte[u
	private String factTableName = null;

	// Facte[ũJKeyƂA̎Ŏ擾ΏۂƂȂ郁oUNameValueɎ
	private LinkedHashMap colWhereClauseMap = new LinkedHashMap();	// 
	private LinkedHashMap rowWhereClauseMap = new LinkedHashMap();	// s
	private LinkedHashMap pageWhereClauseMap = new LinkedHashMap();	// y[W

	// W[y[WGbWɂƂ̃ftHgo(UName)
	private String measureDefaultMember = null;


	// ********** static \bh **********

	// SQL  
	public static CellDataSQL getSelectReportDataSQL(Report report, Connection conn, Object[] items, Object[] selectKeys, boolean formatValue, CommonSettings commonSettings) {

		CellDataSQL cellDataSQL = new CellDataSQL();

		int i;
		int j;
		int k;
		StringTokenizer st;


		// t@Nge[uݒ
		cellDataSQL.setFactTableName(DAOFactory.getDAOFactory().getCubeDAO(null).getFactTableName(report.getCube().getCubeSeq()));

		
		String[] edgeAxisInfoList;		// GbW̎i[IuWFNg
		String axisID;					// ID
		String tmpItemValuePair[];		// e[uIDKEYi[z
										// Y0Fe[uIDAY1FKEY

		String measureMemberKey = "";	// 擾ɐݒ肷郁W[Key
		String meaIndex = "";			// W[Index
		int selectedMeasureNum = 1;	// f[^擾ΏۂƂȂ郁W[̃o
	
		for ( i = 0; i < items.length; i++ ) {	// GbW̐s
			edgeAxisInfoList = (String[])items[i];
			for ( j = 0; j < edgeAxisInfoList.length; j++ ) {	//GbWɔzuꂽs
				if ( i == 2 ) {	
				// y[WGbW̏ꍇ
				// tmpHieItems̔z̊evf́Ae[uIDKEYȂB
				// j<ID>:<KEY> 
				// 	F̏ꍇj     1:0
				// 	FW[̏ꍇj 16:<UNAME>(1`50)
					st = new StringTokenizer(edgeAxisInfoList[j],":");
					tmpItemValuePair = new String[st.countTokens()];
					k = 0;
					while ( st.hasMoreTokens() ) {
						tmpItemValuePair[k] = st.nextToken();
						k++;
					}
					axisID      		= tmpItemValuePair[0];	// ID
					measureMemberKey 	= tmpItemValuePair[1];	// o[KEY
					selectedMeasureNum 	= 1;
				} else {		// sEGbW̏ꍇ
					axisID = edgeAxisInfoList[j];
					selectedMeasureNum = report.getTotalMeasureMemberNumber();	// L[u̎SW[
				}
	
				if ( Constants.MeasureID.equals(axisID) ) {	// W[
					String measureLists = "";	// W[Xg
					for ( k = 0; k < selectedMeasureNum; k++ ) {
						if ( i == 2 ) {
							meaIndex = measureMemberKey.substring(measureMemberKey.indexOf("_") + 1, measureMemberKey.length());
	
							if ( (meaIndex.length() == 2) && (meaIndex.substring(0,1).equals("0") ) ) {
								meaIndex = meaIndex.substring(1,2);
							}
	
							// (y[Wɔzuꂽꍇ)W[̃ftHgoo^
							cellDataSQL.setMeasureDefaultMember(meaIndex);
	
						} else {
							meaIndex = Integer.toString(k+1);
						}
						MeasureMember measureMember = (MeasureMember) report.getMeasure().getAxisMemberByUniqueName(meaIndex);
						if ( measureMember.isSelected() ) {	// ZN^ł͂ĂȂȂ
							if ( measureLists != "" ) {
								measureLists += ",";
							}

							String measureString = null;
							if (formatValue) { // ltH[}bgtŎ擾
								measureString = StringUtil.regReplaceAll("%measure%", "MEASURE[" + meaIndex + "]", measureMember.getMeasureMemberType().getFunction_name());
							} else { // lPʃtH[}bĝ݂Ŏ擾
								String unitFunctionID = measureMember.getMeasureMemberType().getUnitFunctionID();
								measureString = StringUtil.regReplaceAll("%measure%", "MEASURE[" + meaIndex + "]", commonSettings.getMeasureMemberTypeByID(unitFunctionID).getFunction_name());
							}
							measureLists += measureString + " as measure_" + meaIndex;

						}
					}

					// SELECT
					cellDataSQL.addFactKeyColumnList(i, measureLists);

				} else {	// fBV

					String factKeyColumn = "";

					// ZNg
					if ( Integer.valueOf(axisID).intValue() < 10 ) {
						factKeyColumn = "DIM_0" + axisID;
					} else {

						factKeyColumn = "DIM_"  + axisID;
					}
					cellDataSQL.addFactKeyColumnList(i, factKeyColumn);
	
					// WHERE
					if ( i == 2 ) {// y[WGbW
						ArrayList tmpList = new ArrayList();
						tmpList.add(measureMemberKey);
						cellDataSQL.putWhereClauseMap(i, factKeyColumn, tmpList);

					} else {		// sAGbW
						String[] selectEdgeKeys = (String[])selectKeys[i];		// Iꂽo[Xg̏W(GbWP)
						String   selectAxisKeys = selectEdgeKeys[j];			// Iꂽo[Xg
						cellDataSQL.putWhereClauseMap(i, factKeyColumn, StringUtil.splitString(selectAxisKeys,","));

					}
				}
			}
		}
		
		return cellDataSQL;
	}

	// ********** \bh **********

	public String getSQLString() {

		// SELECTóifBV{W[j
		// W[̍i݂͂Ŕf
		String SQL = "SELECT ";

		SQL += StringUtil.joinList(this.getColFactKeyColumnList(), ",");
		SQL += "," + StringUtil.joinList(this.getRowFactKeyColumnList(), ",");
		if (pageFactKeyColumnList.size()>0) {
			SQL += "," + StringUtil.joinList(this.getPageFactKeyColumnList(), ",");
		}

		SQL += " FROM ";
		SQL += getFactTableName();

		// WHEREóifBV̂݁j
		SQL += " WHERE ";

		SQL += this.getWhereClause(this.getColWhereClauseMap());
		if (colWhereClauseMap.size()>0) { // COLɃfBVzuĂ
			if (rowWhereClauseMap.size()>0) {	// ROWɃfBVzuĂ
				SQL += " and ";
			}
		}
		SQL += this.getWhereClause(this.getRowWhereClauseMap());

		if (pageWhereClauseMap.size()>0) {	// y[WɎzuĂȂꍇ
				SQL += " and ";
			SQL += this.getWhereClause(this.getPageWhereClauseMap());
		}
		
		return SQL;
	}

	// t@Nge[ufBVe[uփ}bsOĴ̃Xg(J}؂̕)GbWƂɎ擾
	// ȂAW[͏O
	// return)
	//   string[0]:GbW̃JXg(String,J}؂)
	//   string[1]:GbW̃JXg(String,J}؂)
	//   string[2]:y[WGbW̃JXg(String,J}؂)

	public String[] getDimsFactKeyColumnList() {
		String axesFactKeyColumnList[] = new String[3];
		axesFactKeyColumnList[0] = StringUtil.joinList(StringUtil.exceptElement(colFactKeyColumnList, "MEASURE"), ",");
		axesFactKeyColumnList[1] = StringUtil.joinList(StringUtil.exceptElement(rowFactKeyColumnList, "MEASURE"), ",");
		axesFactKeyColumnList[2] = StringUtil.joinList(StringUtil.exceptElement(pageFactKeyColumnList, "MEASURE"), ",");
		
		return axesFactKeyColumnList;
	}



	// ********** private\bh **********

	private String getWhereClause(LinkedHashMap edgeWhereClauseMap) {
		
		String edgeWhereClause = "";
		
		Iterator iter = edgeWhereClauseMap.keySet().iterator();
		int i = 0;
		while (iter.hasNext()) {
			if(i>0) {
				edgeWhereClause += " and ";
			}
			String factKeyColumn = (String) iter.next();
			edgeWhereClause += factKeyColumn + " in (";

			ArrayList memberKeyList = (ArrayList) edgeWhereClauseMap.get(factKeyColumn);
			edgeWhereClause += StringUtil.joinList(memberKeyList, ",");
			edgeWhereClause += ")";

			i++;
		}
		
		return edgeWhereClause;
	}




	// ********** Setter \bh **********
	public void addFactKeyColumnList(int edgePositionID, String factKeyColumn) {
		if (edgePositionID==0) {
			this.colFactKeyColumnList.add(factKeyColumn);
		} else if (edgePositionID==1){
			this.rowFactKeyColumnList.add(factKeyColumn);
		} else if (edgePositionID==2){
			this.pageFactKeyColumnList.add(factKeyColumn);
		} else {
			throw new IllegalArgumentException();
		}
	}

	public void addColFactKeyColumnList(String factKeyColumn) {
		this.colFactKeyColumnList.add(factKeyColumn);
	}
	public void addRowFactKeyColumnList(String factKeyColumn) {
		this.rowFactKeyColumnList.add(factKeyColumn);
	}
	public void addPageFactKeyColumnList(String factKeyColumn) {
		this.pageFactKeyColumnList.add(factKeyColumn);
	}
	public void setFactTableName(String string) {
		this.factTableName = string;
	}
	public void putWhereClauseMap(int edgePositionID, String factKeyColumn, ArrayList memberKeyList) {
		if (edgePositionID == 0){
			this.colWhereClauseMap.put(factKeyColumn, memberKeyList);
		} else if (edgePositionID == 1) {
			this.rowWhereClauseMap.put(factKeyColumn, memberKeyList);
		} else if (edgePositionID == 2) {
			this.pageWhereClauseMap.put(factKeyColumn, memberKeyList);
		} else {
			throw new IllegalArgumentException();
		}
	}
	public void putColWhereClauseMap(String factKeyColumn, ArrayList memberKeyList) {
		this.colWhereClauseMap.put(factKeyColumn, memberKeyList);
	}
	public void putRowWhereClauseMap(String factKeyColumn, ArrayList memberKeyList) {
		this.rowWhereClauseMap.put(factKeyColumn, memberKeyList);
	}
	public void putPageWhereClauseMap(String factKeyColumn, ArrayList memberKeyList) {
		this.pageWhereClauseMap.put(factKeyColumn, memberKeyList);
	}
	public void setMeasureDefaultMember(String string) {
		measureDefaultMember = string;
	}


	// ********** Getter \bh **********
	public ArrayList getColFactKeyColumnList() {
		return colFactKeyColumnList;
	}
	public LinkedHashMap getColWhereClauseMap() {
		return colWhereClauseMap;
	}
	public String getFactTableName() {
		return factTableName;
	}
	public ArrayList getPageFactKeyColumnList() {
		return pageFactKeyColumnList;
	}

	public LinkedHashMap getPageWhereClauseMap() {
		return pageWhereClauseMap;
	}
	public ArrayList getRowFactKeyColumnList() {
		return rowFactKeyColumnList;
	}
	public LinkedHashMap getRowWhereClauseMap() {
		return rowWhereClauseMap;
	}
	public String getMeasureDefaultMember() {
		return measureDefaultMember;
	}


}
