/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFDAOFactory.java
 *  F
 *
 *  쐬: 2004/01/06
 */
package openolap.viewer.dao;

import java.sql.Connection;

import openolap.viewer.Axis;
import openolap.viewer.common.Messages;

/**
 *  NXFDAOFactory
 *  F
 */
public abstract class DAOFactory {

	public abstract Connection getConnection();

	public abstract DimensionDAO getDimensionDAO(Connection conn);
	public abstract MeasureDAO getMeasureDAO(Connection conn);
	public abstract MeasureMemberDAO getMeasureMemberDAO(Connection conn);
	public abstract ReportDAO getReportDAO(Connection conn);
	public abstract CubeDAO getCubeDAO(Connection conn);
	public abstract AxisLevelDAO getAxisLevelDAO(Connection conn);
	public abstract DimensionMemberDAO getDimensionMemberDAO(Connection conn);
	public abstract CellDataDAO getCellDataDAO(Connection conn);
	public abstract MeasureMemberTypeDAO getMeasureMemberTypeDAO(Connection conn);
	public abstract AxisDAO getAxisDAO(Connection conn);
	public abstract AxisMemberDAO getAxisMemberDAO(Connection conn);
	public abstract AxisMemberDAO getAxisMemberDAO(Connection conn, Axis axis);
	public abstract ColorDAO getColorDAO(Connection conn);
	public abstract UserDAO getUserDAO(Connection conn); 
	

	public static DAOFactory getDAOFactory() {
		String sourceName = Messages.getString("DAOFactory.sourceName"); //$NON-NLS-1$
		if (sourceName.equals("postgreSQL")) { //$NON-NLS-1$
			return new PostgresDAOFactory();
		} else {
			throw new UnsupportedOperationException();
		}		
	}


	
}
