/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresCubeDAO.java
 *  F
 *
 *  쐬: 2004/01/08
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import openolap.viewer.Cube;

/**
 *  NXFPostgresCubeDAO
 *  F
 */
public class PostgresCubeDAO implements CubeDAO {

	Connection conn = null;

	// ********** RXgN^ **********
	PostgresCubeDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	public String getFactTableName(String cubeSeq) {
		String factTableName = "v_CUBE_" + cubeSeq;
		return factTableName;
	}
	
	public Cube getCubeByID(String cubeSeq) throws SQLException {
		String cubeName = this.getCubeName(cubeSeq);
		Cube cube = new Cube(	cubeSeq,					// cubeSeq
								cubeName);					// cubeName		
		return cube;
	}
	
	
	public String getCubeName(String cubeSeq) throws SQLException {

		String cubeName = null;

		String SQL = "";
		Statement stmt = null;
		ResultSet rs = null;
		SQL =   "";
		SQL +=	" select ";
		SQL +=	"    NAME ";
		SQL +=	" from ";
		SQL +=	"    oo_cube ";
		SQL +=	" where ";
		SQL +=	"    cube_seq = " + cubeSeq;

		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(SQL);

			while ( rs.next() ) {
				cubeName = rs.getString("NAME");
			}

		} catch (SQLException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}
//System.out.println(cubeName);
		return cubeName;
	}

}
