/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.export
 *  t@CFExportReport.java
 *  F
 *
 *  쐬: 2004/01/31
 */
package openolap.viewer.export;

import java.util.ArrayList;

import openolap.viewer.Axis;
import openolap.viewer.Edge;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;

/**
 *  NXFExportReport
 *  F
 */
public abstract class ExportReport {

	public abstract String exportReport(RequestHelper helper);


	// ********** protected\bh **********	

	/**
	 * @param edge
	 * @param axis
	 * @param rowIndex
	 * @return
	 */
	protected boolean isPrintPoint(Edge edge, Axis axis, int rowIndex) {
		Integer nextComboNums = edge.getNextAxesMembersComboNums(axis);
		
		if (nextComboNums == null) {// ŏIȉꍇAɕ\Ώ
			return true;
		} else { // ŏIiȊȌꍇ
			if ( (rowIndex % nextComboNums.intValue() == 0)) {//Z̐擪Index
				return true;
			} else {
				return false;			
			}
		}
	}

	// sE񃁃õZ߂
	protected int getCellMergeNum(Edge edge, Axis axis) {

		Integer cellMergeNumber = edge.getNextAxesMembersComboNums(axis);
//System.out.println(colMergeNumber);		
		int mergeNum;
		if (cellMergeNumber != null) {
			mergeNum = cellMergeNumber.intValue()-1;
		} else {
			mergeNum = 0;									
		}
		
		return mergeNum;
	}

	protected int getNextSpreadIndex(Edge edge, Axis axis, int x) {
		
		Integer cellMergeNumber = edge.getNextAxesMembersComboNums(axis);
//System.out.println(colMergeNumber);		
		int mergeNum;
		if (cellMergeNumber != null) {
			mergeNum = cellMergeNumber.intValue();
		} else {
			mergeNum = 1;									
		}
		
		return ( x + mergeNum );
		
	}

	// 񃁃ǒJԂ߂
	protected int getBeforeComboNum(Edge edge, Axis axis) {
		
		Integer axisMemRepeatNumber = edge.getBeforeAxesMembersComboNums(axis);
//System.out.println(axisMemRepeatNumber);
		int axisMemRepeatNum;
		if (axisMemRepeatNumber != null) {
			axisMemRepeatNum = axisMemRepeatNumber.intValue();
		} else {
			axisMemRepeatNum = 1;	// 0ȉꍇAxJԂ
		}
		return axisMemRepeatNum;
	}

	/**
	 * w肳ꂽi̎oΏہi\ΏۊOjǂmFB
	 * O̍s/ɔzuꂽoKey̑gݍ킹ƎKey̑gݍ킹rA
	 * w肳ꂽiтʂ̒iKeyقȂꍇ͕\ΏہAꍇ͕\ΏۊOƂ
	 * @param beforeKeys
	 * @param keys
	 * @param hieIndex
	 * @return
	 */
	protected boolean isJoinMember(String beforeKeys, String keys, int hieIndex) {

		if (beforeKeys == null) {
			return false;
		}

		ArrayList keyList = StringUtil.splitString(keys, ";");
		ArrayList beforeKeyList = StringUtil.splitString(beforeKeys, ";");

		for (int i = 0; i < hieIndex+1; i++) {	// w肳ꂽiт̏iKey͓mF
			String key = (String) keyList.get(i);
			String beforeKey = (String) beforeKeyList.get(i);
			if (!key.equals(beforeKey)){
				return false;
			}
		}
		return true;
	}

}
