/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.export
 *  t@CFExportReportAsCSV.java
 *  FCSV`Ń|[gGNX|[gNXłB
 *
 *  쐬: 2004/01/31
 */
package openolap.viewer.export;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;

import openolap.viewer.Axis;
import openolap.viewer.AxisMember;
import openolap.viewer.CellData;
import openolap.viewer.Col;
import openolap.viewer.Report;
import openolap.viewer.Row;
import openolap.viewer.common.Constants;
import openolap.viewer.common.Messages;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.manager.CellDataManager;

/**
 *  NXFExportReportAsCSV
 *  FCSV`Ń|[gGNX|[gNXłB
 */
public class ExportReportAsCSV extends ExportReport {

	/**
	 * GNX|[gsA_E[hy[W̃pX߂B
	 * @param helper RequestHelperIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 */
	public String exportReport(RequestHelper helper) {

		HttpServletRequest request = helper.getRequest();
		Report report = (Report) helper.getRequest().getSession().getAttribute("report");
		if (report==null) {
			throw new IllegalStateException();
		}

		// t@CpXAt@CURLݒ
		String dirPath = helper.getConfig().getServletContext().getRealPath("/") + "export";
		String fileName = "report" + request.getSession().getId() + ".csv";
		String filePath = dirPath + "/" + fileName;
		String fileURL = request.getContextPath() + "/" + Messages.getString("ExportReportAsCSV.exportTmpDir") + "/" + fileName; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		helper.getRequest().setAttribute("downloadURL", fileURL);

		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		Connection conn = null;
		conn = daoFactory.getConnection();

		FileOutputStream fs = null;
		OutputStreamWriter osw = null;
		PrintWriter out = null;

		try {

			// =============== ʏ擾 ===============

			// sEɔzuꂽSDimensionIuWFNgDimensionMemberIuWFNgZbg
			report.setSelectedCOLROWDimensionMembers(helper, report, conn);

			// Zf[^(l̓tH[}bgt)擾
			ArrayList cellDataList = CellDataManager.selectCellDatas(helper, conn, true);
			// Zf[^e[u`Ƀ\[g
			TreeMap dataRowMap = CellDataManager.getCellDataTable(report, cellDataList);

			// GbW
			Col col = (Col) report.getEdgeByType(Constants.Col);
			Row row = (Row) report.getEdgeByType(Constants.Row);
			
			// GbW̎Xg
			ArrayList colAxesList = col.getAxisList();
			ArrayList rowAxesList = row.getAxisList();
			ArrayList pageAxesList = report.getEdgeByType(Constants.Page).getAxisList();

			// o[
			ArrayList colAxisMembersList = new ArrayList();
			ArrayList rowAxisMembersList = new ArrayList();


			String colIndexKeysString = (String)request.getSession().getAttribute("viewColIndexKey_hidden");
			String rowIndexKeysString = (String)request.getSession().getAttribute("viewRowIndexKey_hidden");

			// =============== CSVt@CJn ===============
			fs = new FileOutputStream(filePath, false);	//̃t@CꍇA㏑
			osw = new OutputStreamWriter(fs,"Shift_JIS");
			out = new PrintWriter(new BufferedWriter(osw));


			// =============== CSVo͊Jn ===============

			// |[g^Cg
			out.println(report.getReportName());

			// y[WGbW, y[WGbWftHgo[
			String pageAxisName = ",";
			String memberName = "Io[,";
			Iterator pageIt = pageAxesList.iterator();
			int i = 0;
			int j = 0;
			int k = 0;
			while (pageIt.hasNext()) {
				if(i>0){
					pageAxisName += ",";
					memberName += ",";
				}
				Axis axis = (Axis) pageIt.next();
				pageAxisName += axis.getName();
				memberName += axis.getDefaultMemberName(conn);
				i++;
			}
			out.println(pageAxisName);
			out.println(memberName);

			out.println();	// s

			// wb_̎Xg
			String colAxisName = null;
				colAxisName = StringUtil.addString("","first",rowAxesList.size(),",");
			Iterator colIt = colAxesList.iterator();
			i = 0;
			while (colIt.hasNext()) {
				if (i>0) {
					colAxisName += ",";
				}
				Axis axis = (Axis) colIt.next();
				colAxisName += axis.getName();
				i++;
			}
			out.println(colAxisName);

			// NXwb_Awb_o

			// swb_̎Xg
			String rowAxisName = "";
			Iterator rowIt = rowAxesList.iterator();
			i = 0;
			while (rowIt.hasNext()) {
				if (i>0) {
					rowAxisName += ",";
				}
				Axis axis = (Axis) rowIt.next();
				rowAxisName += axis.getName();
				i++;
			}

			colIt = colAxesList.iterator();
			i = 0;
			while (colIt.hasNext()) {
				Axis colAxis = (Axis) colIt.next();
				int colMergeNum = getCellMergeNum(col, colAxis)+1;	// ZZ̐

				// ===== NXwb_ =====
				if (i == (colAxesList.size()-1)) {	// ŏIȉꍇA^Cg\
						out.print(rowAxisName);
				} else {
					out.print(StringUtil.addString("", "first", rowAxesList.size()-1, ","));
				}

				// ===== wb_(o[o) =====

				// SpreadIndex̏Ń\[g
				TreeMap colIndexKeyMap = new TreeMap();
				ArrayList colIndexKeyList = StringUtil.splitString(colIndexKeysString, ",");
				Iterator colIndexKeyIt = colIndexKeyList.iterator();

				while (colIndexKeyIt.hasNext()) {
					String colIndexKey = (String) colIndexKeyIt.next();
					ArrayList colIndexKeys = StringUtil.splitString(colIndexKey, ":");
					String index = (String) colIndexKeys.get(0);
					Integer ind  = Integer.decode(index);
					String keys = (String) colIndexKeys.get(1);
					colIndexKeyMap.put(ind, keys);
				}

				Iterator colIndexKeyMapIt = colIndexKeyMap.keySet().iterator();

				String beforeKey = null;
				String beforeKeys = null;
				int mergeNum = 0;
				j = 0;
				while (colIndexKeyMapIt.hasNext()) {

					Integer index = (Integer) colIndexKeyMapIt.next();
					String keys = (String) colIndexKeyMap.get(index);

					ArrayList keyList = StringUtil.splitString(keys, ";");
					String key = (String) keyList.get(i);

					if (isJoinMember(beforeKeys, keys, i)) {
						mergeNum++;
					} else {

						if ( j != 0 ) {
//System.out.println(i + "," + j + "," + colAxis.getAxisMemberByUniqueName(beforeKey).getSpecifiedDisplayName(colAxis) + mergeNum);

							out.print(",");
							out.print("\"" + colAxis.getAxisMemberByUniqueName(beforeKey).getSpecifiedDisplayName(colAxis) + "\"");
							out.print(StringUtil.addString("", "first", mergeNum, ",")); // Z̕̕","o

						}

						beforeKey = key;
						beforeKeys = keys;
						mergeNum = 0;
					}

					j++;
				}

				// Ō̗vf\
				if (j > 0) { // wb_̗vfȏ㑶݂
					out.print(",");
				}

				out.print("\"" + colAxis.getAxisMemberByUniqueName(beforeKey).getSpecifiedDisplayName(colAxis) + "\"");
				out.print(StringUtil.addString("", "first", mergeNum, ",")); // Z̕̕","o

				// so͂̏I^O
				out.println();
				i++;
			}

	
			// ===== swb_(o[)Af[^Z(l)o =====

			// SpreadIndex̏Ń\[g
			TreeMap rowIndexKeyMap = new TreeMap();
			ArrayList rowIndexKeyList = StringUtil.splitString(rowIndexKeysString, ",");
			Iterator rowIndexKeyIt = rowIndexKeyList.iterator();

			while (rowIndexKeyIt.hasNext()) {
				String rowIndexKey = (String) rowIndexKeyIt.next();
				ArrayList rowIndexKeys = StringUtil.splitString(rowIndexKey, ":");
				String index = (String) rowIndexKeys.get(0);
				Integer ind  = Integer.decode(index);
				String keys = (String) rowIndexKeys.get(1);
				rowIndexKeyMap.put(ind, rowIndexKey);
			}

			// ArrayListɎ
			Iterator rowIndexKeyMapIt = rowIndexKeyMap.keySet().iterator();
			ArrayList sortedIndexKeyList = new ArrayList();
			while (rowIndexKeyMapIt.hasNext()) {
				Integer ind = (Integer) rowIndexKeyMapIt.next();
				sortedIndexKeyList.add( rowIndexKeyMap.get(ind));
			}


			Iterator rowIndexIt = sortedIndexKeyList.iterator();
			String beforeKeys = null;
			int rowIndex = 0;
			while (rowIndexIt.hasNext()) {
				String rowIndexKey = (String) rowIndexIt.next();
				ArrayList rowIndexKeys = StringUtil.splitString(rowIndexKey, ":");
				String index = (String) rowIndexKeys.get(0);
				Integer ind  = Integer.decode(index);
				String keys = (String) rowIndexKeys.get(1);
				ArrayList keyList = StringUtil.splitString(keys, ";");

				// swb_[o
				for (i = 0; i < rowAxesList.size(); i++ ){

					if (!this.isJoinMember(beforeKeys, keys, i)) { 
						Axis rowAxis = (Axis) rowAxesList.get(i);
						String key = (String) keyList.get(i);
						AxisMember axisMember = (AxisMember) rowAxis.getAxisMemberByUniqueName(key);

						out.print("\"" + axisMember.getSpecifiedDisplayName((Axis)rowAxesList.get(i)) + "\"");
						out.print(","); // ̃ZƂ̋؂ii̍swb_o[Z̓f[^e[uZj
					} else {
						out.print(","); // ̃Z͌ΏۂƂȂZłÂ͕\ȂA؂蕶͏o͂
					}
				}

				// f[^e[uo
				this.printDataRow(dataRowMap, rowIndex, out);

				beforeKeys = keys;
				rowIndex++;
			}
			
			// s
			out.println();

			out.flush();
			osw.flush();
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {

			if (fs != null) {
				try {
					fs.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}

			if (conn != null) {
				try {
					conn.close();
				} catch (SQLException e1) {
					e1.printStackTrace();
				}
			}

		}

		// ꎞۑfBVo[폜
		report.clearDimensionMembers();
		return "/spread/downloadAct.jsp";

	}

	// ********** private\bh **********

	/**
	 * f[^e[uso͂
	 * @param dataRowMap f[^s킷MapIuWFNg
	 * @param newRowIndex o͂̃CfbNX
	 * @param out PrintWriter킷IuWFNg
	 */
	private void printDataRow(TreeMap dataRowMap, int newRowIndex, PrintWriter out) {

		// 擾ΏۂƂȂs̃NCAgłSpreadIndex̒lƁA擾ΏۂƂȂsɑ΂āAʔԂŐUIndexϊ
		ArrayList oldRowIndex = new ArrayList(dataRowMap.keySet());
		TreeMap dataCellMap = (TreeMap) dataRowMap.get(oldRowIndex.get(newRowIndex));
		Iterator dataCellIt = dataCellMap.keySet().iterator();
		int i = 0;
		while (dataCellIt.hasNext()) {
			Integer colIndex = (Integer) dataCellIt.next();
			String value = "\"" + ( (CellData)dataCellMap.get(colIndex) ).getValue() + "\"";

			if (i>0) {
				out.print(",");
			}
			out.print(value);
			i++;
		}
		// s
		out.println();
	}

}
