
// ============== ʊ֐ =========================================================================
// =================================================================================================
// =================================================================================================

	// @|[g擾\bh@

	// swb_Awb_̎ID߂
	// <Input>	hieIndex:	swb_Awb_̃CfbNX(0start)
	// <Input>	target:		swb_Awb_
	// <Output>	w肳ꂽꏊɔzuĂ鎲ID
	function getHieID( hieIndex, target ) {
		if ( ( hieIndex == null ) || ( target == null ) ) { return null; }
		if ( ( target != "COL" ) && ( target != "ROW" ) ) { return null; }

		var idList;
		if ( target == "COL" ) {
			idList = document.SpreadForm.colEdgeIDList_hidden.value.split(",");
		} else if ( target == "ROW" ) {
			idList = document.SpreadForm.rowEdgeIDList_hidden.value.split(",");
		}

		return idList[hieIndex];
	}

	// GbW̎߂
	// <Input>	targetString:swb_wb_(COLROWPAGE)
	// <Output>	w肳ꂽwb_ɔzuꂽ̐Ԃ
	function getHeaderObjNum( targetString ) {
		if ( targetString == "COL" ) {
			return colObjNum;
		} else if ( targetString == "ROW" ) {
			return rowObjNum;
		} else if ( targetString == "PAGE" ) {
			var pageAxisCount = 0;
			var pageAxisIDs = getAxisIdListInEdge( targetString, axesXmlData );
			if (pageAxisIDs != null) {
				var pageAxisIDArray = pageAxisIDs.split(",");
				pageAxisCount = pageAxisIDArray.length;
			}
			return pageAxisCount;
		} else {
			return null;
		}
	}

	// GbW̎IDXg߂
	// <Input>	edgeType:GbW̃^Cv("COL","ROW","PAGE")
	// <Input>	axesXmlData:|[gXML
	// <Output>	w肳ꂽGbWɔzuĂ鎲IDXg(J}؂,iindex)
	function getAxisIdListInEdge( edgeType, axesXmlData ) {
		if ( ( edgeType != "COL" ) && ( edgeType != "ROW" ) && ( edgeType != "PAGE" ) ) {
			return "";
		}
		if ( axesXmlData == null ) { return ""; }

		var axisIDString = "";
		var axisIDs = axesXMLData.selectNodes("/root/OlapInfo/AxesInfo/" + edgeType + "/HierarchyID")
		for ( i = 0; i < axisIDs.length ; i++ ) {
			if ( i > 0 ) {
				axisIDString += ","
			}
			axisIDString += axisIDs[i].text;
		}

		return axisIDString;
	}

	// GbW߂
	// <Input>	axisID:ID
	// <Output>	w肳ꂽzuĂGbŴ̖ԂB
	function getAxisPosition(axisID) {
		if (axisID == null) { return null; }

		var colEdgeAxisList = getAxisIdListInEdge("COL", axesXmlData);
		var colEdgeAxisArray = colEdgeAxisList.split(",");
		for (var i = 0; i < colEdgeAxisArray.length; i++) {
			if (colEdgeAxisArray[i] == axisID) {
				return "COL";
			}
		}

		var rowEdgeAxisList = getAxisIdListInEdge("ROW", axesXmlData);
		var rowEdgeAxisArray = rowEdgeAxisList.split(",");
		for (var i = 0; i < rowEdgeAxisArray.length; i++) {
			if (rowEdgeAxisArray[i] == axisID) {
				return "ROW";
			}
		}

		var pageEdgeAxisList = getAxisIdListInEdge("PAGE", axesXmlData);
		var pageEdgeAxisArray = pageEdgeAxisList.split(",");
		for (var i = 0; i < pageEdgeAxisArray.length; i++) {
			if (pageEdgeAxisArray[i] == axisID) {
				return "PAGE";
			}
		}

		return null;
	}

	// GbWColGbWARowGbW̑gݍ킹
	// <Input>  targetArray:  rΏۂƂȂ鎲ID̔z
	// <Input>	sourceArray1: r̎ID̔z
	// <Input>	sourceArray2: r̎ID̔z
	//						  ̔znull̏ꍇ́AtargetArraysourceArray1r
	//						  nullłȂꍇ́AtargetArraysourceArray1{sourceArray2r
	// <Output>	̑gݍ킹ĂtrueAȂꍇfalse
	// ColRowŎւĂĂOKB
	// ȂAeGbW͍̏lȂ
	function hasSame2Axes(targetArray, sourceArray1, sourceArray2) {
		if( (targetArray == null) || (sourceArray1 == null) ) { return false; }

		var sourceArray = null;
			if ( sourceArray2 == null ) {
				sourceArray = sourceArray1;
			} else {
				sourceArray = sourceArray1.concat(sourceArray2);
			}

		// GbW̎r
		if(targetArray.length != (sourceArray.length) ) {
			return false;
		}

		// GbW̎vfrAgݍ킹łtrue
		for(var i = 0; i < targetArray.length; i++ ) {
			var findFLG = false;
			for ( var j = 0; j < sourceArray.length; j++ ) {
				if( targetArray[i] == sourceArray[j] ) {
					findFLG = true;
					break;
				}
			}
			if ( findFLG == false ) {
				return false;
			}
		}
		return true;
	}

	// @oZo\bh@

	// w肳ꂽ̃o߂
	// <Input>	targetString:swb_wb_(COLROW)
	// <Input>	hierarchyID:ĩCfbNX(1iڂ̏ꍇ=0,2iڂ̏ꍇ=1,3iڂ̏ꍇ=0)
	// <Output>	w肳ꂽwb_̎w肳ꂽiCfbNXɔzuĂ鎲̃o
	function getAxisMemNum( targetString, hierarchyID ) {

		if ( targetString == "COL" ) {
			if ( hierarchyID == 0 ) {
				return chMemNumList[0];
			} else if ( hierarchyID == 1 ) {
				return chMemNumList[1];
			} else if ( hierarchyID == 2 ) {
				return chMemNumList[2];
			}
		} else if ( targetString == "ROW" ) {
			if ( hierarchyID == 0 ) {
				return rhMemNumList[0];
			} else if ( hierarchyID == 1 ) {
				return rhMemNumList[1];
			} else if ( hierarchyID == 2 ) {
				return rhMemNumList[2];
			}
		}
		return null;
	}

	// w肳ꂽ̃o߂
	// <Input>	oTD:swb_,wb_TDIuWFNg
	// <Output>	w肳ꂽoԂ
	function getAxisMemberNumber(oTD) {
		if ( oTD == null ) { return null; }
		if ( oTD.tagName != "TD" ) { return null; }

		var targetString = getCellPosition(oTD);
		var hierarchyID  = getHieIndex(oTD);;

		if ( ( targetString == null ) || ( hierarchyID == -1 ) ) { return null; }

		return getAxisMemNum( targetString, hierarchyID )
	}

	// iɔzuꂽ̃o߂
	// <Input>	hieIndex:iCfbNX
	// <Input>	target:swb_wb_(COLROW)
	// <Output>	^ꂽiCfbNX̎ĩoԂB
	//			wb_̍ŏIił0ԂB
	function getNextAxisMemberNumber( hieIndex, target ) {
		if ( hieIndex == null ) { return null; }
		if ( target == null ) { return null; }
		if ( hieIndex > 2 || hieIndex < 0 ) {	// CfbNX͈̔̓`FbN
			return -1;
		}

		if ( target == "COL" ) {
			if ( hieIndex + 1 >= colObjNum ) {
				return 0;
			} else {
				return chMemNumList[hieIndex + 1];
			}
		} else if ( target == "ROW" ) {
			if ( hieIndex + 1 >= rowObjNum ) {
				return 0;
			} else {
				return rhMemNumList[hieIndex + 1];
			}
		} else {
			return -1;
		}
	}


	// w肳ꂽZ̉iɔzuꂽȏgݍ킹߂
	// Input)
	//  cellFs܂͗TDvf
	//  targetFTDvfswb_̂̂Awb_̂̂\
	// Output)
	//  ^ꂽTDvf̒íAiȍ~̎/W[ȏgݍ킹ԂB
	//  ɐݒ肳ꂽŌ̎/W[łꍇ́A1ԂB
	function getLowerHieComboNum( cell, target ) {

		var hieIndex = getHieIndex(cell);
		if ( hieIndex == -1 ) {
			return -1;
		}

		var retComboNum = getLowerHieComboNumByIndex(target, hieIndex);
		return retComboNum;
	}

	// w肳ꂽ̉iɔzuꂽȏgݍ킹߂
	function getLowerHieComboNumByIndex( target, hieIndex ) {

		var nextAxisMemNum = -1;
		var retComboNum    = 1;
		var hieMaxIndex    = 0;
		if ( target == "COL" ) {
			hieMaxIndex = colObjNum;
		} else if ( target == "ROW" ) {
			hieMaxIndex = rowObjNum;
		}

		for ( var i = hieIndex; i < hieMaxIndex; i++ ) {
			nextAxisMemNum = getNextAxisMemberNumber(i,target);
			if ( nextAxisMemNum != 0 ) {	// ŉiłgetNextAxisMemberNumber0Ԃ
				retComboNum = retComboNum * nextAxisMemNum;
			}
		}
		return retComboNum;
	}


	// @f[^e[u֘A\bh@

	// f[^e[utargetɂw肳ꂽwb_̍s܂͗
	// <Input>  targetFs܂͗\
	// <Output> <target==̎>PɊ܂܂Z̐
	//          <target==s̎>PsɊ܂܂Z̐
	function getDataTableCellNumbers( target ) {

		if ( target == "COL" ) {
			return dataTable.rows.length;
		} else if ( target == "ROW" ) {
			return dataTable.rows[0].cells.length;
		} else {
			return null;
		}
	}

	// @ZIuWFNg擾\bh@

	// |[gXML̎ovf߂
	// <Input>	xmlDoc:|[gXML
	// <Input>	target:GbW̖
	// <Input>	hieIndex:Index
	// <Input>	xmlIndex:XMLIndex
	// <Output>	XMLm[h
	function getXMLMemberNode (xmlDoc, target, hieIndex, xmlIndex) {
		var axisID = xmlDoc.selectSingleNode("/root/OlapInfo/AxesInfo/" + target +"/HierarchyID[" + (hieIndex+1) + "]").text;

		var targetNode = xmlDoc.selectSingleNode("/root/Axes/Members[@id=" + axisID + "]//Member[@id=" + xmlIndex + "]");
		return targetNode;
	}


	// w肳ꂽwb_̎w肳ꂽSpreadIndexɑΉCOLROW̃IuWFNg擾
	// <Input> target:Ώۂswb_Awb_
	//		   nodeSpreadIndex:m[hSpreadCfbNX
	// <Output>swb_̏ꍇATRIuWFNg
	//		   wb_̏ꍇACOLIuWFNg
	function getSpreadNode( target, spreadIndex ) {
		var spreadNode;

		if ( target == "COL" ) {
			spreadNode = colHeader.all("CH_CG").children(spreadIndex);
		} else if ( target == "ROW"){
			spreadNode = rowHeader.firstChild.rows[spreadIndex];
		}

		return spreadNode;
	}

	// w肳ꂽTDIuWFNgɑΉCOLROW̃IuWFNg擾
	// <Input> ele: swb_͗wb_TDIuWFNg
	// <Output>swb_̏ꍇATRIuWFNg
	//		   wb_̏ꍇACOLIuWFNg
	function getSpreadNodeByTDObj( ele ) {

		if ( isCellInColHeader(ele) ) {
			return colHeader.all( "CH_CG" + getColIndexByTDObj(ele) );
		} else if ( isCellInRowHeader(ele) ) {
			return ele.parentNode;
		}
	}


	// TRCOLIuWFNgs͗TDIuWFNg擾
	// Inputj
	//   node:<target=="s"̏ꍇ>swb_e[uTRIuWFNg
	//        <target==""̏ꍇ>wb_e[uCOLIuWFNg
	//   targetFs񂩂\(COL or ROW)
	//   hieIndexFΏۃwb_̉Ԗڂ̎̃IuWFNg擾邩(0start)
	// Output)TDIuWFNg
	function getCellObj( node, target, hieIndex ) {

		var targetObjNum = getHeaderObjNum( target );

		var colIndex;
		var rowIndex;
		var targetRow;

		// 擾Ώۂwb_̃IuWFNg̏ꍇ
		if ( target == "COL" ) {
			colIndex  = parseInt(getCOLIndexByCOLObj(node));
			targetRow = colHeader.firstChild.rows(hieIndex); 

			var headerMemNum1 = getAxisMemNum( target, 1 );
			var headerMemNum2 = getAxisMemNum( target, 2 );

			if ( targetObjNum == 1 ) {
				colIndex = colIndex;
			} else if ( targetObjNum == 2 ) {
				if ( hieIndex == 0 ) {
					colIndex = Math.round((colIndex/headerMemNum1) - 0.5);
				} else if ( hieIndex == 1 ) {
					colIndex = colIndex;
				}
			} else if ( targetObjNum == 3 ) {
				if ( hieIndex == 0 ) {
					colIndex = Math.round((colIndex / (headerMemNum1*headerMemNum2)) - 0.5);
				} else if ( hieIndex == 1 ) {
					colIndex = Math.round((colIndex / headerMemNum2) - 0.5);
				} else if ( hieIndex == 2 ) {
					colIndex = colIndex;
				}
			}

		} else if ( target == "ROW" ) {
		// 擾Ώۂswb_̃IuWFNg̏ꍇ
			colIndex  = hieIndex;
			targetRow = node; 

			if ( targetObjNum == 1 ) {
				colIndex = colIndex;
			} else if ( targetObjNum == 2 ) {
				if ( hieIndex == 1 ) {
					if ( node.cells.length == 1 ) {
						colIndex = colIndex-1;
					} else if ( node.cells.length == 2 ) {
						colIndex = colIndex;
					}
				} else if ( hieIndex == 0 ) {
					colIndex = colIndex;
				}
			} else if ( targetObjNum == 3 ) {
				if ( hieIndex == 2 ) {
					if ( node.cells.length == 1 ) {
						colIndex = colIndex-2;
					} else if ( node.cells.length == 2 ) {
						colIndex = colIndex-1;
					} else if ( node.cells.length == 3 ) {
						colIndex = colIndex;
					}
				} else if ( hieIndex == 1 ) {
					if ( node.cells.length == 2 ) {
						colIndex = colIndex-1;
					} else if ( node.cells.length == 3 ) {
						colIndex = colIndex;
					}
				} else if ( hieIndex == 0 ) {
					if ( node.cells.length == 3 ) {
						colIndex = colIndex;
					}
				}
			}
		}

		// s͗TDIuWFNg߂
		return targetRow.cells(colIndex);
	}


	//  Zzuʒu擾\bh 

	// Z̔zuꏊ(COL,ROW,DATA)߂
	// <Input>	oTD:sAAf[^e[uTD
	// <Output>	sAAf[^e[u\ԂisFCOLAFROWAf[^e[uFDATAj
	function getCellPosition ( oTD ) {
		if ( oTD == null ) { return null; }
		if ( oTD.tagName != "TD" ) { return null; }

		var strID = oTD.id;

		if ( strID.split("_")[0] == "CH" ) {
			return "COL";
		} else if ( strID.split("_")[0] == "RH" ) {
			return "ROW";
		} else if ( strID.split("_")[0] == "DC" ) {
			return "DATA";
		}

		return null;
	}

	// NXwb_[̃Z
	// <Input>	ele:TD Object
	// <Output>	true / false
	function isInCrossHeaderAreaByTDObj(ele) {
		var t = ele;
		var objID = "";
		var tSPANObj = null;
		if ( t.tagName == "TD" ) {
			tSPANObj = t.parentNode.parentNode.parentNode.parentNode;

			if ( tSPANObj != null ) {
				if ( tSPANObj.id == "CrossHeaderArea" ) {
					return true;
				}
			}
		} else {
			return false;
		}
		return false;
	}

	// wb_̃Z
	// Input	:IuWFNg
	// Output	:elewb_TDIuWFNgł΁AtrueԂ
	function isCellInColHeader( ele ) {
		if ( ele == null ) { return false; }
		if ( ele.tagName != "TD" ) { return false; }

		if ( getCellPosition(ele) == "COL") {
			return true;
		}
		return false;
	}

	// swb_̃Z
	// Input	:IuWFNg
	// Output	:eleswb_TDIuWFNgł΁AtrueԂ
	function isCellInRowHeader( ele ) {
		if ( ele == null ) { return false; }
		if ( ele.tagName != "TD" ) { return false; }

		if ( getCellPosition(ele) == "ROW") {
			return true;
		}
		return false;
	}

	// f[^e[ũZ
	// Input	:IuWFNg
	// Output	:elef[^e[uTDIuWFNgł΁AtrueԂ
	function isCellInDataTable( ele ) {
		if ( ele == null ) { return false; }
		if ( ele.tagName != "TD" ) { return false; }

		if ( getCellPosition(ele) == "DATA") {
			return true;
		}
		return false;
	}


	// @Z擾\bh@

	// ZW߂
	// <Input>	oTD:swb_,wb_TDIuWFNg
	//				iIDFRH_RxCyACH_RxCyADC_RxCyj
	// <Output>	swb_Awb_Af[^e[u̍W
	//			iFux(col):y(row)vj
	function getSpreadCoordinate( oTD ) {
		if ( oTD == null ) { return null; }
		if ( oTD.tagName != "TD" ) { return null; }

		var coordinate = "";
		if ( getCellPosition( oTD ) == "COL" ) {
			coordinate = getSpreadIndexByTDObj(oTD) + ":" + getHieIndex(oTD);
		} else if ( getCellPosition( oTD ) == "ROW" ) {
			coordinate = getHieIndex(oTD) + ":" + getSpreadIndexByTDObj(oTD);
		} else if ( getCellPosition( oTD ) == "DATA" ) {
			coordinate = oTD.cellIndex + ":" + oTD.parentNode.rowIndex;
		}
		return coordinate;
	}

	// oSpreadIndex߂
	// <Input>	oTD:swb_,wb_TDIuWFNg
	//				iIDFRH_RxCyACH_RxCyj
	// <Output>	Spread Index(/sňӂɂȂ0 startindex(int))
	function getSpreadIndexByTDObj( oTD ) {
		if ( oTD == null ) { return null; }
		if ( oTD.tagName != "TD" ) { return null; }

		if ( getCellPosition( oTD ) == "COL" ) {
			return parseInt(getColIndexByTDObj(oTD));
		} else if ( getCellPosition( oTD ) == "ROW" ) {
			return parseInt(getRowIndexByTRObj(oTD.parentNode));
		} else {
			return null;
		}
	}

	// Z̒iCfbNX߂
	// <Input>	oTD:TD IuWFNg
	// <Output>	TDIuWFNgs/̎/W[̍s/ł̒i(0start)
	function getHieIndex( oTD ) {
		if ( oTD == null ) { return -1; }
		if ( oTD.tagName != "TD" ) { return -1; }
		if ( isCellInDataTable(oTD) ) { return -1; }

		if ( isCellInColHeader(oTD) ) {
			return oTD.parentNode.rowIndex;
		}

		if ( isCellInRowHeader(oTD) ) {
			return parseInt(getColIndexByTDObj(oTD));
		}

	}

	// Zs/̍ŉiH
	// <Input>	oTDIuWFNg
	// <Output>	TDIuWFNgs/̍ŉił΁Atrue
	function isLastHie( oTD ) {
		if ( oTD == null ) { return false; }
		if ( oTD.tagName != "TD" ) { return false; }

		var objNum;
		if ( isCellInColHeader( oTD ) ) {
			objNum = colObjNum;
		} else if ( isCellInRowHeader( oTD ) ) {
			objNum = rowObjNum;
		}

		if ( getHieIndex( oTD ) == (objNum-1) ) {
			return true;
		} else {
			return false;
		}
	}

	// NXwb_[̍ŏIsH
	// <Input>	ele: NXwb_TD Object
	// <Output>	true / false
	// Note:	͂ꂽTDIuWFNgNXwb_[
	//			ŏIs̃IuWFNg𒲂ׁAꍇ́utruevAقȂꍇ́ufalsevԂB
	// Error:	E͂ꂽIuWFNgTDIuWFNgłȂꍇ
	//				ˁufalsevԂ
	function isInCrossHeaderLastRow(ele) {

		var isInCrossHeaderFLG = isInCrossHeaderAreaByTDObj(ele);
		if ( ele.tagName == "TD" ) {
			if ( isInCrossHeaderFLG ) {
				var currentRowIndex = ele.parentNode.rowIndex;
				var lastCrossHeaderRowIndex = ele.parentNode.parentNode.lastChild.rowIndex;
				if ( currentRowIndex == lastCrossHeaderRowIndex ) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	// Ziɑ郁oXg̐擪o
	// <Input>	cell: s/GbWTDIuWFNg
	// <Output>	Ziɑ郁oXg̐擪ołtrue
	// 			iiɎꍇA̎̐擪ołtruej
	function isStartPartCell(cell) {
		if (cell == null) { return false; }
		if (cell.tagName != "TD") { return false; }
		if ((!isCellInColHeader(cell)) && (!isCellInRowHeader(cell))) { return false; }

		var index = getSpreadIndexByTDObj(cell);
		var thisHieMemNum = parseInt(parent.display_area.getAxisMemNum( getCellPosition(cell), getHieIndex(cell) ));			var lowerComboNum = 1 * parseInt(parent.display_area.getLowerHieComboNum( cell, getCellPosition(cell) ));

		if ( ( index % (thisHieMemNum * lowerComboNum) ) == 0 ) {
			return true;
		} else {
			return false;
		}
	}

	// Ziɑ郁oXg̍ŏIo
	// <Input>	cell: s/GbWTDIuWFNg
	// <Output>	Ziɑ郁oXg̍ŏIołtrue
	// 			iiɎꍇA̎̍ŏIołfalsej
	function isEndPartCell(cell) {
	// <Input>cell: s/GbWTDIuWFNg

		if (cell == null) { return false; }
		if (cell.tagName != "TD") { return false; }
		if ((!isCellInColHeader(cell)) && (!isCellInRowHeader(cell))) { return false; }

		var index = getSpreadIndexByTDObj(cell);
		var thisHieMemNum = parseInt(parent.display_area.getAxisMemNum( getCellPosition(cell), getHieIndex(cell) ));			var lowerComboNum = 1 * parseInt(parent.display_area.getLowerHieComboNum( cell, getCellPosition(cell) ));

		// iɑp[g̍ŏIo
		if ( ( index % (thisHieMemNum * lowerComboNum) ) == ( (thisHieMemNum - 1) * lowerComboNum ) ) {
			return true;
		} else {
			return false;
		}
	}


	// TDIuWFNgʒi̊eKeyz߂
	// <Input>	oTD:^ꂽŏIiTDIuWFNg
	// <Output>	eiKeyzԂBYiIndexƑΉB
	//        	A݂Ȃo̓Yɂ͋󕶎ΉB
	function getKeyArray( oTD ) {

		var target = getCellPosition(oTD);
		var targetObjNum = getHeaderObjNum( target );

		var keyArray = new Array(3);
				keyArray[0] = "";
				keyArray[1] = "";
				keyArray[2] = "";
			if ( targetObjNum == 1 ) {
				keyArray[0] = oTD.key;

			} else if ( targetObjNum == 2 ) {
				keyArray[0] = getUpperCellObject( oTD, target ).key;
				keyArray[1] = oTD.key;
				keyArray[2] = "";
			} else if ( targetObjNum == 3 ) {

				keyArray[0] = getUpperCellObject ( getUpperCellObject( oTD, target ), target ).key;
				keyArray[1] = getUpperCellObject( oTD, target ).key;
				keyArray[2] = oTD.key;
			}

		return keyArray;
	}


	// Z̗Index߂
	// <Input>	headerCOLObj:NXwb_,wb_COLIuWFNg
	//			iIDFCrossHeader_CGxACH_CGxj
	// <Output>	ڂ\Index
	function getCOLIndexByCOLObj( headerCOLObj ) {
		var strID     = headerCOLObj.id;
		var strGIndex = strID.lastIndexOf("G");
		var colIndex  = strID.substr(strGIndex + 1, strID.length - (strGIndex + 1));
		return colIndex;
	}

	// Z̗Index߂
	// Input	:sAwb_Af[^e[uTDIuWFNg
	//			 (IDFRH_RxCyACH_RxCyADC_RxCy)
	// Output	:ڂ\Index
	function getColIndexByTDObj( headerTDObj ) {
		var strID     = headerTDObj.id;
		var strCIndex = strID.lastIndexOf("C");
		var colIndex  = strID.substr(strCIndex + 1, strID.length - (strCIndex + 1));
		return colIndex;
	}

	// Z̍s̃CfbNX߂
	// Input	:sAwb_Af[^e[uTRIuWFNg
	//           (IDFRH_RxACH_RxADC_Rx)
	// Output	:sڂ\Index
	function getRowIndexByTRObj( headerTRObj ) {
		var strID     = headerTRObj.id;
		var strRIndex = strID.lastIndexOf("R");
		var rowIndex  = strID.substr(strRIndex + 1, strID.length - (strRIndex + 1));
		return rowIndex;
	}

	// @Zړ\bh@

	// ̎oZ߂
	// <Input>	oTD:TD IuWFNg
	// <Output>	w肳ꂽTDIuWFNgł킳鎲o̎o킷TDIuWFNg
	function getNextCell ( oTD ) {
		if ( oTD == null ) { return false; }
		if ( oTD.tagName != "TD" ) { return false; }

		if ( isCellInColHeader(oTD) ) {
			if ( oTD.nextSibling != null ) {
				if ( oTD.className != "adjustCell" ) {
					return oTD.nextSibling;
				} else {
					return null;
				}
			} else {
				return null;
			}
		} else if ( isCellInRowHeader(oTD) ) {
			var r,c;
				r = parseInt(getRowIndexByTRObj(oTD.parentNode)) + parseInt(getLowerHieComboNum( oTD, getCellPosition(oTD) ));
				c = parseInt(getColIndexByTDObj(oTD));

			var nextNode = oTD.parentNode.parentNode.all( "RH_R" + r + "C" + c );
			if ( nextNode != null ) {
				return nextNode;
			} else {
				return null;
			}
		}
	}

	// TDIuWFNg߂
	// <Input>	node:TD IuWFNg
	// <Output>	eƂďʒi̓̎o͈͓ŁA̎oԂB
	function getNextCellWithinUpperCellRange ( node ) {
		if ( isCellInColHeader(node) ) {
			if ( node.parentNode.previousSibling == null ) { return null }

			if ( node.nextSibling != null ) {

				var upperHieNodeRange = parseInt(getLowerHieComboNum( node.parentNode.previousSibling.firstChild, getCellPosition(node)));
				var nodeRangeIndex = Math.floor( parseInt(getColIndexByTDObj( node )) / upperHieNodeRange );
				var nextNodeRangeIndex = Math.floor( parseInt(getColIndexByTDObj( node.nextSibling )) / upperHieNodeRange );

				if ( nodeRangeIndex == nextNodeRangeIndex ) {
					return node.nextSibling;
				} else {
					return null;
				}
			} else {
				return null;
			}
		} else if ( isCellInRowHeader( node ) ) {
			var r,c;
				r = parseInt(getRowIndexByTRObj(node.parentNode)) + parseInt(getLowerHieComboNum( node, getCellPosition(node) ));
				c = parseInt(getColIndexByTDObj(node));

			var upperHieNodeRange = parseInt(getLowerHieComboNum( node.parentNode.parentNode.firstChild.all("RH_R0" + "C" + (c-1)), getCellPosition(node)));
			var nodeRangeIndex = Math.floor( parseInt(getRowIndexByTRObj( node.parentNode )) / upperHieNodeRange );
			var nextNodeRangeIndex = Math.floor( (parseInt(getRowIndexByTRObj( node.parentNode ))+1) / upperHieNodeRange );

			if ( nodeRangeIndex == nextNodeRangeIndex ) {
				return node.parentNode.parentNode.all( "RH_R" + r + "C" + c );
			} else {
				return;
			}
		}
	}

	// ZʒĩZ߂
	// Input) 
	//	headerCellObject:TDvf
	//	targetString:COL or ROW
	// Output)
	//	cellʒi̗vfiTDvfj
	function getUpperCellObject( headerCellObject, targetString ) {

		var cell   = headerCellObject;
		var target = targetString;

		var targetObjNum = getHeaderObjNum( target );
		var spreadIndex;	// Z̃CfbNXis͎ɑ΂ĈӁB0startj
		var hieIndex;		// ͂ꂽZiڂ(0start)
			if ( target == "COL" ) {
				spreadIndex = getColIndexByTDObj(cell);
				hieIndex    = getRowIndexByTRObj(cell.parentElement);
			} else if ( target == "ROW" ) {
				spreadIndex = getRowIndexByTRObj(cell.parentElement);
				hieIndex    = getColIndexByTDObj(cell);
			}

		headerMemNum1 = getAxisMemNum( target, 1 );
		headerMemNum2 = getAxisMemNum( target, 2 );

		var comboNum;
		var upperCellSpreadIndex;

		if ( targetObjNum == 1 ) {
		// s/񂪂Pȉꍇ
			return;
		} else if ( targetObjNum == 2 ) {
		// s/񂪂Qȉꍇ
			if ( hieIndex == 0 ) {
				return;
			} else if ( hieIndex == 1 ) {
				comboNum = headerMemNum1;
				upperCellSpreadIndex = spreadIndex - ( spreadIndex % comboNum );
			}
		} else if ( targetObjNum == 3 ) {
		// s/񂪂Rȉꍇ
			if ( hieIndex == 0 ) {
				return;
			} else if ( hieIndex == 1 ) {
				comboNum = headerMemNum1 * headerMemNum2;
				upperCellSpreadIndex = spreadIndex - ( spreadIndex % comboNum );
			} else if ( hieIndex == 2 ) {
				comboNum = headerMemNum2;
				upperCellSpreadIndex = spreadIndex - ( spreadIndex % comboNum );
			}
		}

		// IuWFNg
		var targetObj;
		if ( target == "COL" ) {
			targetObj = colHeader.all("CH_R" + (hieIndex-1) + "C" + upperCellSpreadIndex );
		} else if ( target == "ROW" ) {
			targetObj = rowHeader.all("RH_R" + upperCellSpreadIndex + "C" + (hieIndex-1));
		}

		return targetObj;

	}

	// w肳ꂽoɑ鎟i̎ôA擪o߂
	// <Input>	oTD:swb_,wb_TDIuWFNg
	// <Output>	^ꂽoiTDIuWFNgjɑ
	//			ĩô擪o(TDIuWFNg)Ԃ
	function getUnderHieFirstNode( oTD ) {
		if ( oTD == null ) { return null; }
		if ( oTD.tagName != "TD" ) { return null; }

		// iȍ~ɃoȂꍇnullԂB
		if ( getNextAxisMemberNumber( getHieIndex(oTD), getCellPosition(oTD) ) == 0 ) { return null; }

		if ( isCellInColHeader( oTD ) ) {
			if ( oTD.parentNode.nextSibling == null ) { return null; }

			var r,c;
				r = oTD.parentNode.rowIndex+1;
				c = parseInt(getColIndexByTDObj( oTD ));

			return oTD.parentNode.nextSibling.all( "CH_R" + r + "C" + c );

		} else if ( isCellInRowHeader( oTD ) ) {
			if ( oTD.nextSibling == null ) { return null; }

			var r,c;
				r = oTD.parentNode.rowIndex;
				c = parseInt(getColIndexByTDObj(oTD))+1;
			return oTD.parentNode.all( "RH_R" + r + "C" + c );
		} else {
			return null;
		}
	}


	// w肳ꂽoɑ鎟ĩoXg߂
	// <Input>	oTD:swb_,wb_TDIuWFNg
	// <Output>	ĩoXg
	function getUnderHieNodes( oTD ) {
		if ( oTD == null ) { return null; }
		if ( oTD.tagName != "TD" ) { return null; }

		// iȍ~ɎȂꍇnullԂB
		if ( getNextAxisMemberNumber( getHieIndex(oTD), getCellPosition(oTD) ) == 0 ) { return null; }

		var underNodeArray = new Array();
		var underNode = getUnderHieFirstNode( oTD );
		for ( i = 0; i < getNextAxisMemberNumber( getHieIndex(oTD), getCellPosition(oTD) ); i++ ) {
			underNodeArray[i] = underNode;
			underNode = getNextCell(underNode);
		}

		return underNodeArray;
	}

	// w肳ꂽoɑ鎟ĩoXg߂
	// <Input>	oTD:swb_,wb_TDIuWFNg
	// <Output>	ĩoXg
	function getUnder2HieNodes( oTD ) {
		if ( oTD == null ) { return null; }
		if ( oTD.tagName != "TD" ) { return null; }

		// w肳ꂽTDIuWFNgA3i\̃wb_0iڂłȂꍇAnullԂ
		if ( getHeaderObjNum( getCellPosition(oTD) ) != 3 ) { return null; }
		if ( getHieIndex(oTD) != 0 ) { return null; }

		var under2NodeArray = new Array();
		var underNodes = getUnderHieNodes(oTD);
		for ( var i = 0; i < underNodes.length; i++ ) {
			var underNode = underNodes[i];
			var under2NodeArrayList = getUnderHieNodes(underNode);
			var under2Num = under2NodeArrayList.length;
			for ( var j = 0; j < under2Num; j++ ) {
				under2NodeArray[(i*under2Num) + j] = under2NodeArrayList[j];
			}
		}

		return under2NodeArray;
	}

	// @Zϊ\bh@

	// XMLCfbNXUName߂
	// <Input>	axisID:ID
	// <Input>	xmlIndex:oXMLID(|[gXMĹuMembervvf́uidv̒l)
	// <Output>	w肳ꂽoUName(|[gXMLMember^O̗vf)
	//			(fBVFkeyAW[F1start̏Index)
	function changeXMLIndexToUName (axisID, xmlIndex) {

		var UName = axesXMLData.axesXMLData.selectSingleNode("/root/Axes/Members[@id=" + axisID  + "]//Member[@id=" + xmlIndex + "]").text;

		return UName;
	}

	// UNameXMLCfbNX߂
	// <Input>	axisID:ID
	// <Input>	UName:oXMLID(|[gXMĹuMembervvf́uUNamev̒l)
	//				  (fBVFkeyAW[F1start̏Index)
	// <Output>	w肳ꂽoXMLCfbNX
	function changeUNameToXMLIndex (axisID, UName) {

		var xmlIndex = parseInt(axesXMLData.axesXMLData.selectSingleNode("/root/Axes/Members[@id = " + axisID  + "]//Member[./UName=" + xmlIndex + "]").text);

		return xmlIndex;
	}

	// SpreadIndexXMLIndex֕ϊ
	// <Input>	spreadIndex:hsȂꂽo̍s/CfbNX
	// <Input>	target:o̗͍sCfbNX(0start)
	// <Input>	hieIndex:iȍ~̃ȏgݍ킹
	// <Output>	oŏɐUꂽCfbNX(|[gXMĹuMembervvf́uidv̒l)
	function changeSpreadIndexToXMLIndex ( spreadIndex, target, hieIndex ) {

		var headerMemNum1  = getNextAxisMemberNumber( 0, target );		// 1iڂ̎̑o
		var headerMemNum2  = getNextAxisMemberNumber( 1, target );		// 2iڂ̎̑o
		var lowerComboNum = getLowerHieComboNumByIndex(target, hieIndex);	// ȉ̒ĩȏgݍ킹

		var xmlIndex = -1;

		// s/񂪂P̎/W[ꍇ
		if ( getHeaderObjNum(target) == 1 ) {
			xmlIndex = spreadIndex;

		// s/񂪂Q̎/W[ꍇ
		} else if ( getHeaderObjNum(target) == 2 ) {
			// 0iڂ̃IuWFNg̏ꍇ
			if ( hieIndex == 0) {
				xmlIndex = Math.round((spreadIndex / lowerComboNum) - 0.5);

			// 1iڂ̃IuWFNg̏ꍇ
			} else if ( hieIndex == 1 ) {
				xmlIndex = spreadIndex % headerMemNum1;
			}

		// s/񂪂Rȉꍇ
		} else if ( getHeaderObjNum(target) == 3 ) {
			// 0iڂ̃IuWFNg̏ꍇ
			if ( hieIndex == 0) {
				xmlIndex = Math.round((spreadIndex / lowerComboNum) - 0.5);
			// 1iڂ̃IuWFNg̏ꍇ
			} else if ( hieIndex == 1 ) {
				xmlIndex = ( spreadIndex / lowerComboNum ) % headerMemNum1;
			// 2iڂ̃IuWFNg̏ꍇ
			} else if ( hieIndex == 2 ) {
				xmlIndex = spreadIndex % headerMemNum2;
			}
		}

		return parseInt(xmlIndex);
	}


	// XMLCfbNXSpreadCfbNX֕ϊ
	// <Input>	axisIDList:܂͍s̑S̎ID̔z
	// <Input>	xmlIndexList:܂͍s̑S̎oXMLID(|[gXMĹuMembervvf́uidv̒l)̔z
	//			axisIDListxmlIndexList͓YőΉÂBz͒iIndex̏ƂB
	// <Output>	^ꂽ̑gݍ킹s/ɔzuĂꍇA
	//			̑gݍ킹ňӂɂȂSpreadCfbNXԂ
	function changeXMLIndexesToSpreadIndex ( axisIDArray, xmlIndexArray ) {
		if ( ( axisIDList == null ) || ( xmlIndexList == null ) ) { return -1; }
		if ( axisIDList.length != xmlIndexList.length ) { return -1; }
		if ( axisIDArray.length != xmlIndexArray.length ) { return -1; }

		var targetObjNum  = getHeaderObjNum( target );	// wb_̎
		if ( axisIDArray.length != targetObjNum ) { return -1; }

		var spreadIndex = -1;			// Spreadł̍s/CfbNX

		var colAxisListString  = getAxisIdListInEdge( "COL", axesXMLData );
		var rowAxisListString  = getAxisIdListInEdge( "ROW", axesXMLData );

		var target = "";
			if ( hasSame2Axes(axisIDArray, colAxisListString.split(","), null) ) {
				target = "COL";
			} else if ( hasSame2Axes(axisIDArray, rowAxisListString.split(","), null) ) {
				target = "ROW";
			}

		var spreadIndex = 0;
		for ( var i = 0; i < axisIDArray.length; i++ ) {
			var axisID = axisIDArray[i];
			var xmlIndex = xmlIndexArray[i];
			var lowerHieComboNum = lowerComboNum = getLowerHieComboNumByIndex(target, i);

			spreadIndex += xmlIndex * lowerHieComboNum;
		}

		return spreadIndex;
	}


	// XMLCfbNXSpreadCfbNX֕ϊ
	// <Input>	xmlIndex:oXMLCfbNX(|[gXMĹuMembervvf́uidv̒l)
	// <Input>	target:COLROW
	// <Input>	startSpreadIndex:߂鎲oƓioɑ郁oW̐擪oSpreadCfbNX
	// <Input>	hieIndex:o̗͍sCfbNX(0start)
	// <Input>	lowerHieComboNum:iȍ~̃ȏgݍ킹
	// <Output>	:xmlIndexŗ^ꂽóASpread̍s/ňӂɂȂCfbNX
	function changeNodeIDToSpreadID ( xmlIndex, target, startSpreadIndex, hieIndex, lowerHieComboNum ){

		var spreadIndex;			// Spreadł̍s/CfbNX

		var drilledNodeSpreadIndex;	// hsꂽvf̃CfbNX
			var headerMemNum1;		// h̍sꂽwb_1s/ڂ̎̃o
			var headerMemNum2;		// h̍sꂽwb_2s/ڂ̎̃o
			var targetObjNum;		// h̍sꂽwb_̎

			headerMemNum1 = getAxisMemNum( target, 1 );
			headerMemNum2 = getAxisMemNum( target, 2 );
			targetObjNum  = getHeaderObjNum( target );

		if ( targetObjNum == 1) {	// wb_Ɏ
			spreadIndex = xmlIndex;
		} else if ( targetObjNum == 2 ) {	// wb_Ɏ
			if ( hieIndex == 0) {	// 0i
				spreadIndex = xmlIndex * lowerHieComboNum;
			} else if ( hieIndex == 1 ) {	// 1i
				spreadIndex = ( startSpreadIndex - ( startSpreadIndex % headerMemNum1 ) ) + xmlIndex;
			}

		} else if ( targetObjNum == 3 ) {	// wb_ɎO
			if ( hieIndex == 0) {	// 0i
				spreadIndex = xmlIndex * lowerHieComboNum;
			} else if ( hieIndex == 1 ) {	// 1i
				spreadIndex = ( startSpreadIndex - ( startSpreadIndex % ( headerMemNum1 * headerMemNum2 ) ) ) + ( xmlIndex *  lowerHieComboNum);
			} else if ( hieIndex == 2 ) {	// 2i
				spreadIndex = ( startSpreadIndex - ( startSpreadIndex % headerMemNum2 ) ) + xmlIndex;
			}
		}

		return spreadIndex;
	}

