#!/bin/sh
#
# Licensed Materials - Property of IBM
#
# Open Platform Trust Services - An open source TCG PTS
#
# (C) Copyright International Business Machines Corp. 2007
#
#
# Database Setup Tool
#
# 2007-11-25 Seiji Munetoh Created
#

if [ -f ./dbconfig ] ; then
    . ./dbconfig
    UPDATE=0;
else
	# new, save config 
	UPDATE=1;
fi


###############################################################################
# Setup New Database
###############################################################################
editConfig()
{
	echo "Setup New Databases"
	echo ""
	
	#
	# Select Database type
	#
    case $DBTYPE in
    postgres)
	    read -p 'Select Database [P(PostgreSQL)/M(MySQL)] :' SELECTED_DBTYPE
	    case $SELECTED_DBTYPE in
    	M)
        	DBTYPE=mysql
			UPDATE=1;
        	;;
    	*)
        	;;
    	esac
	    ;;
    mysql)
	    read -p 'Select Database [M(MySQL)/P(PostgreSQL)] :' SELECTED_DBTYPE
	    case $SELECTED_DBTYPE in
    	P)
        	DBTYPE=postgres
			UPDATE=1;
        	;;
    	*)
        	;;
    	esac
	    ;;
	*)
		;;
	esac
    
	echo "DB type : $DBTYPE"
	echo ""

	#
	# Select Username
	#
	echo -n "Select Database User Name [$DBUSER] :"
	read SELECTED_DBUSER
    case $SELECTED_DBUSER in
    "")
		echo "DB user : $DBUSER"
        ;;
    *)
        DBUSER=$SELECTED_DBUSER
		echo "DB user : $DBUSER"
		UPDATE=1;
        ;;
    esac
	echo ""
	
	#
	# Select IIDB Name
	#
	echo -n "Select Integrity Information Database Name [$IIDB_NAME] :"
	read SELECTED_IIDB_NAME
    case $SELECTED_IIDB_NAME in
    "")
		echo "IIDB name : $IIDB_NAME"
        ;;
    *)
        IIDB_NAME=$SELECTED_IIDB_NAME
		echo "IIDB name : $IIDB_NAME"
		UPDATE=1;
        ;;
    esac
	echo ""

	#
	# Select Vulnerability DB Name
	#
	echo -n "Select Vulnerability Database Name [$VULDB_NAME] :"
	read SELECTED_VULDB_NAME
    case $SELECTED_VULDB_NAME in
    "")
		echo "VULDB name : $VULDB_NAME"
        ;;
    *)
        VULDB_NAME=$SELECTED_VULDB_NAME
		echo "VULDB name : $VULDB_NAME"
		UPDATE=1;
        ;;
    esac
	echo ""

	#
	# Create DB
	#
	
	#
	# Create iBatis Properties
	#
	
	
}


createDB()
{
	echo "Create $DBTYPE Database"

	sh $DBTYPE/setup_dbuser.sh $DBADMIN $DBADMIN_PWD $DBROOT_PWD
	sh $DBTYPE/setup_dbuser.sh $DBUSER $DBUSER_PWD $DBROOT_PWD
	
	sh $DBTYPE/create1db.sh $DBADMIN $DBADMIN_PWD $DBUSER $DBUSER_PWD $VULDB_NAME $DBTYPE/schema/vul_createtables.sql	
	sh $DBTYPE/create1db.sh $DBADMIN $DBADMIN_PWD $DBUSER $DBUSER_PWD $IIDB0_NAME $DBTYPE/schema/iidb_createtables.sql
	sh $DBTYPE/create1db.sh $DBADMIN $DBADMIN_PWD $DBUSER $DBUSER_PWD $IIDB1_NAME $DBTYPE/schema/iidb_createtables.sql
	sh $DBTYPE/create1db.sh $DBADMIN $DBADMIN_PWD $DBUSER $DBUSER_PWD $IIDB2_NAME $DBTYPE/schema/iidb_createtables.sql
	sh $DBTYPE/create1db.sh $DBADMIN $DBADMIN_PWD $DBUSER $DBUSER_PWD $IIDB3_NAME $DBTYPE/schema/iidb_createtables.sql
	sh $DBTYPE/create1db.sh $DBADMIN $DBADMIN_PWD $DBUSER $DBUSER_PWD $IIDB4_NAME $DBTYPE/schema/iidb_createtables.sql
	sh $DBTYPE/create1db.sh $DBADMIN $DBADMIN_PWD $DBUSER $DBUSER_PWD $IIDB5_NAME $DBTYPE/schema/iidb_createtables.sql
	sh $DBTYPE/create1db.sh $DBADMIN $DBADMIN_PWD $DBUSER $DBUSER_PWD $IIDB6_NAME $DBTYPE/schema/iidb_createtables.sql
	sh $DBTYPE/create1db.sh $DBADMIN $DBADMIN_PWD $DBUSER $DBUSER_PWD $IIDB7_NAME $DBTYPE/schema/iidb_createtables.sql
}

createIbatisProperties()
{
	IBATIS_PROP_FILE=ibatis/SqlMapsConfig.properties
	
	case $DBTYPE in
	postgres)
		echo "driver=org.postgresql.Driver" > $IBATIS_PROP_FILE
		echo "url_vul=jdbc:postgresql://localhost/$VULDB_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb0=jdbc:postgresql://localhost/$IIDB0_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb1=jdbc:postgresql://localhost/$IIDB1_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb2=jdbc:postgresql://localhost/$IIDB2_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb3=jdbc:postgresql://localhost/$IIDB3_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb4=jdbc:postgresql://localhost/$IIDB4_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb5=jdbc:postgresql://localhost/$IIDB5_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb6=jdbc:postgresql://localhost/$IIDB6_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb7=jdbc:postgresql://localhost/$IIDB7_NAME" >> $IBATIS_PROP_FILE
		;;
	mysql)
		echo "driver=com.mysql.jdbc.Driver" > $IBATIS_PROP_FILE
		echo "url_vul=jdbc:mysql://localhost/$VULDB_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb0=jdbc:mysql://localhost/$IIDB0_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb1=jdbc:mysql://localhost/$IIDB1_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb2=jdbc:mysql://localhost/$IIDB2_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb3=jdbc:mysql://localhost/$IIDB3_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb4=jdbc:mysql://localhost/$IIDB4_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb5=jdbc:mysql://localhost/$IIDB5_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb6=jdbc:mysql://localhost/$IIDB6_NAME" >> $IBATIS_PROP_FILE
		echo "url_iidb7=jdbc:mysql://localhost/$IIDB7_NAME" >> $IBATIS_PROP_FILE
		;;
	esac
	





}

setupDatabase()
{
	OK=0
	while [ $OK -eq 0 ]; do
		showConfig
		echo ""
    	read -p 'Change?[N/y]:' ASK

	    case $ASK in
    	y)
    		editConfig
        	;;
    	N)
    		OK=1
        	;;
    	"")
    		OK=1
        	;;
	    *)
			echo ""
    		return
    	    ;;
    	esac
    done
    
    read -s -p 'DB root password :' DBROOT_PWD
	echo ""
	
    echo -n "DB $DBADMIN password :"
    read -s DBADMIN_PWD
	echo ""    
	
    echo -n "DB $DBUSER password :"
    read -s DBUSER_PWD
	echo ""    
    
    
   	read -p 'Create New DB?[N/y]:' ASK
	case $ASK in
   	Y)
   		createDB
    	;;   		
   	y)
   		createDB
    	;;
	*)
    	return
    	;;
    esac    
    
   	read -p 'Create iBaits Mapfile? [N/y]:' ASK
	case $ASK in
   	Y)
   		createIbatisProperties
    	;;   		
   	y)
   		createIbatisProperties
    	;;
	*)
    	return
    	;;
    esac    
    
    
}

###############################################################################
# 
###############################################################################
showConfig()
{
	echo ""
	echo "Current Configurations"
	echo "DB type                               : $DBTYPE "
	echo "DB admin                              : $DBADMIN "
	echo "DB user                               : $DBUSER "
	echo "Vulnerability Database name           : $VULDB_NAME "
	echo "Integrity Information Database 0 name : $IIDB0_NAME "
	echo "Integrity Information Database 1 name : $IIDB1_NAME "
	echo "Integrity Information Database 2 name : $IIDB2_NAME "
	echo "Integrity Information Database 3 name : $IIDB3_NAME "
	echo "Integrity Information Database 4 name : $IIDB4_NAME "
	echo "Integrity Information Database 5 name : $IIDB5_NAME "
	echo "Integrity Information Database 6 name : $IIDB6_NAME "
	echo "Integrity Information Database 7 name : $IIDB7_NAME "

	#echo "Admin Database name                  : $PTSDB_NAME "
	echo ""
}

showState()
{

	case $DBTYPE in
	postgres)
		echo ""
		echo "PostgreSQL Database Size:"
		pushd . > /dev/null
		cd /var/lib/pgsql/data/base
		du -csh * | while read SIZE OID; do echo "$SIZE `oid2name -q -H localhost -U postgres  | grep ^$OID' '`"; done | sort -rn		
		popd > /dev/null
		echo ""
		;;
	mysql)

		;;
	esac
	
	echo "TBD"
}

backup()
{
	echo "TBD"
}

delete()
{
	echo "TBD"
}

quit()
{

	if [ $UPDATE -eq 1 ] ; then
		# create backup
		if [ -f ./dbconfig ] ; then
        	mv -f ./dbconfig ./dbconfig.bk
		fi
		
		echo "save config ... "
	
		echo "# update  " > dbconfig
		echo "DBTYPE=$DBTYPE" >> dbconfig
		echo "DBUSER=$DBUSER" >> dbconfig
		echo "IIDB_NAME=$IIDB_NAME" >> dbconfig
		echo "PTSDB_NAME=$PTSDB_NAME" >> dbconfig
		echo "VULDB_NAME=$VULDB_NAME" >> dbconfig
		echo "ENABLED=$ENABLED" >> dbconfig
	fi
	
	echo "done. bye:-) "
	exit
}


###############################################################################
# main
###############################################################################

while :
do
        echo "S) Setup New Databases"
        echo "C) Show Current Configuration"
        echo "L) Show State"
        echo "B) Backup Databases"
        echo "D) Delete Databases"
        echo "Q) Exit"

        echo ""
        read -p 'select:' ANS

        case $ANS in
        S)
                setupDatabase;
                ;;
        C)
                showConfig;
                ;;
        L)
                showState;
                ;;
        B)
                backup;
                ;;
        D)
                delete;
                ;;
        Q)
                quit;
                ;;
        q)
                quit;
                ;;
        *)
                echo "wrong selection $ANS"
                ;;
        esac
done

