#
# Create MySQL tables for Validation Service
#
# 2007-10-17 Nakamegu
# 2007-02-12 Munetoh 
# 2006-12-08 Munetoh
#

#
# User
#

DROP TABLE IF EXISTS `users`;
CREATE TABLE users (
	id int(11) NOT NULL auto_increment,
	login varchar(80) default NULL,
	password varchar(40) default NULL,
	PRIMARY KEY (id)
);

#
# Platform Information 
#

DROP TABLE IF EXISTS `distributions`;
CREATE TABLE distributions (
	id int(11) NOT NULL auto_increment,
	name varchar(255) NOT NULL,
	short varchar(10) NOT NULL,
	PRIMARY KEY (id)
);

DROP TABLE IF EXISTS `architectures`;
CREATE TABLE architectures (
	id int(11) NOT NULL auto_increment,
	name varchar(20) NOT NULL,
	UNIQUE KEY name (name),
	PRIMARY KEY (id)
);

DROP TABLE IF EXISTS `vendors`;
CREATE TABLE vendors(
	id int(11) NOT NULL auto_increment,
	name varchar(255) NOT NULL,
	UNIQUE KEY name (name),
	PRIMARY KEY (id)
);

DROP TABLE IF EXISTS `platforms`;
CREATE TABLE platforms(
	id int(11) NOT NULL auto_increment,
	vendor_id int(11) NOT NULL,
	name varchar(255),
	model varchar(255) NOT NULL,
	UNIQUE KEY model (model),
	PRIMARY KEY (id)
);

DROP TABLE IF EXISTS `bioses`;
CREATE TABLE bioses(
	id int(11) NOT NULL auto_increment,
	bios_ver varchar(45) NOT NULL,
	platform_id int(11),
	PRIMARY KEY (id)
);

