--
-- Create PostgreSQL tables for Vulnerability Information
--
-- 2007-10-17 Nakamegu
--

CREATE TABLE oval_definitions(
	id SERIAL PRIMARY KEY,
	definition_id VARCHAR(100) UNIQUE NOT NULL,
	title VARCHAR(150) NOT NULL,
	description VARCHAR(500) NOT NULL,
	cve VARCHAR(500)
);

CREATE TABLE oval_tests(
	id SERIAL PRIMARY KEY,
	test_id VARCHAR(100) UNIQUE NOT NULL,
	definition_id VARCHAR(100) NOT NULL,
	object_id VARCHAR(100) NOT NULL,
	state_id VARCHAR(100) NOT NULL
);

CREATE TABLE oval_objects(
	id SERIAL PRIMARY KEY,
	object_id VARCHAR(100) UNIQUE NOT NULL,
	name VARCHAR(45) NOT NULL
);

CREATE TABLE cve_definitions(
	id SERIAL PRIMARY KEY,
	cve_id VARCHAR(100) UNIQUE NOT NULL default '',
	url VARCHAR(255) default NULL,
	published_on DATE default NULL,
	modified_on DATE default NULL,
	nvd_severity VARCHAR(45) default NULL,
	nvd_cvss_score VARCHAR(45) default NULL,
	nvd_cvss_vector VARCHAR(100) default NULL,
	nvd_description VARCHAR(3000) default NULL,
	nvd_solution VARCHAR(500) default NULL
); 

CREATE TABLE debian_security_advisories(
	id SERIAL PRIMARY KEY,
	dsa_id VARCHAR(100) UNIQUE NOT NULL,
	url VARCHAR(255) default NULL,
	mid INTEGER default 0,
	package_name VARCHAR(100),
	reported_on DATE default NULL,
	summary VARCHAR(255) default NULL,
	vulnerability INTEGER default 0,
	cve VARCHAR(500) default NULL,
	fixed_version_sarge VARCHAR(50) default NULL,
	fixed_version_etch VARCHAR(50) default NULL,
	fixed_version_sid VARCHAR(50) default NULL
);

CREATE INDEX definition_id ON oval_definitions USING btree (definition_id);
CREATE INDEX test_id ON oval_tests USING btree (test_id);
CREATE INDEX test_definition_id ON oval_tests USING btree (definition_id);
CREATE INDEX test_object_id ON oval_tests USING btree (object_id);
CREATE INDEX test_state_id ON oval_tests USING btree (state_id);
CREATE INDEX object_id ON oval_objects USING btree (object_id);
CREATE INDEX cve_id ON cve_definitions USING btree (cve_id);
CREATE INDEX dsa_id ON debian_security_advisories USING btree (dsa_id);

CREATE RULE "DuplicateCveDefRule" AS ON INSERT TO cve_definitions WHERE (SELECT id FROM cve_definitions WHERE cve_id = NEW.cve_id ) IS NOT NULL DO INSTEAD UPDATE cve_definitions SET cve_id = NEW.cve_id WHERE id = (SELECT id FROM cve_definitions WHERE cve_id = NEW.cve_id ) ;

CREATE RULE "DuplicateOvalDefRule" AS ON INSERT TO oval_definitions WHERE (SELECT id FROM oval_definitions WHERE definition_id = NEW.definition_id ) IS NOT NULL DO INSTEAD UPDATE oval_definitions SET definition_id = NEW.definition_id WHERE id = (SELECT id FROM oval_definitions WHERE definition_id = NEW.definition_id ) ;

CREATE RULE "DuplicateOvalTestRule" AS ON INSERT TO oval_tests WHERE (SELECT id FROM oval_tests WHERE test_id = NEW.test_id ) IS NOT NULL DO INSTEAD UPDATE oval_tests SET test_id = NEW.test_id WHERE id = (SELECT id FROM oval_tests WHERE test_id = NEW.test_id ) ;

CREATE RULE "DuplicateOvalTestRule" AS ON INSERT TO oval_objects WHERE (SELECT id FROM oval_objects WHERE object_id = NEW.object_id ) IS NOT NULL DO INSTEAD UPDATE oval_objects SET object_id = NEW.object_id WHERE id = (SELECT id FROM oval_objects WHERE object_id = NEW.object_id ) ;

CREATE RULE "DuplicateDebianRule" AS ON INSERT TO debian_security_advisories WHERE (SELECT id FROM debian_security_advisories WHERE dsa_id = NEW.dsa_id ) IS NOT NULL DO INSTEAD UPDATE debian_security_advisories SET dsa_id = NEW.dsa_id WHERE id = (SELECT id FROM debian_security_advisories WHERE dsa_id = NEW.dsa_id ) ;


GRANT all on oval_definitions to ptsadmin;
GRANT all on oval_definitions_id_seq to ptsadmin;
GRANT all on oval_tests to ptsadmin;
GRANT all on oval_tests_id_seq to ptsadmin;
GRANT all on oval_objects to ptsadmin;
GRANT all on oval_objects_id_seq to ptsadmin;
GRANT all on cve_definitions to ptsadmin;
GRANT all on cve_definitions_id_seq to ptsadmin;
GRANT all on debian_security_advisories to ptsadmin;
GRANT all on debian_security_advisories_id_seq to ptsadmin;

GRANT select on oval_definitions to ptsuser;
GRANT select on oval_definitions_id_seq to ptsuser;
GRANT select on oval_tests to ptsuser;
GRANT select on oval_tests_id_seq to ptsuser;
GRANT select on oval_objects to ptsuser;
GRANT select on oval_objects_id_seq to ptsuser;
GRANT select on cve_definitions to ptsuser;
GRANT select on cve_definitions_id_seq to ptsuser;
GRANT select on debian_security_advisories to ptsuser;
GRANT select on debian_security_advisories_id_seq to ptsuser;

