/*
 * The Initial Developer of the Original Code is International
 * Business Machines Corporation. Portions created by IBM
 * Corporation are Copyright (C) 2007 International Business
 * Machines Corporation. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Common Public License as published by
 * IBM Corporation; either version 1 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Common Public License for more details.
 *
 * You should have received a copy of the Common Public License
 * along with this program; if not, a copy can be viewed at
 * http://www.opensource.org/licenses/cpl1.0.php.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <tpm_tools/tpm_unseal.h>

#include <getopt.h>

/* options */
const struct option long_option[] = {
	{"input", required_argument, NULL, 'i'},
	{"output", required_argument, NULL, 'o'},
	{"help", no_argument, NULL, 'h'},
	{0, 0, 0, 0}
};
const char short_option[] = "i:o:h";

void usage() {
	printf("Usage: tpm_unsealdata [options]\n");
	printf("\t-h, --help\n");
	printf("\t\tDisplay command usage info.\n");

	printf("\t-i, --input FILE\n");
	printf("\t\tFilename containing data to unseal.\n"); // Default is STDIN
	
	printf("\t-o, --output FILE\n");
	printf("\t\tFilename to write unsealed data to.  Default is STDOUT.\n");

}

int main(int argc, char *argv[])
{
	int rc = -1;
	char *infilename;
	char *outfilename = NULL;
	unsigned char *data;
	int size;
	int so;
	int i;

	while (1) {
		so = getopt_long(argc, argv, short_option, long_option, 0);
		if (so == -1)
			break;	// END

		switch (so) {
		case 'i':	/* input filename  */
			infilename = optarg;
			break;
		case 'o':	/* output filemame */
			outfilename = optarg;
			break;
		case 'h':	/* help */
			usage();
			goto end;
		default:
			usage();
			goto end;
		}
	}
	rc = tpmUnsealFile(infilename, &data, &size);

	if (rc != 0) {
		printf("unseal was failed rc=0x%x, %d\n", rc, rc);
		// 0x15 TPM_E_RESOURCE ?
		// 0x18 
	} else {

		/* Check file  */
		/*
		   int fd = stdout;
		   if (outfilename != NULL) {
		   fd = open(outfilename, O_CREAT);
		   if (fd <= 0) {
		   printf("ERROR: File open failed, %s \n",outfilename);
		   rc = -1; // TODO
		   goto end;
		   }
		   }    
		   write(fd, data, size);

		   if (outfilename != NULL) {
		   close(fd);
		   }
		 */
		FILE *fp = stdout;
		if (outfilename != NULL) {
			if ((fp = fopen(outfilename, "w")) == NULL) {
				printf("ERROR: File open failed, %s \n",
				       outfilename);
				rc = -1;	// TODO
				goto end;
			}
		}
		for (i = 0; i < size; i++)
			fputc(data[i], fp);
		//write(fd, data, size);

		if (outfilename != NULL) {
			fclose(fp);
		}
	}

      end:
	return rc;
}
