/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.engine;

import com.ibm.trl.tcg.pts.tools.Base64Tool;
import com.ibm.trl.tcg.pts.tools.BlobTool;

/**
 * @author munetoh
 * 
 */
public class PCPlatformSpecificEvent {

	/**
	 * @param e
	 * @return
	 * @throws Exception
	 */
	public static PlatformProperty getProperty(Event e) throws Exception {
		PlatformProperty p = new PlatformProperty();

		if (e == null) {
			// log.error("ERROR null Event at getProperty "); // TODO
			// p.setValidProperty("getProperty","ERROR"); // TODO
			// return p;
			throw new Exception("null Event at getProperty");
		}

		byte[] data = e.getEventData();
		int type = (int) BlobTool.UINT32(data, 0);

		byte[] pcEventData = new byte[(data.length - 8)];

		for (int i = 0; i < pcEventData.length; i++)
			pcEventData[i] = data[i + 8];

		p.set("TBD", "");
		switch (type) {
		case 0x0001:
			p.setValidProperty("SMBIOS", Base64Tool.encode(pcEventData));
			return p;
		case 0x0002:
			p.set("BIS Certificate", "TBD");
			return p;
		case 0x0003:
			p.set("POST BIOS ROM Strings", "TBD");
			return p;
		case 0x0004:
			p.set("ESCD", "TBD");
			return p;
		case 0x0005:
			p.setValidProperty("CMOS", Base64Tool.encode(pcEventData));
			return p;
		case 0x0006:
			p.setValidProperty("NVRAM", Base64Tool.encode(pcEventData));
			return p;
		case 0x0007:
			p.set("Option ROM Execute", "TBD");
			return p;
		case 0x0008:
			p.set("Option ROM Config", "TBD");
			return p;
		case 0x000A:
			p.set("Option ROM Microcode Update", "TBD");
			return p;
		case 0x000B:
			p.set("S-CRTM Version String", "TBD");
			return p;
		case 0x000C:
			p.set("S-CRTM Contents", "TBD");
			return p;
		case 0x000D:
			p.set("POST Contents", "TBD");
			return p;
		case 0x000E:
			p.set("Host Platform manufecture table of Devices", "TBD");
			return p;
		default:
			p.set("ERROR", "TBD");
			return p; // TODO Error
		}
	}

}
