/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.vulnerability.oval;

import java.sql.SQLException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibm.trl.tcg.pts.ibatis.SqlConfigIidbCreater;
import com.ibm.trl.tcg.pts.ibatis.dto.Measurements;
import com.ibm.trl.tcg.pts.ibatis.dto.Packages;
import com.ibm.trl.tcg.pts.vulnerability.tool.PackageVersionTool;

/**
 * Scan OVAL definition and pick up vul on packages.
 * 
 * @author Megumi Nakamura, Seiji Munetoh
 */
public class OvalRedhat2Others extends ReadOvalRedhat {

	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	private SqlMapClient sqlMapIidb = null; // Red Hat DB

	private SqlMapClient sqlMapIidb2 = null; // to be copied Red Hat DB

	public OvalRedhat2Others(int dbIndex, int dbIndex2) {
		sqlMapIidb = SqlConfigIidbCreater.getSqlMapInstance(dbIndex);
		sqlMapIidb2 = SqlConfigIidbCreater.getSqlMapInstance(dbIndex2);
	}

	/**
	 * Setup the database connections for the vulnerability database and
	 * integrity info database.
	 */
	public void setupDatabase() {
		try {
			sqlMapIidb.startTransaction();
			sqlMapIidb2.startTransaction();
			setup();

		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Running the all process of preparing the file, parsing the xml, inserting
	 * into the database.
	 */
	public void run() {
		log.debug("# REF REDHAT DB START");
		refRedhat();

	}

	/**
	 * Check all of the packages in the redhat database, and compare the version
	 * with the integrity info database.
	 */
	private void refRedhat() {
		try {
			String rpmname = null;
			String version = null;
			int vulnerability = 0;
			String oval = null;
			String cve = null;

			String versionIidb = null;
			int idIidb = 0;

			List<Packages> pkgs = (List<Packages>) sqlMapIidb
					.queryForList("getPackageAll");

			for (Packages p : pkgs) {
				rpmname = p.getPackageName();
				version = p.getPackageVersion();
				vulnerability = p.getPackageVulnerability();
				oval = p.getPackageOval();
				cve = p.getPackageCve();

				List<Packages> pkgs2 = (List<Packages>) sqlMapIidb2
						.queryForList("getPackageByName", rpmname);
				for (Packages p2 : pkgs2) {
					versionIidb = p2.getPackageVersion();
					idIidb = p2.getPackageId();
					checkVersionVul(vulnerability, idIidb, version,
							versionIidb, oval, cve);
				}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Compare the two versions, and make the sql query from the result.
	 * 
	 * @param vulnerability
	 *            The status of the redhat database
	 * @param packageId
	 *            The package id of the package at the target database
	 * @param versionRH
	 *            The version of the package in the redhat database
	 * @param versionIidb
	 *            The version of the package in the target database
	 * @param oval
	 *            The oval data of the redhat database
	 * @param cve
	 *            The cve data of the redhat database
	 */
	private void checkVersionVul(int vulnerability, int packageId,
			String versionRH, String versionIidb, String oval, String cve) {
		try {
			if (vulnerability == NO_VUL_DISTRO_MATCH
					|| vulnerability == NO_VUL_DISTRO_NOT_MATCH) {

				int rtn = PackageVersionTool.compareTwoVersion(versionRH,
						versionIidb);

				if (rtn == PackageVersionTool.LESS) { // RH < Iidb

					Packages pkgs = new Packages();
					pkgs.setPackageVulnerability(NO_VUL_DISTRO_NOT_MATCH);
					pkgs.setPackageOval(oval);
					pkgs.setPackageCve(cve);
					pkgs.setPackageId(packageId);
					sqlMapIidb2.update("updatePackageVulnerabilities", pkgs);
					sqlMapIidb2.commitTransaction();

					Measurements mgmt = new Measurements();
					mgmt.setDigestVulnerability(NO_VUL_DISTRO_NOT_MATCH);
					mgmt.setDigestPackageId(packageId);
					sqlMapIidb2.update("updateDigestVulnerabilityByPackageId",
							mgmt);
					sqlMapIidb2.commitTransaction();

				} else if (rtn == PackageVersionTool.EQUAL) {

					Packages pkgs = new Packages();
					pkgs.setPackageVulnerability(vulnerability);
					pkgs.setPackageOval(oval);
					pkgs.setPackageCve(cve);
					pkgs.setPackageId(packageId);
					sqlMapIidb2.update("updatePackageVulnerabilities", pkgs);
					sqlMapIidb2.commitTransaction();

					Measurements mgmt = new Measurements();
					mgmt.setDigestVulnerability(vulnerability);
					mgmt.setDigestPackageId(packageId);
					sqlMapIidb2.update("updateDigestVulnerabilityByPackageId",
							mgmt);
					sqlMapIidb2.commitTransaction();

				}
			} else if (vulnerability == VUL_DISTRO_MATCH
					|| vulnerability == VUL_DISTRO_NOT_MATCH) {

				int rtn = PackageVersionTool.compareTwoVersion(versionRH,
						versionIidb);
				if (rtn == PackageVersionTool.GREATER) { // RH > Iidb

					Packages pkgs = new Packages();
					pkgs.setPackageVulnerability(VUL_DISTRO_NOT_MATCH);
					pkgs.setPackageOval(oval);
					pkgs.setPackageCve(cve);
					pkgs.setPackageId(packageId);
					sqlMapIidb2.update("updatePackageVulnerabilities", pkgs);
					sqlMapIidb2.commitTransaction();

					Measurements mgmt = new Measurements();
					mgmt.setDigestVulnerability(VUL_DISTRO_NOT_MATCH);
					mgmt.setDigestPackageId(packageId);
					sqlMapIidb2.update("updateDigestVulnerabilityByPackageId",
							mgmt);
					sqlMapIidb2.commitTransaction();

				} else if (rtn == PackageVersionTool.EQUAL) {

					Packages pkgs = new Packages();
					pkgs.setPackageVulnerability(vulnerability);
					pkgs.setPackageOval(oval);
					pkgs.setPackageCve(cve);
					pkgs.setPackageId(packageId);
					sqlMapIidb2.update("updatePackageVulnerabilities", pkgs);
					sqlMapIidb2.commitTransaction();

					Measurements mgmt = new Measurements();
					mgmt.setDigestVulnerability(vulnerability);
					mgmt.setDigestPackageId(packageId);
					sqlMapIidb2.update("updateDigestVulnerabilityByPackageId",
							mgmt);
					sqlMapIidb2.commitTransaction();
				}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Main.
	 * @param args
	 */
	public static void main(String[] args) {
		OvalRedhat2Others oval = new OvalRedhat2Others(1, 2);
		oval.setupDatabase();
		oval.run();
	}
}
