/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.LinkedHashMap;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;

import net.sf.jtreemap.swing.ColorProvider;
import net.sf.jtreemap.swing.DefaultToolTipBuilder;
import net.sf.jtreemap.swing.IToolTipBuilder;
import net.sf.jtreemap.swing.JTreeMap;
import net.sf.jtreemap.swing.SplitBySortedWeight;
import net.sf.jtreemap.swing.TreeMapNode;
import net.sf.jtreemap.swing.example.BuilderTM3;
import net.sf.jtreemap.swing.provider.ZoomPopupMenu;
import javax.swing.BoxLayout;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import tcdemo.Config;

/**
 * 
 * Size XGA
 * 1000x700
 * 
 * @author Seiji Munetoh
 *
 */
public class VendorTool extends JFrame {

	//private static JwsWrapper jw;
	private static Config config;

	String[] serverUrls = {"http://localhost","http://pts.ibm.com"};
	static String[] serviceList;

	String[] pcrTableColumnNames = {
			"Index" , "Digest(hex)","Usage","Status"
	};
	
	static String[][] pcrTableRowData; 
	static String[] eventlogTableColumnNames = {
			"PCR Index" , "Digest(hex)","Name","Status"
	};
	static String[][] eventlogTableRowData;
	
	private static DefaultTableModel tableModelEventlog;
	
	private static TreeMapNode treemapComponentRoot;
	private static TreeMapNode treemapSecurityPropRoot;

	private DefaultTreeModel treeModel;
	private final static LinkedHashMap<String, ColorProvider> cpColorProviders = new LinkedHashMap<String, ColorProvider>();  //  @jve:decl-index=0:
	private final static LinkedHashMap<String, ColorProvider> spColorProviders = new LinkedHashMap<String, ColorProvider>();
	
	private static final long serialVersionUID = 1L;

	private JMenuBar jJMenuBar = null;

	private JMenu jMenuFile = null;

	private JMenu jMenuHelp = null;

	private JMenuItem jMenuItemAbout = null;

	private JMenuItem jMenuItemHelp = null;

	private JMenuItem jMenuItemExit = null;

	private JPanel jPanel = null;

	private JTabbedPane jTabbedPane = null;

	private JPanel jPanelButtom = null;

	private JTextField jTextFieldMessage = null;

	private static String username;

	private static String biosVersionName;

	private static String macineTypeName;

	private static String pcVendorName;


	private JPanel jPanelComponentMap = null;

	private JPanel jPanel2 = null;

	private JTreeMap jTreeMapComponents = null;

	private JLabel jLabel10 = null;

	private static DefaultTreeModel treeModelSP;

	private JScrollPane jScrollPaneCP = null;

	private JTree jTreeCP = null;

	private JToolTip jToolTipCP;

	private DefaultToolTipBuilder toolTipBuilderSP;

	private static IToolTipBuilder toolTipBuilderCP;

	private static DefaultTreeModel treeModelCP;

	private JPanel jPanelPackages = null;

	private JRadioButton jRadioButtonDeb = null;

	private JRadioButton jRadioButtonRpm = null;

	private JLabel jLabel = null;

	private JLabel jLabel1 = null;

	private JTextField jTextFieldWorkDir = null;

	private JButton jButtonCreatePackageInfo = null;

	private JLabel jLabel2 = null;

	private JButton jButtonSubmit = null;

	private JComboBox jComboBoxIidbIndex = null;

	/**
	 * This method initializes jJMenuBar	
	 * 	
	 * @return javax.swing.JMenuBar	
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.add(getJMenuFile());
			jJMenuBar.add(getJMenuHelp());
		}
		return jJMenuBar;
	}

	/**
	 * This method initializes jMenuFile	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuFile() {
		if (jMenuFile == null) {
			jMenuFile = new JMenu();
			jMenuFile.setText("File");
			jMenuFile.add(getJMenuItemExit());
		}
		return jMenuFile;
	}

	/**
	 * This method initializes jMenuHelp	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuHelp() {
		if (jMenuHelp == null) {
			jMenuHelp = new JMenu();
			jMenuHelp.setText("Help");
			jMenuHelp.add(getJMenuItemAbout());
			jMenuHelp.add(getJMenuItemHelp());
		}
		return jMenuHelp;
	}

	/**
	 * This method initializes jMenuItemAbout	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemAbout() {
		if (jMenuItemAbout == null) {
			jMenuItemAbout = new JMenuItem("About");
		}
		return jMenuItemAbout;
	}

	/**
	 * This method initializes jMenuItemHelp	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemHelp() {
		if (jMenuItemHelp == null) {
			jMenuItemHelp = new JMenuItem("Help");
		}
		return jMenuItemHelp;
	}

	/**
	 * This method initializes jMenuItemExit	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemExit() {
		if (jMenuItemExit == null) {
			jMenuItemExit = new JMenuItem("Exit");
			jMenuItemExit.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					System.out.println("actionPerformed() Menu Exit"); 
					System.exit(0);
				}
			});
		}
		return jMenuItemExit;
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setLayout(null);
			jPanel.add(getJTabbedPane(), null);
			jPanel.add(getJPanelButtom(), null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJTabbedPane() {
		if (jTabbedPane == null) {
			jTabbedPane = new JTabbedPane();
			jTabbedPane.setLocation(new Point(0, 0));
			jTabbedPane.setSize(new Dimension(992, 600));
			jTabbedPane.addTab("Packages", null, getJPanelPackages(), null);
			jTabbedPane.addTab("Components Map", null, getJPanel12(), null);
		}
		return jTabbedPane;
	}

	/**
	 * This method initializes jPanelButtom	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelButtom() {
		if (jPanelButtom == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 1;
			gridBagConstraints1.weightx = 1.0;
			jPanelButtom = new JPanel();
			jPanelButtom.setLayout(new GridBagLayout());
			jPanelButtom.setBounds(new Rectangle(8, 609, 978, 31));
			jPanelButtom.add(getJTextFieldMessage(), gridBagConstraints1);
		}
		return jPanelButtom;
	}

	/**
	 * This method initializes jTextFieldMessage	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldMessage() {
		if (jTextFieldMessage == null) {
			jTextFieldMessage = new JTextField();
			jTextFieldMessage.setPreferredSize(new Dimension(600, 25));
			jTextFieldMessage.setEditable(false);
		}
		return jTextFieldMessage;
	}


	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel12() {
		if (jPanelComponentMap == null) {
			jPanelComponentMap = new JPanel();
			jPanelComponentMap.setLayout(null);
			jPanelComponentMap.add(getJPanel2(), null);
			jPanelComponentMap.add(getJScrollPaneCP(), null);
			jPanelComponentMap.add(getJTreeMapComponents(), null);
		}
		return jPanelComponentMap;
	}

	/**
	 * This method initializes jPanel2	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel2() {
		if (jPanel2 == null) {
			jLabel10 = new JLabel();
			jLabel10.setBounds(new Rectangle(57, 6, 232, 22));
			jLabel10.setText("CVSS vs Package Size");
			jPanel2 = new JPanel();
			jPanel2.setLayout(null);
			jPanel2.setBounds(new Rectangle(4, 4, 977, 36));
			jPanel2.add(jLabel10, null);
		}
		return jPanel2;
	}

	/**
	 * This method initializes jTreeMapComponents	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JTreeMap getJTreeMapComponents() {
		if (jTreeMapComponents == null) {
			jTreeMapComponents = new JTreeMap(this.treemapComponentRoot, jTreeCP);
			//jTreeMapComponents.setLayout(new GridBagLayout());
			jTreeMapComponents.setSize(new Dimension(700, 500));
			jTreeMapComponents.setLocation(new Point(210, 30));
			
			{
				jTreeMapComponents.setStrategy(new SplitBySortedWeight());
				jTreeMapComponents.setColorProvider(new CvssColorProvider(this.jTreeMapComponents));
				//jToolTipCP = 
				//jTreeMapComponents.createToolTip();
				//jToolTipCP.setBackground(Color.white);
				//jTreeMapComponents.setToolTipText("HOGE");
				
				toolTipBuilderCP = new DefaultToolTipBuilder(jTreeMapComponents,"DD","FF",true);

				
				//jTreeMapComponents.setToolTipBuilder(toolTipBuilderCP);
				
				new ZoomPopupMenu(jTreeMapComponents);
			}
		}
		return jTreeMapComponents;
	}

	/**
	 * This method initializes jScrollPaneCP	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPaneCP() {
		if (jScrollPaneCP == null) {
			jScrollPaneCP = new JScrollPane();
			jScrollPaneCP.setLocation(new Point(5, 45));
			jScrollPaneCP.setSize(new Dimension(200, 500));
			jScrollPaneCP.setViewportView(getJTreeCP());
		}
		return jScrollPaneCP;
	}

	/**
	 * This method initializes jTreeCP	
	 * 	
	 * @return javax.swing.JTree	
	 */
	private JTree getJTreeCP() {
		if (jTreeCP == null) {
			jTreeCP = new JTree(treeModelCP);
			jTreeCP.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
				public void valueChanged(javax.swing.event.TreeSelectionEvent e) {
					/* Zoom-in */
					TreeMapNode tmn = (TreeMapNode) jTreeCP.getLastSelectedPathComponent();
					if (tmn != null && tmn.isLeaf() ) {
						/* leaf element -> use parent */
						tmn = (TreeMapNode) tmn.getParent();
					}
					if (tmn == null) {
						// TODO
						return;
					}
					jTreeMapComponents.zoom(tmn);
					jTreeMapComponents.repaint();
				}
			});
		}
		return jTreeCP;
	}

	/**
	 * This method initializes jPanelPackages	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelPackages() {
		if (jPanelPackages == null) {
			jPanelPackages = new JPanel();
			jPanelPackages.setLayout(null);
			jPanelPackages.add(getJRadioButtonDeb(), null);
			jPanelPackages.add(getJRadioButtonRpm(), null);
			jPanelPackages.add(jLabel, null);
			jPanelPackages.add(jLabel1, null);
			jPanelPackages.add(getJTextFieldWorkDir(), null);
			jPanelPackages.add(getJButtonCreatePackageInfo(), null);
			jPanelPackages.add(jLabel2, null);
			jPanelPackages.add(getJButtonSubmit(), null);
			jPanelPackages.add(getJComboBoxIidbIndex(), null);
		}
		return jPanelPackages;
	}





	/**
	 * This method initializes jRadioButtonDeb	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getJRadioButtonDeb() {
		if (jRadioButtonDeb == null) {
			jRadioButtonDeb = new JRadioButton();
			jRadioButtonDeb.setText("Debian");
			jRadioButtonDeb.setLocation(new Point(30, 127));
			jRadioButtonDeb.setSize(new Dimension(70, 20));
			jRadioButtonDeb.setSelected(true);
		}
		return jRadioButtonDeb;
	}

	/**
	 * This method initializes jRadioButtonRpm	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getJRadioButtonRpm() {
		if (jRadioButtonRpm == null) {
			jRadioButtonRpm = new JRadioButton();
			jRadioButtonRpm.setText("RPM");
			jRadioButtonRpm.setSize(new Dimension(70, 20));
			jRadioButtonRpm.setLocation(new Point(30, 145));
		}
		return jRadioButtonRpm;
	}

	/**
	 * This method initializes jTextFieldWorkDir	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldWorkDir() {
		if (jTextFieldWorkDir == null) {
			jTextFieldWorkDir = new JTextField();
			jTextFieldWorkDir.setBounds(new Rectangle(45, 31, 329, 23));
		}
		return jTextFieldWorkDir;
	}

	/**
	 * This method initializes jButtonCreatePackageInfo	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonCreatePackageInfo() {
		if (jButtonCreatePackageInfo == null) {
			jButtonCreatePackageInfo = new JButton();
			jButtonCreatePackageInfo.setText("Create Package Info");
			jButtonCreatePackageInfo.setEnabled(false);
			jButtonCreatePackageInfo.setBounds(new Rectangle(26, 170, 137, 21));
		}
		return jButtonCreatePackageInfo;
	}

	/**
	 * This method initializes jButtonSubmit	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonSubmit() {
		if (jButtonSubmit == null) {
			jButtonSubmit = new JButton();
			jButtonSubmit.setText("Submit Package Info");
			jButtonSubmit.setEnabled(false);
			jButtonSubmit.setBounds(new Rectangle(24, 284, 137, 21));
		}
		return jButtonSubmit;
	}

	/**
	 * This method initializes jComboBoxIidbIndex	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxIidbIndex() {
		if (jComboBoxIidbIndex == null) {
			jComboBoxIidbIndex = new JComboBox();
			jComboBoxIidbIndex.setBounds(new Rectangle(30, 245, 349, 26));
		}
		return jComboBoxIidbIndex;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		/* Initialize PTS Client */
		
		try {
			config= new Config(args);
			serviceList = config.getServiceList();
			pcrTableRowData = config.getPcrData();		
			eventlogTableRowData = config.getEventlogData();
			username = config.getUsername(0);
			pcVendorName = config.getPcVendorName();
			macineTypeName = config.getMacineTypeName();
			biosVersionName = config.getBiosVersionName();
			tableModelEventlog = 
				new DefaultTableModel(eventlogTableColumnNames, 0);
		
			/* Treemap Components */
			//String cpFilename="sampleCP.tm3"; // TODO
			//String cpFilename="rpm-qi-data.tm3"; // TODO
			//String cpFilename="sampledata/knoppix511tcg.tm3"; // TODO
			//String cpFilename="../openpts-testsuite/sandbox/knoppix511tcg.tm3"; // TODO
			//String cpFilename="/opt/OpenPlatformTrustServices/tcdemo/sample.tm3";
			String cpFilename = config.getTM3Filename();
			BuilderTM3 cpBuilderTM3 = new BuilderTM3(new File(cpFilename));
			treemapComponentRoot = cpBuilderTM3.getRoot();
			cpBuilderTM3.setValues("CVSS");
			//cpBuilderTM3.setWeights("LOC");
			cpBuilderTM3.setWeights("Dependency");
		
			treeModelCP = new DefaultTreeModel(treemapComponentRoot);
				
			
			
			/* Swing */
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					VendorTool thisClass = new VendorTool();
					thisClass.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
					thisClass.setVisible(true);
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	/**
	 * This is the default constructor
	 */
	public VendorTool() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(1000, 700);
		this.setContentPane(getJPanel());
		this.setJMenuBar(getJJMenuBar());
		this.setTitle("Platform Trust Service - Client (Debug)");
	}

}  //  @jve:decl-index=0:visual-constraint="1,-9"
