/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	O[v̐i\NX
//
//		ύX
//			2005.01.27  VK쐬  Katsuhiko.Sakurai(UNITEC)
//
//	@\
//
//	̃NX̓O[v̐i\NXłB
//
////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.progress;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.co.ntt.lms.lo.progress.util.LearningProgressConfigurationManager;
import jp.co.ntt.lms.lo.progress.util.XMOInformationGetter;
import jp.co.ntt.lms.xmo.Groups.GroupsClient;

/**
 * O[viNXłB
 * 
 * @author Katsuhiko Sakurai (UNITEC)
 * @version 1.0
 */
public class GroupProgress extends AbstractPeopleProgress {

	private GroupsClient groupClient = null;
	private List childList = null;
	
	/**
	 * RXgN^łB
	 * 
	 * @param groupID ΏۂƂȂO[vID
	 * @param targetLOID ΏۂƂȂLoID 
	 * @param level Kw̃x 
	 * @throws Exception
	 */
	public GroupProgress(String groupID, String targetLOID, int level) throws Exception {
		super(groupID, targetLOID, level);
	}

	/**
	 * RXgN^łB
	 * 
	 * @param groupID ΏۂƂȂO[vID
	 * @param targetLOID ΏۂƂȂLoID 
	 * @param level Kw̃x 
	 * @param config Oݒt@C 
	 * @throws Exception
	 */
	public GroupProgress(String groupID, String targetLOID, int level, 
			LearningProgressConfigurationManager config) throws Exception {
		
		super(groupID, targetLOID, level, config);

		this.childList = new ArrayList();

		if (groupID.equals("grouptreeroot")) return;
		
		// O[vIDPeopleNCAg擾
		this.groupClient = XMOInformationGetter.getGroup(groupID); 
	}
	
	/**
	 * iXg𐶐܂B
	 * Ǝq̊Kw\Xg\ɂĕԂ܂B
	 * 
	 * @return List iXg 
 	 * @throws Exception
	 */
	public List getProgressList() {
		
		ArrayList list = new ArrayList();
		
		// [g̏ꍇ͐iXgɒǉȂ
		if ( this.groupClient != null 
				&& this.groupClient.getGroupID().equals("GR000000") == false ) {
			list.add(this);
		}
		
		Iterator ite = this.childList.iterator();
		while( ite.hasNext()) {
			
			XMOProgress xmoProgress = (XMOProgress)ite.next();
			
			List childList = xmoProgress.getProgressList();
			Iterator iteChild = childList.iterator();
			
			while( iteChild.hasNext() ) {
				list.add(iteChild.next());
			}
		}
		
		return list;
	}
	
	/**
	 * O[vɎq̃[Uiǉ܂B
	 * 
	 * @param progress q[U̐i
	 * @return XMOProgress IuWFNg 
 	 * @throws Exception
	 */
	public XMOProgress add(XMOProgress progress) throws Exception {
		this.childList.add(progress);
		return this;
	}
	
	/**
	 * i̍ږ̂擾܂B
	 * 
	 * @return String O[v 
	 */
	public String getItemName() {
		return this.groupClient.getGroupName();
	}

	/**
	 * Kwxtꂽږ擾܂B
	 * 
	 * @return String KwxtꂽO[v 
	 */
	public String getNestedItemName() {
		String space = "@";
		for(int i=1; i<=this.level; i++) space += space;
		
		return space + this.getItemName();
	}

	/**
	 * O[v̐擾܂B
	 * 
	 * @return String O[v̐ 
	 */
	public String getExplanation() {
		return this.groupClient.getCustomMsgDir();
	}
}
