/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	LOi̊Kw\\zNX
//
//		ύX
//			2005.01.27  VK쐬  Katsuhiko.Sakurai(UNITEC)
//
//	@\
//
//	̃NXLOi̊Kw\\zNXłB
//
////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.progress;

import java.util.Iterator;
import java.util.List;

import jp.co.ntt.lms.lo.progress.util.XMOInformationGetter;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.Lo.LoData;
import jp.co.ntt.lms.xmo.LoRelation.LoRelationClient;

/**
 * LOi̊Kw\\zNXłB
 * 
 * @author Katsuhiko Sakurai (UNITEC)
 * @version 1.0
 */
public class LOProgressTreeFactory extends AbstractXMOProgressTreeFactory {

	/**
	 * RXgN^łB
	 * 
	 * @param parentID Kw\̐eLOID
	 * @param targetID ΏۂƂȂ郆[UEO[vID
	 * @param loginID OC[UID
	 */
	public LOProgressTreeFactory(String parentID, String targetID, String loginID) {
		super(parentID, targetID, loginID);
	}

	/**
	 * LoiKw\𐶐܂B
	 * 
	 * @param parentID 	Kw\̐eLoID
	 * @param targetUserID ΏۂƂȂ郆[UEO[vID
	 * @param loginID OC[UID
	 * @param level Kwx
	 * @return XMOProgress LOiKw\̃[g
	 * @exception Exception
	 */
	protected XMOProgress createProgressTree(String parentID, String targetUserID, String loginID, int level ) throws Exception {
		
		XMOProgress rootProgress = null;
		
		// LO[g̏ꍇ
		if( parentID.equals("LO0") ) {
			
			rootProgress = new ContainerProgress( parentID, targetUserID, level, super.getConfigManager() );

			// w胆[U[g[ȔꍇSLOΏ
			if (targetUserID.equals("PE000000")) {

				// LO̎qLO擾
				LoRelationClient loRelation = new LoRelationClient();
				List childLoIDs = loRelation.getLoIds( parentID );
				Iterator ite = childLoIDs.iterator();
				
				// 
				while( ite.hasNext() ) {
					XMOProgress xmoProgress = this.createProgressTree( ite.next().toString(), targetUserID, loginID, level );
					rootProgress.add( xmoProgress );
				}
			
			// [g[UȊO̓[UɃATCĂLÕc[쐬
			} else {
			
				//w胆[UɊwKATCĂ郋[gLO擾
				List rootLOs = XMOInformationGetter.getRootLoList(targetUserID, 1);
				
				// OC[UɊǗATCĂ郋[gLO擾
				List rootLOsOfLoginUser = XMOInformationGetter.getRootLoList(loginID, 2);
				
				XMOProgress progress = null;
				Iterator iteRootLos = rootLOs.iterator();

				while(iteRootLos.hasNext()) {
				
					LoData loData = (LoData)iteRootLos.next();
					
					// OC[U[gȊOŁAg̃OQƈȊȌꍇA
					// OC[UɊǗ̂LOǂ`FbN
					if (loginID.equals("PE000000") == false && loginID.equals(targetUserID) == false) {
						if ( this.containsLoData(loData,rootLOsOfLoginUser ) == false ) continue;
					}

					// Reȉꍇ
					if ( loData.getLoType().equals("0") ){
						progress = new ContainerProgress( loData.getLoID(), 
															targetUserID, 
															level, 
															super.getConfigManager() );
							
						// LO̎qLO擾
						LoRelationClient loRelation = new LoRelationClient();
						List childLoIDs = loRelation.getLoIds( loData.getLoID() );
						Iterator ite = childLoIDs.iterator();
						
						// KwJEgAbv
						int childLolevel = level + 1 ;
						
						// 
						while( ite.hasNext() ) {
							XMOProgress childProgress = 
								this.createProgressTree( ite.next().toString(),
															targetUserID, 
															loginID,
															childLolevel);
							progress.add( childProgress );
						}
							
					// LȌꍇ
					} else {
						progress = new LOProgress( loData.getLoID(), targetUserID, level, super.getConfigManager() );
					}
					
					rootProgress.add(progress);
				}
			}
			
		// LOw肳ꂽƂ
		} else {
		
			LoClient parentLO = XMOInformationGetter.getLO( parentID );
			
			// eLOLORei𔻒肵A[gXMOProgress쐬
			// Reȉꍇ
			if ( parentLO.getLoType().equals("0") ){
	
				rootProgress = new ContainerProgress( parentID, targetUserID, level, super.getConfigManager() );
				
				// KwxJEgAbv
				level++;
				
				// LO̎qLO擾
				LoRelationClient loRelation = new LoRelationClient();
				List childLoIDs = loRelation.getLoIds( parentID );
				Iterator ite = childLoIDs.iterator();
				
				// 
				while( ite.hasNext() ) {
					XMOProgress xmoProgress = 
							this.createProgressTree( ite.next().toString(), 
														targetUserID, 
														loginID,
														level );
					rootProgress.add( xmoProgress );
				}
				
			// ReiȊȌꍇ
			}else{
				
				rootProgress = new LOProgress( parentID, targetUserID, level, super.getConfigManager() );
			}
		}
		
		return rootProgress;
	}
	
	/**
	 * w肳ꂽLOf[^w肳ꂽLõXgɊ܂܂邩𔻕ʂ܂B
	 * 
	 * @param loData Lõf[^
	 * @param targetList LõXg
	 * @return boolean LoXgɊ܂܂邩 True:܂܂
	 */
	private boolean containsLoData(LoData loData, List targetList) {
		Iterator ite = targetList.iterator();
		while(ite.hasNext()){
			if ( ((LoData)ite.next()).getLoID().equals(loData.getLoID()) ) return true;
		}
		return false;
	}
}
