/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	iNX
//
//		ύX
//			2005.01.27  VK쐬  Katsuhiko.Sakurai(UNITEC)
//
//	@\
//
//	̃NX͐i\NXłB
//
////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.progress;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.ntt.lms.Common.RDF.RDFDocument;
import jp.co.ntt.lms.Common.RDF.RDFNode;
import jp.co.ntt.lms.lo.LoComData;
import jp.co.ntt.lms.lo.LoTopClient;
import jp.co.ntt.lms.lo.SmartForce.CourseUnitLogRecord;
import jp.co.ntt.lms.lo.progress.util.LOConfiguration;
import jp.co.ntt.lms.lo.progress.util.LearningProgressConfigurationManager;
import jp.co.ntt.lms.lo.progress.util.LearningStatusConfiguration;
import jp.co.ntt.lms.lo.progress.util.TimeSpan;
import jp.co.ntt.lms.lo.progress.util.XMOInformationGetter;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.Assignments.AssignmentsClient;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.LoRelation.LoRelationClient;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.base.Logic;
import jp.co.ntt.lms.xms.framework.base.RemoteLogicClient;
import jp.co.ntt.lms.xms.logsumup.LoLogConstant;
import jp.co.ntt.lms.xms.logsumup.LoLogLearnMaterialStatusLogic;
import jp.co.ntt.lms.xms.logsumup.LoLogLearnStatusParam;
import jp.co.ntt.lms.xms.logsumup.LoLogLearnStatusResult;
import jp.co.ntt.lms.xms.logsumup.scorm.IndividualLogUserProgressLogic;
import jp.co.ntt.lms.xms.logsumup.scorm.IndividualLogUserProgressResult;
import jp.co.ntt.lms.xms.logsumup.scorm.IndividualLogUserProgressStoreData;
import jp.co.ntt.lms.xms.logsumup.scorm.ScormDocument;
import jp.co.ntt.lms.xms.logsumup.scorm.ScormItemList;

/**
* iNXłB
* 
* @author Katsuhiko Sakurai (UNITEC)
* @version 1.0
*/
public class LearningProgress {
	
	private Date startDate = null;
	private Date endDate = null;
	private String studyStatus = null;
	private String progress = null;
	private String progressRate = null;
	private String loID = null;
	private String userID = null;
	private boolean isAssigned = true;
	private String loType = null;
	private LoState loState = null;
	
	private LearningProgressConfigurationManager configManager = null; 
	
	private final static String NO_DATA_STRING = "---";
	private final String DATE_FORMAT_STRING = "yyyy/MM/dd";
	private final String PROGRESS_RATE_UNIT ="%";
	private final String LEARNING_SPAN_UNIT ="";
	
	/**
	 * i100%\
	 */
	private final String PROGRESS_RATE_COMPLETE = "100";
	
	/**
	 * i0%\
	 */
	private final String PROGRESS_RATE_NOTSTART = "0";
	
	/**
	 * RXgN^łB
	 * 
	 */
	public LearningProgress(){}
	
	/**
	 * RXgN^łB
	 * 
	 * @param userID ΏۂƂȂO[vID̓[UID
	 * @param loID ΏۂƂȂLoID 
	 * @throws Exception
	 */
	public LearningProgress(String userID, String loID) throws Exception{
		this(userID, loID, null);
	}
	
	/**
	 * RXgN^łB
	 * 
	 * @param userID ΏۂƂȂO[vID̓[UID
	 * @param loID ΏۂƂȂLoID 
	 * @param configManager ݒlǗIuWFNg 
	 * @throws Exception
	 */
	public LearningProgress(String userID, String loID, LearningProgressConfigurationManager configManager) throws Exception{
		
		this.userID = userID;
		this.loID = loID;
		this.configManager = configManager;
		
		// LOʂ擾
		LoClient loClient = XMOInformationGetter.getLO(loID);
		this.loType = (loClient == null) ? "" : loClient.getLoType();

		// if[^̏
		this.setAssignmentNoData();

		// [Ułΐi쐬
		if (userID.startsWith("GR") == false ) { 
			this.makeProgress(userID, loID, this.loType);
		}
	}
	
	/**
	 * wKI擾܂B
	 * 
	 * @return Date wKI 
	 */
	public Date getEndDate() {
		return this.endDate;
	}

	/**
	 * `ꂽwKI擾܂B
	 * 
	 * @return String `ꂽwKI 
	 */
	public String getFormattedEndDate() {
		return ( this.endDate ==null 
				? NO_DATA_STRING
				: new SimpleDateFormat(DATE_FORMAT_STRING).format(this.endDate));
	}

	/**
	 * ΏۂƂȂLOID擾܂B
	 * 
	 * @return String LOID 
	 */
	public String getLoID() {
		return this.loID;
	}
	
	/**
	 * i󋵂擾܂B
	 * 
	 * @return String i
	 */
	public String getProgress() {
		return this.progress;
	}
	
	/**
	 * `ꂽi󋵂擾܂B
	 * 
	 * @return String `ꂽi
	 */
	public String getFormattedProgress() {
		return ( this.progress.length() == 0 ? NO_DATA_STRING : this.progress );
	}

	/**
	 * i擾܂B
	 * 
	 * @return String i
	 */
	public String getProgressRate() {
		return this.progressRate;
	}

	/**
	 * `ꂽi擾܂B
	 * 
	 * @return String `ꂽi
	 */
	public String getFormattedProgressRate() {
		
		// iݒ肳ĂȂꍇ
		// i0%A100%̏ꍇ
		// f[^ȂԂ
		if (this.progressRate.length() == 0 
				|| this.progressRate.equals("100") 
				|| this.progressRate.equals("0")) {
			
			return NO_DATA_STRING;
			
		} else {
		
			return this.progressRate + PROGRESS_RATE_UNIT;
		}
	}

	/**
	 * wKJn擾܂B
	 * 
	 * @return Date wKJn
	 */
	public Date getStartDate() {
		return this.startDate;
	}
	
	/**
	 * `wKJn擾܂B
	 * 
	 * @return String `wKJn
	 */
	public String getFormattedStartDate() {
		return ( this.startDate ==null 
					? NO_DATA_STRING
					: new SimpleDateFormat(DATE_FORMAT_STRING).format(this.startDate));
	}

	/**
	 * wK󋵂擾܂B
	 * 
	 * @return String wK
	 */
	public String getStudyStatus() {
		return this.studyStatus;
	}

	/**
	 * `ꂽwK󋵂擾܂B
	 * 
	 * @return String `ꂽwK
	 */
	public String getFormattedStudyStatus() {
		return (this.studyStatus.length()==0 ? NO_DATA_STRING : this.studyStatus);
	}
	
	/**
	 * wKԂ擾܂B
	 * 
	 * @return String wK
	 */
	public String getLearningSpan() {
		if (this.endDate == null || this.startDate == null ) {
			return "";
		} else {
			double endTime = this.endDate.getTime();
			double startTime = this.startDate.getTime();
			
			// PʂɕϊA[͐؂グ
			int span = (int)Math.ceil( ( endTime - startTime ) / (24*60*60*1000) );
			return String.valueOf(span);
		}
	}
	
	/**
	 * `wKԂ擾܂B
	 * 
	 * @return String `wK
	 */
	public String getFormattedLearningSpan() {
		
		String learningSpan = this.getLearningSpan();
		
		if (learningSpan.length() == 0 ) {
			return NO_DATA_STRING;
		} else {
			return learningSpan + LEARNING_SPAN_UNIT;
		}
	}
	
	/**
	 * w胆[UɎwLOATCĂ邩ǂ擾܂B
	 * 
	 * @return boolean ATCĂTrue
	 */
	public boolean isAssigned () {
		return this.isAssigned;
	}
	
	/**
	 * if[^̏lݒ肵܂B
	 *
	 */
	private void setAssignmentNoData() {
		this.startDate = null;
		this.endDate = null;
		this.studyStatus = "";
		this.progress = "";
		this.progressRate = "";
		this.loState = null;
	}
	
	/**
	 * i쐬܂B
	 * 
	 * @param userID [UID̓O[vID
	 * @param loID@LOID
	 * @param loType Lo
	 * @throws Exception
	 */
	private void makeProgress( String userID, String loID, String loType) throws Exception {
		
		DebugLog.write( this.getClass(), 
				MessageFormat.format("iJnFLOID={0},UserID={1},LOType={2}",new String[]{loID,userID,loType}),
						DebugLog.ROW );

		// [gLOȂ珈Ȃ
		if (loID.equals("LO0")) return;
		
		// w胆[UɎw肳ꂽLOATCĂ邩`FbN
		if (AssignmentsClient.checkAssignAuth(userID, loID, AssignmentsClient.LEARN_TYPE) == false ) {
			this.isAssigned = false;
			return;
		}
		
		// i󋵐ݒXMLt@C̃f[^擾
		LearningProgressConfigurationManager configManager = ( this.configManager == null
																	? new LearningProgressConfigurationManager()
																	: this.configManager );
		
		LOConfiguration loConfig = configManager.getLOCongifuration(loID);
		LearningStatusConfiguration learningStatusConfig = configManager.getLearningStatusConfiguration();

		// wKJn擾
		Date learningStartDate = this.getLearningStartDate(userID, loID, loConfig);
		DebugLog.write( this.getClass(), "wKJn擾IF" + (learningStartDate==null ?"Ȃ":learningStartDate.toString()), DebugLog.ROW );
		
		// wKI擾
		Date learningEndData = this.getLearningEndDate(userID, loID, learningStartDate, loConfig);
		DebugLog.write( this.getClass(), "wKI擾IF"+ (learningEndData==null ?"Ȃ":learningEndData.toString()), DebugLog.ROW );
				
		// LOʃO擾
		LoLogLearnStatusResult commonLog = this.getLoLog(loID,userID);
		DebugLog.write( this.getClass(), "LOʃO擾IF", DebugLog.ROW );
		
		// LȌԂ擾
		LoState loState = this.getLoState(commonLog);
		
		// wK󋵂̎擾
		String studyStatus = this.getStudyStatus(loState, learningStatusConfig);
		DebugLog.write( this.getClass(), "wK󋵎擾IF"+ studyStatus, DebugLog.ROW );
		
		// LO̐i擾
		String loProgressRate = this.makeLoProgressRate(loState, loConfig);
		DebugLog.write( this.getClass(), "LOiF"+loProgressRate, DebugLog.ROW );
		
		// LOʂɂU蕪
		String progressStatus=null;
		String progressRate=null;
		
		// Reȉꍇ
		if (loType.equals("0")) {
			
			Map childProgressRateList = new HashMap();
			
			LoRelationClient loRelation = new LoRelationClient();
			List childLoIDs = loRelation.getLoIds( loID );

			Iterator ite = childLoIDs.iterator();
			while(ite.hasNext()){
				LearningProgress childLearningProgress = new LearningProgress(userID, ite.next().toString(), configManager);
				
				//iXgɒǉ
				childProgressRateList.put(childLearningProgress.getLoID(), childLearningProgress.getProgressRate());
			}
			
			// qLo̐ǐvZ
			String childLoProgressRate = this.makeContainerProgressRate(childProgressRateList, loConfig);
			DebugLog.write( this.getClass(), "Reiq̐iF" + childLoProgressRate, DebugLog.ROW );
			
			// ǐvZ
			progressRate = this.makeProgressRate(loProgressRate, childLoProgressRate);
			DebugLog.write( this.getClass(), "Reii擾IF"+progressRate, DebugLog.ROW );
			
			// ŏIIȐiwK󋵂̕ύX
			if ( loState.isNotStart && progressRate.equals("0") == false ) {
				loState.isNotStart = false;
				studyStatus = this.getStudyStatus(loState, learningStatusConfig);
			}
			
		// XcalatUT[o(WBT)̏ꍇ
		}else if(loType.equals("1")) {
			
			// ʃO̎擾
			jp.co.ntt.lms.lo.WBT.IndividualLog.IndividualLogUserProgressStatusStoreData
										individualLog = this.getWBTIndividualLoLog(loID, userID);
			
			DebugLog.write( this.getClass(), "WBTʃO擾IF", DebugLog.ROW );
			
			// jbgO烆jbg̏Ԃ擾
			List unitStateList = this.getWBTStateList(individualLog);
			
			//jbg̐ǐvZ
			String unitProgressRate = this.makeUnitProgressRate(unitStateList, loConfig);
			DebugLog.write( this.getClass(), "WBTjbgiF"+unitProgressRate, DebugLog.ROW );

			// ǐvZ
			progressRate = this.makeProgressRate(loProgressRate, unitProgressRate);
			DebugLog.write( this.getClass(), "WBTi擾IF"+progressRate, DebugLog.ROW );

		// SmartForcȅꍇ
		}else if(loType.equals("4")) {
		
			// ʃO̎擾
			CourseUnitLogRecord[] individualLog	= this.getSmartForceIndividualLoLog(loID, userID);
			
			DebugLog.write( this.getClass(), "SmartForceʃO擾IF", DebugLog.ROW );
			
			// jbgO烆jbg̐i擾
			String unitProgressRate = this.makeSmartForceUnitProgressRate(individualLog, loConfig);
			DebugLog.write( this.getClass(), "SmartForcejbgiF"+unitProgressRate, DebugLog.ROW );

			// ǐvZ
			progressRate = this.makeProgressRate(loProgressRate, unitProgressRate);
			DebugLog.write( this.getClass(), "SmartForcei擾IF"+progressRate, DebugLog.ROW );

		// Offlinȅꍇ
		}else if(loType.equals("19")) {

			// ʃO̎擾
			jp.co.ntt.lms.lo.Offline.IndividualLog.IndividualLogUserProgressStatusStoreData individualLog
				= this.getOfflineIndividualLoLog(loID, userID);
			
			DebugLog.write( this.getClass(), "OfflineʃO擾IF", DebugLog.ROW );
			
			// jbgO烆jbg̏Ԃ擾
			List unitStateList = this.getOfflineStateList(individualLog);
			
			//jbg̐ǐvZ
			String unitProgressRate = this.makeUnitProgressRate(unitStateList, loConfig);
			DebugLog.write( this.getClass(), "OfflinejbgiF"+unitProgressRate, DebugLog.ROW );

			// ǐvZ
			progressRate = this.makeProgressRate(loProgressRate, unitProgressRate);
			DebugLog.write( this.getClass(), "Offlinei擾IF"+progressRate, DebugLog.ROW );

			
		// Scorm̏ꍇ
		}else if (loType.equals("20")) {

			// jbgO̎擾
			IndividualLogUserProgressResult individualLog = this.getScormIndividualLoLog(loID, userID);
			DebugLog.write( this.getClass(), "ScormʃO擾IF", DebugLog.ROW );
			
			// jbgO烆jbg̏Ԃ擾
			List unitStateList = this.getUnitStateList(individualLog);
			
			//jbg̐ǐvZ
			String unitProgressRate = this.makeUnitProgressRate(unitStateList, loConfig);
			DebugLog.write( this.getClass(), "ScormjbgiF"+unitProgressRate, DebugLog.ROW );

			// ǐvZ
			progressRate = this.makeProgressRate(loProgressRate, unitProgressRate);
			DebugLog.write( this.getClass(), "Scormi擾IF"+progressRate, DebugLog.ROW );

		// ʃOȂꍇ
		}else {
			
			// LO̐iŜ̐iƂ
			progressRate = loProgressRate;
		}

		DebugLog.write( this.getClass(), "Ŝ̐iF"+progressRate, DebugLog.ROW );

		// i󋵂̎Zo
		progressStatus = this.makeProgressStatus(learningStartDate, learningEndData, progressRate, loConfig);
		DebugLog.write( this.getClass(), "i󋵎擾IF"+progressStatus, DebugLog.ROW );
		
		// 擾ۑ
		this.startDate = learningStartDate;
		this.endDate = learningEndData;
		this.studyStatus = studyStatus;
		this.progressRate = progressRate;
		this.progress = progressStatus;
		this.loState = loState;
	}
	
	/**
	 * WBŤʃO擾܂B
	 * 
	 * @param loID LOID
	 * @param userID@[UID̓O[vID
	 * @return IndividualLogUserProgressStatusStoreData WBŤʃOf[^
	 * @throws Exception
	 */
	private jp.co.ntt.lms.lo.WBT.IndividualLog.IndividualLogUserProgressStatusStoreData getWBTIndividualLoLog(String loID, String userID) throws Exception {
		
		jp.co.ntt.lms.lo.WBT.IndividualLog.IndividualLogStoreData logData = 
			new jp.co.ntt.lms.lo.WBT.IndividualLog.IndividualLogStoreData();

		String realLoID = logData.getRealLoID(loID);

		// ގʂLoTopClientCX^X
		// LOT[o̎擾
		Environment env = new Environment();
		String serverName = env.getLoServerName();
		
		// LONXCX^X܂B
		LoClient lo = XMOInformationGetter.getLO(loID);
		String loType = lo.getLoType();
		LoTopClient loTopClient = new LoTopClient( serverName, loType );

		if( loTopClient.getData(realLoID) == false ) return null;
		if( loTopClient.getDataLength() == 0 ) return null;

		// LO狳ޏڍ׏擾
		LoComData loComData = loTopClient.getDataInfo(0);

		// ID̎擾
		String	materialID = loComData.getMaterialID();

		// LO狳ޏڍ׏擾
		Hashtable params = new Hashtable();
		params.put( "MATID", materialID );

		if( loTopClient.getMaterialStructFile(params) == false ) return null;
		
		String document = loTopClient.getMaterialFile();

		RDFDocument rdfDocument = new RDFDocument();
		RDFNode rdfNode = rdfDocument.load( new StringBuffer(document) );

		jp.co.ntt.lms.lo.WBT.IndividualLog.IndividualLogUserProgressStatusStoreData storeData = 
				new jp.co.ntt.lms.lo.WBT.IndividualLog.IndividualLogUserProgressStatusStoreData( loID, userID, loType , rdfNode);
		
		if( storeData.makeStoreData() == false ) return null;
		if( storeData.getMaxData() == 0 ) return null;
		
		return storeData;
	}

	/**
	 * Rei̐i擾
	 * 
	 * @param childProgressRateList Rei̎qLO̐iXg
	 * @param loConfig LO̊Ot@Cݒ
	 * @return@String@Rei̐i
	 */
	private String makeContainerProgressRate(Map childProgressRateList, LOConfiguration loConfig) {

		double containerProgressRateSum =0;
		boolean couldGetWeight = true;
		double childLoProgressRateSum = 0;
		
		Iterator ite = childProgressRateList.keySet().iterator();
		while(ite.hasNext()) {

			String chiliLoID = ite.next().toString();
			String childProgressRate = childProgressRateList.get(chiliLoID).toString();
			
			if (childProgressRate.length() == 0) return "";

			// qLO̐iZ
			try {
				childLoProgressRateSum += Double.parseDouble(childProgressRate);

			}catch(NumberFormatException nfe){
				DebugLog.write(this.getClass(), "Rei̎qLO̐ilϊG[", DebugLog.MID);
				return "";
			}
			
			// LO̐i󋵂ݒ肳ĂȂΏdݎ擾Ȃ
			if (loConfig == null) continue;
			
			// Lȍd݂擾
			String weight = loConfig.getUnitWeight(chiliLoID);
			
			// jbg̏d݂ݒ肳ĂȂ΁A
			// i̔s\Ȃ̂ŊeLO̐i̕ςƂ
			if (weight.length() == 0) {
				couldGetWeight = false;
				continue;
			}
			
			//LO̐iZ
			try {
				containerProgressRateSum += Integer.parseInt(childProgressRate) * Double.parseDouble(weight);

			}catch(NumberFormatException nfe){
				DebugLog.write(this.getClass(), "Rei̎qLȌdݐlϊG[", DebugLog.MID);
				return "";
			}
		}
		
		// d݂擾łꍇ͌vZiԂ
		if(couldGetWeight) {
			return String.valueOf(Math.round(containerProgressRateSum));
		// d݂擾łȂꍇ͐i̕ςԂ
		} else {
			return String.valueOf(Math.round(childLoProgressRateSum / childProgressRateList.keySet().size()));
		}
	}

	/**
	 * wK󋵕擾
	 * 
	 * @param loState LȌ
	 * @param learningStatusConfig wK󋵖̊Oݒt@C
	 * @return@String@wK󋵕
	 */
	private String getStudyStatus(LoState loState,
									LearningStatusConfiguration learningStatusConfig) {
		
		// wK󋵂擾
		if ( loState.isComplete ){
			return learningStatusConfig.getCompleteScreenName();
		} else if (loState.isNotStart ) {
			return learningStatusConfig.getNotStartScreenName();
		} else {
			return learningStatusConfig.getNotCompleteScreenName();
		}
	}

	/**
	 * i󋵂쐬܂B
	 * 
	 * @param startDate wKJn
	 * @param endDate@wKI
	 * @param progressRate i
	 * @param config@LO̊Oݒt@C
	 * @return String i
	 */
	private String makeProgressStatus(Date startDate,
											Date endDate, 
											String progressRate, 
											LOConfiguration config) {
		
		if ( progressRate.length() == 0 || endDate == null || config == null ) return "";
		if ( progressRate.equals("100") ||  progressRate.equals("0") ) return "";

		// 擾
		Date today = new Date();
		
		// wKԂ擾
		long span = ( (endDate.getTime() - startDate.getTime() ) / (24*60*60*1000) ) +1;
		
		DebugLog.write( this.getClass(), "wKԎ擾IF"+String.valueOf(span), DebugLog.ROW );

		// Wi擾
		long standardProgressRate = ( ( ( today.getTime() - startDate.getTime() ) / (24*60*60*1000) ) +1 ) * 100 / span;
		
		// Wi100𒴂ꍇ100ɏC
		if (standardProgressRate > 100) standardProgressRate = 100;
		
		DebugLog.write( this.getClass(), "Wi擾IF"+String.valueOf(standardProgressRate), DebugLog.ROW );
		
		// Wiɑ΂銄vZ
		long ratioToStandardProgressRate = 0; 
		try {
			if (standardProgressRate == 0) {
				ratioToStandardProgressRate = 100;
			} else {
				ratioToStandardProgressRate = Integer.parseInt(progressRate) * 100 / standardProgressRate;
			}
		}catch(NumberFormatException nfe) {
			DebugLog.write(this.getClass(), "ilϊG[", DebugLog.MID);
			return "";
		}
		
		DebugLog.write( this.getClass(), "Wiɑ΂銄擾IF"+String.valueOf(ratioToStandardProgressRate), DebugLog.ROW );
		
		// Wiɑ΂銄ɊY閼̂ݒt@C擾
		return config.getProgressStatusName(ratioToStandardProgressRate);
	}

	/**
	 * LŐʐi쐬܂B
	 * 
	 * @param loState LȌ
	 * @param config@LOiݒ
	 * @return String @LO̐i
	 * @throws XmsException
	 */
	private String makeLoProgressRate(LoState loState, LOConfiguration config) throws XmsException {
		
		// @w肳ꂽLO̐i󋵐ݒt@C݂邩擾
		// ݒt@C݂Ȃ΁ALO̊Xe[^X1000ԂB
		// ȊO̓jbg̊Xe[^X画
		if (config == null) {
			if (loState.isComplete) return PROGRESS_RATE_COMPLETE;
			if (loState.isNotStart) return PROGRESS_RATE_NOTSTART;
			
			return "";
		}
		
		String completeRate = config.getCompleteRate();
		String notCompleteRate = config.getNotCompleteRate();
		String notStartRete = config.getNotStartRate();

		// ݒt@Cɐiw肳ĂȂꍇAis\
		if (completeRate.length() == 0 || notCompleteRate.length() == 0 || notStartRete.length() == 0 ) return "";
				
		//A LÕXe[^XO`ꂽiԂ
		String loProgressRate;
		if (loState.isComplete ){
			loProgressRate = completeRate;
		} else if (loState.isNotStart) {
			loProgressRate = notStartRete;
		} else {
			loProgressRate = notCompleteRate;
		}
		
		return loProgressRate;
	}

	/**
	 * i쐬܂B
	 * 
	 * @param loProgressRate@LŐʐi
	 * @param unitProgressRate@jbg̐i
	 * @return String i
	 * @throws XmsException
	 */
	private String makeProgressRate(String loProgressRate, String unitProgressRate) throws XmsException {
		
		// LO̐i100ȂLO̐iԂ
		if ( loProgressRate.equals(PROGRESS_RATE_COMPLETE) ) return loProgressRate;
		
		// jbg̐i0ȂLO̐iԂ
		return ( unitProgressRate.equals(PROGRESS_RATE_NOTSTART) 
					? loProgressRate
					: unitProgressRate);
	}

	/**
	 * jbg̐i쐬܂B
	 * 
	 * @param unitStateList jbg̊wK󋵂̃Xg 
	 * @param config LO̊Oݒt@C
	 * @return String jbg̐i
	 * @throws XmsException
	 */
	private String makeUnitProgressRate(List unitStateList, LOConfiguration config) throws XmsException {
		
		if(config == null) return "";
		
		String completeRate = config.getCompleteRate();
		String notCompleteRate = config.getNotCompleteRate();
		String notStartRete = config.getNotStartRate();
		
		// ݒt@Cɐiw肳ĂȂꍇAis\
		if (completeRate.length() == 0 || notCompleteRate.length() == 0 || notStartRete.length() == 0 ) return "";
				
		// jbg̃Xe[^Xi擾
		String unitProgressRate;
		boolean couldGetWeight = true;
		double unitProgressRateSum =0;
		double unitProgressRateOnWeightSum =0;
		Iterator ite = unitStateList.iterator();
		while(ite.hasNext()) {
			LoState unitState = (LoState)ite.next();
			
			// Xe[^Xɂi擾
			if (unitState.isComplete) {
				unitProgressRate = completeRate;
			} else if (unitState.isNotStart) {
				unitProgressRate = notStartRete;
			} else {
				unitProgressRate = notCompleteRate;
			}
			
			// jbg̐iZ
			try {
				unitProgressRateSum += Double.parseDouble(unitProgressRate);
				
			}catch(NumberFormatException nfe) {
				DebugLog.write(this.getClass(), "jbg̐ilϊG[", DebugLog.MID);
				return "";
			}
			
			// jbg̏d݂擾
			String activityID = unitState.id;

			String weight = config.getUnitWeight(activityID);
			DebugLog.write( this.getClass(), 
					MessageFormat.format("jbgID={0}, jbg̏d={1}", new String[]{activityID,weight}),
					DebugLog.ROW );
			
			// jbg̏d݂ݒ肳ĂȂ΁A
			// i̔s\
			if (weight.length() == 0) couldGetWeight = false;
			
			//jbg̐id݂ŉZ
			try{
				unitProgressRateOnWeightSum += Integer.parseInt(unitProgressRate) * Double.parseDouble(weight);
			
			}catch(NumberFormatException nfe){
				DebugLog.write(this.getClass(), "jbg̏dݐlϊG[", DebugLog.MID);
				return "";
			}
		}
		
		// d݂ݒ肳ĂΏd݂̐iԂ
		if (couldGetWeight) {
			return String.valueOf(Math.round(unitProgressRateOnWeightSum));
		//@d݂ݒ肳ĂȂΐi̕ςԂ
		} else {
			return String.valueOf(Math.round(unitProgressRateSum / unitStateList.size()));
		}

	}

	/**
	 * jbg̏ԃXg擾܂B
	 * 
	 * @param individualLog jbǧʃO
	 * @return List jbg̏ԃXg
	 * @throws XmsException
	 */
	private List getUnitStateList(IndividualLogUserProgressResult individualLog) throws XmsException {
		
		ArrayList list = new ArrayList();
		
		// jbg̃Xe[^X擾
		Iterator ite = individualLog.getLog().iterator();
		while(ite.hasNext()) {
			IndividualLogUserProgressStoreData unitLog = (IndividualLogUserProgressStoreData)ite.next();
			LoState unitState = new LoState(unitLog.strActivityID, unitLog.blUnitComplete, (unitLog.datStartDate == null));
			list.add(unitState);
		}

		return list;
	}

	/**
	 * SmartForcẽjbg̐i쐬܂B
	 * 
	 * @param individualLog SmartForcěʃOXg
	 * @param config LO̊Oݒt@C
	 * @return String SmartForcẽjbg̐i
	 * @throws XmsException
	 */
	private String makeSmartForceUnitProgressRate(CourseUnitLogRecord[] individualLog, LOConfiguration config) throws XmsException {
		
		boolean couldGetWeight = true;
		double unitProgressRateSum =0;
		double unitProgressRateOnWeightSum =0;
		
		// ʃOȂΌʃO̐iȂ
		if ( individualLog == null || individualLog.length == 0 || config == null) return "";
		
		for(int i=0; i<individualLog.length; i++) {

			// jbgO݂Ȃ΋ނ̐iԋp
			if (individualLog[i].getUnitCount().equals("0")) {
				return individualLog[i].getProgressRate();
			}
			
			// jbg̐i擾
			String unitProgressRate = individualLog[i].getUnitProgress();
			if ( unitProgressRate.length() == 0) return individualLog[i].getProgressRate();
			
			// jbg̐iZ
			try {
				unitProgressRateSum += Double.parseDouble(unitProgressRate);
				
			}catch(NumberFormatException nfe) {
				DebugLog.write(this.getClass(), "SmartForcejbg̐ilϊG[", DebugLog.MID);
				return "";
			}
			
			// jbgID擾
			String unitID = individualLog[i].getUnitOrder();

			// jbg̏dݎ擾
			String weight = config.getUnitWeight(unitID);
			
			// jbg̏d݂ݒ肳ĂȂ΁Ai̔s\
			if (weight.length() == 0) couldGetWeight = false;
			
			//jbg̐id݂ŉZ
			try{
				unitProgressRateOnWeightSum += Integer.parseInt(unitProgressRate) * Double.parseDouble(weight);
			
			}catch(NumberFormatException nfe){
				DebugLog.write(this.getClass(), "SmartForcejbg̏dݐlϊG[", DebugLog.MID);
				return "";
			}
		}

		// d݂ݒ肳ĂΏd݂̐iԂ
		if (couldGetWeight) {
			return String.valueOf(Math.round(unitProgressRateOnWeightSum));
		//@d݂ݒ肳ĂȂΐi̕ςԂ
		} else {
			return String.valueOf(Math.round(unitProgressRateSum / individualLog.length));
		}
	}

	/**
	 * ItCLÕjbg̏ԃXg擾܂B
	 * 
	 * @param individualLog ItCLǑʃO
	 * @return List ItCLÕjbg̏ԃXg
	 * @throws XmsException
	 */
	private List getOfflineStateList(jp.co.ntt.lms.lo.Offline.IndividualLog.IndividualLogUserProgressStatusStoreData individualLog) throws XmsException {
		
		final int FIELD_SECTION_ID = 10;
		final int FIELD_LEARNING_SATART_DATE = 1;
		final int FIELD_COMPLETE = 7;
		final String STR_COMPLETE = "1";
		
		ArrayList list = new ArrayList();
		
		// ʃOȂ΋̃XgԂ
		if(individualLog == null) return list;
		
		// jbg̃Xe[^X擾
		for(int i=0; i<individualLog.getMaxData(); i++) {
			List auLog = individualLog.getStoreData( i );
			LoState unitState = new LoState(auLog.get(FIELD_SECTION_ID).toString(), 
											auLog.get(FIELD_COMPLETE).equals(STR_COMPLETE), 
											( auLog.get(FIELD_LEARNING_SATART_DATE).toString().length() != 0 ) );
			list.add(unitState);
		}

		return list;
	}

	/**
	 * WBT̃jbg̏ԃXg擾܂B
	 * 
	 * @param individualLog WBŤʃO
	 * @return@List WBT̃jbg̏ԃXg
	 * @throws XmsException
	 */
	private List getWBTStateList(jp.co.ntt.lms.lo.WBT.IndividualLog.IndividualLogUserProgressStatusStoreData individualLog) throws XmsException {
		
		final int FIELD_SECTION_ID = 10;
		final int FIELD_LEARNING_SATART_DATE = 1;
		final int FIELD_COMPLETE = 7;
		final String STR_COMPLETE = "1";
		
		ArrayList list = new ArrayList();
		
		// O擾łȂꍇÃXgԂ
		if (individualLog == null ) return list;
		
		// jbg̃Xe[^X擾
		for(int i=0; i<individualLog.getMaxData(); i++) {
			List auLog = individualLog.getStoreData( i );
			LoState unitState = new LoState(auLog.get(FIELD_SECTION_ID).toString(), 
											auLog.get(FIELD_COMPLETE).equals(STR_COMPLETE), 
											( auLog.get(FIELD_LEARNING_SATART_DATE).toString().length() != 0 ) );
			list.add(unitState);
		}

		return list;
	}

	/**
	 * LȌԂ擾܂B
	 * 
	 * @param commonLog LŐʃO
	 * @return LoState LȌ
	 * @throws XmsException
	 */
	private LoState getLoState(LoLogLearnStatusResult commonLog) throws XmsException {
		
		// @LÕXe[^X擾
		boolean isComplete = commonLog.getCompleteCondition().equals("1");
		boolean isNotStart = ( commonLog.getDateStart() == null || commonLog.getDateStart().equals("") );
		String id = commonLog.getId();
		
		return new LoState(id, isComplete, isNotStart);
	}

	/**
	 * Scorm̌ʃO擾܂B
	 * 
	 * @param loID LoID
	 * @param userID [UID̓O[vID
	 * @return Scorm̌ʃO
	 * @throws Exception
	 */
	private IndividualLogUserProgressResult getScormIndividualLoLog(String loID, String userID) throws Exception {
		
		LoClient lo = XMOInformationGetter.getLO(loID);
		
		ScormDocument scormDoc = this.getScormDocument(loID, lo.getLoType());
		
		// WbN擾
		Logic logic = new IndividualLogUserProgressLogic(
					                userID,
					                loID,
					                lo.getLoType(),
					                lo.getForeignID(),
									"",
									scormDoc.getRootItemID(),
							        new ScormItemList(scormDoc, scormDoc.getRootItemID()) );
		
		DebugLog.write( this.getClass(), "ScormʃOWbN擾F", DebugLog.ROW );

		// RMINCAg
		RemoteLogicClient remote = new RemoteLogicClient();

		// O擾
		//LogicResult result = remote.doLogic(logic);
		IndividualLogUserProgressResult result = (IndividualLogUserProgressResult)remote.doLogic(logic);
		
		result.beforeFirst();
		result.next();
			
		return result;
	}

	/**
	 * OfflineLǑʃO擾܂B
	 * 
	 * @param loID LoID
	 * @param userID [UID̓O[vID
	 * @return IndividualLogUserProgressStatusStoreData OfflineLǑʃO
	 * @throws Exception
	 */
	private jp.co.ntt.lms.lo.Offline.IndividualLog.IndividualLogUserProgressStatusStoreData getOfflineIndividualLoLog(String loID, String userID) throws Exception {
		
		jp.co.ntt.lms.lo.Offline.IndividualLog.IndividualLogStoreData logData 
			= new jp.co.ntt.lms.lo.Offline.IndividualLog.IndividualLogStoreData();
		
		String realLoID = logData.getRealLoID(loID);

		// ގʂLoTopClientCX^X
		// LOT[o̎擾
		Environment env = new Environment();
		String serverName = env.getLoServerName();
		
		// LONXCX^X܂B
		LoClient lo = XMOInformationGetter.getLO(loID);
		String loType = lo.getLoType();
		LoTopClient loTopClient = new LoTopClient( serverName, loType );

		if( loTopClient.getData(realLoID) == false ) return null;
		if( loTopClient.getDataLength() == 0 ) return null;

		// LO狳ޏڍ׏擾
		LoComData loComData = loTopClient.getDataInfo(0);

		// ID̎擾
		String	materialID = loComData.getMaterialID();

		// LO狳ޏڍ׏擾
		Hashtable params = new Hashtable();
		params.put( "MATID", materialID );

		if( loTopClient.getMaterialStructFile(params) == false ) return null;
		
		String document = loTopClient.getMaterialFile();

		RDFDocument rdfDocument = new RDFDocument();
		RDFNode rdfNode = rdfDocument.load( new StringBuffer(document) );
		
		jp.co.ntt.lms.lo.Offline.IndividualLog.IndividualLogUserProgressStatusStoreData storeData 
			= new jp.co.ntt.lms.lo.Offline.IndividualLog.IndividualLogUserProgressStatusStoreData( loID, userID, loType , rdfNode);
		
		if( storeData.makeStoreData() == false ) return null;
		if( storeData.getMaxData() == 0 ) return null;
		
		return storeData;
	}

	/**
	 * SmartForcěʃO擾܂B
	 * 
	 * @param loID LoID
	 * @param userID [UID̓O[vID
	 * @return CourseUnitLogRecord[] SmartForcěʃO
	 * @throws Exception
	 */
	private CourseUnitLogRecord[] getSmartForceIndividualLoLog(String loID, String userID) throws Exception {
		
		Environment env = new Environment();
		String serverName = env.getLoServerName();

		// LONXCX^X܂B
		LoClient lo = XMOInformationGetter.getLO(loID);
		String loType = lo.getLoType();
		LoTopClient loTopClient = new LoTopClient( serverName, loType );
		
		// LOIDRealLOID֕ϊ
		String realLOID = lo.getRealLOID();
		
		// ʃO擾
		if(loTopClient.getIndividualLog(userID, realLOID) == false) return null;

		// ʃf[^擾
		CourseUnitLogRecord[] courceUnitList = (CourseUnitLogRecord[])loTopClient.getIndividualLog();
		
		return courceUnitList;
	}

	/**
	 * ATC擾܂B
	 * 
	 * @param userID [UID̓O[vID
	 * @param loID LoID
	 * @return AssignmentsClient ATC
	 * @throws Exception
	 */
	private AssignmentsClient getAssignment( String userID, String loID ) throws Exception {
		
		String membershipID = this.getMembershipID(userID);
		String materialID = this.getMaterialID(loID);
		
		if (membershipID == null || materialID == null) return null;
		
		AssignmentsClient client = new AssignmentsClient();
		
		client.setWhereMemberShipID(membershipID);
		client.setWhereMaterialID(materialID);

		if( client.select() == false ) return null;
		if( client.next() == false ) return null;
		
		return client;
	}
	
	/**
	 * w肵[UqɎo[ID擾܂B
	 * 
	 * @param childID [UID
	 * @return String o[ID
	 * @throws Exception
	 */
	private String getMembershipID( String childID ) throws Exception {
		
		GroupAndPeopleClient client = new GroupAndPeopleClient();
		client.setWhereChildID(childID);
		
		if( client.select() == false ) return null;
		if( client.next() == false ) return null;
		
		return client.getMemberShipID();
	}

	/**
	 * LO̕WwKԂ擾܂B
	 * 
	 * @param loID LOID
	 * @return String LOWwK
	 * @throws Exception
	 */
	private String getLOLearningSpan( String loID ) throws Exception {
		
		LoClient loClient = new LoClient();

		// LOIDݒ肷
		loClient.setTimeSpan( loID );
		
		return loClient.getTimeSpan();
	}

	/**
	 * w肵LOqɎR|[lgID擾܂B
	 * 
	 * @param childID [UID
	 * @return String R|[lgID
	 * @throws Exception
	 */
	private String getMaterialID( String childID ) throws Exception {
		
		LoRelationClient client = new LoRelationClient();
		client.setWhereChildID(childID);
		
		if( client.select() == false ) return null;
		if( client.next() == false ) return null;
		
		return client.getmaterialID();
	}

	/**
	 * wKJn擾܂B
	 * 
	 * @param userID [UID
	 * @param loID LoID
	 * @param config LO̊Ot@Cݒ
	 * @return Date wKJn
	 * @throws Exception
	 */
	private Date getLearningStartDate( String userID, String loID, LOConfiguration config ) throws Exception {

		// ATCLO擾
		String assignedLOID = XMOInformationGetter.getAssignedParentLOID(loID, userID, AssignmentsClient.LEARN_TYPE);
		if( assignedLOID.length() ==0 ) return null;
		LoClient assignedLO = XMOInformationGetter.getLO(assignedLOID);
			
		// LÕATC擾
		AssignmentsClient assignment = this.getAssignment(userID, assignedLO.getLoID());

		// LÕJX^ATC̓t擾
		Date customStartDate = assignment.getOpeningDate();
		
		//JX^ATC̊wKJnݒ肳Ăꍇ
		//JX^ATC̊wKJnwKJnƂ
		if ( customStartDate != null ) return customStartDate;

		//TODO: }C[jOEpX@\̎擾
//		LoClient lo = XMOInformationGetter.getLO(loID);
//		Date loStartDate = lo.getStartDate();
//		if (loStartDate != null ) return loStartDate;
		
		if ( config != null ) {
			Date configStartDate = config.getStartDate();
			if (configStartDate != null ) return configStartDate;
		}
		
		//LȊȌꍇALO̊wKJnƂ
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

		return sdf.parse(assignment.getStudyStartDate());
	}

	/**
	 * wKI擾܂B
	 * 
	 * @param userID [UID
	 * @param loID LoID
	 * @param startDate wKJn
	 * @param config Lo̊Ot@Cݒ
	 * @return Date wKI
	 * @throws Exception
	 */
	private Date getLearningEndDate( String userID, String loID, Date startDate, LOConfiguration config ) throws Exception {

		// ATCLO擾
		String assignedLOID = XMOInformationGetter.getAssignedParentLOID(loID, userID, AssignmentsClient.LEARN_TYPE);
		if( assignedLOID.length() ==0 ) return null;
		LoClient assignedLO = XMOInformationGetter.getLO(assignedLOID);

		// LÕATC擾
		AssignmentsClient assignment = this.getAssignment(userID, assignedLOID);

		// LÕJX^ATC̓t擾
		Date customEndDate = assignment.getClosingDate();
		
		//JX^ATC̊wKIݒ肳ĂāAwKJn̓tł
		//JX^ATC̊wKIwKIƂ
		if ( customEndDate != null && customEndDate.after(startDate)) return customEndDate;

		//}C[jOpX̊wKԂ擾
		TimeSpan timeSpan = null;
		String loTimeSpan = this.getLOLearningSpan(loID);
		if (loTimeSpan != null ) timeSpan = TimeSpan.parseTimeSpan(loTimeSpan);

		//擾łȂ΁AXMLt@C擾
		if (timeSpan == null && config != null ) timeSpan = config.getTimeSpan();
		DebugLog.write(this.getClass(), "IF"+(timeSpan==null?"Ȃ":timeSpan.toString()),DebugLog.ROW);
		
		//LO̊wKԂݒ肳Ăꍇ
		//wKJn + LO̊wKԂwKIƂ
		if (timeSpan != null ) {
			
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(startDate);

			calendar.add(Calendar.YEAR, timeSpan.getYears());
			calendar.add(Calendar.MONTH, timeSpan.getMonths());
			calendar.add(Calendar.DATE, timeSpan.getDays());
			calendar.add(Calendar.HOUR, timeSpan.getHours());
			calendar.add(Calendar.MINUTE, timeSpan.getMinutes());
			calendar.add(Calendar.SECOND, timeSpan.getSeconds());
			
			// Date^ɕϊ
			Date loLearningSpan = calendar.getTime();
			if (loLearningSpan.after(startDate)) return loLearningSpan;
		}
		
		//LȊȌꍇAwKIȂ
		return null;
	}
	
	/**
	 * LOO擾܂B
	 * 
	 * @param loID LoID
	 * @param userID [UID
	 * @return LoLogLearnStatusResult LoO
	 * @throws Exception
	 */
	private LoLogLearnStatusResult getLoLog(String loID, String userID) throws Exception {
		
		// WbN擾
		Logic logic = new LoLogLearnMaterialStatusLogic(
									this.getLoLogLearnStatusParam(),
									LoLogConstant.LOG_SELECT_U_M,
									loID,
									new ArrayList(),
									userID,
									new ArrayList(),
									1,
									1);

		DebugLog.write( this.getClass(), "ʃOWbN擾F", DebugLog.ROW );

		// RMINCAg
		RemoteLogicClient remote = new RemoteLogicClient();
		
		// O擾
		//LogicResult result = remote.doLogic(logic);
		LoLogLearnStatusResult result = (LoLogLearnStatusResult)remote.doLogic(logic);
		result.beforeFirst();
		result.next();

		return result;
	}
	
	/**
	 * ʃO擾pp[^擾܂B
	 * 
	 * @return LoLogLearnStatusParam@ʃO擾pp[^
	 */
	private LoLogLearnStatusParam getLoLogLearnStatusParam() {
		
		LoLogLearnStatusParam param = new LoLogLearnStatusParam();
		
		//wKJn(date_start)
		param.setDateStartCondition("0");
		param.setDateStart("");
		//ŏIANZX(date_last)
		param.setDateLastCondition("0");	//selectȏ/ȉ
		param.setDateLast("");

		//ANZX(total_access)
		param.setTotalAccessCondition("0");
		param.setTotalAccess("");

		//ݐϑ؍ݎ(total_learn_time)					
		param.setTotalLearnTimeCondition("0");
		param.setTotalLearnTime("");
		//LO(mat_complete)
		param.setMatCompleteCondition("");
		param.setMatComplete("");
		//ikn(mat_pass)					
		param.setMatPassCondition("");
		param.setMatPass("");	
		//ŐV_(mat_newest_score)					
		param.setMatNewestScoreCondition("0");
		param.setMatNewestScore("");
		//ō_(mat_high_score)					
		param.setMatHighScoreCondition("0");
		param.setMatHighScore("");
		//Ґ(user_complete_condition)							
		param.setUserCompleteCondition("");
		param.setUserComplete("");
		//iҐ(user_pass)							
		param.setUserPassCondition("");
		param.setUserPass("");
		//(complete_condition)
		param.setCompleteCondition("");
		//i(pass_condition)					
		param.setPassCondition("");
		//menu痈
		param.setMenu("no");
		//O[vID
		param.setBelonggroupid("");
		//ztO
		param.setSubordinateFlg("off");
		
		return param;
	}
	
	/**
	 * ScormDocument擾܂B
	 * 
	 * @param loID LoID
	 * @param loType Lo
	 * @return ScormDocument ScormDocument
	 * @throws Exception
	 */
	private ScormDocument getScormDocument(String loID, String loType ) throws Exception {

		// RealLoID̎擾
		LoClient loClient = new LoClient();
		if(loClient.getRealLOIDFromLOID(loID) == false) throw new Exception();
		
		String realLoID = loClient.getRealLOIDResult();

		// ގʂLoTopClientCX^X
		// LOT[o̎擾
		Environment env = new Environment();
		String loServerName = env.getLoServerName();

		// LONXCX^X܂B
		LoTopClient loTopClient = new LoTopClient( loServerName, loType );

		String materialID = null;
		
		// LO狳ޏڍ׏擾
		if( loTopClient.getData(realLoID) ) {
			if( loTopClient.getDataLength() > 0 ) {
				LoComData loComData = loTopClient.getDataInfo(0);
				// ID̎擾
				materialID = loComData.getMaterialID();
			}
		}

		// LO狳ޏڍ׏擾
		Hashtable params = new Hashtable();
		String document = null;
		params.put( "MATID", materialID );
		if( loTopClient.getMaterialStructFile(params) ) {
			document = loTopClient.getMaterialFile();
		}
		else{
			//ލ\t@C̎擾Ɏs܂B;
			Exception e = new Exception();
			e.printStackTrace();
			throw e;
		}

		String strSectionTopID = null;
		String strSectionTopTitle = null;

		// Scormލ\`擾iScormm[h쐬j
		ScormDocument scormDocument = new ScormDocument();
		scormDocument.parseXML( document );
		// [ghc̐ݒ
		strSectionTopID = scormDocument.getRootItemID();
		if(strSectionTopID.equals(null)){
			throw new Exception();
		}
		// [g^Cg̐ݒ
		strSectionTopTitle = scormDocument.getRootTitle();
		if(strSectionTopTitle.equals(null)){
			throw new Exception();
		}

		return scormDocument;
	}
	
	/**
	 * LoԃNX
	 * 
	 * @author Katsuhiko Sakurai (UNITEC)
	 * @version 1.0
	 */
	private class LoState {
		
		private String id = null;
		private boolean isComplete = false;
		private boolean isNotStart = true;
		
		/**
		 * RXgN^łB
		 * 
		 * @param id LoID
		 * @param isComplete Ă邩ǂ@True:
		 * @param isNotStart ܂JnĂȂǂ@True:
		 */
		public LoState(String id, boolean isComplete, boolean isNotStart ){
			this.id = id;
			this.isComplete = isComplete;
			this.isNotStart = isNotStart;
		}
		
		/**
		 * LoID擾܂B
		 * 
		 * @return String LoID
		 */
		public String getId() {
			return this.id;
		}
		
		/**
		 * Ă邩ǂ𔻕ʂ܂B
		 * 
		 * @return boolean Ă邩ǂ True:
		 */
		public boolean isComplete() {
			return this.isComplete;
		}

		/**
		 * 肩ǂ𔻕ʂ܂B
		 * 
		 * @return boolean 肩ǂ True:
		 */
		public boolean isNotStart() {
			return this.isNotStart;
		}
	}
}
