/*
 * 쐬: 2005/02/17
 */
package jp.co.ntt.lms.xmf.actions.xmo.evaluate;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import java.net.URLEncoder;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;

import jp.co.ntt.lms.xmo.Evaluate.EvaluateClient;
import jp.co.ntt.lms.xmo.Evaluate.EvaluateData;
import jp.co.ntt.lms.xmo.MessageData;

/**
 * @author ~ _i
 */
public class EvaluateDisplayAction extends Action {

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		// bZ[W\[X擾
		MessageResources resCnt = getResources(request, "msg.xmf.xmo.Evaluate.MessageResources");

		// LbV
		response.setHeader("cache-control", "no-cache");

		// ILOID擾
		String strSelectID = request.getParameter("selectID");
		if(strSelectID == null || strSelectID.equals(""))
		{
			String strErrMessage = "";

			strErrMessage = URLEncoder.encode(resCnt.getMessage("STR_ERRMSG_LOID"), "UTF-8");

			response.sendRedirect("../Com/ComErr.vm?message=" + strErrMessage);
		}

		// ]f[^ꗗ擾
		Vector vecEvaluateList = new Vector();
		int intListCount       = 0;
		Vector vecRet          = new Vector();
		MessageData objMd      = null;
		Hashtable htbRecord = new Hashtable();


		EvaluateClient objEc   = new EvaluateClient();
		objEc.setLoID(strSelectID);
		vecRet = objEc.makeEvaluateDataComp();
		objMd  = (MessageData)vecRet.get(0);
		if(objMd != null)
		{
			if(objMd.getMessage() == null)
			{
				// G[y[W
				response.sendRedirect("../Com/ComErr.vm?message=" + resCnt.getMessage("STR_ERRMSG_EVALUATELIST"));
			}
			else
			{
				// G[y[W

				String strMessage = URLEncoder.encode(objMd.getMessage(), "UTF-8");

				response.sendRedirect("../Message/Messageerror.vm?message=" + strMessage);
			}
		}
		else
		{
			vecEvaluateList = (Vector)vecRet.get(1);
			for(int i = 0; i < vecEvaluateList.size(); i++)
			{
				EvaluateData objWork = (EvaluateData)vecEvaluateList.get(i);
				String strLoID = objWork.getLoID();
				if(htbRecord.get(strLoID) == null)
				{
					Vector vecList = new Vector();
					vecList.add(objWork);
					htbRecord.put(strLoID, vecList);
				}
				else
				{
					Vector vecWork = (Vector)htbRecord.get(strLoID);
					vecWork.add(objWork);
				}
			}
		}
		intListCount = vecEvaluateList.size();

		Enumeration objEnum = htbRecord.keys();
		Vector vecLoID = new Vector();
		while(objEnum.hasMoreElements())
		{
			vecLoID.add((String)objEnum.nextElement());
		}
		
		request.setAttribute("vecLoID", vecLoID);
		request.setAttribute("htbRecord", htbRecord);
		
		return mapping.findForward("success");
	}
}
