/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	RoleAssignments ǗXMO f[^ANZXNX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.xmo.RoleAssignments;

import java.util.*;
import java.sql.*;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.xmo.RoleAssignments.RoleAssignmentsClient;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xmo.*;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.Message.Message;

/**
 * RoleAssignments ǗXMO f[^ANZXNXłB<BR>
 * ̃NXAssignmentse[uւ̓o^ACA폜As܂B<BR>
 * DataAccessNXgpAo^ACA폜APʂ
 * gUNVǗs܂B
 * @author T.Nijou
 * @version 0.0.0.1 2004.01.08
 */
public class RoleAssignmentsDataAccess
	implements RoleAssignmentsMessage, RoleAssignmentsTable
{

	/**
	 * RXgN^łB<BR>
	 */
	public RoleAssignmentsDataAccess() {
	}

	/**
	 * RoleAssignmentse[u֓o^s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * Ȃe[u̎L[ȊOȗꍇ͏ȗtB[hɂ
	 * Nullli[܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             MEMBER_SHIP_ID          lXID
	 *             USER_ID                 [UID
	 *             ROLE_ID                 ID
	 *             GROUP_ID                O[vID
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData o^
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	synchronized public String insert( Hashtable htParam )
		throws XMOException
	{
		// f[^null̂Ƃ
		if( htParam == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );	
			// p[^G[X[
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htParam );

			// ݃`FbNs܂
			if( isExitAssign( htParam, objDataAccess ) ) {
				// łɑ݂ĂG[Ԃ܂
				throw new XMOException( getMessageData( ALREADY_ASSIGN_ERR ) );
			}

			// CT[gs\bhĂт܂
			insertAction( htParam, objDataAccess );
			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN

			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException se ) {
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );

			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		// 펞󕶎ԋp
		return "";
	}

	/**
	 * o^s\bhłB<BR>
	 * ̃e[uɓo^sAO[vƐlǗXMO
	 * qO[v擾A݂AqO[vɂl
	 * o^s܂B
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam o^
	 * @exception XMOException XMOƎO
	 * @exception SQLException DBG[
	 */
	private void insertAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// o^p̃f[^Zbg܂
		Hashtable htbData = setData( htbParam );

		// ݃`FbNsłɓo^Ăꍇ
		// Ɏq̓o^ɍs܂B

		if( !isExitAssign( htbData, objDataAccess ) ) {
			// őRoleAssignID擾
			String strAssignID = getMaxRoleAssignID(objDataAccess);

			// AssignIDo^ɃZbg܂
			htbData.put( ROLE_ASSIGN_ID, strAssignID );

			// o^SQL擾܂
			String strSQL = objDataAccess.getInsertSQL( htbData );

			// o^s
			objDataAccess.execute( strSQL );
		}
		//[h擾܂
		String strMode = (String)htbParam.get( MODE_KEY );

		// [hON̏ꍇ͈ȉ͍̏sȂ
		// O[vƐlǗXMOgpāAqO[vѐl݂邩s
		// ݂ꍇ͓l̓o^s܂
		if( strMode == null || !strMode.equals("on") ) {
			htbData.put(MEMBER_SHIP_ID,htbParam.get( MEMBER_SHIP_ID ) );
			insertChild( htbData, objDataAccess );
		}

	}

	/**
	 * O[vƐlǗXMOw肳ꂽo[VbvID̎qXg擾
	 * ݂ꍇ͎qɑ΂āARoleAssignmento^܂
	 * @param htbData p[^
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void insertChild( Hashtable htbData, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		try {

			// O[vƐlǗXMÕNCAgCX^X܂
			GroupAndPeopleClient objGroupAndPeople = new GroupAndPeopleClient();

			// o[VbvID擾܂
			String strMemberShipID = (String)htbData.get( MEMBER_SHIP_ID );
			// O[vƐlǗXMONCAgɃo[VbvIDݒ肵
			// s܂
			objGroupAndPeople.setMemberShipID( strMemberShipID );

			// ݎgp̃RlNVCfbNXݒ肵܂
			objGroupAndPeople.setConnectionIndex( objDataAccess.getConnectionIndex() );

			if( !objGroupAndPeople.select() ) {
				// Ɏsꍇ͌G[Ԃ܂
				throw new XMOException( objGroupAndPeople.getMessageData() );
			}

			// ʐ[vāAinsertĂяo܂
			if( objGroupAndPeople.next() ) {
				// o[VbvID茩R[h̎qIDL[ɂāAqXg擾
				String strParentID = objGroupAndPeople.getChildID();

				// p[^NA
				objGroupAndPeople.clear();
				objGroupAndPeople.setParentID( strParentID );

				// qXg
				if( !objGroupAndPeople.select() ) {

					// Ɏsꍇ͌G[Ԃ܂
					throw new XMOException( objGroupAndPeople.getMessageData() );
				}

				// qXg[vĐeO[vƓ[蓖Ă܂B
				while( objGroupAndPeople.next() ) {

					// q̃o[VbvIDݒ肵܂
					Hashtable htbChildParam = setData( htbData );

					htbChildParam.put( MEMBER_SHIP_ID, objGroupAndPeople.getMemberShipID() );

					htbChildParam.put( USER_ID, objGroupAndPeople.getChildID() );

					// ATC̃CT[g̍ċAĂяos܂
					insertAction( htbChildParam, objDataAccess );
				}
			}
		}
		catch( Exception e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );

			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
	}

	/**
	 * RoleAssignmentse[u֍XVs܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * ȗtB[h͍XV܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             MEMBER_SHIP_ID          lXID
	 *             USER_ID                 [UID
	 *             ROLE_ID                 ID
	 *             GROUP_ID                O[vID
	 *          ---------------------------------------------
	 *             CONDITION_KEY           XV
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData XV
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	synchronized public String update( Hashtable htParam )
		throws XMOException
	{
		// LOf[^null̂Ƃ
		if( htParam == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );	
			// p[^G[X[
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htParam );

			// XVs\bhs܂
			updateAction( htParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException se ) {
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		// 펞󕶎ԋp
		return "";
	}

	/**
	 * XVs\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam XV
	 * @exception XMOException XMOƎO
	 * @exception SQLException DBG[
	 */
	private void updateAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		// XVp̃f[^Zbg܂
		Hashtable htbData = setData( htbParam );

		String strSQL = objDataAccess.getUpdateSQL(htbData);

		// ̎擾
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			strSQL += strCondition;
		}

		// XVs
		objDataAccess.execute( strSQL );
	}

	/**
	 * RoleAssignmentse[u֍폜s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           폜
	 *          ---------------------------------------------
	 *          ܂
	 *          ---------------------------------------------
	 *             DELETE_USER_ID          user_id
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 폜
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	synchronized public String delete( Hashtable htParam )
		throws XMOException
	{
		// 폜f[^null̂Ƃ
		if( htParam == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );	
			// p[^G[X[
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans( htParam );

			// 폜s\bhs܂
			deleteAction( htParam, objDataAccess );
			
			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN

			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException se ) {
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			// [obN

			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
		return DELETE_COMPLETE;
	}

	/**
	 * 폜s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 폜
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// user_id̎擾
		String strUserID = (String)htbParam.get( DELETE_USER_ID );
		
		// group_id̎擾
		String strGroupID = (String)htbParam.get( DELETE_GROUP_ID );
		
		if( strGroupID != null ) {
			// O[vIDR[h폜
			deleteEqGroup( strGroupID, objDataAccess );
		}
		else if( strUserID == null ) {
			// w̍폜s
			deleteCondition( htbParam, objDataAccess );
		} else {
			// [UIDR[h폜
			deleteEqUser( strUserID, objDataAccess );
		}

	}

	/**
	 * 폜s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 폜
	 * @exception XMOException XMOƎO
	 * @exception SQLException DBG[
	 */
	private void deleteCondition( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "DELETE FROM " + TABLE_NAME );

		// ̎擾
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}
		// 폜s
		objDataAccess.execute( sbSQL.toString() );

		//[h擾܂
		String strMode = (String)htbParam.get( MODE_KEY );

		// [hON̏ꍇ͈ȉ͍̏sȂ
		// O[vƐlǗXMOgpāAqO[vѐl݂邩s
		// ݂ꍇ͓l̍폜s܂
		if( strMode == null || !strMode.equals("on") ) {
			deleteChild( htbParam, objDataAccess );
		}

	}

	/**
	 * O[vƐlǗXMOw肳ꂽo[VbvID̎qXg擾
	 * ݂ꍇ͎qɑ΂āARoleAssignment폜܂
	 * @param htbData p[^
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteChild( Hashtable htbData, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		try {

			// O[vƐlǗXMÕNCAgCX^X܂
			GroupAndPeopleClient objGroupAndPeople = new GroupAndPeopleClient();

			// o[VbvID擾܂
			String strMemberShipID = (String)htbData.get( MEMBER_SHIP_ID );

			// O[vƐlǗXMONCAgɃo[VbvIDݒ肵
			// s܂
			objGroupAndPeople.setMemberShipID( strMemberShipID );

			// ݎgp̃RlNVCfbNXݒ肵܂
			objGroupAndPeople.setConnectionIndex( objDataAccess.getConnectionIndex() );

			if( !objGroupAndPeople.select() ) {
				// Ɏsꍇ͌G[Ԃ܂
				throw new XMOException( objGroupAndPeople.getMessageData() );
			}

			// ʐ[vāAdeletĂяo܂
			if( objGroupAndPeople.next() ) {

				// o[VbvID茩R[h̎qIDL[ɂāAqXg擾
				String strParentID = objGroupAndPeople.getChildID();

				// p[^NA
				objGroupAndPeople.clear();
				objGroupAndPeople.setParentID( strParentID );

				// qXg
				if( !objGroupAndPeople.select() ) {

					// Ɏsꍇ͌G[Ԃ܂
					throw new XMOException( objGroupAndPeople.getMessageData() );
				}

				// qXg[vĐeO[vƓ[蓖Ă܂B
				while( objGroupAndPeople.next() ) {

					// q̃o[VbvIDݒ肵܂
					Hashtable htbChildParam = setData( htbData );

					htbChildParam.put( MEMBER_SHIP_ID, objGroupAndPeople.getMemberShipID() );
					// ̑gݗ
					String strUserID = objGroupAndPeople.getChildID();
					String strRoleID = (String)htbData.get(ROLE_ID);
					String strGroupID = (String)htbData.get(GROUP_ID);
					
					String strCondition = " WHERE " + USER_ID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " + ROLE_ID + "='" + StringEscapeUtils.escapeSql(strRoleID) + "' AND " + GROUP_ID + "='" + StringEscapeUtils.escapeSql(strGroupID) + "'";
					htbChildParam.put( CONDITION_KEY, strCondition );

					// ATC̍폜̍ċAĂяos܂
					deleteAction( htbChildParam, objDataAccess );
				}
			}
		}
		catch( Exception e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );

			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
	}

	/**
	 * RoleAssignmentse[uuser_id̈v郌R[h폜܂B
	 *
	 * @param strUserID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteEqUser( String strUserID, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		StringBuffer sbSQL = new StringBuffer( "DELETE FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( USER_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strUserID) );
		sbSQL.append( "' ");

		objDataAccess.execute( sbSQL.toString() );

	}

	/**
	 * RoleAssignmentse[uuser_id̈v郌R[h폜܂B
	 *
	 * @param strGroupID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteEqGroup( String strGroupID, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		StringBuffer sbSQL = new StringBuffer( "DELETE FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( GROUP_ID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strGroupID) );
		sbSQL.append( "' ");

		objDataAccess.execute( sbSQL.toString() );

	}

	/**
	 * RoleAssignmentse[u֌s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public Vector select( Hashtable htParam )
		throws XMOException
	{
		// f[^null̂Ƃ
		if( htParam == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );	
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// ߂l
		Vector vecReturn = new Vector();

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htParam );

			// s\bh
			vecReturn = selectAction( htParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException se ) {
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); }
			catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		return vecReturn;
	}

	/**
	 * s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 
	 * @return Vector 
	 * @exception XMOException XMOƎO
	 * @exception SQLException DBG[
	 */
	private Vector selectAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT * FROM " + TABLE_NAME );

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );
		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}

		// ̎擾
		String strOrderBy = (String)htbParam.get( "order_by" );
		if( strOrderBy != null ) {
			sbSQL.append( strOrderBy );
		}

		// NG[s܂
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		Vector vecReturn = new Vector();
		while(rs.next()) {
			String strRoleAssignID = ChangeEncode.setChar( rs.getString( ROLE_ASSIGN_ID ) );
			String strUserID = ChangeEncode.setChar( rs.getString( USER_ID ) );
			String strRoleID = ChangeEncode.setChar( rs.getString( ROLE_ID ) );
			String strGroupID = ChangeEncode.setChar( rs.getString( GROUP_ID ) );
			RoleAssignmentsData objData = new RoleAssignmentsData();
			objData.setRoleAssignID( strRoleAssignID );
			objData.setUserID( strUserID );
			objData.setRoleID( strRoleID );
			objData.setGroupID( strGroupID );
			vecReturn.add( objData );
		}
		return vecReturn;
	}

	/**
	 * őRoleAssignID擾
	 * @return String őRoleAssignID
	 */
	private String getMaxRoleAssignID( DataAccess objDataAccess )
		throws SQLException
	{
		String strSQL = "";
		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				strSQL = "select MAX(CONVERT(INT," + ROLE_ASSIGN_ID + ")) + 1 as maxassignid from " + TABLE_NAME;
			//Oraclȅꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
				strSQL = "select MAX(TO_NUMBER(" + ROLE_ASSIGN_ID + ")) + 1 as maxassignid from " + TABLE_NAME;
			//PostgreSQL̏ꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				strSQL = "select MAX(TO_NUMBER((" + ROLE_ASSIGN_ID + "),'9999999999')) + 1 as maxassignid from " + TABLE_NAME;
			}
		}
		catch(Exception ex)
		{

		}

		String strMaxAssignID = "";

		DebugLog.write( this.getClass(), strSQL, DebugLog.ROW );
		ResultSet rs = objDataAccess.executeQuery(strSQL);

		while(rs.next()) {
			int intTemp = 0;
			intTemp = rs.getInt( "maxassignid" );
			strMaxAssignID = new Integer(intTemp).toString();
		}
		return strMaxAssignID;
	}

	/**
	 * ̑݃`FbNs܂
	 * @param htbParam p[^
	 * @param objDataAccess DBANZXNX
	 * @return boolean true: 蓖ĂĂ false: 蓖ĂĂȂ
	 * @exception SQLException DBG[
	 */
	private boolean isExitAssign( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{
		// [UID̎擾
		String strUserID = (String)htbParam.get( USER_ID );
		// ID̎擾
		String strRoleID = (String)htbParam.get( ROLE_ID );
		// O[vID̎擾
		String strGroupID = (String)htbParam.get( GROUP_ID );

		// ̑gݗ
		String strCondition = " WHERE " + USER_ID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " + ROLE_ID + "='" + StringEscapeUtils.escapeSql(strRoleID) + "' AND " + GROUP_ID + "='" + StringEscapeUtils.escapeSql(strGroupID) + "'";
		return objDataAccess.isExit( strCondition, TABLE_NAME );
	}

	/**
	 * o^AXṼf[^gݗĂ܂
	 * @param htData
	 * @return Hashtable
	 */
	private Hashtable setData( Hashtable htbParam ) {
		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, ROLE_ASSIGN_ID );
		putData( htbData, htbParam, USER_ID );
		putData( htbData, htbParam, ROLE_ID );
		putData( htbData, htbParam, GROUP_ID );
		return htbData;
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData, Hashtable htbParam, String strKey ) {
		String strValue = (String)htbParam.get( strKey );
		if( strValue != null ) {
			htbData.put( strKey, strValue );
		}
	}

	/**
	 * bZ[WIuWFNg쐬܂
	 * @param strMessageID bZ[WID
	 * @return MessageData bZ[WIuWFNg OnullԂ܂
	 */
	private MessageData getMessageData( String strMessageID) {
		MessageData objMessage = null;
		try {
			objMessage = Message.getInstance().getMessageData( strMessageID, MSG_FIEL_PATH, MSG_FILE_NAME );
		}
		catch( Exception e ) {

		}
		return objMessage;
	}

}

