/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

/**
 * Smartforceݒt@C̏ڂɂē͂߂ANVNXB
 * @author T.Nishiki
 */
public class SmartforceInputAction implements InstallerAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(SmartforceInputAction.class);
	}

	/**
	 * ANVXLbv邩肵܂B<br>
	 * SelectLoActionł̓͂ɊÂ肵܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return LOISmartforceIĂȂtrue߂܂B
	 * @throws InstallerException ̌ƂȂ擾ɎsꍇB
	 * @see SelectLoAction
	 */
	public boolean isSkipped(InstallerValues values)
			throws InstallerException {
		LoggerUtil.methodHead(_logger, "isSkipped(InstallerValues)");

		boolean skipped = false;
		try {
			// LOISmartforce𖢑IɂĂtrueB
			skipped = (values.getOptionLOSelected(
					SmartforceInputValue.KEY_LO) == false);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		LoggerUtil.methodTail(_logger, "isSkipped(InstallerValues)", skipped);
		return skipped;
	}

	/**
	 * Smartforceݒt@C̏ڂɂḗEmF߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return SmartforceInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 * @see SmartforceInputValue
	 */
	public InstallerActionValue action(InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger, "action(InstallerValues)");
		// ̓f[^
		SmartforceInputValue inputValue = null;
		try {
			// ̓f[^iftHgf[^ƂĎgpj
			SmartforceInputValue defaultValue = getDefaultValue(values);
			// ^Cg̕\
			InstallerUiUtil.outputMessageAsTitle(
				values, "SmartforceInputAction.welcome");

			while (true) {
				// ͎s
				inputValue = readInputValue(values, defaultValue);
				// ͊mF
				if (confirmInputValue(values, inputValue) == true) {
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger, "action(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * Smartforceݒt@C̏ڂɂē͂߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param defaultValue ftHglB
	 * @return ͂ꂽeSmartforceInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private SmartforceInputValue readInputValue(
			InstallerValues values, SmartforceInputValue defaultValue)
			throws InstallerException {
		LoggerUtil.methodHead(_logger,
			"readInputValue(InstallerValues," + defaultValue + ")");

		SmartforceInputValue inputValue = null;
		try {
			inputValue = new SmartforceInputValue();
			// =================================================================
			// URL
			String materialURL = null;
			while (true) {
				materialURL = InstallerUiUtil.askUserInput(values,
						"SmartforceInputAction.prompt.materialURL",
						defaultValue.getMaterialURL());
				// 
				if (InstallerCheckUtil.isEmptyViolation(materialURL, values,
						"SmartforceInputAction.error.materialURL.empty")) {
					continue;
				}
				break;
			}
			inputValue.setMaterialURL(materialURL);
			// =================================================================
			// qcalr̎ޑI
			String dbCategory = null;
			while (true) {
				dbCategory = InstallerUiUtil.askUserInput(values,
					"SmartforceInputAction.prompt.dbCategory",
					defaultValue.getDbCategory());
				// ΏۊO̓
				boolean violate = InstallerCheckUtil.isPatternViolation(
					dbCategory, "[0-1]", values,
					"SmartforceInputAction.error.dbCategory.format");
				if (violate) {
					continue;
				}
				break;
			}
			inputValue.setDbCategory(dbCategory);
			// =================================================================
			// f[^x[X̃zXg
			String dbHost = null;
			while (true) {
				dbHost = InstallerUiUtil.askUserInput(values,
						"SmartforceInputAction.prompt.dbHost",
						defaultValue.getDbHost());
				// 
				if (InstallerCheckUtil.isEmptyViolation(dbHost, values,
						"SmartforceInputAction.error.dbHost.empty")) {
					continue;
				}
				break;
			}
			inputValue.setDbHost(dbHost);
			// =================================================================
			// f[^x[Xڑ̃[U
			String dbUser = null;
			while (true) {
				dbUser = InstallerUiUtil.askUserInput(values,
						"SmartforceInputAction.prompt.dbUser",
						defaultValue.getDbUser());
				// 
				if (InstallerCheckUtil.isEmptyViolation(dbUser, values,
						"SmartforceInputAction.error.dbUser.empty")) {
					continue;
				}
				break;
			}
			inputValue.setDbUser(dbUser);
			// =================================================================
			// f[^x[Xڑ̃pX[h
			String dbPassword = null;
			dbPassword = InstallerUiUtil.askUserInput(values,
					"SmartforceInputAction.prompt.dbPassword",
					defaultValue.getDbPassword());
			inputValue.setDbPassword(dbPassword);
			// =================================================================
			// f[^x[X̃|[gԍ
			String dbPort = null;
			while (true) {
				dbPort = InstallerUiUtil.askUserInput(values,
						"SmartforceInputAction.prompt.dbPort",
						defaultValue.getDbPort());
				// 
				if (InstallerCheckUtil.isEmptyViolation(dbPort, values,
						"SmartforceInputAction.error.dbPort.empty")) {
					continue;
				}
				break;
			}
			inputValue.setDbPort(dbPort);
			// =================================================================
			// f[^x[X
			String dbName = null;
			while (true) {
				dbName = InstallerUiUtil.askUserInput(values,
						"SmartforceInputAction.prompt.dbName",
						defaultValue.getDbName());
				// 
				if (InstallerCheckUtil.isEmptyViolation(dbName, values,
						"SmartforceInputAction.error.dbName.empty")) {
					continue;
				}
				break;
			}
			inputValue.setDbName(dbName);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"readInputValue(InstallerValues,SmartforceInputValue)", inputValue);
		return inputValue;
	}

	/**
	 * ͂e\A[UɊmF߂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param inputValue ͂ꂽe
	 * @return ͂ꂽeɃ[UmFƂꂽꍇtrueA
	 *          ƂȂꍇfalse߂܂B
	 * @throws InstallerException ɃG[ꍇB
	 */
	private boolean confirmInputValue(
			InstallerValues values, SmartforceInputValue inputValue)
			throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"confirmInputValue(InstallerValues, SmartforceInputValue)");
		boolean confirm = false;
		try {
			InstallerUiUtil.outputConfirmTitle(values,
				"SmartforceInputAction.confirm.title");
			// =================================================================
			// ͓e̕\
			// =================================================================
			// zXg
			InstallerUiUtil.outputConfirm(values,
				"SmartforceInputAction.confirm.materialURL",
				inputValue.getMaterialURL());
			// f[^x[X
			String dbCategoryName = values.getMessage(
				"SmartforceInputAction.confirm.dbCategory."
					+ inputValue.getDbCategory());
			InstallerUiUtil.outputConfirm(values,
				"SmartforceInputAction.confirm.dbCategory", dbCategoryName);
			// f[^x[XEzXg
			InstallerUiUtil.outputConfirm(values,
				"SmartforceInputAction.confirm.dbHost",
				inputValue.getDbHost());
			// f[^x[XE[U
			InstallerUiUtil.outputConfirm(values,
				"SmartforceInputAction.confirm.dbUser",
				inputValue.getDbUser());
			// f[^x[XEpX[h
			InstallerUiUtil.outputConfirm(values,
				"SmartforceInputAction.confirm.dbPassword",
				inputValue.getDbPassword());
			// f[^x[XE|[gԍ
			InstallerUiUtil.outputConfirm(values,
				"SmartforceInputAction.confirm.dbPort",
				inputValue.getDbPort());
			// f[^x[X
			InstallerUiUtil.outputConfirm(values,
				"SmartforceInputAction.confirm.dbName",
				inputValue.getDbName());
			// =================================================================
			// [UmF
			confirm = InstallerUiUtil.askUserConfirm(
				values, "SmartforceInputAction.confirm" );
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"confirmInputValue(InstallerValues, SmartforceInputValue)",
			confirm);
		return confirm;
	}

	/**
	 * ̃f[^A͍ڂ̃ftHgl擾܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ftHglSmartforceInputValuě`Ŗ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private SmartforceInputValue getDefaultValue(InstallerValues values)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getDefaultValue(InstallerValues)");

		SmartforceInputValue defaultValue = null;
		try {
			defaultValue = new SmartforceInputValue();
			////////////////////////////////////////////////////////////////////
			// vpeB̎擾
			// =================================================================
			// ̓e
			File existFile = values.getFileOnSystem(
					defaultValue.getTargetFileKey());
			Properties existProperties
				= FileUtil.loadAsProperties(existFile);
			// =================================================================
			// \[Xi{j̓e
			Properties resourceProperties
				= InstallerPropertiesUtil.load(
					values, defaultValue.getTargetFileKey());
			////////////////////////////////////////////////////////////////////
			// ftHgl̐ݒ
			// =================================================================
			// zXg
			String materialURL = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								SmartforceInputValue.KEY_MATERIAL_URL);
			defaultValue.setMaterialURL(materialURL);
			// =================================================================
			// f[^x[XE
			String dbCategory = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								SmartforceInputValue.KEY_DB_CATEGORY);
			defaultValue.setDbCategory(dbCategory);
			// =================================================================
			// f[^x[XEzXg
			String dbHost = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								SmartforceInputValue.KEY_DB_HOST);
			defaultValue.setDbHost(dbHost);
			// =================================================================
			// f[^x[Xڑ̃[U
			String dbUser = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								SmartforceInputValue.KEY_DB_USER);
			defaultValue.setDbUser(dbUser);
			// =================================================================
			// f[^x[Xڑ̃pX[h
			String dbPassword = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								SmartforceInputValue.KEY_DB_PASS);
			defaultValue.setDbPassword(dbPassword);
			// =================================================================
			// f[^x[X̃|[gԍ
			String dbPort = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								SmartforceInputValue.KEY_DB_PORT);
			defaultValue.setDbPort(dbPort);
			// =================================================================
			// f[^x[X
			String dbName = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								SmartforceInputValue.KEY_DB_NAME);
			defaultValue.setDbName(dbName);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getDefaultValue(InstallerValues)", defaultValue);
		return defaultValue;
	}
}
