/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;
import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.lms.OfflineInputValue;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

public class OfflineInputAction
implements InstallerAction {
    private static Logger _logger = LoggerUtil.getLogger(class$jp$co$ntt$lms$installer$lms$OfflineInputAction == null ? (class$jp$co$ntt$lms$installer$lms$OfflineInputAction = OfflineInputAction.class$("jp.co.ntt.lms.installer.lms.OfflineInputAction")) : class$jp$co$ntt$lms$installer$lms$OfflineInputAction);
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$lms$OfflineInputAction;

    public boolean isSkipped(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "isSkipped(InstallerValues)");
        boolean bl = false;
        try {
            bl = !installerValues.getOptionLOSelected("offline");
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "isSkipped(InstallerValues)", bl);
        return bl;
    }

    public InstallerActionValue action(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "action(InstallerValues)");
        OfflineInputValue offlineInputValue = null;
        try {
            OfflineInputValue offlineInputValue2 = this.getDefaultValue(installerValues);
            InstallerUiUtil.outputMessageAsTitle(installerValues, "OfflineInputAction.welcome");
            while (!this.confirmInputValue(installerValues, offlineInputValue = this.readInputValue(installerValues, offlineInputValue2))) {
            }
            File file = new File(offlineInputValue.getMaterialInstallPath());
            installerValues.addMadeDirectory(file);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "action(InstallerValues)", offlineInputValue);
        return offlineInputValue;
    }

    private OfflineInputValue readInputValue(InstallerValues installerValues, OfflineInputValue offlineInputValue) throws InstallerException {
        LoggerUtil.methodHead(_logger, "readInputValue(InstallerValues)");
        OfflineInputValue offlineInputValue2 = null;
        try {
            offlineInputValue2 = new OfflineInputValue();
            String string = null;
            while (InstallerCheckUtil.isEmptyViolation(string = InstallerUiUtil.askUserInput(installerValues, "OfflineInputAction.prompt.materialInstallPath", offlineInputValue.getMaterialInstallPath()), installerValues, "OfflineInputAction.error.materialInstallPath.empty") || InstallerCheckUtil.isFilePath(string, installerValues, "OfflineInputAction.error.materialInstallPath.file")) {
            }
            offlineInputValue2.setMaterialInstallPath(string);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "readInputValue(InstallerValues)", offlineInputValue2);
        return offlineInputValue2;
    }

    private boolean confirmInputValue(InstallerValues installerValues, OfflineInputValue offlineInputValue) throws InstallerException {
        LoggerUtil.methodHead(_logger, "confirmInputValue(InstallerValues, OfflineInputValue)");
        boolean bl = false;
        try {
            InstallerUiUtil.outputConfirmTitle(installerValues, "OfflineInputAction.confirm.title");
            InstallerUiUtil.outputConfirm(installerValues, "OfflineInputAction.confirm.materialInstallPath", offlineInputValue.getMaterialInstallPath());
            bl = InstallerUiUtil.askUserConfirm(installerValues, "OfflineInputAction.confirm");
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "confirmInputValue(InstallerValues, OfflineInputValue)", bl);
        return bl;
    }

    private OfflineInputValue getDefaultValue(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getDefaultValue(InstallerValues)");
        OfflineInputValue offlineInputValue = null;
        try {
            offlineInputValue = new OfflineInputValue();
            File file = installerValues.getFileOnSystem(offlineInputValue.getTargetFileKey());
            Properties properties = FileUtil.loadAsProperties(file);
            Properties properties2 = InstallerPropertiesUtil.load(installerValues, offlineInputValue.getTargetFileKey());
            String string = InstallerPropertiesUtil.determineInitialValue(properties, properties2, "material_temp");
            offlineInputValue.setMaterialInstallPath(string);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "getDefaultValue(InstallerValues)", offlineInputValue);
        return offlineInputValue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

