/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ContentsInfoCacher
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm.engine;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import jp.co.ntt.lms.lo.scorm.util.Debug;
import jp.co.ntt.lms.lo.scorm.util.SG;

import org.xml.sax.SAXException;

/**
 * ContentsInfoCacherNX
 * RecLbVNX
 */
public class ContentsInfoCacher implements Runnable {
	/** LbV̓ꕨBZNVL[ŒlHashMap */
	private static HashMap cacheHolder = new HashMap();

	/** LbV̕ێ(msec) */
	private static long preserveTime;

	/** B̎g */
	private static ContentsInfoCacher self;

	/** LbVjXbh */
	private static Thread discarderThread;

	static {
		try {
			// SGLbVێԂ擾
			String value = SG.get("ContentsInfoCacheMinutes");

			// 擾łꍇmsecɒAvpeB֐ݒ肷
			if (value != null) {
				try {
					preserveTime = Long.parseLong(value) * 60 * 1000;
				}
				catch (Exception ex) {
					Debug.write(ex);

					preserveTime = 0;
					ex.printStackTrace(System.out);
				}
			}

			// g쐬
			new ContentsInfoCacher();
		}
		catch (Exception ex) {
			Debug.write(ex);

			preserveTime = 0;
			ex.printStackTrace(System.out);
		}
	}

	/**
	 * LbVXVꂽǂ`FbNsׂinterface
	 */
	public interface ValidateChecker {
		/**
		 * LbVXVꂽǂ`FbN
		 *
		 * @return LbVLȏꍇtrueALbVXVꂽꍇfalseԋp
		 */
		boolean isValid();
	}

	/**
	 * t@CXVꂽǂ`FbNsׂ̃NX
	 */
	public static class FileValidateChecker implements ValidateChecker {
		/** FileIuWFNg */
		private File file;

		/** CX^X̃t@CŏIXVt */
		private long lastModified;

		/**
		 * ftHgRXgN^
		 */
		private FileValidateChecker() {}

		/**
		 * RXgN^
		 *
		 * @param filename t@Cw肷
		 */
		public FileValidateChecker(String filename) {
			this.file = new File(filename);
			lastModified = file.lastModified();
		}

		/**
		 * t@CXVꂽǂ`FbN
		 *
		 * @return XVꂽꍇfalseAXVĂȂꍇtrueԋp
		 */
		public boolean isValid() {
			return (lastModified == file.lastModified());
		}
	}

	/**
	 * cacheHolderɊi[Item
	 */
	private static class CacheItem {
		/** j */
		private long discardTime;

		/** LbVĂObject */
		private Object object;

		/** ValidateChecker */
		private ValidateChecker validateChecker;

		/**
		 * jݒ肷
		 *
		 * @param discardTime	j
		 */
		private void setDiscardTime(long discardTime) {
			this.discardTime = discardTime;
		}

		/**
		 * j擾
		 *
		 * @return j
		 */
		private long getDiscardTime() {
			return discardTime;
		}

		/**
		 * Objectݒ肷
		 *
		 * @param object	Object
		 */
		private void setObject(Object object) {
			this.object = object;
		}

		/**
		 * Object擾
		 *
		 * @return Object
		 */
		private Object getObject() {
			return object;
		}

		/**
		 * ValidateChecker擾
		 *
		 * @return ValidateCheckerԋp
		 */
		public ValidateChecker getValidateChecker() {
			return validateChecker;
		}

		/**
		 * ValidateCheckerݒ肷
		 *
		 * @param validateChecker ValidateCheckerw肷
		 */
		public void setValidateChecker(ValidateChecker validateChecker) {
			this.validateChecker = validateChecker;
		}
	}

	/**
	 * ftHgRXgN^
	 */
	private ContentsInfoCacher() {
		if (preserveTime > 0) {
			self = this;

			discarderThread = new Thread(this);
			discarderThread.setDaemon(true);
			discarderThread.start();
		}
	}

	/**
	 * sectionykeyŎw肳ꂽlLbV擾<br>
	 * LbVɑ݂Ȃꍇnullԋp
	 *
	 * @param section	ZNV
	 * @param key		L[
	 * @return LbVĂObjectԋpBLbV݂Ȃꍇnullԋp
	 */
	public static Object get(String section, String key)
		throws IOException, ParserConfigurationException, SAXException, TransformerException {

		// cacheHolderLbV擾
		if (preserveTime > 0) {
			synchronized (self) {
				HashMap sectionMap = (HashMap)cacheHolder.get(section);

				if (sectionMap != null) {
					CacheItem item = (CacheItem)sectionMap.get(key);

					// LbVꂽitem݂ꍇ
					if (item != null) {
						ValidateChecker validateChecker = item.getValidateChecker();

						if ((validateChecker == null) || (validateChecker.isValid())) {
							// LbVjݒ肷
							item.setDiscardTime(System.currentTimeMillis() + preserveTime);

							// LbVjXbhɃLbV̍XVʒm
							self.notify();

							// 擾łitemɐݒ肳ĂObjectԋp
							return item.getObject();
						}

						// LbVj0ɐݒ肵Ajs
						item.setDiscardTime(0);

						// LbVjXbhɃLbV̍XVʒm
						self.notify();

						// 擾łitemɐݒ肳ĂObjectԋp
						return null;
					}
				}
			}
		}

		return null;
	}

	/**
	 * sectionykeyobjectLbVɐݒ肷
	 *
	 * @param section	ZNV
	 * @param key		L[
	 * @param object	LbVObject
	 */
	public static void set(String section, String key, Object object, ValidateChecker validateChecker) {
		if (preserveTime > 0) {
			synchronized (self) {
				HashMap sectionMap = (HashMap)cacheHolder.get(section);

				if (sectionMap == null) {
					sectionMap = new HashMap();
					cacheHolder.put(section, sectionMap);
				}

				CacheItem item = new CacheItem();

				item.setObject(object);
				item.setDiscardTime(key.equals("") ? Long.MAX_VALUE : (System.currentTimeMillis() + preserveTime));
				item.setValidateChecker(validateChecker);

				sectionMap.put(key, item);

				self.notify();
			}
		}
	}

	/**
	 * LbVjXbh<br>
	 * SGŎw肳ꂽԂ߂ăANZXsȂCachedItemcacheHolder菜
	 */
	public void run() {
		try {
			ArrayList discardItems = new ArrayList();
			long wackupMillis;

			synchronized (self) {
				while (true) {
					wackupMillis = Long.MAX_VALUE;

					// LbVSčXVAj߂ĂItem̃Xg쐬
					for (Iterator sections = cacheHolder.keySet().iterator(); sections.hasNext();) {
						HashMap sectionMap = (HashMap)cacheHolder.get(sections.next());

						for (Iterator keys = sectionMap.keySet().iterator(); keys.hasNext();) {
							Object key = keys.next();

							CacheItem item = (CacheItem)sectionMap.get(key);

							if (item.getDiscardTime() <= System.currentTimeMillis()) {
								discardItems.add(key);
							}
							else {
								if (item.getDiscardTime() < wackupMillis) {
									wackupMillis = item.getDiscardTime();
								}
							}
						}

						// j߂ĂItemLbV폜
						for (int i = 0; i < discardItems.size(); i++) {
							sectionMap.remove(discardItems.get(i));
						}

						discardItems.clear();
					}

					// ̔jCxg܂őҋ@
					if (wackupMillis >= Long.MAX_VALUE) {
						self.wait();
					}
					else {
						wackupMillis -= System.currentTimeMillis();

						if (wackupMillis > 0) {
							self.wait(wackupMillis);
						}
					}
				}
			}
		}
		catch (Exception ex) {
			Debug.write(ex);

			ex.printStackTrace(System.out);
		}
	}
}
