/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ntt.lms.installer.core.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Logger;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

public class InstallerFileUtil {
    private static Logger _logger = LoggerUtil.getLogger(class$jp$co$ntt$lms$installer$core$util$InstallerFileUtil == null ? (class$jp$co$ntt$lms$installer$core$util$InstallerFileUtil = InstallerFileUtil.class$("jp.co.ntt.lms.installer.core.util.InstallerFileUtil")) : class$jp$co$ntt$lms$installer$core$util$InstallerFileUtil);
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$core$util$InstallerFileUtil;

    public static void copyFile(File file, File file2) throws InstallerException {
        String string = null;
        if (LoggerUtil.isLoggableMethod(_logger)) {
            string = "copyFile(" + file + "," + file2 + ")";
            LoggerUtil.methodHead(_logger, string);
        }
        try {
            FileUtil.copyFile(file, file2);
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        if (LoggerUtil.isLoggableMethod(_logger)) {
            LoggerUtil.methodTail(_logger, string);
        }
    }

    public static void cleanDirectory(File file) throws InstallerException {
        LoggerUtil.methodHead(_logger, "cleanDirectory(" + file + ")");
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            InstallerFileUtil.delete(fileArray[i]);
        }
        LoggerUtil.methodTail(_logger, "cleanDirectory(" + file + ")");
    }

    public static void delete(File file) throws InstallerException {
        LoggerUtil.methodHead(_logger, "delete(" + file + ")");
        try {
            FileUtil.delete(file);
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "delete(" + file + ")");
    }

    public static void close(InputStream inputStream, boolean bl) throws InstallerException {
        try {
            FileUtil.close(inputStream, bl);
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
    }

    public static void close(OutputStream outputStream, boolean bl) throws InstallerException {
        try {
            FileUtil.close(outputStream, bl);
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
    }

    public static void close(InputStream inputStream, OutputStream outputStream, boolean bl) throws InstallerException {
        InstallerException installerException;
        block5: {
            installerException = null;
            try {
                InstallerFileUtil.close(inputStream, bl);
            }
            catch (InstallerException installerException2) {
                installerException = installerException2;
            }
            try {
                InstallerFileUtil.close(outputStream, bl);
            }
            catch (InstallerException installerException3) {
                if (installerException != null) break block5;
                installerException = installerException3;
            }
        }
        if (installerException != null) {
            throw installerException;
        }
    }

    public static void close(Reader reader, boolean bl) throws InstallerException {
        try {
            FileUtil.close(reader, bl);
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
    }

    public static void close(Writer writer, boolean bl) throws InstallerException {
        try {
            FileUtil.close(writer, bl);
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
    }

    public static void close(Reader reader, Writer writer, boolean bl) throws InstallerException {
        InstallerException installerException;
        block5: {
            installerException = null;
            try {
                InstallerFileUtil.close(reader, bl);
            }
            catch (InstallerException installerException2) {
                installerException = installerException2;
            }
            try {
                InstallerFileUtil.close(writer, bl);
            }
            catch (InstallerException installerException3) {
                if (installerException != null) break block5;
                installerException = installerException3;
            }
        }
        if (installerException != null) {
            throw installerException;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadFile(InstallerValues installerValues, File file, String string) throws InstallerException {
        LoggerUtil.methodHead(_logger, "loadFile(" + file + "," + string + ")");
        InputStream inputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        boolean bl = false;
        try {
            inputStream = installerValues.getResourceKeyStream(string);
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            while (true) {
                byte[] byArray;
                int n;
                if ((n = inputStream.read(byArray = new byte[10240])) <= 0) {
                    bl = true;
                    break;
                }
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
        }
        catch (InstallerException installerException) {
            try {
                throw installerException;
                catch (Exception exception) {
                    LoggerUtil.throwable(_logger, exception);
                    throw new InstallerException(exception);
                }
            }
            catch (Throwable throwable) {
                InstallerFileUtil.close(inputStream, bufferedOutputStream, bl);
                throw throwable;
            }
        }
        InstallerFileUtil.close(inputStream, bufferedOutputStream, bl);
        LoggerUtil.methodTail(_logger, "loadFile(" + file + "," + string + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

