/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//LoInfo IuWFNgXgNX
//
//ύX
//2005.01.27  VK쐬  X@qu
//
//@\
//
//ScormXMLInfoNX̌pNX̃IuWFNg쐬邽߂factoryNXłB
//
/////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.lom.learnableinfo;

import java.io.*;
import java.util.*;

import org.w3c.dom.*;
import jp.co.ntt.lms.lo.scorm.ScormLoEnv;

/**
 * ScormXMLInfoNX̌pNX̃IuWFNg쐬邽߂factoryNXłB
 * @author s-mori
 * @version 1.00
 */
public class ScormXMLInfoFactory {
	
	private NodeController ctrl = null;
	private NodeList manifestNodeList = null;
	private File manifestDirectory = null;
	private File metadataDirectory = null;
	
	/**
	 * RXgN^B
	 * CX^X̍쐬֎~Ă܂B
	 */
	private ScormXMLInfoFactory(){
	}
	
	/**
	 * RXgN^B}jtFXgt@Cw肵܂B
	 * @param manifestFile }jtFXgt@C
	 */
	public ScormXMLInfoFactory(File manifestFile) throws Exception{
		
		// scorm.ini Ǎ
		ScormLoEnv env = new ScormLoEnv();

		// m[hRg[̎擾
		this.ctrl = new NodeController();

		// }jtFXgm[h擾
		this.getManifestNodeList(manifestFile);

		// }jtFXgt@C̐΃fBNgpX擾
		this.manifestDirectory = manifestFile.getParentFile();
		
		// xms2̃^f[^̐΃fBNgpX擾
		this.metadataDirectory = new File(env.getTempMaterialPath() + File.separator + this.manifestDirectory.getName());
		
					
	}

	/**
	 * manifestm[h̃XgA}jtFXgt@C擾܂B
	 * @param manifestFile }jtFXgt@C
	 * @throws Exception
	 */
	private void getManifestNodeList(File manifestFile) throws Exception{
		if(manifestFile == null){
			throw new NullPointerException("Manifest file is null.");
		}
		
		Node topNode = ctrl.parse(manifestFile);
		
		this.manifestNodeList = ctrl.getNodeList(topNode, "//:manifest");
		
	}
	
	/**
	 * ManifestInfõXgIuWFNg쐬܂B
	 * @return ManifestInfõRNV
	 * @throws Exception
	 */
	public Collection makeManifestInfoList() throws Exception{
		Collection manifestInfoList = new ArrayList();
		
		for(int m = 0; m < this.manifestNodeList.getLength(); m++){
			
			Node manifestNode = this.manifestNodeList.item(m);
			
			// manifest  identifier ͑ݕK{BȂꍇ NullPointerException 
			String maniId = manifestNode.getAttributes().getNamedItem("identifier").getNodeValue();
			
			// manifestInfo 쐬
			ManifestInfo maniInfo = new ManifestInfo(maniId);
			maniInfo.setNode(manifestNode);
			maniInfo.setInline(m != 0);

			// manifest meta-data 擾
			LomInfo topLomInfo = this.makeLomInfo(manifestNode);
			if(topLomInfo != null){
				maniInfo.addLomInfo(topLomInfo);
			}
			
			
			// item m[hT
			NodeList itemNodeList = ctrl.getNodeList(manifestNode, ".//:organizations/:organization//:item");

			// itemIdentifier 擾AƂ LomInfo 쐬AmanifestInfo ɒǉ
			for(int i = 0; i < itemNodeList.getLength(); i++){
				String identifier = itemNodeList.item(i).getAttributes().getNamedItem("identifier").getNodeValue();
				if(identifier != null){
					LomInfo info = this.makeLomInfo(identifier);
					if(info != null){
						maniInfo.addLomInfo(info);
					}
				}
			}
			
			//  manifestInfo RNVɒǉ
			manifestInfoList.add(maniInfo);
		}
		
		return manifestInfoList;
	}
	
	
	private LomInfo makeLomInfo(Node manifestNode) throws Exception{
		return this.makeLomInfo(manifestNode, null);
	}
	private LomInfo makeLomInfo(String itemIdentifier) throws Exception{
		return this.makeLomInfo(null, itemIdentifier);
	}
	
	private LomInfo makeLomInfo(Node manifestNode, String itemIdentifier) throws Exception{
		if(manifestNode == null && (itemIdentifier == null || itemIdentifier.equals(""))){
			throw new NullPointerException("Manifest node or Item identifier is null.");
		}
		
		// manifest  metadata ̏ꍇ́AmanifestNodeAłȂꍇ́AitemIdentifier 킽Ă
		boolean isTopMetadata = (manifestNode != null);
			
		LomInfo lomInfo = null;
		Node metadataNode = null;

		if(isTopMetadata){
			lomInfo = new LomInfo();
			lomInfo.setResourceIdentifier(null);
			metadataNode = ctrl.getNode(manifestNode, "./:metadata");
			
			
		}else{
			Node itemNode = this.getItem(itemIdentifier);
			
			// ACeȂꍇ͒Eo
			if(itemNode == null){
				return null;
			}
	
			// Ỹm[hAitemIdentifier 擾
			NamedNodeMap attrs = itemNode.getAttributes();
			lomInfo = new LomInfo(attrs.getNamedItem("identifier").getNodeValue());
	
	
			// identifierrefꍇ́AID擾A\[X
			Node resourceNode = null;
			if(attrs.getNamedItem("identifierref") != null){
				lomInfo.setResourceIdentifier(attrs.getNamedItem("identifierref").getNodeValue());
				resourceNode = this.getResource(attrs.getNamedItem("identifierref").getNodeValue());
			}else{
				// refꍇ́Ảɒ meta-data Ԃ牺Ă̂ƌȂA
				// itemNode  \[Xm[hɌĂ
				resourceNode = itemNode;
			}
			
			// \[XȂꍇ͒Eo
			if(resourceNode == null){
				return null;
			}
		
			// z metadata m[h擾
			metadataNode = ctrl.getNode(resourceNode, ".//:metadata");
		}
		
		// metadata Ȃꍇ͒Eo
		if(metadataNode == null){
			return null;
		}

		// ^f[^̉ lom m[hT
		Node lomNode = this.getInlineLomNode(metadataNode);
		
		// ݂Ȃ΁Alocation m[hTAQƐ悩 lom m[h擾
		if(lomNode == null){
			lomNode = this.getLocatedLomNode(metadataNode);
			
			// ł݂Ȃꍇ͒Eo
			if(lomNode == null){
				return null;
			}
			
			lomInfo.setInline(false);
			lomInfo.setLocation(this.getLocationPath(metadataNode));
						
		}else{
			lomInfo.setInline(true);
			lomInfo.setLocation(null);
		}
		
		lomInfo.setNode(lomNode);			
		
		
		return lomInfo;
	}
	

	
	private Node getInlineLomNode(Node metadataNode) throws Exception{
		if(metadataNode == null){
			throw new NullPointerException("Metadata node is null.");
		}
		
		Node lomNode = null;

		NodeList n = metadataNode.getChildNodes();
		for(int i = 0; i < n.getLength(); i++){
			Node x = n.item(i);
			if(x.getNodeName().equals("lom") || x.getNodeName().equals("lom:lom")){
				lomNode = x;
				break;
			}
		}
		
		return lomNode;
	}
	
	
	private Node getLocatedLomNode(Node metadataNode) throws Exception{
		if(metadataNode == null){
			throw new NullPointerException("Metadata node is null.");
		}

		Node lomNode = null;
		
		String locationPath = this.getLocationPath(metadataNode);
		
		lomNode = ctrl.parse(new File(locationPath));
		return lomNode;
		
	}
	
	
	private String getLocationPath(Node metadataNode) throws Exception{
		if(metadataNode == null){
			throw new NullPointerException("Metadata node is null.");
		}
		
		// ^f[^̉ location ܂ lom m[hT
		Node locationNode = ctrl.getNode(metadataNode, ".//adlcp:location");

		// ȂΒEo
		if(locationNode == null){
			return null;
		}
			
		File locationFile = new File(locationNode.getFirstChild().getNodeValue());
		
		// locationxmlt@CJēWJ
		String locationPath = null;
		if(locationFile.isAbsolute()){
			locationPath = locationNode.getFirstChild().getNodeValue();			
		}else{
			locationPath = this.metadataDirectory.getPath() + File.separator + locationNode.getFirstChild().getNodeValue();				
		}
		
		return locationPath;
		
	}
	
	
	private Node getItem(String identifier) throws Exception{
		if(identifier == null || identifier.equals("")){
			throw new NullPointerException("Identifier is null.");
		}
		
		Node itemNode = null;
		
		// item m[hT
		for(int m = 0; m < this.manifestNodeList.getLength(); m++){

			Node manifestNode = this.manifestNodeList.item(m);
			
			itemNode = ctrl.getNode(manifestNode, ".//:organizations/:organization//:item[@identifier='" + identifier + "']");

			if(itemNode != null){
				break;
			}			
		}

		return itemNode;
	
	}
	
	
	
	private Node getResource(String identifierRef) throws Exception{
		if(identifierRef == null || identifierRef.equals("")){
			throw new NullPointerException("Identifierref is null.");
		}
				
		Node resNode = null;
		
		// item ɑΉ郊\[XT
		for(int m = 0; m < this.manifestNodeList.getLength(); m++){

			Node manifestNode = this.manifestNodeList.item(m);
			
			resNode = ctrl.getNode(manifestNode, ".//:resources/:resource[@identifier='" + identifierRef + "']");

			if(resNode != null){
				break;
			}			
		}
		
		return resNode;
	}
	
	

	
	
}
