/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	wKiΔ\@\ǗNX
//
//		ύX
//			2005.01.26  VK쐬  Katsuhiko.Sakurai(UNITEC)
//
//	@\
//
//	̃NX͊wKiΔ\@\ǗNXłB
//
////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.progress;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import jp.co.ntt.lms.Common.Bean.xmo.Base.BaseVo;
import jp.co.ntt.lms.lo.progress.util.XMOInformationGetter;
import jp.co.ntt.lms.xmo.MenuData;
import jp.co.ntt.lms.xmo.XMOPropertyDef;
import jp.co.ntt.lms.xmo.Base.XMSBaseClient;
import jp.co.ntt.lms.xmo.RoleAssignments.RoleAssignmentsClient;
import jp.co.ntt.lms.xmo.util.DebugLog;


/**
 * wKiΔ\@\ǗNXłB
 * 
 * @author Katsuhiko Sakurai (UNITEC)
 * @version 1.0
 */
public class LearningProgressManager {

	private final String ACTION_MAPPING_URI = "../../../LearningProgress.do?";
	private final String URI_PARAMS = "listType={0}&parentID={1}&targetID={2}&loginID={3}";
	private final String MENU_DISPLAY_NAME = "i\";

	private final String CANNOT_DISPLAY_LIST = "-1";
	private final String LIST_TYPE_PEOPLE = "0";
	private final String LIST_TYPE_LO = "1";
	
	private final String GROUP_ROOT_ID = "GR000000";
	private final String LO_ROOT_ID = "LO0";
	private final String LEARNER_LO_ROOT_ID = "lotreeroot";
	private final String GROUP_TREE_ROOT_ID ="grouptreeroot";
	
	// ݂̏
	private final int CURRENT_STATE_LO_ROOT = 0;
	private final int CURRENT_STATE_LO_CONTAINER = 1;
	private final int CURRENT_STATE_LO_LO = 2;
	private final int CURRENT_STATE_PEOPLE_ROOT = 3;
	private final int CURRENT_STATE_PEOPLE_GROUP = 4;
	private final int CURRENT_STATE_PEOPLE_PEOPLE = 5;
	
	/**
	 * j[擾܂B
	 * 
	 * @param treeViewType@c[r[
	 * @param treePath ݂̃c[pX
	 * @param selectedPeopleOrGroupID IĂO[vID̓[UID 
	 * @param selectedLOID@IĂLoID
	 * @param parentID eID
	 * @param selectedAuthorityMenu IĂ鏉j[
	 * @param loginUserID OC[UID@
	 * @return MenuData j[
	 * @throws Exception
	 */
	public MenuData getMenu( String treeViewType, 
								String treePath, 
								String selectedPeopleOrGroupID,
								String selectedLOID,
								String parentID,
								String selectedAuthorityMenu,
								String loginUserID) throws Exception {
	
		DebugLog.write( this.getClass(), 
				MessageFormat.format(
					"ij[\pp[^FtreeViewType={0},treePath={1},selectedPeopleOrGroupID={2}," +
					"selectedLOID={3},parentID={4},selectedAuthorityMenu={5},loginUserID={6}",
					new String[]{treeViewType,selectedPeopleOrGroupID,selectedLOID,parentID,selectedAuthorityMenu,loginUserID}), 
					DebugLog.ROW );
		
		// Xgʂ擾
		URLParamaters params = this.getURLParamaters( treeViewType, 
														treePath, 
														selectedPeopleOrGroupID, 
														selectedLOID, 
														parentID,
														selectedAuthorityMenu,
														loginUserID);
		
		// Xg\łȂԂ̏ꍇAj[\Ȃ
		if ( params.getListType() == CANNOT_DISPLAY_LIST ) return null;
		
		String url = ACTION_MAPPING_URI;

		url += MessageFormat.format( URI_PARAMS, params.getParamsArray() ); 
		
		DebugLog.write( this.getClass(), "url : " + url, DebugLog.ROW );

		return new MenuData( url, this.MENU_DISPLAY_NAME );
	}
	
	/**
	 * LOvpeBʂŎgp郁j[擾܂B
	 * 
	 * @param baseVo j[\pp[^
	 * @return MenuData j[
	 * @throws Exception
	 */
	public MenuData getMenu( BaseVo baseVo) throws Exception {
		
		MenuData menu = this.getMenu(baseVo.getTreeViewType(),
								baseVo.getTreepath(),
								baseVo.getGroupUserId(),
								baseVo.getSelectId(),
								baseVo.getParentID(),
								baseVo.getIniMenu(),
								baseVo.getUserId());
		
		if (menu != null) menu.setTargetWindow("_blank");
		
		return menu;
	}
	
	
	/**
	 * LO̐iXg擾܂B
	 * 
	 * @param parentID ΏۂƂȂLO̐eLoID
	 * @param targetUserID ΏۂƂȂ郆[UID̓O[vID
	 * @param loginID OC[UID
	 * @return List i񃊃Xg
	 * @throws Exception
	 */
	public List getLOProgressList( String parentID, String targetUserID, String loginID ) throws Exception{
		
		AbstractXMOProgressTreeFactory factory = new LOProgressTreeFactory( parentID, targetUserID, loginID );
		return factory.create().getProgressList();
	}

	/**
	 * [U̐iXg擾܂B
	 * 
	 * @param parentID ΏۂƂȂe[UID͐eO[vID
	 * @param targetLOID ΏۂƂȂLoID
	 * @param loginID OC[UID
	 * @return List i񃊃Xg
	 * @throws Exception
	 */
	public List getUserProgressList( String parentID, String targetLOID, String loginID ) throws Exception {
		
		AbstractXMOProgressTreeFactory factory = new PeopleProgressTreeFactory( parentID, targetLOID, loginID );
		return factory.create().getProgressList();
	}
	
	
	/**
	 * i\p̃f[^擾܂B
	 * 
	 * @param listType Xgʁ@0:[Uꗗ, 1:Loꗗ
	 * @param parentID@ΏۂƂȂꗗ\̐eLOID͐e[UIDiO[vIDj
	 * @param targetID@ΏۂƂȂLo̓[UID
	 * @return LearningProgressViewData i\pf[^IuWFNg
	 * @throws Exception
	 */
	public LearningProgressViewData getLearningProgressViewData(String listType, 
																	String parentID,
																	String targetID,
																	String loginID) throws Exception {
		
		String targetName = null;
		List progressList = null;
		
		// Xgʂ[UꗗȂ烆[U̐iXg擾
		if ( listType.equals(LIST_TYPE_PEOPLE) ) {
			
			targetName = XMOInformationGetter.getLO( targetID ).getLoTytle();
			progressList = this.getUserProgressList(parentID,targetID, loginID);
			
		// XgʂLOꗗȂLO̐iXg擾
		} else {

			if ( targetID.startsWith("PE") ) {
				targetName = XMOInformationGetter.getPeople(targetID).getUserName();
			} else {
				targetName = XMOInformationGetter.getGroup(targetID).getGroupName();
			}
			
			progressList = this.getLOProgressList(parentID, targetID, loginID);
		}
		
		// \pif[^IuWFNg𐶐ԋp
		return new LearningProgressViewData(listType, targetName, progressList );  
	}
	
	
	/**
	 * i\j[pGETp[^擾܂B
	 * 
	 * @param treeViewType@c[r[
	 * @param treePath ݂̃c[pX
	 * @param selectedPeopleOrGroupID IĂO[vID̓[UID 
	 * @param selectedLOID@IĂLoID
	 * @param parentID eID
	 * @param selectedAuthorityMenu IĂ鏉j[
	 * @param loginUserID OC[UID@
	 * @return URLParamaters URLp[^
	 * @throws Exception
	 */
	protected URLParamaters getURLParamaters( String treeViewType, 
												String treePath, 
												String selectedGroupOrPeopleID, 
												String selectedLOID, 
												String parentID,
												String selectedAuthorityMenu,
												String loginUserID) throws Exception {
		
		// i݃j[ōi荞܂ĂꍇAi\j[\Ȃ
		//if (selectedAuthorityMenu.length() != 0) return new URLParamaters(CANNOT_DISPLAY_LIST,"","");
		
		// ݂̏Ԃ擾
		int currentState = this.getCurrentState( treeViewType, treePath );
		if (currentState <  0 ) return new URLParamaters(CANNOT_DISPLAY_LIST,"","","");
		
		DebugLog.write( this.getClass(), "{ʏ : " + String.valueOf(currentState), DebugLog.ROW );
		
		List xmoClassNameList = new ArrayList(
				Arrays.asList(new String[]{ XMOPropertyDef.LEARN_XMO, XMOPropertyDef.LOG_XMO }));
		
		switch (currentState) {
        // @[U[gI 
		case CURRENT_STATE_PEOPLE_ROOT:
        // @O[vI 
		case CURRENT_STATE_PEOPLE_GROUP:
        // @[UI 
		case CURRENT_STATE_PEOPLE_PEOPLE:
		
			// [UIĂꍇɑIꂽ[U̐i\
			if ( selectedGroupOrPeopleID.startsWith("PE") ) {

				// OC[UɃOQƌȂꍇ̓j[Ȃ
				if ( this.hasAuthority(loginUserID, treeViewType, XMOPropertyDef.LOG_XMO) == false ) {
					DebugLog.write( this.getClass(), "OQƌȂ : ", DebugLog.ROW );
					break;
				}

				// [U\ĂԂŃNbNꍇ̓j[Ȃ
				if ( currentState == CURRENT_STATE_PEOPLE_PEOPLE) {
					break;
				}

				return new URLParamaters(LIST_TYPE_LO, LO_ROOT_ID, selectedGroupOrPeopleID, loginUserID);
			} 
			
			// LOIĂꍇɑIꂽLO̐i\
			if ( selectedLOID != null && selectedLOID.length() != 0 ) {
				String parentGroupOrPeopleID = this.getParentIDFromTreePath(treePath);
				
				// OC[UɃOQƌȂꍇ̓j[Ȃ
				if ( this.hasAuthority(loginUserID, selectedLOID, treeViewType, XMOPropertyDef.LOG_XMO) == false ) {
					DebugLog.write( this.getClass(), "OQƌȂ : ", DebugLog.ROW );
					break;
				}

				return new URLParamaters(LIST_TYPE_PEOPLE, 
						parentGroupOrPeopleID.length() == 0 ? GROUP_ROOT_ID : parentGroupOrPeopleID, 
					    selectedLOID, loginUserID );
			}
			
			break;
		
        // @LO[gI 
		case CURRENT_STATE_LO_ROOT:
			
			// [UIĂꍇ̓j[\Ȃ
			if (selectedGroupOrPeopleID != null 
					&& ( selectedGroupOrPeopleID.startsWith("PE") 
							|| selectedGroupOrPeopleID.startsWith("GR") ) ) {
				break;
			}

			// ꗗLO^ȕꍇ[U̐i\
			// OC[UɊwKꍇɐi\
			if (this.hasAuthority(loginUserID, treeViewType, XMOPropertyDef.LEARN_XMO)) {
				return new URLParamaters(LIST_TYPE_LO,
											selectedLOID.length() == 0 ? LO_ROOT_ID : selectedLOID,
													loginUserID, loginUserID);
			}
			break;
		
        // @ReiI 
		case CURRENT_STATE_LO_CONTAINER:
        // @LOI 
		case CURRENT_STATE_LO_LO:

			// [UIĂꍇ͑IԂLOz̎w肳ꂽ[U̐i\
			if (selectedGroupOrPeopleID != null 
					&& ( selectedGroupOrPeopleID.startsWith("PE") 
							|| selectedGroupOrPeopleID.startsWith("GR") ) ) {
				
				// OC[UɃOQƌȂꍇ̓j[Ȃ
				if ( this.hasAuthority(loginUserID, treeViewType, XMOPropertyDef.LOG_XMO) == false ) {
					break;
				}

				return new URLParamaters(LIST_TYPE_PEOPLE,
											selectedGroupOrPeopleID,
											selectedLOID.length() == 0 ? LO_ROOT_ID : selectedLOID,
													loginUserID
										);
			}

			// ꗗLO^ȕꍇ[U̐i\
			// OC[UɊwKꍇɐi\
			if (this.hasAuthority(loginUserID, selectedLOID, treeViewType, XMOPropertyDef.LEARN_XMO)) {
				return new URLParamaters(LIST_TYPE_LO,
											selectedLOID.length() == 0 ? LO_ROOT_ID : selectedLOID,
													loginUserID,
													loginUserID);
			}
			
			break;
		}
		
		return new URLParamaters(CANNOT_DISPLAY_LIST,"","","");
	}
	
	/**
	 * ݂̊{ʂ̕\Ԃ擾܂B
	 * 
	 * @param treeViewType c[
	 * @param treePath c[pX
	 * @return int ݂̊{ʏ
	 * @throws Exception
	 */
	protected int getCurrentState( String treeViewType, String treePath ) throws Exception {

		String currentState = this.getParentIDFromTreePath(treePath);

		// ݂̏ԂrootȊȌꍇ
		// TreePath猻݂̏Ԃ擾
		if ( currentState.length() != 0 ) {
			
			// [URoot
			if ( currentState.equals(GROUP_ROOT_ID) || currentState.equals(GROUP_TREE_ROOT_ID) ) {
				return CURRENT_STATE_PEOPLE_ROOT;
			}
			
			// LO[g
			if ( currentState.equals(LO_ROOT_ID) || currentState.equals(LEARNER_LO_ROOT_ID)) {
				return CURRENT_STATE_LO_ROOT;
			}
			
			// ݂̏Ԃ[Ȕꍇ
			if (currentState.startsWith("PE") ) {
				return CURRENT_STATE_PEOPLE_PEOPLE;
			
			// ݂̏ԂO[v̏ꍇ
			} else if (currentState.startsWith("GR") ) {
				return CURRENT_STATE_PEOPLE_GROUP;

			// ݂̏ԂLȌꍇ
			} else {

				// LO^Cv擾
				String loType = XMOInformationGetter.getLO( currentState ).getLoType();
				
				// LO^Cv0ȂRei
				if (loType.equals("0")) {
					return CURRENT_STATE_LO_CONTAINER;
				} else {
					return CURRENT_STATE_LO_LO;
				}
			}
			
		} else {
			// ݏԂ擾łȂ΃G[
			return -1;
		}
	}

	/**
	 * c[pXeID擾܂B
	 * 
	 * @param treePath c[pX
	 * @return String eID
	 */
	private String getParentIDFromTreePath(String treePath) {
		
		String[] treeArray = treePath.split("/");

		if ( treeArray.length == 0 ) {
			return "";
		} else {
			return treeArray[ treeArray.length -1 ];
		}
	}
	
	/**
	 * w肳ꂽ[UɎw肳ꂽ邩ǂ擾܂B
	 * 
	 * @param userID [UID
	 * @param treeViewType c[
	 * @param xmoClassName 
	 * @return boolean w肳ꂽ邩ǂ True:
	 * @throws Exception
	 */
	private boolean hasAuthority( String userID, 
			String treeViewType, 
			String xmoClassName ) throws Exception {
		
		return this.hasAuthority(userID, null, treeViewType, 
				new ArrayList(Arrays.asList(new String[]{xmoClassName})) );
	}
	
	/**
	 * w肳ꂽ[UɎw肳ꂽLOɑ΂Ďw肳ꂽ邩ǂ擾܂B
	 * 
	 * @param userID [UID
	 * @param targetLoID@LoID
	 * @param treeViewType c[
	 * @param xmoClassName 
	 * @return boolean w肳ꂽ邩ǂ True:
	 * @throws Exception
	 */
	private boolean hasAuthority( String userID, 
			String targetLoID, 
			String treeViewType,
			String xmoClassName) throws Exception {
		
		return this.hasAuthority(userID, targetLoID, treeViewType,
				new ArrayList(Arrays.asList(new String[]{xmoClassName})) );
	}

	/**
	 * w肳ꂽ[UɎw肳ꂽLOɑ΂Ďw肳ꂽ邩ǂ擾܂B
	 * 
	 * @param userID [UID
	 * @param targetLoID@LoID
	 * @param treeViewType c[
	 * @param List Xg
	 * @return boolean w肳ꂽ邩ǂ True:
	 * @throws Exception
	 */
	private boolean hasAuthority( String userID, 
									String targetLoID, 
									String treeViewType,
									List xmoClassNameList ) throws Exception {
		
		//[g[UȂ疳OK
		if (userID.equals("PE000000")) return true;
		
		try{
			//[UɊ蓖ĂĂXmoIDXg̎擾
			ArrayList roleList = this.getAssignXmoList(userID, targetLoID);

			XMSBaseClient xmsBaseClient = new XMSBaseClient();
	
			//̐ݒ
			//xmsBaseClient.setWhereTreeViewType(treeViewType);
	
			//słXMOXg擾
			if (xmsBaseClient.select() == false) {
				throw new Exception("select Method of XMSBaseClient Class returned false.");
			}
	
			while (xmsBaseClient.next()) {
				String xmoId = xmsBaseClient.getXmoID();		//xmoId
				String className = xmsBaseClient.getClassName();//sNX
	
				// [UsłXMOListɉʂŕ\łXMO܂܂ĂȂꍇȂ
				if(roleList.contains(xmoId) == false) continue;
	
				//w茠TrueԂ
				if (className != null 
						&& className.length() != 0 
						&& xmoClassNameList.contains(className)) {
					return true;
				}
	
			}
			return false;

		} catch(Exception e) {
			DebugLog.write( this.getClass(), "擾G[F"+ e.getMessage(), DebugLog.MID );
			throw e;
		}
	}
	
	/**
	 * [UIDAIIDɃ[UɊ蓖ĂĂXmoIDXg擾܂B
	 * 
	 * @param userId [UID
	 * @param selectId IꂽID
	 * @return ArrayList [UɊ蓖ĂĂXmoID̃Xg
	 */
	private ArrayList getAssignXmoList(String userId, String selectId)throws Exception {

		// 烆[UɊ蓖ĂĂ錠擾
		RoleAssignmentsClient roleAss = new RoleAssignmentsClient();

		// searchXmoList\bh̑Q͑IΏۂLȌꍇnull̓p[^Ƃ
		if ((roleAss.searchXmoList(
				userId,
				((selectId != null && selectId.indexOf("LO") == -1)) ? selectId : null))
			== false) {
			//s
			throw new Exception("searchXmoList Method of RoleAssignmentsClient Class returned false.");
		}

		//getXmoList̖߂肪String[]Ȃ̂ArryListɕϊĕԋp
		return new ArrayList(Arrays.asList(roleAss.getXmoList()));
	}

	/**
	 * i\j[pURLp[^NXłB
	 * 
	 * @author Katsuhiko Sakurai (UNITEC)
	 * @version 1.0
	 */
	public class URLParamaters {

		private String listType = null;
		private String parentID = null;
		private String targetID = null;
		private String loginID = null;
		
		/**
		 * RXgN^łB
		 * 
		 * @param listType \郊Xg̎ 0:[Uꗗ, 1:Loꗗ
		 * @param parentID ꗗ\eIDiLo̓[UEO[vj
		 * @param targetID i\ΏۂƂȂLoID̓[UEO[vID
		 * @param loginID OC[UID
		 */
		public URLParamaters( String listType, String parentID, String targetID, String loginID ) {
			this.listType = listType;
			this.parentID = parentID;
			this.targetID = targetID;
			this.loginID = loginID;
		}
		
		/**
		 * Xgʂ擾܂B
		 * 
		 * @return String Xg
		 */
		public String getListType() {
			return this.listType;
		}
		
		/**
		 * eID擾܂B
		 * 
		 * @return String eID
		 */
		public String getParentID() {
			return this.parentID;
		}
		
		/**
		 * ΏID擾܂B
		 * 
		 * @return String ΏۂƂȂID
		 */
		public String getTargetID() {
			return this.targetID;
		}
		
		/**
		 * OC[UID擾܂B
		 * 
		 * @return String OC[UID
		 */
		public String getLoginID() {
			return this.loginID;
		}
		
		
		/**
		 * p[^zƂĎ擾܂B
		 * 
		 * @return String[] p[^̔z
		 */
		public String[] getParamsArray() {
			return new String[]{ String.valueOf(this.listType), this.parentID, this.targetID, this.loginID };
		}
	}
}
