/*
 * 쐬: 2005/10/08
 *
 * ύX
 *     2006.01.20  getAssigneeToGroupID ̃oOC
 *                 getManagementMembershipID  񐄏ɐݒB(폜\)
 *
 *     2006.02.09  isManagementAssign ǉB
 * 
 */
package jp.co.ntt.lms.otm;

import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import jp.co.ntt.lms.otm.util.OTMUtil;
import jp.co.ntt.lms.xmf.xmo.Base.Common;
import jp.co.ntt.lms.xmo.XMOPropertyDef;
import jp.co.ntt.lms.xmo.Assignments.AssignmentsClient;
import jp.co.ntt.lms.xmo.Base.XMSBaseClient;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xmo.RoleAssignments.RoleAssignmentsClient;
import jp.co.ntt.lms.xmo.Roles.RolesClient;

/**
 * 
 * OTM [U[Ɋ֘A擾NX
 * 
 * @author yasu
 *
 */
public class OTMUser {
	
	private String		userID;
		
	/**
	 * w肵RXgN^
	 * @param userId	[U[ID
	 */
	public OTMUser(String userId)
	{
		this.userID = userId;
	}

	/**
	 * w肳ꂽ[ID̃Xg擾B
	 * 
	 * @param xmoClassName XMO ̃NX
	 * @return
	 * @throws Exception
	 */
	private static String[] getRoleIDList(String xmoClassName) throws Exception {

		// w肳ꂽ XMOID 擾
		XMSBaseClient objXMSBase = new XMSBaseClient();
		objXMSBase.setWhereClassName(xmoClassName);
		if( !objXMSBase.select() )
		{
			// ܂Ȃꍇ
			if( objXMSBase.isErr() )
			{
				throw new Exception(objXMSBase.getMessage());
			}
		}
		objXMSBase.next();
		String instructor_xmoid = objXMSBase.getXmoID();

		// Roles, RolesFunction e[uAw肳ꂽ[̃[IDXg̎擾
		RolesClient rolesClient = new RolesClient();
		Vector vecFunction = new Vector();
		vecFunction.add(instructor_xmoid);
		rolesClient.searchRoleIdFromFunc(vecFunction);
		if (rolesClient.isErr())
		{
			throw new Exception(rolesClient.getMessage());
		}
		//counselorRoleIDList = rolesClient.getRoleIdList();
		return rolesClient.getRoleIdList();
	}
	
	
	/**
	 * ̃[U[̏ʃO[v̂Aw肳ꂽLOATCꂽ
	 * ŏʂ̃O[v̊OID擾B
	 * O[v̌ɂ͓I getAssigneeTopGroupID gpB
	 * 
	 * Ȃꍇ́Anull ԋpB
	 * 
	 * @param loID
	 * @return
	 */
	public String getAssigneeTopGroupForeignID(String loID) throws Exception
	{
		String foreignID = null;

		String groupID = getAssigneeTopGroupID(loID);

		foreignID = OTMUtil.getGroupForeignID(groupID);
		
		return foreignID;
	}
	
	/**
	 * ̃[U[̏ʃO[v̂Aw肳ꂽLOATCꂽ
	 * ŏʂ̃O[ṽO[vID擾B
	 * 
	 * Ȃꍇ́Anull ԋpB
	 * 
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public String getAssigneeTopGroupID(String loID) throws Exception
	{
		
		//LÕ}eAID ̎擾
		Vector materialIDVector = OTMUtil.getMaterial(loID);
		if (materialIDVector.size() == 0)
		{
			throw new Exception("LOID " + loID + " ̃}eAID擾ł܂B");
		}
		String materialID = (String)materialIDVector.get(0);
		
		//̃[U[̃o[VbvID 擾
		String membershipID = getMembershipID(loID);
		GroupAndPeopleClient client = new GroupAndPeopleClient();
		client.setWhereMemberShipID(membershipID);
		client.select();
		client.next();

		String childID = client.getChildID();
		//̐eO[vID 擾
		String groupID = client.getParentID();
		String parentID = groupID;
		
		String result = null;
		AssignmentsClient assignClient = new AssignmentsClient();
		while (!parentID.equals(Common.GROUP_ROOT))
		{
			childID = groupID;
			groupID = parentID;
			parentID = OTMUtil.getParentGroupID(groupID);
			
			//̃O[vɑ΂Ďw肵LOwKATCĂ邩
			assignClient.clear();
			assignClient.setWhereLearnAuthority();
			assignClient.setWhereMaterialID(materialID);
			assignClient.setWhereMemberShipID(parentID + groupID);
			assignClient.select();
			if (!assignClient.next())
			{
				//wKATCĂȂ
				//̎_ł childID ̒l擾ׂO[vID
				result = childID;
				break;
			}
			else
			{
				//wKATCĂ
				result = groupID;
			}
		}
		
		return result;
	}
		
	/**
	 * w肳ꂽLOwKATCĂO[v̂Ã[U[
	 * w肳ꂽO[vIDȂ郊XgԋpB
	 * 
	 * @param loID
	 * @param xmoClassName XMO ̃NX
	 * @return
	 * @throws Exception
	 */
	public Vector getLearnGroupIDList(String loID, String xmoClassName) throws Exception
	{
		//
		Vector result = new Vector();
		
		// w茠[IDXg̃Zbg
		String[] roleIDList = getRoleIDList(xmoClassName);
		
		// [ID  [U[IDÃ[U[w肳ꂽ
		// [蓖ĂĂO[ṽo[VbvID擾
		Hashtable membershipIdHash = new Hashtable(); //o[VbvID 擾p
		RoleAssignmentsClient raClient = new RoleAssignmentsClient();
		for(int i = 0; i < roleIDList.length ; i++)
		{

			// [IDXg̎o
		    String roleId = roleIDList[i];

		    raClient.clear();
			raClient.setWhereUserID(userID);
		    // NGɂ̃[IDZbg
		    raClient.setWhereRoleID(roleId);
		    if(raClient.select() == false){
				throw new Exception(raClient.getMessage());
		    }
		    
		    // O[vID  O[ṽo[VbvID̎擾
		    String groupID = null;
		    while (raClient.next())
		    {
		    	groupID = raClient.getGroupID();
				GroupAndPeopleClient gapc = new GroupAndPeopleClient();
				gapc.setWhereChildID(groupID);
				gapc.select();
				while( gapc.next() ) {
					// O[ṽo[Vbvo^Ȃo^
					if(gapc.isGroup()){
						String strAssignMembershipID = gapc.getMemberShipID();
						if(!membershipIdHash.containsKey(strAssignMembershipID)){
							membershipIdHash.put(strAssignMembershipID, groupID);
						}
					}
				}
		    }
		}

		// w肵\bh̃}eAID 擾
		Vector vcMaterialID = OTMUtil.getMaterial(loID);
		for (int i = 0; i < vcMaterialID.size(); i++)
		{
			// w肵\bhwKATCĂO[v
			// o[Vbv擾
			String materialID = (String)vcMaterialID.get(i);
			AssignmentsClient assignClient = new AssignmentsClient();
			assignClient.setWhereMaterialID(materialID);
			assignClient.setWhereLearnAuthority();
			assignClient.select();
			while (assignClient.next())
			{
				// w肵\bhwKATCĂO[v
				// o[VbvƔr
				String assignedMembershipID = assignClient.getMemberShipID();
				Iterator itr = membershipIdHash.keySet().iterator();
				while (itr.hasNext())
				{
					String membershipID = (String)itr.next();
					
					// ꍇAO[vo^Ȃo^
					if (membershipID.compareTo(assignedMembershipID) == 0)
					{
						String strGroupID = (String)membershipIdHash.get(membershipID);
						if(!result.contains(strGroupID))
						{
							result.add(strGroupID);
						}
					}
				}
			}
		}
		return result;
	}

	/**
	 * w肳ꂽLOɑ΂āÃ[U[̍utƂȂĂ
	 * [U[ID̃Xg擾B
	 * 
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public List getInstructorIDList(String loID) throws Exception
	{
		//[U[w肳ꂽLOwKۂ̎uNXiO[vjID
		String strGroupID = OTMUtil.getGroupID(getMembershipID(loID));
		
		// w肳ꂽLOǗATCꂽ[U[IDȂ郊Xg
		Vector tmpInstructorList = new Vector();
		// LÕ}eAID𒲂ׂ
		Vector tmpVcMaterialID = OTMUtil.getMaterial(loID);
		for (int i = 0; i < tmpVcMaterialID.size(); i++)
		{
			String strMaterialID = (String)tmpVcMaterialID.get(i);
			
			// }eAIDLOǗATCꂽo[VbvID𒲂ׂ
			AssignmentsClient assignClient = new AssignmentsClient();
			assignClient.setWhereMaterialID(strMaterialID);
			assignClient.setWhereManagementAuthority();
			assignClient.select();
			while ( assignClient.next() )
			{
				String strMemberShipID = assignClient.getMemberShipID();

				// o[VbvID烆[U[ID𒲂ׂ
				GroupAndPeopleClient gapc = new GroupAndPeopleClient();
				gapc.setWhereMemberShipID(strMemberShipID);
				gapc.select();
				while( gapc.next() )
				{
					Vector tmpVec = new Vector();
					String strManagerUserID = gapc.getChildID();
					tmpInstructorList.add(strManagerUserID);
				}
			}
		}

		// 𖞂[U[ID Ȃ郊Xg
		Vector instructorList = new Vector();
		// ut[ID̃Xg
		String[] instructorRoleIDs = getRoleIDList(XMOPropertyDef.INSTRUCTOR_XMO);
		// uNXiO[vjɑ΂čutĂ郆[U[I
		for (int i = 0; i < tmpInstructorList.size(); i++)
		{
			// ƂȂ郆[U[
			String instructorID = (String)tmpInstructorList.get(i);
			
			// uNXiO[vjɑ΂čut邩
		    for (int j = 0; j < instructorRoleIDs.length; j++)
		    {
			    String roleId = instructorRoleIDs[j];
				RoleAssignmentsClient raClient = new RoleAssignmentsClient();
				
				// ɎuNXiO[vjIDZbg
				raClient.setWhereGroupID(strGroupID);
				// Ƀ[IDZbg
			    raClient.setWhereRoleID(roleId);			    	
			    // Ɍ҂̃[U[IDZbg
			    raClient.setWhereUserID(instructorID);
			    if(!raClient.select())
			    {
					throw new Exception(raClient.getMessage());
			    }
			    
			    // O[vɑ΂čutŃ[蓖Ă󂯂[U[ID ̎擾
			    if (raClient.next())
			    {
			    	if(!instructorList.contains(instructorID))
			    	{
			    		instructorList.add(instructorID);
			    	}
			    }
		    }
		}
		
		return instructorList;
	}
	
//	/**
//	 * w肳ꂽނ̂̃[U[ɑ΂wK蓖Ă
//	 * ATCID 擾B
//	 * 
//	 * o[VbvID  getMembershipID ̃WbNɏ]đIꂽ
//	 * ̂gpB
//	 * }eAID getMaterial ̃WbNɏ]đIꂽ̂A
//	 * Ԗڂ̃}eAID gpB
//	 * 
//	 * @param loID
//	 * @return
//	 */
//	public String getAssignmentID(String loID) throws Exception
//	{
//		String assignmentID = null;
//		
//		List materialIDList = getMaterial(loID);
//		if (materialIDList.size() == 0)
//		{
//			throw new Exception("w肳ꂽLO " + loID + " ̐eo^Ă܂B");
//		}
//		String materialID = (String)materialIDList.get(0);
//		
//		String membershipID = getMembershipID(loID);
//		
//		AssignmentsClient client = new AssignmentsClient();
//		client.setWhereMaterialID(materialID);
//		client.setWhereMemberShipID(membershipID);
//		client.setWhereLearnAuthority();
//		if (client.select())
//		{
//			if (client.next())
//			{
//				assignmentID = client.getAssignID();
//			}
//			else
//			{
//				throw new Exception(client.getMessage());
//			}
//		}
//		else
//		{
//			throw new Exception(client.getMessage());
//		}
//		
//		return assignmentID;
//	}
	
	/**
	 * ̃[U[w肳ꂽLOwKۂ́A
	 * up̃O[vւ̏o[VbvID擾B
	 * (ǂ̃O[ṽo[ƂĎû肳B)
	 * 
	 * o[VbvID ȂꍇAnull ԋpB
	 * 
	 * AwKATCsĂꍇ́AԌÂATC
	 * ɑ΂̂擾B
	 * 
	 * @param loID
	 * @return u[U[̃o[VbvID
	 * @throws Exception
	 */
	public String getMembershipID(String loID) throws Exception
	{
		//
		// [U[邷ׂẴO[vɑ΂
		// [U[ɐUꂽo[VbvIDƃO[vID ̃nbV
		// o[VbvID L[ƂAO[vID lƂnbV
		//
		//Vector vcMembership = new Vector();
		Hashtable membershipHash = OTMUtil.getMembershipHash(userID);

		Vector vcMaterial = OTMUtil.getMaterial(loID);
		String classMembership = null;
		
		RoleAssignmentsClient raClient = new RoleAssignmentsClient();
		Date mostOldOpeningDate = null;
		//[U[ׂẴo[VbvID ɑ΂
		//for(int i = 0; i < vcMembership.size(); i++)
		Iterator membershipItr = membershipHash.keySet().iterator();
		while (membershipItr.hasNext())
		{
			//String membershipID = (String)vcMembership.get(i);
			String membershipID = (String)membershipItr.next();
			
			//w肳ꂽLOɂĂׂ̂Ẵ}eA(ʏЂƂ)
			//AwKATCĂ邩`FbNB
			for (int i = 0; i < vcMaterial.size(); i++)
			{
				String materialID = (String)vcMaterial.get(i);
				AssignmentsClient ac = new AssignmentsClient();
				ac.setWhereLearnAuthority();
				ac.setWhereMaterialID(materialID);
				ac.setWhereMemberShipID(membershipID);
				ac.select();
				while ( ac.next() )
				{
					//
					//wKATCĂ̂ŁA
					//eO[vɑ΂čut[U[݂邩
					//ǂ`FbN
					//
					boolean rolecheck = false;
					String[] roleIds = getRoleIDList(XMOPropertyDef.INSTRUCTOR_XMO);
					String parentID = (String)membershipHash.get(membershipID);
					for (int j=0; j < roleIds.length; j++)
					{
						raClient.clear();
						raClient.setWhereRoleID(roleIds[j]);
						raClient.setWhereGroupID(parentID);
						raClient.select();
						if (raClient.next())
						{
							//݂΁A`FbNOK
							rolecheck = true;
							break;
						}
					}
					if (rolecheck == false)
					{
						//݂Ȃ΁A
						//̃ATC`FbN
						continue;
					}
					if (classMembership == null)
					{
						classMembership = ac.getMemberShipID();
						mostOldOpeningDate = ac.getOpeningDate();
					}
					else
					{
						Date openingDate = ac.getOpeningDate();
						if (openingDate != null)
						{
							if (openingDate.compareTo(mostOldOpeningDate) < 0)
							{
								//̃ATCÂ
								classMembership = ac.getMemberShipID();
								mostOldOpeningDate = ac.getOpeningDate();
							}
						}
					}
			    } // ATC while loop
			} // }eA for loop
		} //o[Vbv while loop
		raClient = null;
		
		return classMembership;
	}
	
	/**
	 * ̃[U[w肳ꂽLOǗۂ́A
	 * up̃O[vւ̏o[VbvID擾B
	 * (ǂ̃O[ṽo[ƂĎû肳B)
	 * 
	 * o[VbvID ȂꍇAnull ԋpB
	 * 
	 * AǗATCsĂꍇ́AԌÂATC
	 * ɑ΂̂擾B
	 * 
	 * @deprecated
	 * 
	 * @param loID
	 * @return u[U[̃o[VbvID
	 * @throws Exception
	 */
	public String getManagementMembershipID(String loID) throws Exception
	{
		//
		// [U[邷ׂẴO[vɑ΂
		// [U[ɐUꂽo[VbvIDƃO[vID ̃nbV
		// o[VbvID L[ƂAO[vID lƂnbV
		//
		//Vector vcMembership = new Vector();
		Hashtable membershipHash = new Hashtable();

		GroupAndPeopleClient gapc = new GroupAndPeopleClient(); 
		gapc.setWhereChildID(userID);
		gapc.select();
		while( gapc.next() )
		{
			String strMembershipID = gapc.getMemberShipID();
			//vcMembership.add(strMembershipID);
			if (!membershipHash.containsKey(strMembershipID))
			{
				membershipHash.put(strMembershipID, gapc.getParentID());
			}
		}
		Vector vcMaterial = OTMUtil.getMaterial(loID);
		String classMembership = null;
		
		RoleAssignmentsClient raClient = new RoleAssignmentsClient();
		Date mostOldOpeningDate = null;
		//[U[ׂẴo[VbvID ɑ΂
		//for(int i = 0; i < vcMembership.size(); i++)
		Iterator membershipItr = membershipHash.keySet().iterator();
		while (membershipItr.hasNext())
		{
			//String membershipID = (String)vcMembership.get(i);
			String membershipID = (String)membershipItr.next();
			
			//w肳ꂽLOɂĂׂ̂Ẵ}eA(ʏЂƂ)
			//AǗATCĂ邩`FbNB
			for (int i = 0; i < vcMaterial.size(); i++)
			{
				String materialID = (String)vcMaterial.get(i);
				AssignmentsClient ac = new AssignmentsClient();
				ac.setWhereManagementAuthority();
				ac.setWhereMaterialID(materialID);
				ac.setWhereMemberShipID(membershipID);
				ac.select();
				while ( ac.next() )
				{
					//
					//ǗATCĂ̂ŁA
					//eO[vɑ΂čut[U[݂邩
					//ǂ`FbN
					//
					boolean rolecheck = false;
					String[] roleIds = getRoleIDList(XMOPropertyDef.INSTRUCTOR_XMO);
					String parentID = (String)membershipHash.get(membershipID);
					for (int j=0; j < roleIds.length; j++)
					{
						raClient.clear();
						raClient.setRoleID(roleIds[j]);
						raClient.setGroupID(parentID);
						raClient.select();
						if (raClient.next())
						{
							//݂΁A`FbNOK
							rolecheck = true;
							break;
						}
					}
					if (rolecheck == false)
					{
						//݂Ȃ΁A
						//̃ATC`FbN
						continue;
					}
					if (classMembership == null)
					{
						classMembership = ac.getMemberShipID();
						mostOldOpeningDate = ac.getOpeningDate();
					}
					else
					{
						Date openingDate = ac.getOpeningDate();
						if (openingDate != null)
						{
							if (openingDate.compareTo(mostOldOpeningDate) < 0)
							{
								//̃ATCÂ
								classMembership = ac.getMemberShipID();
								mostOldOpeningDate = ac.getOpeningDate();
							}
						}
					}
			    } // ATC while loop
			} // }eA for loop
		} //o[Vbv while loop
		raClient = null;
		
		return classMembership;
	}
	
	/**
	 * ̃[U[Aw肳ꂽLO̍utł邩ǂ
	 * u[lԋpB
	 * 
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public boolean isInstructor(String loID) throws Exception
	{
		
		//
		// Step1.
		// ŏɁÃ[U[utO[vXg擾B
		//
		
		// ut[IDXg̎擾
		String[] instructorRoleIDList = getRoleIDList(XMOPropertyDef.INSTRUCTOR_XMO);
		
		// [ID  [U[ID gpāA
		// ̃[U[[蓖ĂĂO[v擾
		Vector groupIdList = new Vector(); //O[vID 擾p
		for (int i = 0; i < instructorRoleIDList.length ; i++)
		{
			RoleAssignmentsClient raClient = new RoleAssignmentsClient();
			raClient.setWhereUserID(userID);
			// ut[ID
		    String roleId = instructorRoleIDList[i];
		    // NGɂ̃[IDZbg
		    raClient.setWhereRoleID(roleId);
		    if(!raClient.select())
		    {
				throw new Exception(raClient.getMessage());
		    }
		    
		    // [蓖ĂꂽO[vID ̎擾
		    while (raClient.next())
		    {
		        String groupId = raClient.getGroupID();
		        groupIdList.add(groupId);
		    }
		}
		//
		// [蓖ĂꂽO[vȂꍇ
		// ̃[U[ɂ́Aǂ̃O[vɑ΂Ă
		// utĂȂB
		//
		if(groupIdList.size() == 0)
	    {
			return false;
	    }

		//
		// Step 2.
		// ̃[U[utO[v̂ŁA
		// ̃O[v ɑ΂āAw肳ꂽLO wKATCĂ邩
		// 𔻒fB
		//

		GroupAndPeopleClient gapc = new GroupAndPeopleClient();
		for (int i = 0; i < groupIdList.size();i++)
		{
			gapc.clear();
			gapc.setWhereChildID((String)groupIdList.get(i));
			gapc.select();
			if (gapc.next())
			{
				String membershipID = gapc.getMemberShipID();
				Vector materialIDVector = OTMUtil.getMaterial(loID);
				for (int j=0; j < materialIDVector.size(); j++)
				{
					String materialID = (String)materialIDVector.get(j);
					AssignmentsClient assignClient = new AssignmentsClient();
					//wKATC
					assignClient.setWhereLearnAuthority();
					//}eAID
					assignClient.setWhereMaterialID(materialID);
					//o[VbvID
					assignClient.setWhereMemberShipID(membershipID);
					assignClient.select();
					if (assignClient.next())
					{
						return true;
					}
				}
			}
		}
		
		return false;
	}
	
	/**
	 * w肳ꂽLOǗATCĂ邩ǂ
	 * u[lԋpB
	 * LÕ}eAIDƂ̃[U[̃o[Vbv̑gɑ΂
	 * ׂČAǗATCĂ̂ΐ^B
	 * 
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public boolean isManagementAssign(String loID) throws Exception
	{
	    boolean result = false;
		//
		// [U[邷ׂẴO[vɑ΂
		// [U[ɐUꂽo[VbvIDƃO[vID ̃nbV
		// o[VbvID L[ƂAO[vID lƂnbV
		//
		Hashtable membershipHash = new Hashtable();

		GroupAndPeopleClient gapc = new GroupAndPeopleClient(); 
		gapc.setWhereChildID(userID);
		gapc.select();
		while( gapc.next() )
		{
			String strMembershipID = gapc.getMemberShipID();
			if (!membershipHash.containsKey(strMembershipID))
			{
				membershipHash.put(strMembershipID, gapc.getParentID());
			}
		}
		Vector vcMaterial = OTMUtil.getMaterial(loID);
		String classMembership = null;
		
		RoleAssignmentsClient raClient = new RoleAssignmentsClient();
		Date mostOldOpeningDate = null;
		//[U[ׂẴo[VbvID ɑ΂
		Iterator membershipItr = membershipHash.keySet().iterator();
		while (membershipItr.hasNext())
		{
			String membershipID = (String)membershipItr.next();
			
			//w肳ꂽLOɂĂׂ̂Ẵ}eA(ʏЂƂ)
			//AǗATCĂ邩`FbNB
			for (int i = 0; i < vcMaterial.size(); i++)
			{
				String materialID = (String)vcMaterial.get(i);
				AssignmentsClient ac = new AssignmentsClient();
				ac.setWhereManagementAuthority();
				ac.setWhereMaterialID(materialID);
				ac.setWhereMemberShipID(membershipID);
				ac.select();
				while ( ac.next() )
				{
					//
					//ǗATCĂ
					//
				    result = true;
				    break;
				}
				if (result == true)
				{
				    break;
				}
			}
			if (result == true)
			{
			    break;
			}
		}
		
		return result;
	}

//	/**
//	 * ̃[U[̏ʃO[v̂Aw肳ꂽLOǗATCꂽ
//	 * ŏʂ̃O[v̊OID擾B
//	 * O[v̌ɂ͓I getAssigneeTopGroupID gpB
//	 * 
//	 * Ȃꍇ́Anull ԋpB
//	 * 
//	 * @param loID
//	 * @return
//	 */
//	public String getAssigneeTopGroupManagementForeignID(String loID) throws Exception
//	{
//		String foreignID = null;
//
//		String groupID = getAssigneeTopGroupManagementID(loID);
//
//		GroupsClient gClient = new GroupsClient();
//		gClient.setWhereGroupID(groupID);
//		if (gClient.select())
//		{
//			if (gClient.next())
//			{
//				foreignID = gClient.getForeignID();
//			}
//		}
//		gClient = null;
//		
//		return foreignID;
//	}
//	
//	/**
//	 * ̃[U[̏ʃO[v̂Aw肳ꂽLOǗATCꂽ
//	 * ŏʂ̃O[ṽO[vID擾B
//	 * 
//	 * Ȃꍇ́Anull ԋpB
//	 * 
//	 * @param loID
//	 * @return
//	 * @throws Exception
//	 */
//	public String getAssigneeTopGroupManagementID(String loID) throws Exception
//	{
//		
//		//LÕ}eAID ̎擾
//		Vector materialIDVector = OTMUtil.getMaterial(loID);
//		if (materialIDVector.size() == 0)
//		{
//			throw new Exception("LOID " + loID + " ̃}eAID擾ł܂B");
//		}
//		String materialID = (String)materialIDVector.get(0);
//		
//		//̃[U[̃o[VbvID 擾
//		String membershipID = getManagementMembershipID(loID);
//		GroupAndPeopleClient client = new GroupAndPeopleClient();
//		client.setWhereMemberShipID(membershipID);
//		client.select();
//		client.next();
//
//		String childID = client.getChildID();
//		//̐eO[vID 擾
//		String groupID = client.getParentID();
//		String parentID = groupID;
//		
//		String result = null;
//		AssignmentsClient assignClient = new AssignmentsClient();
//		while (!parentID.equals(Common.GROUP_ROOT))
//		{
//			childID = groupID;
//			groupID = parentID;
//			parentID = OTMUtil.getParentGroupID(groupID);
//			
//			//̃O[vɑ΂Ďw肵LOwKATCĂ邩
//			assignClient.clear();
//			assignClient.setWhereLearnAuthority();
//			assignClient.setMaterialID(materialID);
//			assignClient.setWhereMemberShipID(parentID + groupID);
//			assignClient.select();
//			if (!assignClient.next())
//			{
//				//wKATCĂȂ
//				//̎_ł childID ̒l擾ׂO[vID
//				result = childID;
//				break;
//			}
//			else
//			{
//				result = groupID;
//			}
//		}
//		
//		return result;
//	}

}
