/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	XMO ʃNCAgi
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.xmo;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.registry.Registry;
import java.rmi.registry.LocateRegistry;
import java.util.*;
import jp.co.ntt.lms.xmo.XMO;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * ׂĂXMÕNCAgi̐eNXɂȂ܂B<BR>
 * eXMOɊ֘ANCAgi쐬ꍇ͂̃NXp
 * ĂB
 * @author T.Nijou
 * @version 0.0.0.1 2004/01/08
 */
public class XMOClient {

	/**
	 * [gIuWFNgLbV܂
	 */
	private static final Hashtable mhtbXMO = new Hashtable();

	/**
	 * T[oNCAg𔻕ʂ邽߂̃tOłB
	 * T[oœ삳ꍇ͂̃tOtrueɂĂB
	 */
	private static boolean mblServer = false;

	/**
	 * NXێ܂
	 */
	private String mstrClassName = "";

	/**
	 * [gIuWFNgێ܂
	 */
	private XMO mobjXMO;

	/**
	 * RMIʐMgC
	 */
	private static final int RMI_RETRY_COUNT = 10;

	/**
	 * RMIʐMgCҋ@
	 */
	private static final int RMI_RETRY_WAIT = 1000;

	/**
	 * RXgN^łB<BR>
	 * 擾RMIIuWFNg̓o^w肵ĂB
	 * @param strClassName 擾RMIIuWFNg̓o^
	 */
	public XMOClient( String strClassName ) throws Exception {
		// vCx[gϐɃNXݒ
		mstrClassName = strClassName;
		synchronized( this.getClass() ) {
			// LbVw肳ꂽNX̃[gIuWFNgo܂
			XMO objXMO = (XMO)mhtbXMO.get( strClassName );
			// LbVɑ݂Ȃꍇ͍쐬
			if( objXMO == null ) {
				objXMO = getXMO( strClassName );
			}
			mobjXMO = objXMO;
		}

	}

	/**
	 * XMO擾\bh
	 */
	private XMO getXMO( String strClassName )
		throws Exception
	{
		XMO objXMO = null;
		// [g̏ꍇ
		if( !mblServer ) {
			try{
				// T[ô̎擾
				Environment objEnvironment = new Environment();
				String strServerName = objEnvironment.getServerName();
				int intXmoPort = new Integer( objEnvironment.getXmoRegistryPort() ).intValue();
				Registry registry = LocateRegistry.getRegistry( strServerName, intXmoPort );

				for( int i=0; i<RMI_RETRY_COUNT; i++ ){
					try{
						objXMO = (XMO)registry.lookup( "//" + strServerName + "/" + strClassName );
						break;
					}catch( Exception ex ){
						// gC񐔏I
						if( i == RMI_RETRY_COUNT -1 ) {
							// OX[
							throw ex;
						}
						try{
							Thread.sleep(RMI_RETRY_WAIT);
						}
						catch(InterruptedException ex2){
						}
					}
				}
			}catch(Exception e){
				// Oo
				DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
				throw e;
			}
		}
		// T[ȍꍇ
		else {
			objXMO = (XMO)newInstance( strClassName );
		}
		mhtbXMO.put( strClassName, objXMO );
		return objXMO;
	}

	/**
	 * {XMO\bh̋Ns܂B<BR>
	 * XMÕj[Xg擾܂
	 * @return Vector j[Xg
	 * @exception Exception RMIڑɎsꍇ
	 */
	public Vector getMenuList(Hashtable htbParam)
		throws Exception
	{
		Vector vecList = new Vector();
		try {
			vecList = mobjXMO.getMenuList(htbParam);
		}
		catch(RemoteException ce)
		{
			try
			{
				// Ď擾
				mobjXMO = getXMO( mstrClassName );
				vecList = mobjXMO.getMenuList(htbParam);
			}
			catch( RemoteException re ) {
				// gC
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecList = mobjXMO.getMenuList(htbParam);
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}
		return vecList;
	}

	/**
	 * {XMO\bh̋Ns܂B<BR>
	 * XMÕ\bhXg擾܂
	 * @return Vector \bhXg
	 * @exception Exception RMIڑɎsꍇ
	 */
	public Vector getMethodList()
		throws Exception
	{
		Vector vecList = new Vector();
		try {
			vecList = mobjXMO.getMethodList();
		}
		catch(RemoteException ce)
		{
			try
			{
				// Ď擾
				mobjXMO = getXMO( mstrClassName );
				vecList = mobjXMO.getMethodList();
			}
			catch( RemoteException re ) {
				// gC
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						vecList = mobjXMO.getMethodList();
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}
		return vecList;
	}

	/**
	 * {XMO\bh̋Ns܂B<BR>
	 * ftHgj[URL̎擾s܂
	 * @return String ftHgj[URL
	 * @exception Exception RMIڑɎsꍇ
	 */
	public MenuData getDefaultMenu()
		throws Exception
	{
		MenuData objMenu = null;
		try {
			objMenu = mobjXMO.getDefaultMenu();
		}
		catch(RemoteException ce)
		{
			try
			{
				// Ď擾
				mobjXMO = getXMO( mstrClassName );
				objMenu = mobjXMO.getDefaultMenu();
			}
			catch( RemoteException re ) {
				// gC
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						objMenu = mobjXMO.getDefaultMenu();
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}
		return objMenu;
	}

	/**
	 * {XMO\bh̋Ns܂B<BR>
	 * XMO\bh̋Ns\bhłB
	 * @param strMethodName \bh
	 * @param objData \bh̃p[^
	 * @return Object \bh̖߂l
	 * @exception Exception RMIڑɎsꍇ
	 */
	public Object execute( String strMethodName, Hashtable objData )
		throws Exception
	{
		Object objRec = null;
		try {
			objRec = mobjXMO.execute( strMethodName, objData );
		}
		catch(RemoteException ce)
		{
			try
			{
				// Ď擾
				mobjXMO = getXMO( mstrClassName );
				objRec = mobjXMO.execute( strMethodName, objData );
			}
			catch( RemoteException re ) {
				// gC
				for(int i = 0; i < RMI_RETRY_COUNT; i++ ) {
					try {
						objRec = mobjXMO.execute( strMethodName, objData );
						break;
					}
					catch(RemoteException re2) {

						// gC񐔂Iꍇ
						if( i == RMI_RETRY_COUNT -1 ) {
							re2.printStackTrace();
						}

						try {
							Thread.sleep( RMI_RETRY_WAIT );
						}
						catch( InterruptedException ie ) {}
					}
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
			}
		}
		return objRec;
	}

	/**
	 * XMŐNmFs܂
	 */
	public boolean isLaunch()
		throws Exception
	{
		boolean blLaunch = false;
		try {
			blLaunch = mobjXMO.isLaunch();
		}
		catch( RemoteException ce ) {
			try {
				// Ď擾
				mobjXMO = getXMO( mstrClassName );
				blLaunch = mobjXMO.isLaunch();
			}
			catch( Exception e ) {
				e.printStackTrace();
				throw e;
			}
		}
		return blLaunch;
	}

	/**
	 * T[oœ삳ꍇɂ̃\bhs܂
	 */
	public static void setServerSide() {
		mblServer = true;
	}

	/**
	 * NXNX̃CX^X擾֐
	 * @param strClassName pbP[W܂ރNX
	 * @return Object CX^XꂽIuWFNg
	 * @exception Exception NXȂƂ
	 */
	private static Object newInstance( String strClassName )
		throws Exception
	{
		Class c = Class.forName( strClassName );
		Object obj = c.newInstance();
		return obj;
	}

}

