/*
 * CopyRight(C) 2003, NTT All rights reserved
 *
 *	XMS2[U̍쐬ƌt^
 *		ύX
 *			2004.01.08 VK쐬 haga
 *
 *	MS SQLServerXMS2[U̍쐬ƌt^s܂B
*/

import java.sql.*;
import java.io.*;

public class DBSet_Cont{

	// [Uێ
	private String USER_NAME;
	// pX[hێ
	private String USER_PASSWORD;
	// DBێ
	private String DB_NAME;
	// DB|[gێ
	private String DB_PORT;
	// T[oێ
	private String DB_SERVER;
	// XMS2CXg[fBNgێ
	private String XMS2_DIR;

	// [UIvV
	private static String USER_NAME_OPTION = "-U";
	// pX[hIvV
	private static String USER_PASSWORD_OPTION = "-P";
	// DBIvV
	private static String DB_NAME_OPTION = "-D";
	// DB|[gIvV
	private static String DB_PORT_OPTION = "-p";
	// T[oIvV
	private static String DB_SERVER_OPTION = "-S";
	// XMS2CXg[fBNgIvV
	private static String XMS2_DIR_OPTION = "-i";

	// hCo
	private static final String DRIVER_NAME = "com.microsoft.jdbc.sqlserver.SQLServerDriver";

	// SQL؂蕶
	private static final String SQL_TOKEN = "GO";

	// DBRlNV
	private Connection connection;

	// SQL`t@C
	private String[] DBSET_FILE = {"CreateUser_Cont.sql"};

	/**
	 * C֐
	 * R}hCȉ̈擾܂B
	 * -U [U
	 * -P pX[h
	 * -D DB
	 * -p DB|[g
	 * -S DBT[o
	 * -i XMS2CXg[fBNg
	 */
	public static void main(String[] args) {
		String userName = null;
		String password = null;
		String dbName = null;
		String dbPort = null;
		String dbServer = null;
		String xms2Dir = null;

		// `FbN
		for( int i = 0; i < args.length; i++ ) {
			if( args[i].charAt(0) == '-' ) {
				String option = args[i];
				String value = "";
				try {
					if( args[i+1].charAt(0) != '-' ) {
						value = args[i+1];
					}
				}
				catch( ArrayIndexOutOfBoundsException ae ) {
				}
				if( option.equals( USER_NAME_OPTION ) ) {
					userName = value;
				}
				else if( option.equals( USER_PASSWORD_OPTION ) ) {
					password = value;
				}
				else if( option.equals( DB_NAME_OPTION ) ) {
					dbName = value;
				}
				else if( option.equals( DB_PORT_OPTION ) ) {
					dbPort = value;
				}
				else if( option.equals( DB_SERVER_OPTION ) ) {
					dbServer = value;
				}
				else if( option.equals( XMS2_DIR_OPTION ) ) {
					xms2Dir = value;
				}
			}
		}

		// 1łnullG[
		if( userName == null || password == null || dbName == null ||
			dbPort == null || dbServer == null || xms2Dir == null)
		{
			// ُI
			System.exit(1);
		}

		// CX^X
		try {
			DBSet_Cont objDBSet_Cont = new DBSet_Cont(userName, password, dbName,
																	dbPort, dbServer, xms2Dir);
			objDBSet_Cont.setDB();
		}
		catch(ClassNotFoundException ce) {
			ce.printStackTrace();
			// JDBChCo[݂Ȃ
			System.exit(1);
		}
		catch(FileNotFoundException fe) {
			fe.printStackTrace();
			// t@C݂Ȃꍇ
			System.exit(1);
		}
		catch(IOException ie) {
			ie.printStackTrace();
			// t@CǂݍݗO
			System.exit(1);
		}
		catch(SQLException se) {
			se.printStackTrace();
			// SQLO
			System.exit(1);
		}

		// I
		System.exit(0);
	}

	/**
	 * RXgN^
	 * @param userName [U
	 * @param password pX[h
	 * @param dbName DB
	 * @param dbServer DBT[o
	 * @param xms2_dir XMS2CXg[fBNg
	 */
	private DBSet_Cont(	String userName,
						String password,
						String dbName,
						String dbPort,
						String dbServer,
						String xms2_dir )
		throws SQLException, ClassNotFoundException
	{
		USER_NAME = userName;
		USER_PASSWORD = password;
		DB_NAME = dbName;
		DB_PORT = dbPort;
		DB_SERVER = dbServer;
		XMS2_DIR = xms2_dir + "/table/";

		connection = getConnection();
		connection.setAutoCommit( false );
	}

	/**
	 * DBݒs܂B
	 * @exception SQLException SQLO
	 * @exception IOException t@CǂݍݗO
	 * @exception FileNotFoundException t@C݂Ȃꍇ
	 */
	private void setDB()
		throws SQLException, IOException, FileNotFoundException
	{
		// Statement擾
		Statement statement = connection.createStatement();

		String strFilePath = "";
		String strSQL = "";

		// SQLt@C`t@CJԂ
		try {
			for( int i = 0; i < DBSET_FILE.length; i++ ) {
				strFilePath = XMS2_DIR + DBSET_FILE[i];
				strSQL = loadFile( strFilePath );
				statement.execute( strSQL );
			}

			connection.commit();
		}
		catch( FileNotFoundException fe ) {
			// [obN
			try { connection.rollback();
			} catch( Exception e) {}
			throw fe;
		}
		catch( IOException ie ) {
			// [obN
			try { connection.rollback();
			} catch( Exception e) {}
			throw ie;
		}
		catch( SQLException se ) {
			// [obN
			try { connection.rollback();
			} catch( Exception e) {}
			throw se;
		}
		finally {
			try {	statement.close();
					connection.close();
			} catch( Exception e) {}
		}

	}

	/**
	 * t@C[h<BR>
	 * t@C"GO"͓ǂݔ΂܂
	 * @param t@CpX
	 * @return String t@Ce
	 * @exception IOException t@CǂݍݗO
	 * @exception FileNotFoundException t@C݂Ȃꍇ
	 */
	private String loadFile( String strFilePath )
		throws IOException, FileNotFoundException
	{
		BufferedReader reader = new BufferedReader(new FileReader( strFilePath ));

		StringBuffer sbFile = new StringBuffer();
		String strLine = null;
		while( (strLine = reader.readLine()) != null ) {
			if(!strLine.trim().equals( SQL_TOKEN )) {
				sbFile.append( strLine + "\n");
			}
		}
		return new String(sbFile);
	}

	private Connection getConnection()
		throws SQLException, ClassNotFoundException
	{
		// hCo̐ݒ
		Class.forName(DRIVER_NAME);

		// ڑ񐶐
		String strCon = "jdbc:microsoft:sqlserver://" + DB_SERVER + ":" + DB_PORT;

		// RlNV擾܂
		Connection con = DriverManager.getConnection(strCon,USER_NAME,USER_PASSWORD);

		return con;
	}
}