/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

package jp.co.ntt.lms.installer.lms;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerDatabaseUtil;
import jp.co.ntt.lms.installer.core.util.InstallerFileUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;

/**
 * f[^x[XEe[u쐬ANVENXB
 * @author T.Nishiki
 */
public abstract class CreateDbAbstractAction implements InstallerAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(CreateDbAbstractAction.class);
	}

	/**
	 * f[^x[XǗҗpRlNVB
	 */
	private Connection _dbaConection;

	/**
	 * LMS^ppRlNVB
	 */
	private Connection _lmsConection;

	/**
	 * ANVXLbv邩肵܂B<br>
	 * [Uf[^x[X̏邱ƊmFĂA
	 * f[^x[X̎ʂw̎ʂƈvꍇ̂݁Afalse߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return LQƁB
	 */
	public final boolean isSkipped(InstallerValues values) {
		// [U珉̊mFĂ邱
		ConfirmDbInitializeValue dbInitializeValue
			= (ConfirmDbInitializeValue)values.getActionValue(
					ConfirmDbInitializeAction.class.getName());

		return (dbInitializeValue.isConfirmInitialize() == false)
			|| (values.getDbCategory().equals(getDbCategory()) == false);
	}

	/**
	 * f[^x[XEe[u쐬鋤ʃANVB
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return null߂܂B
	 * @throws InstallerException f[^x[XANZXɗOꍇB
	 */
	public InstallerActionValue action(InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger, "action(InstallerValues)");
		boolean successFlag = false;
		try {
			// JnbZ[Wo
			InstallerUiUtil.outputMessageAsTitle(
				values,	"CreateDbAbstractAction.head");
			// =================================================================
			// [UEf[^x[X쐬
			createUserAndDatabase(values);
 			// =================================================================
			// ʏ̃NGiOj
			Connection connection = getLmsUserConnection(values);
			executeQueryType(values, connection, "common.first");
			// =================================================================
			// IvVLOpNG
			executeQueriesOptionLO(values, connection);
			// =================================================================
			// ʏ̃NGi㔼j
			executeQueryType(values, connection, "common.second");
			// R~bg
			if (_lmsConection != null
					&& _lmsConection.getAutoCommit() == false) {
				_lmsConection.commit();
			}
			if (_dbaConection != null
					&& _dbaConection.getAutoCommit() == false) {
				_dbaConection.commit();
			}
			// tryubN[܂œB
			successFlag = true;
			// IbZ[Wo
			InstallerUiUtil.outputMessage(
				values, "CreateDbAbstractAction.tail", true);
		}
		catch (InstallerException e) {
			// G[bZ[Wo
			InstallerUiUtil.outputMessage(
				values, "CreateDbAbstractAction.error", true);
			rollback();
			throw e;
		}
		catch (Exception e) {
			// G[bZ[Wo
			InstallerUiUtil.outputMessage(
				values, "CreateDbAbstractAction.error", true);
			rollback();
			throw new InstallerException(e);
		}
		finally {
			closeConnection(successFlag);
		}
		LoggerUtil.methodTail(_logger, "action(InstallerValues)");
		return null;
	}

	/**
	 * Ήf[^x[X̎ʂ߂܂B<br>
	 * @return f[^x[Xʂ߂܂B
	 */
	protected abstract String getDbCategory();


	/**
	 * [Uƃf[^x[X쐬B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @throws InstallerException f[^x[XANZXɗOꍇB
	 */
	protected void createUserAndDatabase(InstallerValues values)
		throws InstallerException {

		Connection connection = getDbaConnection(values);
		executeQueryType(values, connection, "create.database");
		executeQueryType(values, connection, "create.user");
	}

	/**
	 * nꂽNG[Ă悢肵܂B
	 * @param queryLine Ώۂ̃NG[ꕶB
	 * @return ꍇtrueB
	 */
	protected boolean isIgnoreQuery(String queryLine) {
		return false;
	}

	/**
	 * w肳ꂽNG^CṽNG[s܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param connection NGs邽߂̃f[^x[XڑIuWFNgB
	 * @param queryType sNG[ʁB
	 * @throws InstallerException f[^x[XANZXɗOꍇB
	 */
	protected final void executeQueryType(
			InstallerValues values, Connection connection, String queryType)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"executeQueryType(InstallerValues,"
				+ connection + "," + queryType + ")");

		Statement statement = null;
		boolean successFlag = false;
		try {
			String[][] queryResources
				= values.getQueryResources(queryType);
			// NGȂꍇ͏I
			if (queryResources.length > 0) {
				for (int i = 0; i < queryResources.length; i++) {
					// NGs
					String[] queries = loadQuery(values,
						queryResources[i][0], queryResources[i][1]);
					// NGs
					_logger.info("[" + i + "]"
						+ "[" + StringUtil.toString(queries) + "]");
					// Xe[gg擾Es
					for (int j = 0; j < queries.length; j++) {
						statement = connection.createStatement();
						statement.execute(queries[j]);
					}
					// Xe[ggN[Y
					InstallerDatabaseUtil.close(statement, true);
				}
				// gUNVER~bg
				if (connection.getAutoCommit() == false) {
					connection.commit();
				}
			}
			// tryubN[܂œB
			successFlag = true;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		finally {
			InstallerDatabaseUtil.close(statement, successFlag);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"executeQueryType(InstallerValues,"
				+ connection + "," + queryType + ")");
	}

	/**
	 * IvVLO֘ÃNG[s܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param connection f[^x[XRlNVIuWFNgB
	 * @throws InstallerException f[^x[XANZXɗOꍇB
	 */
	protected void executeQueriesOptionLO(
		InstallerValues values, Connection connection)
		throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"executeQueriesOptionLO(InstallerValues)");
		String[] optionLOKeys = values.getOptionLOKeys();
		for (int i = 0; i < optionLOKeys.length; i++) {
			if ( values.getOptionLOSelected(optionLOKeys[i]) == false ) {
				continue;
			}
			executeQueryType(values, connection,
				"optionLO." + optionLOKeys[i]);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"executeQueriesOptionLO(InstallerValues)");
	}

	/**
	 * f[^x[XǗ҂ANZXf[^x[X擾܂B
	 * ̃NXłInstallerValues#getDbName()̖߂l߂Ă܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return f[^x[XǗ҂ANZXf[^x[XB
	 * @see InstallerValues#getDbName()
	 */
	protected String getDbNameForDba(InstallerValues values) {
		// f[^x[X́A}l[W̐ݒl̓
		ManagerInputValue managerValue
			= (ManagerInputValue)values.getActionValue(
					ManagerInputAction.class.getName());
		return managerValue.getDbName();
	}

	/**
	 * f[^x[XǗҌł̃RlNV擾܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return f[^x[XǗҌł̃RlNVB
	 * @throws InstallerException RlNV擾ɎsꍇB
	 */
	protected Connection getDbaConnection(
		InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"getDbaConnection(InstallerValues)");
		try {
			if (_dbaConection != null && _dbaConection.isClosed() == false) {
				if (_dbaConection.getAutoCommit() == false) {
					_dbaConection.commit();
				}
				_dbaConection.close();
				_dbaConection = null;
			}
			// f[^x[X́A}l[W̐ݒl̓
			ManagerInputValue managerValue
				= (ManagerInputValue)values.getActionValue(
						ManagerInputAction.class.getName());
			// [U珉̍ۂɓ͂lgpB
			ConfirmDbInitializeValue dbInitializeValue
				= (ConfirmDbInitializeValue)values.getActionValue(
						ConfirmDbInitializeAction.class.getName());
			// DBzXg
			String host = managerValue.getDbHost();
			// DB|[gԍ
			String port = managerValue.getDbPort();
			// f[^x[X
			String dbName = getDbNameForDba(values);
			// [U
			String user = dbInitializeValue.getDbaUser();
			// pX[h
			String pass = dbInitializeValue.getDbaPassword();
			// RlNV
			_dbaConection = InstallerDatabaseUtil.getConnection(
				values, host, port, dbName, user, pass,
				"connectionStringPatternDba", true);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		LoggerUtil.methodTail(_logger,
			"getDbaConnection(InstallerValues)");
		return _dbaConection;
	}

	/**
	 * LMS^p̃[Uł̃RlNV擾܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return LMS^p̃[Uł̃RlNVB
	 * @throws InstallerException RlNV擾ɎsꍇB
	 */
	protected Connection getLmsUserConnection(
		InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"getLmsUserConnection(InstallerValues)");
		try {
			if (_lmsConection != null && _lmsConection.isClosed() == false) {
				if (_lmsConection.getAutoCommit() == false) {
					_lmsConection.commit();
				}
				_lmsConection.close();
				_lmsConection = null;
			}
			// f[^x[X́A}l[W̐ݒl̓
			ManagerInputValue managerValue
				= (ManagerInputValue)values.getActionValue(
						ManagerInputAction.class.getName());
			String host = managerValue.getDbHost();
			String port = managerValue.getDbPort();
			String dbName = managerValue.getDbName();
			String user = managerValue.getDbUser();
			String pass = managerValue.getDbPassword();
			_lmsConection = InstallerDatabaseUtil.getConnection(
				values, host, port, dbName, user, pass,
				"connectionStringPattern", true);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		LoggerUtil.methodTail(_logger,
			"getLmsUserConnection(InstallerValues)");
		return _lmsConection;
	}

	/**
	 * RlNV[obN܂B<br>
	 * [obNŗOĂÃG[
	 * [obNĂ͂Ȃ̂ŁAO̓X[܂B
	 */
	private void rollback() {
		// Ǘ҃RlNṼ[obN
		if (_dbaConection != null) {
			try {
				if (_dbaConection.getAutoCommit() == false) {
					_dbaConection.rollback();
				}
			}
			catch (Exception e) {
				LoggerUtil.throwable(_logger, e);
			}
		}
		// ^ppRlNṼ[obN
		if (_lmsConection != null) {
			try {
				if (_lmsConection.getAutoCommit() == false) {
					_lmsConection.rollback();
				}
			}
			catch (Exception e) {
				LoggerUtil.throwable(_logger, e);
			}
		}
	}

	/**
	 * RlNVN[Y܂B<br>
	 * @param throwFlag RlNVN[YɎsƂ
	 *                   OX[ꍇ́AtrueB
	 * @throws InstallerException LQƁB
	 */
	private void closeConnection(boolean throwFlag)
		throws InstallerException {
		InstallerException thrownException = null;

		// Ǘ҃RlNṼN[Y
		if (_dbaConection != null) {
			try {
				_dbaConection.close();
			}
			catch (Exception e) {
				LoggerUtil.throwable(_logger, e);
				if (throwFlag) {
					thrownException = new InstallerException(e);
				}
			}
			_dbaConection = null;
		}
		// ^ppRlNṼN[Y
		if (_lmsConection != null) {
			try {
				_lmsConection.close();
			}
			catch (Exception e) {
				LoggerUtil.throwable(_logger, e);
				if (throwFlag && thrownException == null) {
					thrownException = new InstallerException(e);
				}
			}
			_lmsConection = null;
		}
		// Oꍇ̓X[B
		if (thrownException != null) {
			throw thrownException;
		}
	}

	/**
	 * w肵\[X̃NG擾܂B
	 * @param values CXg[ʃf[^IuWFNgB
	 * @param resourcePath NG擾邽߂̃\[X擾B
	 * @param encode \[X̕R[hB
	 * @return \[X擾NG[B
	 * @throws InstallerException \[X̎擾ɎsƂ
	 */
	protected String[] loadQuery(
		InstallerValues values, String resourcePath, String encode)
		throws InstallerException {

		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getLmsUserConnection(InstallerValues,"
				+ resourcePath + "," + encode + ")");

		// \[X̓̕Xg[
		BufferedReader reader = null;
		// NGĩ\bh̖߂lj
		String[] queries = null;
		// String
		List queryList = new ArrayList();
		// tOiꍇtrueɕύXj
		boolean successFlag = false;
		String endOfLine = System.getProperty("line.separator");
		try {
			InputStream resourceStream
				= values.getResourcePathStream(resourcePath);
			if (resourceStream != null) {
				// ̓Xg[擾
				reader = new BufferedReader(
					new InputStreamReader(resourceStream, encode));
				StringBuffer buffer = new StringBuffer();
				// Ps݁A̓sxAAB
				while (true) {
					String line = reader.readLine();
					if (line == null) {
						break;
					}
					if (isIgnoreQuery(line)) {
						continue;
					}
					// u
					line = replace(values, line);
					// Z~R莟敪
					int pos = line.indexOf(';');
					if (pos >= 0) {
						String forward = null;
						String back = null;
						if (pos == 0) {
							forward = "";
							back = line.substring(pos + 1);
						}
						else if (pos + 1 == line.length()) {
							forward = line.substring(0, pos);
							back = "";
							buffer.append(forward);
						}
						else {
							forward = line.substring(0, pos);
							back = line.substring(pos + 1);
							buffer.append(forward);
						}
						// Z~ROAāAXgɓo^
						String query = buffer.toString().trim();
						if (query.length() > 0) {
							queryList.add(query);
						}

						// 炽ȃNG[𐶐
						buffer = new StringBuffer(back);
						buffer.append(endOfLine);
					}
					else {
						buffer.append(line);
						buffer.append(endOfLine);
					}
				}

				// Xgɓo^ĂȂNGΓo^
				if (buffer.length() > 0) {
					String query = buffer.toString().trim();
					if (query.length() > 0) {
						queryList.add(query);
					}
				}
			}
			queries = new String[queryList.size()];
			queryList.toArray(queries);
			// tryubNI[܂œB
			successFlag = true;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		finally {
			InstallerFileUtil.close(reader, successFlag);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getLmsUserConnection(InstallerValues,"
				+ resourcePath + "," + encode + ")",
			StringUtil.toString(queries));
		return queries;
	}

	/**
	 * ^ꂽNG[̒us܂B
	 * @param values CXg[ʃf[^IuWFNgB
	 * @param queryLine ϊΏۂ̃NG[B
	 * @return ũNG[B
	 */
	protected String replace(InstallerValues values, String queryLine) {
		// ftHg͕ϊȂ߂B
		return queryLine;
	}
}
