/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

/**
 * Peceptionݒt@C̏ڂɂē͂߂ANVNXB
 * @author T.Nishiki
 */
public class PerceptionInputAction implements InstallerAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(PerceptionInputAction.class);
	}

	/**
	 * ANVXLbv邩肵܂B<br>
	 * SelectLoActionł̓͂ɊÂ肵܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return LOIPerceptionIĂȂtrue߂܂B
	 * @throws InstallerException ̌ƂȂ擾ɎsꍇB
	 * @see SelectLoAction
	 */
	public boolean isSkipped(InstallerValues values)
			throws InstallerException {
		LoggerUtil.methodHead(_logger, "isSkipped(InstallerValues)");

		boolean skipped = false;
		try {
			// LOIPerception𖢑IɂĂꂢtrueB
			skipped = values.getOptionLOSelected(
				PerceptionInputValue.KEY_LO) == false;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		LoggerUtil.methodTail(_logger, "isSkipped(InstallerValues)", skipped);
		return skipped;
	}

	/**
	 * Peceptionݒt@C̏ڂɂḗEmF߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return PerceptionInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 * @see PerceptionInputValue
	 */
	public InstallerActionValue action(InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger, "action(InstallerValues)");
		// ̓f[^
		PerceptionInputValue inputValue = null;
		try {
			// ̓f[^iftHgf[^ƂĎgpj
			PerceptionInputValue defaultValue = getDefaultValue(values);
			// ^Cg̕\
			InstallerUiUtil.outputMessageAsTitle(
				values, "PerceptionInputAction.welcome");

			while (true) {
				// ͎s
				inputValue = readInputValue(values, defaultValue);
				// ͊mF
				if (confirmInputValue(values, inputValue) == true) {
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger, "action(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * Peceptionݒt@C̏ڂɂē͂߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param defaultValue ftHglB
	 * @return ͂ꂽePerceptionInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private PerceptionInputValue readInputValue(
			InstallerValues values, PerceptionInputValue defaultValue)
			throws InstallerException {
		LoggerUtil.methodHead(_logger,
			"readInputValue(InstallerValues," + defaultValue + ")");

		PerceptionInputValue inputValue = null;
		try {
			inputValue = new PerceptionInputValue();
			// =================================================================
			// [UID
			String userId = null;
			while (true) {
				userId = InstallerUiUtil.askUserInput(values,
						"PerceptionInputAction.prompt.userId",
						defaultValue.getUserId());
				// 
				if (InstallerCheckUtil.isEmptyViolation(userId, values,
						"PerceptionInputAction.error.userId.empty")) {
					continue;
				}
				break;
			}
			inputValue.setUserId(userId);
			// =================================================================
			// IDpX[h
			String password = null;
			while (true) {
				password = InstallerUiUtil.askUserInput(values,
						"PerceptionInputAction.prompt.password",
						defaultValue.getPassword());
				// 
				if (InstallerCheckUtil.isEmptyViolation(password, values,
						"PerceptionInputAction.error.password.empty")) {
					continue;
				}
				break;
			}
			inputValue.setPassword(password);
			// =================================================================
			// ANZXURL
			String accessURL = null;
			while (true) {
				accessURL = InstallerUiUtil.askUserInput(values,
						"PerceptionInputAction.prompt.accessURL",
						defaultValue.getAccessURL());
				// 
				if (InstallerCheckUtil.isEmptyViolation(accessURL, values,
						"PerceptionInputAction.error.accessURL.empty")) {
					continue;
				}
				break;
			}
			inputValue.setAccessURL(accessURL);
			// =================================================================
			// T[oZLeBL[
			String securityKey = null;
			while (true) {
				securityKey = InstallerUiUtil.askUserInput(values,
						"PerceptionInputAction.prompt.securityKey",
						defaultValue.getSecurityKey());
				// 
				if (InstallerCheckUtil.isEmptyViolation(securityKey, values,
						"PerceptionInputAction.error.securityKey.empty")) {
					continue;
				}
				break;
			}
			inputValue.setSecurityKey(securityKey);
			// =================================================================
			// AZXgJnURL
			String assessmentURL = null;
			while (true) {
				assessmentURL = InstallerUiUtil.askUserInput(values,
						"PerceptionInputAction.prompt.assessmentURL",
						defaultValue.getAssessmentURL());
				// 
				if (InstallerCheckUtil.isEmptyViolation(assessmentURL, values,
						"PerceptionInputAction.error.assessmentURL.empty")) {
					continue;
				}
				break;
			}
			inputValue.setAssessmentURL(assessmentURL);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"readInputValue(InstallerValues,PerceptionInputValue)",
			inputValue);
		return inputValue;
	}

	/**
	 * ͂e\A[UɊmF߂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param inputValue ͂ꂽe
	 * @return ͂ꂽeɃ[UmFƂꂽꍇtrueA
	 *          ƂȂꍇfalse߂܂B
	 * @throws InstallerException ɃG[ꍇB
	 */
	private boolean confirmInputValue(
			InstallerValues values, PerceptionInputValue inputValue)
			throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"confirmInputValue(InstallerValues, PerceptionInputValue)");
		boolean confirm = false;
		try {
			InstallerUiUtil.outputConfirmTitle(values,
				"PerceptionInputAction.confirm.title");
			// =================================================================
			// ͓e̕\
			// =================================================================
			// [UID
			InstallerUiUtil.outputConfirm(values,
				"PerceptionInputAction.confirm.userId",
				inputValue.getUserId());
			// =================================================================
			// IDpX[h
			InstallerUiUtil.outputConfirm(values,
				"PerceptionInputAction.confirm.password",
				inputValue.getPassword());
			// =================================================================
			// ANZXURL
			InstallerUiUtil.outputConfirm(values,
				"PerceptionInputAction.confirm.accessURL",
				inputValue.getAccessURL());
			// =================================================================
			// T[oZLeBL[
			InstallerUiUtil.outputConfirm(values,
				"PerceptionInputAction.confirm.securityKey",
				inputValue.getSecurityKey());
			// =================================================================
			// AZXgJnURL
			InstallerUiUtil.outputConfirm(values,
				"PerceptionInputAction.confirm.assessmentURL",
				inputValue.getAssessmentURL());
			// =================================================================
			// [UmF
			confirm = InstallerUiUtil.askUserConfirm(
				values, "PerceptionInputAction.confirm" );
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"confirmInputValue(InstallerValues, PerceptionInputValue)",
			confirm);
		return confirm;
	}

	/**
	 * ̃f[^A͍ڂ̃ftHgl擾܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ftHglPerceptionInputValuě`Ŗ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private PerceptionInputValue getDefaultValue(InstallerValues values)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getDefaultValue(InstallerValues)");

		PerceptionInputValue defaultValue = null;
		try {
			defaultValue = new PerceptionInputValue();
			////////////////////////////////////////////////////////////////////
			// vpeB̎擾
			// =================================================================
			// ̓e
			File existFile = values.getFileOnSystem(
					defaultValue.getTargetFileKey());
			Properties existProperties
				= FileUtil.loadAsProperties(existFile);
			// =================================================================
			// \[Xi{j̓e
			Properties resourceProperties
				= InstallerPropertiesUtil.load(
					values, defaultValue.getTargetFileKey());
			////////////////////////////////////////////////////////////////////
			// ftHgl̐ݒ
			// =================================================================
			// [UID
			String userId = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								PerceptionInputValue.KEY_USER_ID);
			defaultValue.setUserId(userId);
			// =================================================================
			// ANZXURL
			String accessURL = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								PerceptionInputValue.KEY_ACCESS_URL);
			defaultValue.setAccessURL(accessURL);
			// =================================================================
			// ZLeBEL[
			String securityKey = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								PerceptionInputValue.KEY_SCURITY_KEY);
			defaultValue.setSecurityKey(securityKey);
			// =================================================================
			// IDpX[h
			String password = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								PerceptionInputValue.KEY_ID_PASSWORD);
			defaultValue.setPassword(password);
			// =================================================================
			// AZXgURL
			String accessmentURL
				= InstallerPropertiesUtil.determineInitialValue(
					existProperties, resourceProperties,
					PerceptionInputValue.KEY_ACCESSMENT_URL);
			defaultValue.setAssessmentURL(accessmentURL);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getDefaultValue(InstallerValues)", defaultValue);
		return defaultValue;
	}
}
