/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	NavigateBusinessAction
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm.engine;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.transform.stream.StreamResult;

import jp.co.ntt.lms.lo.util.UserIDFolder;
import jp.co.ntt.lms.lo.scorm.kernel.Activity;
import jp.co.ntt.lms.lo.scorm.kernel.exception.SequencingException;
import jp.co.ntt.lms.lo.scorm.util.Debug;
import jp.co.ntt.lms.lo.scorm.util.SG;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;
import jp.co.ntt.lms.xms.framework.XmsBusinessAction;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsRequest;
import jp.co.ntt.lms.xms.framework.XmsResponse;
import jp.co.ntt.lms.xms.framework.XmsSystemException;

import org.w3c.dom.Document;

/**
 *	NavigateBusinessAction NX<br>
 *	navigationR}h󂯕tNX<br>
 */
public class NavigateBusinessAction extends XmsBusinessAction {
	/**
	 * ftHgRXgN^
	 */
	public NavigateBusinessAction() {}

	/**
	 * 
	 *
	 * @param	xmsRequest	NGXgIuWFNg
	 */
	protected void initProcessRequest(XmsRequest xmsRequest) throws XmsException {}

	/**
	 * navigationvt
	 *
	 * @param	xmsRequest	NGXgIuWFNg
	 * @param	xmsResponse	X|XIuWFNg
	 */
	protected void processRequest(XmsRequest xmsRequest, XmsResponse xmsResponse) throws XmsException {
		try {
			HttpServletRequest request = xmsRequest.getRequest();
			HttpSession session = request.getSession();
			ServletContext application = session.getServletContext();

			// Np[^session擾
			ExecuteParameters executeParameters = (ExecuteParameters)session.getAttribute("SCORM.EXECUTE_PARAMETERS");

			// session擾łȂꍇ  Session Timeout 
			if (executeParameters == null) {
				xmsResponse.setBusinessStatus("SessionTimeout");
				return;
			}

			// sessionapi adapter擾
			SCORMAPIAdapter apiAdapter = (SCORMAPIAdapter)session.getAttribute("SCORM.API_ADAPTER");

			// session擾łȂꍇ  Session Timeout 
			if (apiAdapter == null) {
				xmsResponse.setBusinessStatus("SessionTimeout");
				return;
			}

			// GWapplication擾
			String engineKeyName =
				"SCORM." + executeParameters.getUserID() + "." + executeParameters.getLOID() + ".ENGINE";

			Engine engine = (Engine)application.getAttribute(engineKeyName);

			// application擾łȂꍇ  ɋނIĂꍇ  Session TimeoutɌ
			if (engine == null) {
				xmsResponse.setBusinessStatus("SessionTimeout");
				return;
			}

			// irQ[VR}h擾
			String command = xmsRequest.getParameter("Command");

			if (apiAdapter.getCommunicationModule() != null) {
				// "cmi.exit"̒l擾
				String exitStatus = apiAdapter.getCommunicationModule().getValue("cmi.exit");

				if (exitStatus != null) {
					// "cmi.exit"̒l"time-out"̏ꍇ́AExitAlls
					if (exitStatus.equals("time-out")) {
						command = "ExitAll";
					}
					// "cmi.exit"̒l"logout"̏ꍇ́ASuspendAlls
					else if (exitStatus.equals("logout")) {
						command = "SuspendAll";
					}
				}

			}

			boolean result;
			StringBuffer SCOURL = null;

			try {
				// GWɃirQ[Vvs
				result = engine.navigate(command, xmsRequest.getParameter("ActivityID"));

				// Iꍇ́AV[PVOONA
				engine.setLastSequencingException(null);

				// uwKp\vȏꍇ
				if (result) {
					// JgANeBreB݂邩ǂ`FbN
					if (engine.getCurrentActivity() != null) {
						int attemptCount = 0;

						if (engine.getCurrentActivity().getActivityProgressStatus()) {
							attemptCount = engine.getCurrentActivity().getActivityAttemptCount();
						}

						// AICCO̊i[tH_쐬
						StringBuffer learningLogFolder = new StringBuffer();

						learningLogFolder.append(userIDPath(SG.get("LearningLogBaseURL"), executeParameters.getUserID()));
						learningLogFolder.append(File.separator);
						learningLogFolder.append(executeParameters.getLOID());
						learningLogFolder.append(File.separator);
						learningLogFolder.append(executeParameters.getStudySessionCount());
						learningLogFolder.append(File.separator);
						learningLogFolder.append(executeParameters.getLaunchCount());
						learningLogFolder.append(File.separator);
						learningLogFolder.append(engine.getCurrentActivity().getIdentifier());
						learningLogFolder.append(File.separator);
						learningLogFolder.append(new DecimalFormat("0000000000").format(attemptCount));
						learningLogFolder.append(File.separator);
						learningLogFolder.append(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
						learningLogFolder.append(File.separator);

						// ()SCOւURL擾
						String nextSCOURL = engine.getURL(learningLogFolder.toString());

						// ()SCOURL擾łꍇ
						if (nextSCOURL != null) {
							SCOURL = new StringBuffer();
							SCOURL.append(SG.get("SystemBaseURL"));
							SCOURL.append("contents/");
							SCOURL.append(executeParameters.getManifestID());
							SCOURL.append("/");
							SCOURL.append(nextSCOURL);
						}

						// api adapterJgANeBreBapi adapterɕύX
						apiAdapter.setCommunicationModule(engine.getCommunicationModule());
					}
				}
			}
			catch (SequencingException ex) {
				Debug.write(ex);

				// V[PVOOꍇ
				result = true;
				engine.setLastSequencingException(ex);
			}

			Document traceLog = engine.getTraceLog();

			// g[XO݂ꍇ
			if (traceLog != null) {
				// g[XÕtpX쐬
				StringBuffer navtraceLogFile = new StringBuffer();

				navtraceLogFile.append(userIDPath(SG.get("ResumeDataBaseURL"), executeParameters.getUserID()));
				navtraceLogFile.append(File.separator);
				navtraceLogFile.append(executeParameters.getLOID());
				navtraceLogFile.append(File.separator);
				navtraceLogFile.append(executeParameters.getStudySessionCount());
				navtraceLogFile.append(File.separator);
				navtraceLogFile.append(executeParameters.getLaunchCount());
				navtraceLogFile.append(File.separator);
				navtraceLogFile.append("navtrace.xml");

				// g[XOuǉ[hvŃI[v
				BufferedOutputStream bos =
					new BufferedOutputStream(new FileOutputStream(navtraceLogFile.toString(), true));

				try {
					// navtrace.xmlɃg[XOǉ
					XMLUtil.output(traceLog.getDocumentElement(), true, SG.get("XMLEncoding"), new StreamResult(bos));
				}
				finally {
					bos.close();
				}
			}

			// uwKfv́uwKv̏ꍇ
			if (!result) {
				// api adapter𖢐ݒԂɐݒ肷
				apiAdapter.setCommunicationModule(null);

				// root activity擾
				Activity rootActivity = engine.getRootActivity();
				String exitResult;

				// activty is suspended ̏ꍇ͒f("SuspendAll"sꂽ)
				if (rootActivity.isSuspended() && !command.equals("ExitAll")) {
					exitResult = "SUSPEND";
				}
				// activty is suspended łȂꍇ͏I(ɋނ̊wKIA"ExitAll"sꂽ)
				else {
					exitResult = "EXIT";
				}

				// fXMSU֑M
				Exception error = null;

				synchronized (engine) {
					try {
						// fsAfXMSU֑M
						engine.discontinue(exitResult, false);
					}
					catch (Exception ex) {
						Debug.write(ex);

						error = ex;
					}

					// GWapplication폜
					application.removeAttribute(engineKeyName);
				}

				// session폜
				session.removeAttribute("SCORM.TIMEOUT_WATCHER");
				session.removeAttribute("SCORM.EXECUTE_PARAMETERS");
				session.removeAttribute("SCORM.API_ADAPTER");

				// fɗOȂꍇ
				if (error == null) {
					EndLearningBusinessBean elbb = new EndLearningBusinessBean(executeParameters);
					elbb.setExitResult(exitResult);

					xmsResponse.setBusinessBean(elbb);
					xmsResponse.setBusinessStatus("EndLearning");
				}
				// fɗOꍇ
				else {
					LearningLogSendErrorBusinessBean llsebb = new LearningLogSendErrorBusinessBean(executeParameters);
					llsebb.setException(error);

					xmsResponse.setBusinessBean(llsebb);
					xmsResponse.setBusinessStatus("LearningLogSendError");
				}

				return;
			}

			NavigateBusinessBean navigateBusinessBean = new NavigateBusinessBean(executeParameters);

			navigateBusinessBean.setSCOURL((SCOURL == null) ? null : SCOURL.toString());

			xmsResponse.setBusinessBean(navigateBusinessBean);
		}
		catch (Exception ex) {
			throw new XmsSystemException(ex);
		}
	}

	private static String userIDPath(String strDirPath, String strUserID)
	{
		return UserIDFolder.getPath(strDirPath, strUserID);
	}
}
