/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ntt.lms.installer.core;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;
import jp.co.ntt.lms.installer.util.XmlUtil;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstallerValues {
    private static Logger _logger = LoggerUtil.getLogger(class$jp$co$ntt$lms$installer$core$InstallerControl == null ? (class$jp$co$ntt$lms$installer$core$InstallerControl = InstallerValues.class$("jp.co.ntt.lms.installer.core.InstallerControl")) : class$jp$co$ntt$lms$installer$core$InstallerControl);
    private Document _propertiesDoc;
    private Document _messagesDoc;
    private Map _actionValueMap;
    private File _projectBaseDir;
    private File _installerDir;
    private File _installerTempDir;
    private String _resourceBasePath;
    private List _madeDirectoriesList;
    private Map _optionLOSelcted;
    private String _dbCategory;
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$core$InstallerControl;

    InstallerValues(Document document) throws InstallerException {
        LoggerUtil.methodHead(_logger, "InstallerValues(" + document + ")");
        try {
            this._propertiesDoc = document;
            this._actionValueMap = Collections.synchronizedMap(new HashMap());
            String string = this.getProperty("resource.messages");
            this._messagesDoc = StringUtil.isEmpty(string) ? this._propertiesDoc : XmlUtil.convertXmlResourceToDocument(string);
            String string2 = System.getProperty("user.dir");
            this._installerDir = new File(string2);
            String string3 = this.getProperty("path.project");
            this._projectBaseDir = new File(this._installerDir, string3).getCanonicalFile();
            String string4 = this.getProperty("path.dir.installer.temp");
            this._installerTempDir = new File(this._installerDir, string4).getCanonicalFile();
            this._resourceBasePath = this.getProperty("path.dir.resources");
            this._madeDirectoriesList = new ArrayList();
            this._optionLOSelcted = new HashMap();
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "InstallerValues(" + document + ")");
    }

    public InstallerActionValue getActionValue(String string) {
        return (InstallerActionValue)this._actionValueMap.get(string);
    }

    void setActionValue(InstallerAction installerAction, InstallerActionValue installerActionValue) {
        _logger.info("setActionValue(" + installerAction + "," + installerActionValue + ")");
        this._actionValueMap.put(installerAction.getClass().getName(), installerActionValue);
    }

    public InstallerAction[] getActions() throws InstallerException {
        LoggerUtil.methodHead(_logger, "getActions()");
        InstallerAction[] installerActionArray = this.getActions("actions");
        LoggerUtil.methodTail(_logger, "getActions()", installerActionArray);
        return installerActionArray;
    }

    public InstallerAction[] getRestreActions() throws InstallerException {
        LoggerUtil.methodHead(_logger, "getRestreActions()");
        InstallerAction[] installerActionArray = this.getActions("restoreActions");
        LoggerUtil.methodTail(_logger, "getRestreActions()", installerActionArray);
        return installerActionArray;
    }

    private InstallerAction[] getActions(String string) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getActions(" + string + ")");
        InstallerAction[] installerActionArray = null;
        try {
            ArrayList<InstallerAction> arrayList = new ArrayList<InstallerAction>();
            NodeList nodeList = XPathAPI.selectNodeList((Node)this._propertiesDoc, (String)("/installer/" + string + "/action/@name"));
            int n = nodeList.getLength();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Number of action classes:" + n);
            }
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                String string2 = node.getNodeValue();
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "actionClassName[" + i + "]:" + string2);
                }
                Class<?> clazz = Class.forName(string2);
                InstallerAction installerAction = (InstallerAction)clazz.newInstance();
                arrayList.add(installerAction);
            }
            installerActionArray = new InstallerAction[arrayList.size()];
            arrayList.toArray(installerActionArray);
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "getActions(" + string + ")", installerActionArray);
        return installerActionArray;
    }

    public String getMessage(String string) {
        LoggerUtil.methodHead(_logger, "getMessage(" + string + ")");
        String string2 = this.getMessage(string, null);
        LoggerUtil.methodTail(_logger, "getMessage(" + string + ")", string2);
        return string2;
    }

    public String getMessage(String string, Object[] objectArray) {
        String string2 = null;
        if (LoggerUtil.isLoggableMethod(_logger)) {
            string2 = "getMessage(" + string + "," + StringUtil.toString(objectArray) + ")";
            LoggerUtil.methodHead(_logger, string2);
        }
        String string3 = null;
        try {
            String string4 = "/installer/messages/message[@id=\"" + string + "\"]/text()";
            String string5 = XmlUtil.getNodeValue(this._messagesDoc, string4);
            string3 = StringUtil.isEmpty(string5) ? "" : (objectArray == null ? string5 : MessageFormat.format(string5, objectArray));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 == null) {
            string3 = "";
        }
        if (LoggerUtil.isLoggableMethod(_logger)) {
            LoggerUtil.methodTail(_logger, string2, string3);
        }
        return string3;
    }

    public File getProjectBaseDir() throws InstallerException {
        return this._projectBaseDir;
    }

    public File getInstallerDir() throws InstallerException {
        return this._installerDir;
    }

    public File getInstallerTempDir() throws InstallerException {
        return this._installerTempDir;
    }

    public File[][] getCopiedFiles() throws InstallerException {
        LoggerUtil.methodHead(_logger, "getCopiedFiles()");
        File[][] fileArray = null;
        try {
            String[] stringArray = XmlUtil.getNodeValues(this._propertiesDoc, "/installer/files/file/@path");
            ArrayList<File[]> arrayList = new ArrayList<File[]>();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(this._projectBaseDir, stringArray[i]).getCanonicalFile();
                File file2 = new File(this._installerTempDir, stringArray[i]).getCanonicalFile();
                File[] fileArray2 = new File[]{file, file2};
                arrayList.add(fileArray2);
            }
            fileArray = new File[arrayList.size()][];
            arrayList.toArray((T[])fileArray);
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "getCopiedFiles()", fileArray);
        return fileArray;
    }

    public File getFileOnSystem(String string) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getFileOnSystem(" + string + ")");
        File file = null;
        try {
            String string2 = XmlUtil.getNodeValue(this._propertiesDoc, "/installer/files/file[@name=\"" + string + "\"]/@path");
            file = new File(this._projectBaseDir, string2).getCanonicalFile();
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "getFileOnSystem(" + string + ")", file);
        return file;
    }

    public String getSystemURL(String string) {
        String string2 = null;
        String string3 = this.getProperty("systemurl");
        string2 = MessageFormat.format(string3, string);
        return string2;
    }

    public void addMadeDirectory(File file) {
        if (file != null) {
            this._madeDirectoriesList.add(file);
        }
    }

    public File[] getMadeDirectories() {
        File[] fileArray = new File[this._madeDirectoriesList.size()];
        this._madeDirectoriesList.toArray(fileArray);
        return fileArray;
    }

    public InputStream getResourceKeyStream(String string) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getResourceKeyStream(" + string + ")");
        InputStream inputStream = null;
        try {
            String string2 = this.getResourcePath(string);
            inputStream = this.getResourcePathStream(string2);
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
        }
        LoggerUtil.methodTail(_logger, "getResourceKeyStream(" + string + ")", inputStream);
        return inputStream;
    }

    public InputStream getResourcePathStream(String string) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getResourcePathStream(" + string + ")");
        InputStream inputStream = null;
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            inputStream = classLoader.getResourceAsStream(string);
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
        }
        LoggerUtil.methodTail(_logger, "getResourcePathStream(" + string + ")", inputStream);
        return inputStream;
    }

    public String getResourceKeyEncode(String string) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getResourceKeyEncode(" + string + ")");
        String string2 = null;
        try {
            string2 = XmlUtil.getNodeValue(this._propertiesDoc, "/installer/files/file[@name=\"" + string + "\"]/@encode");
            if (StringUtil.isEmpty(string2)) {
                string2 = "UTF-8";
            }
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            string2 = "UTF-8";
        }
        LoggerUtil.methodTail(_logger, "getResourceKeyEncode(" + string + ")", string2);
        return string2;
    }

    private String getResourcePath(String string) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getResourcePath(" + string + ")");
        String string2 = null;
        try {
            String string3 = XmlUtil.getNodeValue(this._propertiesDoc, "/installer/files/file[@name=\"" + string + "\"]/@path");
            if (!StringUtil.isEmpty(string3)) {
                string2 = this._resourceBasePath;
                if (string2.charAt(string2.length() - 1) != '/') {
                    string2 = string2 + "/";
                }
                string2 = string2 + string3;
            }
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
        }
        LoggerUtil.methodTail(_logger, "getResourcePath(" + string + ")", string2);
        return string2;
    }

    public String getProperty(String string) {
        String string2 = null;
        try {
            string2 = XmlUtil.getNodeValue(this._propertiesDoc, "/installer/properties/property[@name=\"" + string + "\"]/@value");
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    public String[] getOptionLOKeys() {
        String[] stringArray = null;
        try {
            stringArray = XmlUtil.getNodeValues(this._propertiesDoc, "/installer/optionLOs/optionLO/@name");
        }
        catch (Exception exception) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String getDbProperty(String string) {
        String string2 = this.getDbProperty(string, this._dbCategory);
        return string2;
    }

    public String getDbProperty(String string, String string2) {
        String string3 = null;
        try {
            string3 = XmlUtil.getNodeValue(this._propertiesDoc, "/installer/dbscripts/database[@category=\"" + string2 + "\"]" + "/property[@name=\"" + string + "\"]" + "/@value");
        }
        catch (Exception exception) {
            string3 = "";
        }
        return string3;
    }

    public void setOptionLOSelected(String string, boolean bl) {
        if (string != null) {
            this._optionLOSelcted.put(string, bl);
        }
    }

    public boolean getOptionLOSelected(String string) {
        Boolean bl;
        boolean bl2 = false;
        bl2 = string == null ? false : ((bl = (Boolean)this._optionLOSelcted.get(string)) == null ? true : bl);
        return bl2;
    }

    public String getDbCategory() {
        return this._dbCategory;
    }

    public void setDbCategory(String string) {
        this._dbCategory = string;
    }

    public String[] getDbExtendPropetyName() {
        String[] stringArray = null;
        try {
            String string = "/installer/dbscripts/database[@category=\"" + this.getDbCategory() + "\"]" + "/extendProperties/extendProperty/@name";
            stringArray = XmlUtil.getNodeValues(this._propertiesDoc, string);
        }
        catch (Exception exception) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String[][] getQueryResources(String string) throws InstallerException {
        String[][] stringArray;
        LoggerUtil.methodHead(_logger, "getQueryResources(" + string + ")");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            stringArray = "/installer/dbscripts/database[@category=\"" + this.getDbCategory() + "\"]" + "/queries[@type=\"" + string + "\"]";
            _logger.info("queriesPath=" + (String)stringArray);
            Element element = (Element)XPathAPI.selectSingleNode((Node)this._propertiesDoc, (String)stringArray);
            if (element != null) {
                String string2 = element.getAttribute("encode");
                NodeList nodeList = XPathAPI.selectNodeList((Node)element, (String)"./query");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    String string3 = element2.getAttribute("resourcePath");
                    String string4 = element2.getAttribute("encode");
                    if (StringUtil.isEmpty(string4)) {
                        string4 = string2;
                    }
                    String[] stringArray2 = new String[]{string3, string4};
                    arrayList.add(stringArray2);
                }
            }
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
        }
        stringArray = null;
        stringArray = new String[arrayList.size()][];
        arrayList.toArray((T[])stringArray);
        LoggerUtil.methodTail(_logger, "getQueryResources(" + string + ")", stringArray);
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

