/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	wKiΔ\pXMLݒǗNX
//
//		ύX
//			2005.02.03  VK쐬  Katsuhiko.Sakurai(UNITEC)
//
//	@\
//
//	̃NX͊wKiΔ\pXMLݒǗNXłB
//
////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.progress.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import jp.co.ntt.lms.xmo.util.DebugLog;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * wKiΔ\pXMLݒǗNXłB
 * 
 * @author Katsuhiko Sakurai (UNITEC)
 * @version 1.0
 */
public class LearningProgressConfigurationManager {
	
	private HashMap loProgressConfigurationMap = null;
	private LearningStatusConfiguration learningStatusConfiguration = null;
	
	private final String FILE_PATH = "/conf/lo/progress/LearningProgress.xml";
	
	/**
	 * RXgN^łB
	 * 
	 */
	public LearningProgressConfigurationManager() {
		this.loProgressConfigurationMap = new HashMap();
		this.learningStatusConfiguration = new LearningStatusConfiguration();
		
		try {
			// ݒt@Cǂݍ
			this.loadConfiguration();
		} catch (Exception e) {
			DebugLog.write(this.getClass(), e, DebugLog.MID);
			DebugLog.write(this.getClass(), "wKiΔ\pXMLݒt@Cǂݍ݃G[", DebugLog.MID);
		}
	}
	
	/**
	 * LOݒ擾܂B
	 * 
	 * @param loID ΏۂƂȂLOID
	 * @return LOConfiguraton LOݒ
	 */
	public LOConfiguration getLOCongifuration( String loID ) {
		return (LOConfiguration)this.loProgressConfigurationMap.get(loID);
	}
	
	/**
	 * wK󋵐ݒ擾܂B
	 * 
	 * @return LearningStatusConfiguration wK󋵐ݒ
	 */
	public LearningStatusConfiguration getLearningStatusConfiguration() {
		return this.learningStatusConfiguration;
	}
	
	/**
	 * Oݒt@Cǂݍ݂܂B
	 * 
	 * @throws FileNotFoundException
	 * @throws SAXException
	 * @throws IOException
	 * @throws ParserConfigurationException
	 */
	private void loadConfiguration() throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
		
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();

		DebugLog.write( this.getClass(), "iݒXMLǂݍ݊Jn : " , DebugLog.ROW );
		
		Node root = null;
		InputStream in = null;
		try {
			in = this.getClass().getResourceAsStream(FILE_PATH);
			// t@CDOMɕϊ
			root = builder.parse(in);
			//root = builder.parse(FILE_PATH);
		
		} finally {
			if (in != null ) in.close();
		}
		
		NodeList loNodeList = root.getFirstChild().getChildNodes();
		
		for (int i = 0; i < loNodeList.getLength(); i++) {

			//LOm[ho  
			Node loNode = loNodeList.item(i);
			
			// eLXgNODȄꍇȂ
			if ( loNode.getNodeType() == Node.TEXT_NODE  
					|| loNode.getNodeType() == Node.COMMENT_NODE) continue;
			
			// wK󋵂̃L[[h̐ݒ擾
			if (loNode.getNodeName().equals("learningStatus")) {
				
				this.setLearningStatusToConfiguration(loNode, this.learningStatusConfiguration);
			
			// LOƂ̐ݒl擾
			} else if(loNode.getNodeName().equals("lo")) {
				
				// LOi[LOCongiguration𐶐
				LOConfiguration loConfig = new LOConfiguration();
				
				// LOID̐ݒ
				this.setLOIDToConfiguration( loNode, loConfig );
				
				DebugLog.write( this.getClass(), "LOID : " + loConfig.getLoID(), DebugLog.ROW );

				// LOIDݒ肳ĂȂꍇȂ
				if ( loConfig.getLoID() == null ) continue;
				
				// LO̎qm[h擾
				NodeList loChildNodeList = loNode.getChildNodes();
				
				for (int j = 0; j < loChildNodeList.getLength(); j++) {
					
					Node loChildNode = loChildNodeList.item(j);
					
					// eLXgNODȄꍇȂ
					if ( loChildNode.getNodeType() == Node.TEXT_NODE  
							|| loChildNode.getNodeType() == Node.COMMENT_NODE) continue;

					// wKm[h̏擾
					if ( loChildNode.getNodeName().equals("learning")) {
						
						// wK̐ݒ
						this.setLearningInfoToConfiguration(loChildNode, loConfig);
						
					// i֘Am[h̏擾
					} else	if ( loChildNode.getNodeName().equals("progressRate") ) {
						
						NodeList progressRateChildNodeList = loChildNode.getChildNodes();
						
						for (int k = 0; k < progressRateChildNodeList.getLength(); k++) {
							
							Node progressRateChildNode = progressRateChildNodeList.item(k);
							
							// eLXgNODȄꍇȂ
							if ( progressRateChildNode.getNodeType() == Node.TEXT_NODE 
									|| progressRateChildNode.getNodeType() == Node.COMMENT_NODE) continue;

							// im[h̏擾
							if ( progressRateChildNode.getNodeName().equals("statusRate") ) {
						
								// i̐ݒ
								this.setStatusRateToConfiguration(progressRateChildNode, loConfig);
								
							// jbgƂ̏d݂擾
							} else if ( progressRateChildNode.getNodeName().equals("unitWeight") ) {

								//jbgƂ̏dݐݒ
								this.setUnitWeightToConfiguration(progressRateChildNode, loConfig);
							}
						}
						
	 				// i󋵊֘A̐ݒl擾
					} else if ( loChildNode.getNodeName().equals("progressStatus") ) {

						//jbgƂ̏dݐݒ
						this.setProgressStatusToConfiguration(loChildNode, loConfig);
					}
				}

				// LO̐iۑ
				this.loProgressConfigurationMap.put(loConfig.getLoID(), loConfig);
			}
		}
	}
	
	/**
	 * wK󋵂ݒlǗɐݒ肵܂B
	 * 
	 * @param learningStatusNode wK󋵃m[h
	 * @param configuration wK󋵕ێf[^
	 */
	private void setLearningStatusToConfiguration(Node learningStatusNode, LearningStatusConfiguration configuration) {
		
		Node idAttribute = learningStatusNode.getAttributes().getNamedItem("id");
		Node screenNameAttribute = learningStatusNode.getAttributes().getNamedItem("screenName");
		
		if (idAttribute == null || screenNameAttribute == null) return;
		
		// wK󋵂̃L[[h̎擾
		// 
		if ( idAttribute.getNodeValue().equals("Complete") ) {
			configuration.setCompleteScreenName( screenNameAttribute.getNodeValue() );
		// 
		} else if ( idAttribute.getNodeValue().equals("NotComplete") ) {
			configuration.setNotCompleteScreenName( screenNameAttribute.getNodeValue());
		// 
		} else if ( idAttribute.getNodeValue().equals("NotStart") ) {
			configuration.setNotStartScreenName( screenNameAttribute.getNodeValue());
		}			
	}

	/**
	 * LOIDݒlǗɐݒ肵܂B
	 * 
	 * @param loNode LOm[h
	 * @param configuration LOێf[^
	 */
	private void setLOIDToConfiguration(Node loNode, LOConfiguration configuration) {
		
		Node idAttribute = loNode.getAttributes().getNamedItem("id");
		if (idAttribute == null) return;
		
		configuration.setLoID(idAttribute.getNodeValue());
	}
	
	/**
	 * wKݒlǗɐݒ肵܂B
	 * 
	 * @param learningNode wKm[h
	 * @param configuration LOێf[^
	 */
	private void setLearningInfoToConfiguration(Node learningNode, LOConfiguration configuration) {
		
		Node startDateAttribute = learningNode.getAttributes().getNamedItem("startdate");
		Node timeSpanAttribute = learningNode.getAttributes().getNamedItem("timespan");
		if (startDateAttribute == null || timeSpanAttribute == null) return;

		// wKJn
		configuration.setStartDate(startDateAttribute.getNodeValue());

		// wK
		configuration.setTimeSpan(timeSpanAttribute.getNodeValue());
	}

	/**
	 * iݒlǗɐݒ肵܂B
	 * 
	 * @param statusNode ԃm[h
	 * @param configuration LOێf[^
	 */
	private void setStatusRateToConfiguration(Node statusNode, LOConfiguration configuration) {

		// Xe[^XƂ̐i̎擾
		NodeList statusNodeList = statusNode.getChildNodes();
		
		for (int i = 0; i < statusNodeList.getLength(); i++) {
			
			Node statusRateNode = statusNodeList.item(i);
			
			// eLXgNODȄꍇȂ
			if ( statusRateNode.getNodeType() == Node.TEXT_NODE  
					|| statusRateNode.getNodeType() == Node.COMMENT_NODE) continue;

			Node idAttribute = statusRateNode.getAttributes().getNamedItem("id");
			Node rateAttribute = statusRateNode.getAttributes().getNamedItem("rate");
			if (idAttribute == null || rateAttribute == null) continue;

			// 
			if ( idAttribute.getNodeValue().equals("Complete") ) {
				configuration.setCompleteRate( rateAttribute.getNodeValue() );
			// 
			} else if ( idAttribute.getNodeValue().equals("NotComplete") ) {
				configuration.setNotCompleteRate( rateAttribute.getNodeValue() );
			// 
			} else if ( idAttribute.getNodeValue().equals("NotStart") ) {
				configuration.setNotStartRate( rateAttribute.getNodeValue() );
			}			
		}
	}
	
	/**
	 * jbg̏d݂ݒlǗɐݒ肵܂B
	 * 
	 * @param unitWeightNode jbg̏d݃m[h
	 * @param configuration LOێf[^
	 */
	private void setUnitWeightToConfiguration(Node unitWeightNode, LOConfiguration configuration){

		// jbgƂ̏d݂̎擾
		NodeList unitNodeList = unitWeightNode.getChildNodes();
		
		for (int i = 0; i < unitNodeList.getLength(); i++) {

			Node unitNode = unitNodeList.item(i);
			
			// eLXgNODȄꍇȂ
			if ( unitNode.getNodeType() == Node.TEXT_NODE  
					|| unitNode.getNodeType() == Node.COMMENT_NODE) continue;

			Node idAttribute = unitNode.getAttributes().getNamedItem("id");
			Node weightAttribute = unitNode.getAttributes().getNamedItem("weight");
			if (idAttribute == null || weightAttribute == null) continue;

			//jbgƂ̏dݐݒ
			configuration.setUnitWeight(idAttribute.getNodeValue(), weightAttribute.getNodeValue());
		}
	}
	
	/**
	 * i󋵂ݒlǗɐݒ肵܂B
	 * 
	 * @param progressStatus i
	 * @param configuration LOێf[^
	 */
	private void setProgressStatusToConfiguration(Node progressStatus, LOConfiguration configuration) {

		// i󋵎擾
		NodeList levelNodeList = progressStatus.getChildNodes();
		
		for (int i = 0; i < levelNodeList.getLength(); i++) {
			
			Node levelNode = levelNodeList.item(i);
			
			// eLXgNODȄꍇȂ
			if ( levelNode.getNodeType() == Node.TEXT_NODE 
					|| levelNode.getNodeType() == Node.COMMENT_NODE) continue;

			Node nameAttribute = levelNode.getAttributes().getNamedItem("name");
			Node minAttribute = levelNode.getAttributes().getNamedItem("min");
			Node maxAttribute = levelNode.getAttributes().getNamedItem("max");
			if (nameAttribute == null || minAttribute == null || maxAttribute == null) continue;

			// i̐ݒ
			configuration.setProgressStatus(nameAttribute.getNodeValue(),
											minAttribute.getNodeValue(),
											maxAttribute.getNodeValue());
			
		}
	}
}
