/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormAttemptDataAccess
//	ύX
//		2004.02.01	VK쐬
//      2006.12.01@ύX T.Kiyokawa
//                  IMOXMLeLXg`ɕύXA
//

package jp.co.ntt.lms.lo.scorm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.util.DebugLog;

// CommentOut 2006.11.24 (CSVΉ̂)
//@import org.w3c.dom.Node;

/**
 * ScormAttempte[uւ̃ANZXENXB
 * @author T.Nishiki
 */
public class ScormAttemptDataAccess extends ScormDataAccess {
	/**
	 * e[uB
	 */
	public static final String TABLE_NAME = "Scorm_Attempt";

	/**
	 * e[uE񖼁F[UIDB
	 */
	public static final String USERID = "UserID";

	/**
	 * e[uE񖼁FLOIDB
	 */
	public static final String LOID = "LOID";

	/**
	 * e[uE񖼁FwKZbV񐔁B
	 */
	public static final String STUDY_SESSION_COUNT = "StudySessionCount";

	/**
	 * e[uE񖼁FANeBreBIDB
	 */
	public static final String ACTIVITYID = "ActivityID";

	/**
	 * e[uE񖼁Fs񐔁B
	 */
	public static final String ATTEMPT_COUNT = "AttemptCount";

	/**
	 * e[uE񖼁FLearnZbV񐔁B
	 */
	public static final String LEARN_SESSION_COUNT = "LearnSessionCount";

	/**
	 * e[uE񖼁FZbVIDB
	 */
	public static final String SESSIONID = "SessionID";

	/**
	 * e[uE񖼁FwKB
	 */
	public static final String LEARNSESSION_DATE = "LearnSession_Date";

	/**
	 * e[uE񖼁FXe[^XB
	 */
	public static final String COMPLETION_STATUS = "Completion_Status";

	/**
	 * e[uE񖼁FKςݓ_B
	 */
	public static final String SCALED_SCORE = "ScaledScore";

	/**
	 * e[uE񖼁F_B
	 */
	public static final String RAWSCORE = "RawScore";

	/**
	 * e[uE񖼁Fō_B
	 */
	public static final String MAXSCORE = "MaxScore";

	/**
	 * e[uE񖼁FŒᓾ_B
	 */
	public static final String MINSCORE = "MinScore";

	/**
	 * e[uE񖼁F؍ݎԁB
	 */
	public static final String ATTEMPT_SESSION_TIME = "Attempt_Session_Time";

	/**
	 * e[uE񖼁FiXe[^XB
	 */
	public static final String SUCCESS_STATUS = "Success_Status";

	/**
	 * e[uE񖼁FP[VB
	 */
	public static final String LOCATION = "location";

	/**
	 * e[uE񖼁FwKIԁB
	 */
	public static final String EXIT = "exit";

	/**
	 * &lt;Xe[^X&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_COMPLETION_STATUS_VALUE =
		"./completionstatus/text()";

	/**
	 * &lt;Kςݓ_&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_SCALED_SCORE_VALUE =
		"./score/scaled/text()";

	/**
	 * &lt;_&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_RAW_SCORE_VALUE = "./score/raw/text()";

	/**
	 * &lt;ō_&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_MAX_SCORE_VALUE = "./score/max/text()";

	/**
	 * &lt;Œᓾ_&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_MIN_SCORE_VALUE = "./score/min/text()";

	/**
	 * &lt;؍ݎ&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_ATTEMPT_SESSION_TIME_VALUE =
		"./sessiontime/text()";

	/**
	 * &lt;iXe[^X&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_SUCCESS_STATUS_VALUE =
		"./successstatus/text()";

	/**
	 * &lt;P[V&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_LOCATION_VALUE = "./location/text()";

	/**
	 * &lt;wKI&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_EXIT_VALUE = "./exit/text()";

	/**
	 * getTotalMaxMinScores\bh̖߂l̔z񒷁B<br>
	 * @see #getTotalMaxMinScores(DataAccess, String, String, String)
	 */
	private static final int MAX_MIN_SCORES_LENGTH = 2;

	/**
	 * getTotalMaxMinScores\bh̖߂lōō_CfbNXB
	 * @see #getTotalMaxMinScores(DataAccess, String, String, String)
	 */
	public static final int INDEX_MAX_SOCRE = 0;
	/**
	 * getTotalMaxMinScores\bh̖߂lōŏ_CfbNXB
	 * @see #getTotalMaxMinScores(DataAccess, String, String, String)
	 */
	public static final int INDEX_MIN_SOCRE = 1;

	/**
	 * J̍őTCYB
	 */
	public static final int COLUMN_SIZE_MAX;

	/**
	 * J̍őTCYB
	 */
	public static final int COLUMN_SIZE_UNIT;
	
//	ADD start 2006.11.22 T.Kiyokawa

	/** 
	CSVEԍFSCOXe[^X
	 */
	public static final int CSVCOL_AT_COMP_STATUS = 4 ;


	/** 
	CSVEԍFKςݓ_
	 */
	public static final int CSVCOL_AT_SCORE_SCALED = 5 ;


	/** 
	CSVEԍF_
	 */
	public static final int CSVCOL_AT_SCORE_RAW = 6 ;


	/** 
	CSVEԍFő哾_ 
	 */
	public static final int CSVCOL_AT_SCORE_MAX = 7 ;


	/** 
	CSVEԍFŏ_ 
	 */
	public static final int CSVCOL_AT_SCORE_MIN = 8 ;


	/** 
	CSVEԍFZbV^C
	 */
	public static final int CSVCOL_AT_SESSION_TIME = 9 ;


	/** 
	CSVEԍFSCOitO
	 */
	public static final int CSVCOL_AT_SUCCESS_STATUS = 10 ;


	/** 
	CSVEԍFwK 
	 */
	public static final int CSVCOL_AT_LOCATION = 11 ;


	/** 
	CSVEԍFޏoR 
	 */
	public static final int CSVCOL_AT_EXIT = 12 ;
	
//  ADD end
	
	/**
	 * X^eBbNECjVCUB
	 * f[^x[X̎ʂɊÂAJ̍őTCY萔肵܂B
	 */
	static {
		// f[^x[XɂăJTCYETCYʂݒ
		int columnSizeMax = 0;
		int columnSizeUnit = 0;
		try {
			Environment environment = new Environment();
			String dbType = environment.getDBType();
			if (dbType.equals(Environment.DB_SQLSERVER)) {
				columnSizeMax = 0;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_SQLSERVER;
			}
			else if (dbType.equals(Environment.DB_ORACLE)) {
				columnSizeMax = 0;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_ORACLE;
			}
			else if (dbType.equals(Environment.DB_POSTGRE)) {
				columnSizeMax = 0;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_POSTGRE;
			}
		}
		catch (Exception e) {
		}
		COLUMN_SIZE_MAX = columnSizeMax;
		COLUMN_SIZE_UNIT = columnSizeUnit;
	}

	/**
	 * RXgN^
	 **/
	public ScormAttemptDataAccess() {
		super( TABLE_NAME );
	}

	// Add Start T.Kiyokawa 2006.11.24

	/**
	 * ScormAttempte[uւ݂̏s܂B<br>
	 * &lt;attempt&gt;vfƂɌĂяoAR[hǉ܂B<br>
	 *
	 * @param dataAccess f[^ANZXNXB
	 * @param endLearnData wKIB
	 * @param attemptCSV attemptsCSVf[^
	 * @param activityID f[^ޑΏۂĂANeBreBIDB
	 * @param attemptCount s񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
	 * @param learnSessionCount LearnZbV񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
	 * @param learnSessionDate LearnZbV񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnsession&gt;vfdatelB
	 *
	 * @throws LOException f[^x[Xւ̏ɎsꍇB
	 */
	public static void insert(
		DataAccess dataAccess,
		ScormLoEndLearnData endLearnData,
		ScormLoCsvData attemptCSV,
		String activityID,
		int attemptCount,
		int learnSessionCount,
		String learnSessionDate)
		throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"HEAD insert("
				+ "dataAccess,endLearnData"
				+ "," + attemptCSV + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + learnSessionDate + ")",
			DebugLog.ROW);

		try {
			////////////////////////////////////////////////////////////////////
			// eJ̒l擾
			//==================================================================
			// Jƒl̃}bv
			ScormColumnInfo[] columnInfos =
				makeColumnInfos(
					endLearnData, attemptCSV,
					activityID,	attemptCount,
					learnSessionCount, learnSessionDate);
			////////////////////////////////////////////////////////////////////
			// SQL̐
			String query =
				ScormLoUtil.makeInsertQuery(TABLE_NAME, columnInfos);
			////////////////////////////////////////////////////////////////////
			// SQL̎s
			dataAccess.execute(query.toString());
		}
		catch (LOException e) {
			throw e;
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL insert("
				+ "dataAccess,endLearnData"
				+ "," + attemptCSV + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + learnSessionDate + ")",
			DebugLog.ROW);
	}

	/**
	 * ScormAttemte[ũJz𐶐܂B<br>
	 * @param endLearnData wKIB
	 * @param attemptCSV &lt;attempt&gt;CSVf[^B
	 * @param activityID f[^ޑΏۂĂANeBreBIDB
	 * @param attemptCount s񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
	 * @param learnSessionCount LearnZbV񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
	 * @param learnSessionDate LearnZbV񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnsession&gt;vfdatelB
	 *
	 * @return ScormAttemte[ũJzB
	 * @throws LOException m[hŃf[^擾sꍇB
	 */
	private static ScormColumnInfo[] makeColumnInfos(
		ScormLoEndLearnData endLearnData,
		ScormLoCsvData attemptCSV,
		String activityID,
		int attemptCount,
		int learnSessionCount,
		String learnSessionDate)
		throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"HEAD makeColumnInfos(endLearnData"
				+ "," + attemptCSV
				+ "," + activityID + "," + attemptCount
				+ "," + learnSessionCount + "," + learnSessionDate + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		ScormColumnInfo[] columnInfos = null;
		// z񐶐pXg
		List columnInfoList = new ArrayList();
		try {
			////////////////////////////////////////////////////////////////////
			// endLearnData擾łf[^JƂĐݒ
			//==================================================================
			// [UID
			String userID = endLearnData.getUserID();
			ScormColumnInfo userIDColumn =
				new ScormColumnInfo(USERID, userID,
					ScormColumnInfo.COLUMN_TYPE_STRING,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(userIDColumn);
			// LOID
			String loID = endLearnData.getLoID();
			ScormColumnInfo loIDColumn =
				new ScormColumnInfo(LOID, loID,
					ScormColumnInfo.COLUMN_TYPE_STRING,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(loIDColumn);
			// wKZbV
			int studySessionCount = endLearnData.getStudySession();
			ScormColumnInfo studySessionCountColumn =
				new ScormColumnInfo(
					STUDY_SESSION_COUNT,
					Integer.toString(studySessionCount),
					ScormColumnInfo.COLUMN_TYPE_NUMBER,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(studySessionCountColumn);
			// ZbVID(OCZbV)
			int sessionID = endLearnData.getLoginSession();
			ScormColumnInfo sessionIDColumn =
				new ScormColumnInfo(
					SESSIONID, Integer.toString(sessionID),
					ScormColumnInfo.COLUMN_TYPE_STRING,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(sessionIDColumn);
			////////////////////////////////////////////////////////////////////
			// endLearnDataANodeȊO擾łf[^JƂĐݒ
			//==================================================================
			// ANeBreBID
			ScormColumnInfo activityIDColumn =
				new ScormColumnInfo(
					ACTIVITYID, activityID,
					ScormColumnInfo.COLUMN_TYPE_STRING,
					ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_MAX,
					ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_UNIT);
			columnInfoList.add(activityIDColumn);
			// s
			ScormColumnInfo attemptCountColumn =
				new ScormColumnInfo(
					ATTEMPT_COUNT, Integer.toString(attemptCount),
					ScormColumnInfo.COLUMN_TYPE_NUMBER,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(attemptCountColumn);
			// LearnZbV
			ScormColumnInfo learnSessionCountColumn =
				new ScormColumnInfo(
					LEARN_SESSION_COUNT, Integer.toString(learnSessionCount),
					ScormColumnInfo.COLUMN_TYPE_NUMBER,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(learnSessionCountColumn);
			// wKJn(SCORMT[otDBpɏϊ)
			Date sessionDate =
					ScormLoUtil.convertScormServerFormatToDate(
						learnSessionDate);
			String learnSessionDateForDB =
					ScormLoUtil.convertDateToDbFormat(sessionDate);
			ScormColumnInfo learnSessionDateColumn =
				new ScormColumnInfo(
					LEARNSESSION_DATE, learnSessionDateForDB,
					ScormColumnInfo.COLUMN_TYPE_DATETIME,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(learnSessionDateColumn);
			////////////////////////////////////////////////////////////////////
			// Node擾łf[^JƂĐݒ
			//==================================================================
			List columnInfoFromNodeList = makeColumnInfosFromCSV(attemptCSV);
			columnInfoList.addAll(columnInfoFromNodeList);
			////////////////////////////////////////////////////////////////////
			// Xgzɕϊ
			columnInfos = new ScormColumnInfo[ columnInfoList.size() ];
			columnInfoList.toArray(columnInfos);

		}
		catch (LOException e) {
			throw e;
		}

		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL makeColumnInfos(endLearnData"
				+ "," + attemptCSV
				+ "," + activityID + "," + attemptCount
				+ "," + learnSessionCount + "," + learnSessionDate + ")"
				+ (" return " + columnInfos),
			DebugLog.ROW);
		return columnInfos;
	}


	/**
	 * ScormAttempte[ũJz𐶐܂B<br>
	 * &lt;attempt&gt;CSV擾łXgƂĖ߂܂B
	 * @param attemptCSV &lt;attempt&gt;vf\CSVB
	 *
	 * @return ScormAttemte[ũJvfƂListB
	 * @throws LOException m[hŃf[^擾sꍇB
	 */
	private static List makeColumnInfosFromCSV(
		ScormLoCsvData attemptCSV)
		throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"HEAD makeColumnInfosFromCSV(" + attemptCSV + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		List columnInfoList = new ArrayList();
		try {
			////////////////////////////////////////////////////////////////////
			// Node擾łf[^JƂĐݒ
			//==================================================================
			// Xe[^X
			String completionStatus =
				attemptCSV.getData(CSVCOL_AT_COMP_STATUS) ;
			if (completionStatus != null) {
				ScormColumnInfo completionStatusColumn =
					new ScormColumnInfo(
						COMPLETION_STATUS, completionStatus,
						ScormColumnInfo.COLUMN_TYPE_STRING,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(completionStatusColumn);
			}
			// Kςݓ_
			String scaledScore =
				attemptCSV.getData(CSVCOL_AT_SCORE_SCALED) ;
			if (scaledScore != null) {
				ScormColumnInfo scaledScoreColumn =
					new ScormColumnInfo(
						SCALED_SCORE, scaledScore,
						ScormColumnInfo.COLUMN_TYPE_NUMBER,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(scaledScoreColumn);
			}
			// _
			String rawScore =
				attemptCSV.getData(CSVCOL_AT_SCORE_RAW) ;
			if (rawScore != null) {
				ScormColumnInfo rawScoreColumn =
					new ScormColumnInfo(RAWSCORE, rawScore,
						ScormColumnInfo.COLUMN_TYPE_NUMBER,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(rawScoreColumn);
			}
			// ō_
			String maxScore =
				attemptCSV.getData(CSVCOL_AT_SCORE_MAX) ;
			if (maxScore != null) {
				ScormColumnInfo maxScoreColumn =
					new ScormColumnInfo(MAXSCORE, maxScore,
						ScormColumnInfo.COLUMN_TYPE_NUMBER,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(maxScoreColumn);
			}
			// Œᓾ_
			String minScore =
				attemptCSV.getData(CSVCOL_AT_SCORE_MIN) ;
			if (minScore != null) {
				ScormColumnInfo minScoreColumn =
					new ScormColumnInfo(MINSCORE, minScore,
						ScormColumnInfo.COLUMN_TYPE_NUMBER,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(minScoreColumn);
			}
			// ؍ݎ
			String attemptSessionTimeDuration =
				attemptCSV.getData(CSVCOL_AT_SESSION_TIME) ;
			if (attemptSessionTimeDuration != null) {
				// Durationbɕϊ
				double attemptSessionTime =
					ScormLoUtil.parseDuration(attemptSessionTimeDuration);
				ScormColumnInfo attemptSessionTimeColumn =
					new ScormColumnInfo(
						ATTEMPT_SESSION_TIME,
						Double.toString(attemptSessionTime),
						ScormColumnInfo.COLUMN_TYPE_STRING,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(attemptSessionTimeColumn);
			}
			// iXe[^X
			String successStatus =
				attemptCSV.getData(CSVCOL_AT_SUCCESS_STATUS) ;
			if (successStatus != null) {
				ScormColumnInfo successStatusColumn =
					new ScormColumnInfo(
						SUCCESS_STATUS, successStatus,
						ScormColumnInfo.COLUMN_TYPE_STRING,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(successStatusColumn);
			}
			// P[V
			String location =
				attemptCSV.getData(CSVCOL_AT_LOCATION) ;
			if (location != null) {
				ScormColumnInfo locationColumn =
					new ScormColumnInfo(
						LOCATION, location,
						ScormColumnInfo.COLUMN_TYPE_STRING,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(locationColumn);
			}
			// wKI
			String exit =
				attemptCSV.getData(CSVCOL_AT_EXIT) ;
			if (exit != null) {
				ScormColumnInfo exitColumn =
					new ScormColumnInfo(
						EXIT, exit,
						ScormColumnInfo.COLUMN_TYPE_STRING,
						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(exitColumn);
			}
		}
		catch (LOException e) {
			throw e;
		}

		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL makeColumnInfosFromCSV(" + attemptCSV + ")"
				+ (" return " + columnInfoList),
			DebugLog.ROW);
		return columnInfoList;
	}
	// Add End
	
	// CommentOut Start 2006.11.24 T.Kiyokawa(CSVΉ̂)
//	/**
//	 * ScormAttempte[uւ݂̏s܂B<br>
//	 * &lt;attempt&gt;vfƂɌĂяoAR[hǉ܂B<br>
//	 *
//	 * @param dataAccess f[^ANZXNXB
//	 * @param endLearnData wKIB
//	 * @param attemptNode &lt;attempt&gt;vf\m[hB
//	 * @param activityID f[^ޑΏۂĂANeBreBIDB
//	 * @param attemptCount s񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnSessionCount LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnSessionDate LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnsession&gt;vfdatelB
//	 *
//	 * @throws LOException f[^x[Xւ̏ɎsꍇB
//	 */
//	public static void insert(
//		DataAccess dataAccess,
//		ScormLoEndLearnData endLearnData,
//		Node attemptNode,
//		String activityID,
//		int attemptCount,
//		int learnSessionCount,
//		String learnSessionDate)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormAttemptDataAccess.class,
//			"HEAD insert("
//				+ "dataAccess,endLearnData"
//				+ "," + attemptNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + learnSessionDate + ")",
//			DebugLog.ROW);
//
//		try {
//			////////////////////////////////////////////////////////////////////
//			// eJ̒l擾
//			//==================================================================
//			// Jƒl̃}bv
//			ScormColumnInfo[] columnInfos =
//				makeColumnInfos(
//					endLearnData, attemptNode,
//					activityID,	attemptCount,
//					learnSessionCount, learnSessionDate);
//			////////////////////////////////////////////////////////////////////
//			// SQL̐
//			String query =
//				ScormLoUtil.makeInsertQuery(TABLE_NAME, columnInfos);
//			////////////////////////////////////////////////////////////////////
//			// SQL̎s
//			dataAccess.execute(query.toString());
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		catch (SQLException e) {
//			DebugLog.write(ScormAttemptDataAccess.class, e, DebugLog.HIGHT);
//			throw new LOException(e.getMessage());
//		}
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormAttemptDataAccess.class,
//			"TAIL insert("
//				+ "dataAccess,endLearnData"
//				+ "," + attemptNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + learnSessionDate + ")",
//			DebugLog.ROW);
//	}
//
//	/**
//	 * ScormAttemte[ũJz𐶐܂B<br>
//	 * @param endLearnData wKIB
//	 * @param attemptNode &lt;attempt&gt;vf\m[hB
//	 * @param activityID f[^ޑΏۂĂANeBreBIDB
//	 * @param attemptCount s񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnSessionCount LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnSessionDate LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnsession&gt;vfdatelB
//	 *
//	 * @return ScormAttemte[ũJzB
//	 * @throws LOException m[hŃf[^擾sꍇB
//	 */
//	private static ScormColumnInfo[] makeColumnInfos(
//		ScormLoEndLearnData endLearnData,
//		Node attemptNode,
//		String activityID,
//		int attemptCount,
//		int learnSessionCount,
//		String learnSessionDate)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormAttemptDataAccess.class,
//			"HEAD makeColumnInfos(endLearnData"
//				+ "," + attemptNode
//				+ "," + activityID + "," + attemptCount
//				+ "," + learnSessionCount + "," + learnSessionDate + ")",
//			DebugLog.ROW);
//
//		// ̃\bh̖߂l
//		ScormColumnInfo[] columnInfos = null;
//		// z񐶐pXg
//		List columnInfoList = new ArrayList();
//		try {
//			////////////////////////////////////////////////////////////////////
//			// endLearnData擾łf[^JƂĐݒ
//			//==================================================================
//			// [UID
//			String userID = endLearnData.getUserID();
//			ScormColumnInfo userIDColumn =
//				new ScormColumnInfo(USERID, userID,
//					ScormColumnInfo.COLUMN_TYPE_STRING,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(userIDColumn);
//			// LOID
//			String loID = endLearnData.getLoID();
//			ScormColumnInfo loIDColumn =
//				new ScormColumnInfo(LOID, loID,
//					ScormColumnInfo.COLUMN_TYPE_STRING,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(loIDColumn);
//			// wKZbV
//			int studySessionCount = endLearnData.getStudySession();
//			ScormColumnInfo studySessionCountColumn =
//				new ScormColumnInfo(
//					STUDY_SESSION_COUNT,
//					Integer.toString(studySessionCount),
//					ScormColumnInfo.COLUMN_TYPE_NUMBER,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(studySessionCountColumn);
//			// ZbVID(OCZbV)
//			int sessionID = endLearnData.getLoginSession();
//			ScormColumnInfo sessionIDColumn =
//				new ScormColumnInfo(
//					SESSIONID, Integer.toString(sessionID),
//					ScormColumnInfo.COLUMN_TYPE_STRING,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(sessionIDColumn);
//			////////////////////////////////////////////////////////////////////
//			// endLearnDataANodeȊO擾łf[^JƂĐݒ
//			//==================================================================
//			// ANeBreBID
//			ScormColumnInfo activityIDColumn =
//				new ScormColumnInfo(
//					ACTIVITYID, activityID,
//					ScormColumnInfo.COLUMN_TYPE_STRING,
//					ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_MAX,
//					ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_UNIT);
//			columnInfoList.add(activityIDColumn);
//			// s
//			ScormColumnInfo attemptCountColumn =
//				new ScormColumnInfo(
//					ATTEMPT_COUNT, Integer.toString(attemptCount),
//					ScormColumnInfo.COLUMN_TYPE_NUMBER,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(attemptCountColumn);
//			// LearnZbV
//			ScormColumnInfo learnSessionCountColumn =
//				new ScormColumnInfo(
//					LEARN_SESSION_COUNT, Integer.toString(learnSessionCount),
//					ScormColumnInfo.COLUMN_TYPE_NUMBER,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(learnSessionCountColumn);
//			// wKJn(SCORMT[otDBpɏϊ)
//			Date sessionDate =
//					ScormLoUtil.convertScormServerFormatToDate(
//						learnSessionDate);
//			String learnSessionDateForDB =
//					ScormLoUtil.convertDateToDbFormat(sessionDate);
//			ScormColumnInfo learnSessionDateColumn =
//				new ScormColumnInfo(
//					LEARNSESSION_DATE, learnSessionDateForDB,
//					ScormColumnInfo.COLUMN_TYPE_DATETIME,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(learnSessionDateColumn);
//			////////////////////////////////////////////////////////////////////
//			// Node擾łf[^JƂĐݒ
//			//==================================================================
//			List columnInfoFromNodeList = makeColumnInfosFromNode(attemptNode);
//			columnInfoList.addAll(columnInfoFromNodeList);
//			////////////////////////////////////////////////////////////////////
//			// Xgzɕϊ
//			columnInfos = new ScormColumnInfo[ columnInfoList.size() ];
//			columnInfoList.toArray(columnInfos);
//
//		}
//		catch (LOException e) {
//			throw e;
//		}
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormAttemptDataAccess.class,
//			"TAIL makeColumnInfos(endLearnData"
//				+ "," + attemptNode
//				+ "," + activityID + "," + attemptCount
//				+ "," + learnSessionCount + "," + learnSessionDate + ")"
//				+ (" return " + columnInfos),
//			DebugLog.ROW);
//		return columnInfos;
//	}
//
//
//	/**
//	 * ScormAttempte[ũJz𐶐܂B<br>
//	 * &lt;attempt&gt;vfm[h擾łXgƂĖ߂܂B
//	 * @param attemptNode &lt;attempt&gt;vf\m[hB
//	 *
//	 * @return ScormAttemte[ũJvfƂListB
//	 * @throws LOException m[hŃf[^擾sꍇB
//	 */
//	private static List makeColumnInfosFromNode(
//		Node attemptNode)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormAttemptDataAccess.class,
//			"HEAD makeColumnInfosFromNode(" + attemptNode + ")",
//			DebugLog.ROW);
//
//		// ̃\bh̖߂l
//		List columnInfoList = new ArrayList();
//		try {
//			////////////////////////////////////////////////////////////////////
//			// Node擾łf[^JƂĐݒ
//			//==================================================================
//			// Xe[^X
//			String completionStatus =
//				ScormLoUtil.getNodeValue(
//					attemptNode, PATH_COMPLETION_STATUS_VALUE);
//			if (completionStatus != null) {
//				ScormColumnInfo completionStatusColumn =
//					new ScormColumnInfo(
//						COMPLETION_STATUS, completionStatus,
//						ScormColumnInfo.COLUMN_TYPE_STRING,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(completionStatusColumn);
//			}
//			// Kςݓ_
//			String scaledScore =
//				ScormLoUtil.getNodeValue(attemptNode, PATH_SCALED_SCORE_VALUE);
//			if (scaledScore != null) {
//				ScormColumnInfo scaledScoreColumn =
//					new ScormColumnInfo(
//						SCALED_SCORE, scaledScore,
//						ScormColumnInfo.COLUMN_TYPE_NUMBER,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(scaledScoreColumn);
//			}
//			// _
//			String rawScore =
//				ScormLoUtil.getNodeValue(attemptNode, PATH_RAW_SCORE_VALUE);
//			if (rawScore != null) {
//				ScormColumnInfo rawScoreColumn =
//					new ScormColumnInfo(RAWSCORE, rawScore,
//						ScormColumnInfo.COLUMN_TYPE_NUMBER,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(rawScoreColumn);
//			}
//			// ō_
//			String maxScore =
//				ScormLoUtil.getNodeValue(attemptNode, PATH_MAX_SCORE_VALUE);
//			if (maxScore != null) {
//				ScormColumnInfo maxScoreColumn =
//					new ScormColumnInfo(MAXSCORE, maxScore,
//						ScormColumnInfo.COLUMN_TYPE_NUMBER,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(maxScoreColumn);
//			}
//			// Œᓾ_
//			String minScore =
//				ScormLoUtil.getNodeValue(attemptNode, PATH_MIN_SCORE_VALUE);
//			if (minScore != null) {
//				ScormColumnInfo minScoreColumn =
//					new ScormColumnInfo(MINSCORE, minScore,
//						ScormColumnInfo.COLUMN_TYPE_NUMBER,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(minScoreColumn);
//			}
//			// ؍ݎ
//			String attemptSessionTimeDuration =
//				ScormLoUtil.getNodeValue(
//					attemptNode, PATH_ATTEMPT_SESSION_TIME_VALUE);
//			if (attemptSessionTimeDuration != null) {
//				// Durationbɕϊ
//				double attemptSessionTime =
//					ScormLoUtil.parseDuration(attemptSessionTimeDuration);
//				ScormColumnInfo attemptSessionTimeColumn =
//					new ScormColumnInfo(
//						ATTEMPT_SESSION_TIME,
//						Double.toString(attemptSessionTime),
//						ScormColumnInfo.COLUMN_TYPE_STRING,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(attemptSessionTimeColumn);
//			}
//			// iXe[^X
//			String successStatus =
//				ScormLoUtil.getNodeValue(
//					attemptNode, PATH_SUCCESS_STATUS_VALUE);
//			if (successStatus != null) {
//				ScormColumnInfo successStatusColumn =
//					new ScormColumnInfo(
//						SUCCESS_STATUS, successStatus,
//						ScormColumnInfo.COLUMN_TYPE_STRING,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(successStatusColumn);
//			}
//			// P[V
//			String location =
//				ScormLoUtil.getNodeValue(attemptNode, PATH_LOCATION_VALUE);
//			if (location != null) {
//				ScormColumnInfo locationColumn =
//					new ScormColumnInfo(
//						LOCATION, location,
//						ScormColumnInfo.COLUMN_TYPE_STRING,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(locationColumn);
//			}
//			// wKI
//			String exit =
//				ScormLoUtil.getNodeValue(attemptNode, PATH_EXIT_VALUE);
//			if (exit != null) {
//				ScormColumnInfo exitColumn =
//					new ScormColumnInfo(
//						EXIT, exit,
//						ScormColumnInfo.COLUMN_TYPE_STRING,
//						COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(exitColumn);
//			}
//		}
//		catch (LOException e) {
//			throw e;
//		}
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormAttemptDataAccess.class,
//			"TAIL makeColumnInfosFromNode(" + attemptNode + ")"
//				+ (" return " + columnInfoList),
//			DebugLog.ROW);
//		return columnInfoList;
//	}
	// CommentOut End 

	/**
	 * ނ̍ő哾_Eŏ_̍vl擾܂B<br>
	 * w肳ꂽ[UIDALOIDAZbVIDɊY郌R[hA
	 * ANeBreBƂ̍ő哾_Eŏ_擾A
	 * ő哾_Eŏ_ꂼ̍vlzƂĖ߂܂B<br>
	 * źAvfQŁA擪珇ɍő哾_vAŏ_vƂȂ܂B
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param sessionID ZbVIDiN񐔁jB
	 * @return ȉ̔z߂܂B
	 * 	<table border="1">
	 * 		<tr>
	 * 			<th>CfbNX</th>
	 * 			<th>vf</th>
	 * 		</tr>
	 * 		<tr>
	 * 			<td>INDEX_MAX_SOCRE</td>
	 * 			<td>ő哾_v</td>
	 * 		</tr>
	 * 		<tr>
	 * 			<td>INDEX_MIN_SOCRE</td>
	 * 			<td>ŏ_v</td>
	 * 		</tr>
	 * 	</table><br>
	 * @throws LOException f[^x[XANZXɎsꍇB
	 * @see #INDEX_MAX_SOCRE
	 * @see #INDEX_MIN_SOCRE
	 */
	public static double[] getTotalMaxMinScores(
		DataAccess dataAccess,
		String userID,
		String loID, String sessionID) throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"HEAD getTotalMaxMinScores("
				+ dataAccess + "," + userID
				+ "," + loID + "," + sessionID + ")",
			DebugLog.ROW);

		double totalMinSocre = 0.0;
		double totalMaxSocre = 0.0;
		ResultSet resultSet = null;
		boolean successFlag = false;
		try {
			////////////////////////////////////////////////////////////////////
			// NG[̐
			// =================================================================
			// w肳ꂽ[UIDALOIDAZbVIDɈv郌R[ĥ
			// ANeBreBʁi{[UIDʁALOIDʁAZbVIDʁjɁA
			// s񐔁ALearnZbV񐔂ől߁A
			// ꂼꂪv郌R[ĥ݂擾A
			// Y郌R[h̐K_̍vl߂܂B
			StringBuffer query = new StringBuffer();
			query.append( "SELECT" );
			// K_̍ől
			query.append( " SUM(sca.maxScaledScore)"
							+ " as maxScaledScore" );
			query.append( ",SUM(sca.minScaledScore)"
							+ " as minScaledScore" );
			query.append( " FROM" );
			// =================================================================
			// 񐔍ő̃R[hNG[
			query.append( "(" );
			query.append(     "SELECT" );
			query.append(     " " + ACTIVITYID + " as " + ACTIVITYID );
			query.append(     ",MAX(" + SCALED_SCORE + ") as maxScaledScore" );
			query.append(     ",MIN(" + SCALED_SCORE + ") as minScaledScore" );
			query.append(     " FROM " + TABLE_NAME );
			query.append(     " WHERE " + USERID + "='" + userID + "'" );
			query.append(     " AND " + LOID + "='" + loID + "'" );
			query.append(     " AND " + SESSIONID + "='" + sessionID + "'" );
			query.append(     " GROUP BY " + ACTIVITYID );
			query.append( ") sca" );
			////////////////////////////////////////////////////////////////////
			// NG[s
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			resultSet = dataAccess.executeQuery(queryString);
			////////////////////////////////////////////////////////////////////
			// R[h擾
			// 擾_͐KꂽlȂ̂100|B
			if (resultSet.next()) {
				totalMaxSocre = resultSet.getDouble("maxScaledScore");
				totalMaxSocre *= 100.0;
				totalMinSocre = resultSet.getDouble("minScaledScore");
				totalMinSocre *= 100.0;
			}
			// tryubN̍Ō܂œB琬B
			successFlag = true;
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		finally {
			// ʃZbg̃N[Y
			// OꍇA܂܂ŗOȂƂɂ݃X[B
			if (resultSet != null) {
				try {
					resultSet.close();
				}
				catch (SQLException e) {
					DebugLog.write(ScormAttemptDataAccess.class,
						e, DebugLog.HIGHT);
					if (successFlag) {
						throw new LOException(e.getMessage());
					}
				}
			}
		}
		// 擾f[^̔z
		double[] scores = new double[MAX_MIN_SCORES_LENGTH];
		scores[INDEX_MAX_SOCRE] = totalMaxSocre;
		scores[INDEX_MIN_SOCRE] = totalMinSocre;
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL getTotalLatestScore("
				+ dataAccess + "," + userID
				+ "," + loID + "," + sessionID + ")"
				+ " return " + scores
				+ "(" + totalMaxSocre + "," + totalMinSocre + ")",
			DebugLog.ROW);
		return scores;
	}

	/**
	 * ANeBreBƂ̖_̍vl߂܂B<br>
	 *
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param sessionID ZbVIDiN񐔁jB
	 * @return w肳ꂽ[UIDALOIDAZbVIDɊY郌R[hA
	 *          K_܂܂ANeBreB100|l߂܂B
	 * @throws LOException f[^x[XANZXɎsꍇB
	 */
	public static int getTotalFullScore(
		DataAccess dataAccess,
		String userID, String loID, String sessionID) throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL getTotalFullScore("
				+ dataAccess + "," + userID
				+ "," + loID + "," + sessionID + ")",
			DebugLog.ROW);

		int totalFullSocre = 0;
		ResultSet resultSet = null;
		boolean successFlag = false;
		try {
			////////////////////////////////////////////////////////////////////
			// NG[̐
			// =================================================================
			// w肳ꂽ[UIDALOIDAZbVIDɈv郌R[ĥ
			// K_܂܂ANeBreB߂B
			// yNGCz_o͂ĂȂSCO܂܂Ă̂ŕύX܂ 2006/02/21 NTT-R m.kitahara
			StringBuffer query = new StringBuffer();
			//query.append( "SELECT count(*)"
			// 				+ " as activityCount" );
			//query.append( " FROM (" );
			// =================================================================
			// ANeBreBƂɐK_܂܂郌R[h
			// 擾NG[
			//query.append(     "SELECT" );
			//query.append(     " " + ACTIVITYID + " as " + ACTIVITYID );
			//query.append(     ",count(" + SCALED_SCORE + ")"
			//					+ " as " + SCALED_SCORE );
			//query.append(     " FROM " + TABLE_NAME );
			//query.append(     " WHERE " + USERID + "='" + userID + "'" );
			//query.append(     " AND " + LOID + "='" + loID + "'" );
			//query.append(     " AND " + SESSIONID + "='" + sessionID + "'" );
			//query.append(     " GROUP BY " + ACTIVITYID );
			//query.append( ") sca" );

			query.append( "SELECT COUNT(DISTINCT\"activityid\") AS activityCount" );
			query.append( " FROM Scorm_Attempt" );
			query.append( " WHERE UserID='" + userID + "'" );
			query.append( " AND LOID='" + loID + "'" );
			query.append( " AND ScaledScore IS NOT NULL" );

			////////////////////////////////////////////////////////////////////
			// NG[s
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			resultSet = dataAccess.executeQuery(queryString);
			////////////////////////////////////////////////////////////////////
			// R[h擾
			// 擾񐔂100|l𖞓_ƂB
			if (resultSet.next()) {
				totalFullSocre = resultSet.getInt("activityCount");
				totalFullSocre *= 100;
			}
			// tryubN̍Ō܂œB琬B
			successFlag = true;
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		finally {
			// ʃZbg̃N[Y
			// OꍇA܂܂ŗOȂƂɂ݃X[B
			if (resultSet != null) {
				try {
					resultSet.close();
				}
				catch (SQLException e) {
					DebugLog.write(ScormAttemptDataAccess.class,
						e, DebugLog.HIGHT);
					if (successFlag) {
						throw new LOException(e.getMessage());
					}
				}
			}
		}

		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"HEAD getTotalFullScore("
				+ dataAccess + "," + userID
				+ "," + loID + "," + sessionID + ")"
				+ " return " + totalFullSocre,
			DebugLog.ROW);
		return totalFullSocre;
	}

	/**
	 * ŐV̓_̍vl߂܂B<br>
	 *
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param sessionID ZbVIDiN񐔁jB
	 * @return w肳ꂽ[UIDALOIDAZbVIDɊY郌R[hA
	 *          K_݂ANeBreB񐔂100|l߂܂B
	 * @throws LOException f[^x[XANZXɎsꍇB
	 */
	public static double getTotalLatestScore(
		DataAccess dataAccess,
		String userID, String loID, String sessionID) throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL getTotalLatestScore("
				+ dataAccess + "," + userID
				+ "," + loID + "," + sessionID + ")",
			DebugLog.ROW);

		double totalLatestSocre = 0.0;
		ResultSet resultSet = null;
		boolean successFlag = false;
		try {
			////////////////////////////////////////////////////////////////////
			// NG[̐
			// =================================================================
			// w肳ꂽ[UIDALOIDAZbVIDɈv郌R[ĥ
			// ANeBreBʁi{[UIDʁALOIDʁAZbVIDʁjɁA
			// s񐔁ALearnZbV񐔂ől߁A
			// ꂼꂪv郌R[ĥ݂擾A
			// Y郌R[h̐K_̍vl߂܂B
			StringBuffer query = new StringBuffer();
			query.append("SELECT");
			// K_̍vl
			query.append(" SUM(sca." + SCALED_SCORE + ")"
							+ " as totalScore");
			query.append(" FROM " + TABLE_NAME + " sca");
			query.append(" INNER JOIN");
			// =================================================================
			// SCOƂ̎s񐔂̒LearnZbV񐔍őƂȂ
			// R[hNG[
			query.append("(");
			query.append(    "SELECT");
			query.append(    " sca1." + USERID + " as " + USERID);
			query.append(    ",sca1." + LOID + " as " + LOID);
			query.append(    ",sca1." + ACTIVITYID + " as " + ACTIVITYID);
			query.append(    ",sca1." + SESSIONID + " as " + SESSIONID);
			query.append(    ",sca1." + ATTEMPT_COUNT + " as " + ATTEMPT_COUNT);
			query.append(    ",max(sca1." + LEARN_SESSION_COUNT + ")"
									+ " as " + LEARN_SESSION_COUNT);
			query.append(    " FROM " + TABLE_NAME + " sca1");
			query.append(    " INNER JOIN");
			query.append(    "(");
			// SCOƂ̎s񐔍ől擾NG[
			query.append(        "SELECT");
			query.append(        " " + USERID + " as " + USERID);
			query.append(        "," + LOID + " as " + LOID);
			query.append(        "," + ACTIVITYID + " as " + ACTIVITYID);
			query.append(        "," + SESSIONID + " as " + SESSIONID);
			query.append(        ",max(" + ATTEMPT_COUNT + ")"
										+ " as " + ATTEMPT_COUNT);
			query.append(        " FROM " + TABLE_NAME);
			query.append(        " WHERE " + USERID + "='" + userID + "'");
			query.append(        " AND " + LOID + "='" + loID + "'");
			query.append(        " AND " + SESSIONID + "='" + sessionID + "'");
			query.append(        " GROUP BY");
			query.append(        " " + USERID);
			query.append(        "," + LOID);
			query.append(        "," + ACTIVITYID);
			query.append(        "," + SESSIONID);
			query.append(    ") lsa1");
			// SCOƂ̎s񐔍ől擾NG[Ƃ̌
			query.append(    " ON sca1." + USERID + "=lsa1." + USERID);
			query.append(    " AND sca1." + LOID
									+ "=lsa1." + LOID);
			query.append(    " AND sca1." + SESSIONID
									+ "=lsa1." + SESSIONID);
			query.append(    " AND sca1." + ACTIVITYID
									+ "=lsa1." + ACTIVITYID);
			query.append(    " AND sca1." + ATTEMPT_COUNT
									+ "=lsa1." + ATTEMPT_COUNT);
			query.append(    " GROUP BY");
			query.append(    " sca1." + USERID);
			query.append(    ",sca1." + LOID);
			query.append(    ",sca1." + ACTIVITYID);
			query.append(    ",sca1." + SESSIONID);
			query.append(    ",sca1." + ATTEMPT_COUNT);
			query.append(") lsa");
			// =================================================================
			// NG[Ƃ̌
			query.append(" ON sca." + USERID + "=lsa." + USERID);
			query.append(" AND sca." + LOID
								+ "=lsa." + LOID);
			query.append(" AND sca." + SESSIONID
								+ "=lsa." + SESSIONID);
			query.append(" AND sca." + ACTIVITYID
								+ "=lsa." + ACTIVITYID);
			query.append(" AND sca." + ATTEMPT_COUNT
								+ "=lsa." + ATTEMPT_COUNT);
			query.append(" AND sca." +  LEARN_SESSION_COUNT
								+ "=lsa." + LEARN_SESSION_COUNT);
			////////////////////////////////////////////////////////////////////
			// NG[s
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			resultSet = dataAccess.executeQuery(queryString);
			////////////////////////////////////////////////////////////////////
			// R[h擾
			// 擾_͐KꂽlȂ̂100|B
			if (resultSet.next()) {
				totalLatestSocre = resultSet.getDouble("totalScore");
				totalLatestSocre *= 100.0;
			}
			// tryubN̍Ō܂œB琬B
			successFlag = true;
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		finally {
			// ʃZbg̃N[Y
			// OꍇA܂܂ŗOȂƂɂ݃X[B
			if (resultSet != null) {
				try {
					resultSet.close();
				}
				catch (SQLException e) {
					DebugLog.write(ScormAttemptDataAccess.class,
						e, DebugLog.HIGHT);
					if (successFlag) {
						throw new LOException(e.getMessage());
					}
				}
			}
		}

		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL getTotalLatestScore("
				+ dataAccess + "," + userID
				+ "," + loID + "," + sessionID + ")"
				+ " return " + totalLatestSocre,
			DebugLog.ROW);
		return totalLatestSocre;
	}

	/**
	 * w肳ꂽ[UAނ̑gݍ킹̃O폜܂B
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param userID 폜Ώۂ̃[UIDB
	 * @param loID 폜Ώۂ̋ނLOIDB
	 * @throws LOException f[^x[XANZXɗOꍇB
	 */
	public static void delete(
		DataAccess dataAccess, String userID, String loID)
		throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"HEAD delete(" + dataAccess + "," + userID + "," + loID + ")",
			DebugLog.ROW);
		try {
			// WHERE̐
			StringBuffer queryWhere = new StringBuffer();
			if (loID != null) {
				queryWhere.append(" and " + LOID + "='" + loID + "'" );
			}
			if (userID != null) {
				queryWhere.append(" and " + USERID + "='" + userID + "'" );
			}
			// 폜NG̐
			StringBuffer query = new StringBuffer();
			query.append("delete from " + TABLE_NAME );
			if (queryWhere.length() > 0) {
				query.append(" where " + queryWhere.substring(5) );
			}
			// 폜NG̎s
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			dataAccess.execute(queryString);
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class,
				e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL delete(" + dataAccess + "," + userID + "," + loID + ")",
			DebugLog.ROW);
	}


	/**
	 * LearnZbV񐔍ől擾܂B<br>
	 * w肵[UIDALOIDAwK񐔂̑gݍ킹ŁA
	 * ANeBreBʂɍő厎s񐔂̍őLearnZbV񐔂
	 * ̂QzƂĖ߂܂B
	 * Y郌R[h݂ȂꍇAvfO̔z߂܂B
	 * <br>
	 * @param dataAccess f[^ANZXIuWFNgB
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param studySession wK񐔁iJn|IłPPʂ̉񐔁j
	 * @return ȉ̂PzvfƂz߂܂B
	 * <table border="1">
	 * 	<tr>
	 * 		<th>CfbNX</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">0</td>
	 * 		<td>ANeBreBID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">1</td>
	 * 		<td>ANeBreB̒ōő̎s</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">2</td>
	 * 		<td>
	 * 			ANeBreB̒ōő̎s񐔂̒
	 * 			őLearnZbV
	 * 		</td>
	 * 	</tr>
	 * </table>
	 * <br>
	 * @throws LOException if[^x[XANZXjɃG[ꍇB
	 */
	public static String[][] getMaxLearnSessionCount(
			DataAccess dataAccess, String userID,
			String loID, int studySession)
			throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"HEAD getMaxLearnSessionCount("
				+ dataAccess + "," + userID
				+ "," + loID + "," + studySession + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		String[][] matrix = null;
		// NGʃZbg
		ResultSet resultSet = null;
		// tryubNɗOĂȂtOitrueOȂj
		boolean successFlag = false;
		try {
			////////////////////////////////////////////////////////////////////
			// NG̐
			StringBuffer query = new StringBuffer();
			query.append("select");
			// ANeBreBID
			query.append(" a." + ACTIVITYID + " as " + ACTIVITYID);
			// ő厎s
			query.append(",a." + ATTEMPT_COUNT + " as " + ATTEMPT_COUNT);
			// ̒̍őLearnZbV
			query.append(",max(a." + LEARN_SESSION_COUNT + ")"
							+ " as " + LEARN_SESSION_COUNT);
			query.append(" from " + TABLE_NAME + " a");
			query.append(" inner join (");
			// =================================================================
			// ő厎s񐔂擾邽߂̃TuNG
			query.append(	"select");
			query.append(	" " + USERID + " as " + USERID);
			query.append(	"," + LOID + " as " + LOID);
			query.append(	"," + STUDY_SESSION_COUNT);
			query.append(			" as " + STUDY_SESSION_COUNT);
			query.append(	"," + ACTIVITYID + " as " + ACTIVITYID);
			query.append(	",max(" + ATTEMPT_COUNT + ") as " + ATTEMPT_COUNT);
			query.append(	" from " + TABLE_NAME);
			// TuNGł̏
			// w肳ꂽ[UIDALOIDAwK񐔂ƈv郌R[h
			query.append(	" where " + USERID + "='" + userID + "'");
			query.append(	" and " + LOID + "='" + loID + "'");
			query.append(	" and " + STUDY_SESSION_COUNT );
			query.append(		"=" + studySession );
			// TuNGmax(AttemptCount)gp邽߂group by
			query.append(	" group by ");
			query.append(	" " + USERID);
			query.append(	"," + LOID);
			query.append(	"," + STUDY_SESSION_COUNT);
			query.append(	"," + ACTIVITYID);
			query.append(") b");
			// =================================================================
			// TuNGƂ̌
			// [UIDALOIDAwK񐔁AANeBreBIDvāA
			// s񐔂ől̃R[h
			query.append(" on a." + USERID + "=b." + USERID );
			query.append(" and a." + LOID + "=b." + LOID );
			query.append(" and a." + STUDY_SESSION_COUNT );
			query.append(		"=b." + STUDY_SESSION_COUNT );
			query.append(" and a." + ACTIVITYID + "=b." + ACTIVITYID );
			query.append(" and a." + ATTEMPT_COUNT + "=b." + ATTEMPT_COUNT );
			// =================================================================
			// where
			// w肳ꂽ[UIDALOIDAwK񐔂ƈv郌R[h
			query.append(" where a." + USERID + "='" + userID + "'");
			query.append(" and a." + LOID + "='" + loID + "'");
			query.append(" and a." + STUDY_SESSION_COUNT );
			query.append(		"=" + studySession );
			// =================================================================
			// max(LearnSessionCount)gp邽߂group by
			query.append(" group by");
			query.append(" a." + ACTIVITYID);
			query.append(",a." + ATTEMPT_COUNT);
			////////////////////////////////////////////////////////////////////
			// NGs
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			resultSet = dataAccess.executeQuery(queryString);
			////////////////////////////////////////////////////////////////////
			// NGʂ̃Xg
			List list = new ArrayList();
			while (resultSet.next()) {
				String[] record = new String[3];
				record[0] = resultSet.getString(ACTIVITYID).trim();
				record[1] = resultSet.getString(ATTEMPT_COUNT);
				record[2] = resultSet.getString(LEARN_SESSION_COUNT);

				list.add(record);
			}
			//Xgz
			matrix = new String[list.size()][];
			list.toArray(matrix);

			// tryubNŌ܂œB̂ŃtOtrueɕύX
			successFlag = true;
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class,
				e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		finally {
			// ʃZbg̃N[Y
			if (resultSet != null) {
				try {
					resultSet.close();
				}
				catch (SQLException e) {
					DebugLog.write(ScormAttemptDataAccess.class,
						e, DebugLog.HIGHT);
					// tryubNɂėOȂ΁AX[
					if (successFlag) {
						throw new LOException(e.getMessage());
					}
				}
			}
		}
		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL getMaxLearnSessionCount("
				+ dataAccess + "," + userID
				+ "," + loID + "," + studySession + ")",
			DebugLog.ROW);
		return matrix;
	}
}
