/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormInteractionDataAccess
//	ύX
//		2004.02.01	VK쐬
//      2006.12.01@ύX T.Kiyokawa
//                  IMOXMLeLXg`ɕύXA
//

package jp.co.ntt.lms.lo.scorm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

// CommentOut 2006.11.24 T.Kiyokawa (CSVΉ̂)
//import org.w3c.dom.Node;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * ScormInteractione[uւ̃ANZXENXB
 * @author T.Nishiki
 */
public class ScormInteractionDataAccess extends ScormDataAccess {
	/**
	 * e[uB
	 */
	public static final String TABLE_NAME = "Scorm_Interaction";

	/**
	 * e[uE񖼁F[UIDB
	 */
	public static final String USERID = "UserID";

	/**
	 * e[uE񖼁FLOIDB
	 */
	public static final String LOID = "LOID";

	/**
	 * e[uE񖼁FwKZbV񐔁B
	 */
	public static final String STUDY_SESSION_COUNT = "StudySessionCount";

	/**
	 * e[uE񖼁FANeBreBIDB
	 */
	public static final String ACTIVITYID = "ActivityID";

	/**
	 * e[uE񖼁Fs񐔁B
	 */
	public static final String ATTEMPT_COUNT = "AttemptCount";

	/**
	 * e[uE񖼁FLearnZbV񐔁B
	 */
	public static final String LEARN_SESSION_COUNT = "LearnSessionCount";

	/**
	 * e[uE񖼁FK񐔁B
	 */
	public static final String INTERACTION_COUNT = "InteractionCount";

	/**
	 * e[uE񖼁FZbVIDB
	 */
	public static final String SESSIONID = "SessionID";

	/**
	 * e[uE񖼁FKIDB
	 */
	public static final String INTERACTIONID = "InteractionID";

	/**
	 * e[uE񖼁FK^CvB
	 */
	public static final String INTERACTION_TYPE = "InteractionType";

	/**
	 * e[uE񖼁FwKڕWB
	 */
	public static final String OBJECTIVEID = "ObjectiveId";

	/**
	 * e[uE񖼁FKB
	 */
	public static final String TIMESTAMP = "Timestamp";

	/**
	 * e[uE񖼁F1B
	 */
	public static final String CORRECT_RESPONSE1 = "CorrectResponse1";

	/**
	 * e[uE񖼁F2B
	 */
	public static final String CORRECT_RESPONSE2 = "CorrectResponse2";

	/**
	 * e[uE񖼁F3B
	 */
	public static final String CORRECT_RESPONSE3 = "CorrectResponse3";

	/**
	 * e[uE񖼁F4B
	 */
	public static final String CORRECT_RESPONSE4 = "CorrectResponse4";

	/**
	 * e[uE񖼁F5B
	 */
	public static final String CORRECT_RESPONSE5 = "CorrectResponse5";

	/**
	 * e[uE񖼁Fd݁B
	 */
	public static final String WEIGHTING = "Weighting";

	/**
	 * e[uE񖼁FwK҉񓚁B
	 */
	public static final String LEARNER_RESPONSE = "LearnerResponse";

	/**
	 * e[uE񖼁FwKʁB
	 */
	public static final String LEARNER_RESULT = "Learner_Result";

	/**
	 * e[uE񖼁FwKoߎԁB
	 */
	public static final String LATENCY = "Latency";

	/**
	 * e[uE񖼁FKڍׁB
	 */
	public static final String DESCRIPTION = "Description";

	/**
	 * &lt;C^NVID&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_INTERACTION_ID_VALUE =
		"./id/text()";

	/**
	 * &lt;K&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_INTERACTION_TYPE_VALUE =
		"./type/text()";

	/**
	 * &lt;wKڕW&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_OBJECTIVE_ID_VALUE =
		"./objectiveid/text()";

	/**
	 * &lt;K&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_TIMESTAMP_VALUE =
		"./timestamp/text()";

	/**
	 * &lt;P&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_CORRECT_RESPONSE1_VALUE =
		"./correctresponses/pattern1/text()";

	/**
	 * &lt;Q&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_CORRECT_RESPONSE2_VALUE =
		"./correctresponses/pattern2/text()";

	/**
	 * &lt;R&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_CORRECT_RESPONSE3_VALUE =
		"./correctresponses/pattern3/text()";

	/**
	 * &lt;S&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_CORRECT_RESPONSE4_VALUE =
		"./correctresponses/pattern4/text()";

	/**
	 * &lt;T&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_CORRECT_RESPONSE5_VALUE =
		"./correctresponses/pattern5/text()";

	/**
	 * &lt;d&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_WEIGHTING_VALUE =
		"./weighting/text()";

	/**
	 * &lt;wK҉&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_LEARNER_RESPONSE_VALUE =
		"./learnerresponse/text()";

	/**
	 * &lt;wK&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_LEARNER_RESULT_VALUE =
		"./result/text()";

	/**
	 * &lt;wKoߎ&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_LATENCY_VALUE =
		"./latency/text()";

	/**
	 * &lt;Kڍ&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_DESCRIPTION_VALUE =
		"./description/text()";

	/**
	 * J̍őTCYB
	 */
	public static final int COLUMN_SIZE_MAX;

	/**
	 * J̍őTCYB
	 */
	public static final int COLUMN_SIZE_UNIT;

//	ADD start 2006.11.22 T.Kiyokawa
	/** 
	CSVEԍFKID 
	 */
	public static final int CSVCOL_IN_ID = 4 ;


	/** 
	CSVEԍFK^Cv 
	 */
	public static final int CSVCOL_IN_TYPE = 5 ;


	/** 
	CSVEԍFKʊwKڕW
	 */
	public static final int CSVCOL_IN_OBJECTIVE_ID = 6 ;


	/** 
	CSVEԍFK 
	 */
	public static final int CSVCOL_IN_TIMESTAMP = 7 ;


	/** 
	CSVEԍF1 
	 */
	public static final int CSVCOL_IN_CORRECT_RESPONSE1 = 8 ;


	/** 
	CSVEԍF2 
	 */
	public static final int CSVCOL_IN_CORRECT_RESPONSE2 = 9 ;


	/** 
	CSVEԍF3 
	 */
	public static final int CSVCOL_IN_CORRECT_RESPONSE3 = 10 ;


	/** 
	CSVEԍF4 
	 */
	public static final int CSVCOL_IN_CORRECT_RESPONSE4 = 11 ;


	/** 
	CSVEԍF5 
	 */
	public static final int CSVCOL_IN_CORRECT_RESPONSE5 = 12 ;


	/** 
	CSVEԍFd
	 */
	public static final int CSVCOL_IN_WEIGHTING = 13 ;


	/** 
	CSVEԍFwK҉ 
	 */
	public static final int CSVCOL_IN_LEARNER_RESPONSE = 14 ;


	/** 
	CSVEԍFwK 
	 */
	public static final int CSVCOL_IN_RESULT = 15 ;


	/** 
	CSVEԍFwKoߎ
	 */
	public static final int CSVCOL_IN_LATENCY = 16 ;


	/** 
	CSVEԍFK 
	 */
	public static final int CSVCOL_IN_DESCRIPTION = 17 ;
	
//	ADD end
	
	/**
	 * X^eBbNECjVCUB
	 * f[^x[X̎ʂɊÂAJ̍őTCY萔肵܂B
	 */
	static {
		// f[^x[XɂăJTCYETCYʂݒ
		int columnSizeMax = 0;
		int columnSizeUnit = 0;
		try {
			Environment environment = new Environment();
			String dbType = environment.getDBType();
			if (dbType.equals(Environment.DB_SQLSERVER)) {
				columnSizeMax = 510;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_SQLSERVER;
			}
			else if (dbType.equals(Environment.DB_ORACLE)) {
				columnSizeMax = 4000;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_ORACLE;
			}
			else if (dbType.equals(Environment.DB_POSTGRE)) {
				columnSizeMax = 4096;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_POSTGRE;
			}
		}
		catch (Exception e) {
		}
		COLUMN_SIZE_MAX = columnSizeMax;
		COLUMN_SIZE_UNIT = columnSizeUnit;
	}

	/**
	 * RXgN^
	 **/
	public ScormInteractionDataAccess() {
		super( TABLE_NAME );
	}	

	// Add Start T.Kiyokawa 2006.11.24

	/**
	 * ScormInteractione[uւ݂̏s܂B<br>
	 * &lt;interaction&gt;vfƂɌĂяoAR[hǉ܂B<br>
	 *
	 * @param dataAccess f[^ANZXNXB
	 * @param endLearnData wKIB
	 * @param interactionCSV &lt;interaction&gt;CSVf[^B
	 * @param activityID f[^ޑΏۂĂANeBreBIDB
	 * @param attemptCount s񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
	 * @param learnSessionCount LearnZbV񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
	 * @param interactionCount wK҃Rg񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;interaction&gt;vf̈ʒuiPȏ̐jB
	 *
	 * @throws LOException f[^x[Xւ̏ɎsꍇB
	 */
	public static void insert(
		DataAccess dataAccess,
		ScormLoEndLearnData endLearnData,
		ScormLoCsvData interactionCSV,
		String activityID,
		int attemptCount,
		int learnSessionCount,
		int interactionCount)
		throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormInteractionDataAccess.class,
			"HEAD insert("
				+ "dataAccess,endLearnData"
				+ "," + interactionCSV + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + interactionCount + ")",
			DebugLog.ROW);

		try {
			////////////////////////////////////////////////////////////////////
			// eJ̒l擾
			//==================================================================
			// Jƒl̃}bv
			ScormColumnInfo[] columnInfos =
				makeColumnInfos(
					endLearnData, interactionCSV,
					activityID,	attemptCount,
					learnSessionCount, interactionCount);
			////////////////////////////////////////////////////////////////////
			// SQL̐
			String query =
				ScormLoUtil.makeInsertQuery(TABLE_NAME, columnInfos);
			////////////////////////////////////////////////////////////////////
			// SQL̎s
			dataAccess.execute(query.toString());
		}
		catch (LOException e) {
			throw e;
		}
		catch (SQLException e) {
			DebugLog.write(
				ScormInteractionDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormInteractionDataAccess.class,
			"TAIL insert("
				+ "dataAccess,endLearnData"
				+ "," + interactionCSV + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + interactionCount + ")",
			DebugLog.ROW);
	}


	/**
	 * ScormInteractione[ũJz𐶐܂B<br>
	 * @param endLearnData wKIB
	 * @param interactionCSV &lt;interaction&gt;CSVf[^B
	 * @param activityID f[^ޑΏۂĂANeBreBIDB
	 * @param attemptCount s񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
	 * @param learnSessionCount LearnZbV񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
	 * @param interactionCount wK҃Rg񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;interaction&gt;vf̈ʒuiPȏ̐jB
	 *
	 * @return ScormInteractione[ũJzB
	 * @throws LOException f[^x[Xւ̏ɎsꍇB
	 */
	private static ScormColumnInfo[] makeColumnInfos(
		ScormLoEndLearnData endLearnData,
		ScormLoCsvData interactionCSV,
		String activityID,
		int attemptCount,
		int learnSessionCount,
		int interactionCount)
		throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormInteractionDataAccess.class,
			"HEAD makeColumnInfos(endLearnData"
				+ "," + interactionCSV + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + interactionCount + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		ScormColumnInfo[] columnInfos = null;
		// z񐶐pXg
		List columnInfoList = new ArrayList();
		try {
			////////////////////////////////////////////////////////////////////
			// endLearnData擾łf[^JƂĐݒ
			//==================================================================
			// [UID
			String userID = endLearnData.getUserID();
			ScormColumnInfo userIDColumn = new ScormColumnInfo(
				USERID, userID,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(userIDColumn);
			// LOID
			String loID = endLearnData.getLoID();
			ScormColumnInfo loIDColumn = new ScormColumnInfo(
				LOID, loID,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(loIDColumn);
			// wKZbV
			int studySessionCount = endLearnData.getStudySession();
			ScormColumnInfo studySessionCountColumn = new ScormColumnInfo(
				STUDY_SESSION_COUNT, Integer.toString(studySessionCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(studySessionCountColumn);
			// ZbVID
			int sessionID = endLearnData.getLoginSession();
			ScormColumnInfo sessionIDColumn = new ScormColumnInfo(
				SESSIONID, Integer.toString(sessionID),
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(sessionIDColumn);
			////////////////////////////////////////////////////////////////////
			// endLearnDataAattemptNodeȊO擾łf[^JƂĐݒ
			//==================================================================
			// ANeBreBID
			ScormColumnInfo activityIDColumn = new ScormColumnInfo(
				ACTIVITYID, activityID,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_MAX,
				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_UNIT);
			columnInfoList.add(activityIDColumn);
			// s
			ScormColumnInfo attemptCountColumn = new ScormColumnInfo(
				ATTEMPT_COUNT, Integer.toString(attemptCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(attemptCountColumn);
			// LearnZbV
			ScormColumnInfo learnSessionCountColumn = new ScormColumnInfo(
				LEARN_SESSION_COUNT, Integer.toString(learnSessionCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(learnSessionCountColumn);
			// K
			ScormColumnInfo interactionCountColumn = new ScormColumnInfo(
				INTERACTION_COUNT, Integer.toString(interactionCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(interactionCountColumn);
			////////////////////////////////////////////////////////////////////
			// Node擾łf[^JƂĐݒ
			//==================================================================
			List columnInfoFromNodeList = null;
			columnInfoFromNodeList = makeColumnInfosFromCSV(interactionCSV);
			columnInfoList.addAll(columnInfoFromNodeList);
			////////////////////////////////////////////////////////////////////
			// Xgzɕϊ
			columnInfos = new ScormColumnInfo[ columnInfoList.size() ];
			columnInfoList.toArray(columnInfos);
		}
		catch (LOException e) {
			throw e;
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormInteractionDataAccess.class,
			"TAIL makeColumnInfos(endLearnData"
				+ "," + interactionCSV + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + interactionCount + ")"
			+ " return " + columnInfos,
			DebugLog.ROW);

		return columnInfos;
	}

	/**
	 * ScormInteractione[ũJz𐶐܂B<br>
	 * nꂽ&lt;interaction&gt;m[h琶ł镔쐬܂B
	 * @param interactionCSV &lt;interaction&gt;CSVf[^B
	 *
	 * @return interactionNodê琶ColumnInfoNXvfƂListB
	 * @throws LOException f[^x[Xւ̏ɎsꍇB
	 */
	private static List makeColumnInfosFromCSV(
			ScormLoCsvData interactionCSV) throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormInteractionDataAccess.class,
			"HEAD makeColumnInfosFromNode(" + interactionCSV + ")",
			DebugLog.ROW);
		// ̃\bh̖߂l
		List columnInfoList = new ArrayList();
		////////////////////////////////////////////////////////////////////////
		// attemptNode擾łf[^JƂĐݒ
		//======================================================================
		// KID
		String interactionID = 
			interactionCSV.getData(CSVCOL_IN_ID);
		if (interactionID != null) {
			ScormColumnInfo interactionIDColumn = new ScormColumnInfo(
				INTERACTIONID, interactionID,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(interactionIDColumn);
		}
		// K^Cv
		String interactionType = 
			interactionCSV.getData(CSVCOL_IN_TYPE);
		if (interactionType != null) {
			ScormColumnInfo interactionTypeColumn = new ScormColumnInfo(
				INTERACTION_TYPE, interactionType,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(interactionTypeColumn);
		}
		// wKڕW
		String objectiveId = 
			interactionCSV.getData(CSVCOL_IN_OBJECTIVE_ID);
		if (objectiveId != null) {
			ScormColumnInfo objectiveIdColumn = new ScormColumnInfo(
				OBJECTIVEID, objectiveId,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(objectiveIdColumn);
		}
		// K
		String timestamp = 
			interactionCSV.getData(CSVCOL_IN_TIMESTAMP);
		if (timestamp != null) {
			String timestampDbString = timestamp;
			ScormColumnInfo timestampColumn = new ScormColumnInfo(
				TIMESTAMP, timestampDbString,
				ScormColumnInfo.COLUMN_TYPE_DATETIME,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(timestampColumn);
		}
		// 1
		String correctResponse1 = 
			interactionCSV.getData(CSVCOL_IN_CORRECT_RESPONSE1);
		if (correctResponse1 != null) {
			ScormColumnInfo correctResponse1Column = new ScormColumnInfo(
				CORRECT_RESPONSE1, correctResponse1,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(correctResponse1Column);
		}
		// 2
		String correctResponse2 =
			interactionCSV.getData(CSVCOL_IN_CORRECT_RESPONSE2);
		if (correctResponse2 != null) {
			ScormColumnInfo correctResponse2Column = new ScormColumnInfo(
				CORRECT_RESPONSE2, correctResponse2,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(correctResponse2Column);
		}
		// 3
		String correctResponse3 = 
			interactionCSV.getData(CSVCOL_IN_CORRECT_RESPONSE3);
		if (correctResponse3 != null) {
			ScormColumnInfo correctResponse3Column = new ScormColumnInfo(
				CORRECT_RESPONSE3, correctResponse3,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(correctResponse3Column);
		}
		// 4
		String correctResponse4 = 
			interactionCSV.getData(CSVCOL_IN_CORRECT_RESPONSE4);
		if (correctResponse4 != null) {
			ScormColumnInfo correctResponse4Column = new ScormColumnInfo(
				CORRECT_RESPONSE4, correctResponse4,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(correctResponse4Column);
		}
		// 5
		String correctResponse5 = 
			interactionCSV.getData(CSVCOL_IN_CORRECT_RESPONSE5);
		if (correctResponse5 != null) {
			ScormColumnInfo correctResponse5Column = new ScormColumnInfo(
				CORRECT_RESPONSE5, correctResponse5,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(correctResponse5Column);
		}
		// d
		String weighting = 
			interactionCSV.getData(CSVCOL_IN_WEIGHTING);
		if (weighting != null) {
			ScormColumnInfo weightingColumn = new ScormColumnInfo(
				WEIGHTING, weighting,
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(weightingColumn);
		}
		// wK҉
		String learnerResponse =
			interactionCSV.getData(CSVCOL_IN_LEARNER_RESPONSE);
		if (learnerResponse != null) {
			ScormColumnInfo learnerResponseColumn = new ScormColumnInfo(
				LEARNER_RESPONSE, learnerResponse,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(learnerResponseColumn);
		}
		// wK
		String learnerResult = 
			interactionCSV.getData(CSVCOL_IN_RESULT);
		if (learnerResult != null) {
			ScormColumnInfo learnerResultColumn = new ScormColumnInfo(
				LEARNER_RESULT, learnerResult,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(learnerResultColumn);
		}
		// wKoߎ
		String latency = 
			interactionCSV.getData(CSVCOL_IN_LATENCY);
		if (latency != null) {
			// Durationbɕϊ
			double latencySecond =
				ScormLoUtil.parseDuration(latency);
			ScormColumnInfo latencyColumn = new ScormColumnInfo(
				LATENCY, Double.toString(latencySecond),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(latencyColumn);
		}
		// Kڍ
		String description = 
			interactionCSV.getData(CSVCOL_IN_DESCRIPTION);
		if (description != null) {
			ScormColumnInfo descriptionColumn = new ScormColumnInfo(
				DESCRIPTION, description,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(descriptionColumn);
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormInteractionDataAccess.class,
			"TAIL makeColumnInfos(" + interactionCSV + ")"
			+ " return " + columnInfoList, DebugLog.ROW);
		return columnInfoList;
	}
	// Add End
	
	// CommentOut Start 2006.11.24 T.Kiyokawa(CSVΉ̂)
//	/**
//	 * ScormInteractione[uւ݂̏s܂B<br>
//	 * &lt;interaction&gt;vfƂɌĂяoAR[hǉ܂B<br>
//	 *
//	 * @param dataAccess f[^ANZXNXB
//	 * @param endLearnData wKIB
//	 * @param interactionNode &lt;interaction&gt;vf\m[hB
//	 * @param activityID f[^ޑΏۂĂANeBreBIDB
//	 * @param attemptCount s񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnSessionCount LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
//	 * @param interactionCount wK҃Rg񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;interaction&gt;vf̈ʒuiPȏ̐jB
//	 *
//	 * @throws LOException f[^x[Xւ̏ɎsꍇB
//	 */
//	public static void insert(
//		DataAccess dataAccess,
//		ScormLoEndLearnData endLearnData,
//		Node interactionNode,
//		String activityID,
//		int attemptCount,
//		int learnSessionCount,
//		int interactionCount)
//		throws LOException {
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormInteractionDataAccess.class,
//			"HEAD insert("
//				+ "dataAccess,endLearnData"
//				+ "," + interactionNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + interactionCount + ")",
//			DebugLog.ROW);
//
//		try {
//			////////////////////////////////////////////////////////////////////
//			// eJ̒l擾
//			//==================================================================
//			// Jƒl̃}bv
//			ScormColumnInfo[] columnInfos =
//				makeColumnInfos(
//					endLearnData, interactionNode,
//					activityID,	attemptCount,
//					learnSessionCount, interactionCount);
//			////////////////////////////////////////////////////////////////////
//			// SQL̐
//			String query =
//				ScormLoUtil.makeInsertQuery(TABLE_NAME, columnInfos);
//			////////////////////////////////////////////////////////////////////
//			// SQL̎s
//			dataAccess.execute(query.toString());
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		catch (SQLException e) {
//			DebugLog.write(
//				ScormInteractionDataAccess.class, e, DebugLog.HIGHT);
//			throw new LOException(e.getMessage());
//		}
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormInteractionDataAccess.class,
//			"TAIL insert("
//				+ "dataAccess,endLearnData"
//				+ "," + interactionNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + interactionCount + ")",
//			DebugLog.ROW);
//	}
//
//	/**
//	 * ScormInteractione[ũJz𐶐܂B<br>
//	 * @param endLearnData wKIB
//	 * @param interactionNode &lt;interaction&gt;vf\m[hB
//	 * @param activityID f[^ޑΏۂĂANeBreBIDB
//	 * @param attemptCount s񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnSessionCount LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
//	 * @param interactionCount wK҃Rg񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;interaction&gt;vf̈ʒuiPȏ̐jB
//	 *
//	 * @return ScormInteractione[ũJzB
//	 * @throws LOException f[^x[Xւ̏ɎsꍇB
//	 */
//	private static ScormColumnInfo[] makeColumnInfos(
//		ScormLoEndLearnData endLearnData,
//		Node interactionNode,
//		String activityID,
//		int attemptCount,
//		int learnSessionCount,
//		int interactionCount)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormInteractionDataAccess.class,
//			"HEAD makeColumnInfos(endLearnData"
//				+ "," + interactionNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + interactionCount + ")",
//			DebugLog.ROW);
//
//		// ̃\bh̖߂l
//		ScormColumnInfo[] columnInfos = null;
//		// z񐶐pXg
//		List columnInfoList = new ArrayList();
//		try {
//			////////////////////////////////////////////////////////////////////
//			// endLearnData擾łf[^JƂĐݒ
//			//==================================================================
//			// [UID
//			String userID = endLearnData.getUserID();
//			ScormColumnInfo userIDColumn = new ScormColumnInfo(
//				USERID, userID,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(userIDColumn);
//			// LOID
//			String loID = endLearnData.getLoID();
//			ScormColumnInfo loIDColumn = new ScormColumnInfo(
//				LOID, loID,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(loIDColumn);
//			// wKZbV
//			int studySessionCount = endLearnData.getStudySession();
//			ScormColumnInfo studySessionCountColumn = new ScormColumnInfo(
//				STUDY_SESSION_COUNT, Integer.toString(studySessionCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(studySessionCountColumn);
//			// ZbVID
//			int sessionID = endLearnData.getLoginSession();
//			ScormColumnInfo sessionIDColumn = new ScormColumnInfo(
//				SESSIONID, Integer.toString(sessionID),
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(sessionIDColumn);
//			////////////////////////////////////////////////////////////////////
//			// endLearnDataAattemptNodeȊO擾łf[^JƂĐݒ
//			//==================================================================
//			// ANeBreBID
//			ScormColumnInfo activityIDColumn = new ScormColumnInfo(
//				ACTIVITYID, activityID,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_MAX,
//				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_UNIT);
//			columnInfoList.add(activityIDColumn);
//			// s
//			ScormColumnInfo attemptCountColumn = new ScormColumnInfo(
//				ATTEMPT_COUNT, Integer.toString(attemptCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(attemptCountColumn);
//			// LearnZbV
//			ScormColumnInfo learnSessionCountColumn = new ScormColumnInfo(
//				LEARN_SESSION_COUNT, Integer.toString(learnSessionCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(learnSessionCountColumn);
//			// K
//			ScormColumnInfo interactionCountColumn = new ScormColumnInfo(
//				INTERACTION_COUNT, Integer.toString(interactionCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(interactionCountColumn);
//			////////////////////////////////////////////////////////////////////
//			// Node擾łf[^JƂĐݒ
//			//==================================================================
//			List columnInfoFromNodeList = null;
//			columnInfoFromNodeList = makeColumnInfosFromNode(interactionNode);
//			columnInfoList.addAll(columnInfoFromNodeList);
//			////////////////////////////////////////////////////////////////////
//			// Xgzɕϊ
//			columnInfos = new ScormColumnInfo[ columnInfoList.size() ];
//			columnInfoList.toArray(columnInfos);
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormInteractionDataAccess.class,
//			"TAIL makeColumnInfos(endLearnData"
//				+ "," + interactionNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + interactionCount + ")"
//			+ " return " + columnInfos,
//			DebugLog.ROW);
//
//		return columnInfos;
//	}
//
//	/**
//	 * ScormInteractione[ũJz𐶐܂B<br>
//	 * nꂽ&lt;interaction&gt;m[h琶ł镔쐬܂B
//	 * @param interactionNode &lt;interaction&gt;vf\m[hB
//	 *
//	 * @return interactionNodê琶ColumnInfoNXvfƂListB
//	 * @throws LOException f[^x[Xւ̏ɎsꍇB
//	 */
//	private static List makeColumnInfosFromNode(
//			Node interactionNode) throws LOException {
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormInteractionDataAccess.class,
//			"HEAD makeColumnInfosFromNode(" + interactionNode + ")",
//			DebugLog.ROW);
//		// ̃\bh̖߂l
//		List columnInfoList = new ArrayList();
//		////////////////////////////////////////////////////////////////////////
//		// attemptNode擾łf[^JƂĐݒ
//		//======================================================================
//		// KID
//		String interactionID = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_INTERACTION_ID_VALUE);
//		if (interactionID != null) {
//			ScormColumnInfo interactionIDColumn = new ScormColumnInfo(
//				INTERACTIONID, interactionID,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(interactionIDColumn);
//		}
//		// K^Cv
//		String interactionType = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_INTERACTION_TYPE_VALUE);
//		if (interactionType != null) {
//			ScormColumnInfo interactionTypeColumn = new ScormColumnInfo(
//				INTERACTION_TYPE, interactionType,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(interactionTypeColumn);
//		}
//		// wKڕW
//		String objectiveId = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_OBJECTIVE_ID_VALUE);
//		if (objectiveId != null) {
//			ScormColumnInfo objectiveIdColumn = new ScormColumnInfo(
//				OBJECTIVEID, objectiveId,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(objectiveIdColumn);
//		}
//		// K
//		String timestamp = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_TIMESTAMP_VALUE);
//		if (timestamp != null) {
//			String timestampDbString = timestamp;
//			ScormColumnInfo timestampColumn = new ScormColumnInfo(
//				TIMESTAMP, timestampDbString,
//				ScormColumnInfo.COLUMN_TYPE_DATETIME,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(timestampColumn);
//		}
//		// 1
//		String correctResponse1 = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_CORRECT_RESPONSE1_VALUE);
//		if (correctResponse1 != null) {
//			ScormColumnInfo correctResponse1Column = new ScormColumnInfo(
//				CORRECT_RESPONSE1, correctResponse1,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(correctResponse1Column);
//		}
//		// 2
//		String correctResponse2 = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_CORRECT_RESPONSE2_VALUE);
//		if (correctResponse2 != null) {
//			ScormColumnInfo correctResponse2Column = new ScormColumnInfo(
//				CORRECT_RESPONSE2, correctResponse2,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(correctResponse2Column);
//		}
//		// 3
//		String correctResponse3 = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_CORRECT_RESPONSE3_VALUE);
//		if (correctResponse3 != null) {
//			ScormColumnInfo correctResponse3Column = new ScormColumnInfo(
//				CORRECT_RESPONSE3, correctResponse3,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(correctResponse3Column);
//		}
//		// 4
//		String correctResponse4 = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_CORRECT_RESPONSE4_VALUE);
//		if (correctResponse4 != null) {
//			ScormColumnInfo correctResponse4Column = new ScormColumnInfo(
//				CORRECT_RESPONSE4, correctResponse4,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(correctResponse4Column);
//		}
//		// 5
//		String correctResponse5 = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_CORRECT_RESPONSE5_VALUE);
//		if (correctResponse5 != null) {
//			ScormColumnInfo correctResponse5Column = new ScormColumnInfo(
//				CORRECT_RESPONSE5, correctResponse5,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(correctResponse5Column);
//		}
//		// d
//		String weighting = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_WEIGHTING_VALUE);
//		if (weighting != null) {
//			ScormColumnInfo weightingColumn = new ScormColumnInfo(
//				WEIGHTING, weighting,
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(weightingColumn);
//		}
//		// wK҉
//		String learnerResponse = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_LEARNER_RESPONSE_VALUE);
//		if (learnerResponse != null) {
//			ScormColumnInfo learnerResponseColumn = new ScormColumnInfo(
//				LEARNER_RESPONSE, learnerResponse,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(learnerResponseColumn);
//		}
//		// wK
//		String learnerResult = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_LEARNER_RESULT_VALUE);
//		if (learnerResult != null) {
//			ScormColumnInfo learnerResultColumn = new ScormColumnInfo(
//				LEARNER_RESULT, learnerResult,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(learnerResultColumn);
//		}
//		// wKoߎ
//		String latency = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_LATENCY_VALUE);
//		if (latency != null) {
//			// Durationbɕϊ
//			double latencySecond =
//				ScormLoUtil.parseDuration(latency);
//			ScormColumnInfo latencyColumn = new ScormColumnInfo(
//				LATENCY, Double.toString(latencySecond),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(latencyColumn);
//		}
//		// Kڍ
//		String description = ScormLoUtil.getNodeValue(
//				interactionNode, PATH_DESCRIPTION_VALUE);
//		if (description != null) {
//			ScormColumnInfo descriptionColumn = new ScormColumnInfo(
//				DESCRIPTION, description,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(descriptionColumn);
//		}
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormInteractionDataAccess.class,
//			"TAIL makeColumnInfos(" + interactionNode + ")"
//			+ " return " + columnInfoList, DebugLog.ROW);
//		return columnInfoList;
//	}
	// CommentOut End

	/**
	 * w肳ꂽ[UAނ̑gݍ킹̃O폜܂B
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param userID 폜Ώۂ̃[UIDB
	 * @param loID 폜Ώۂ̋ނLOIDB
	 * @throws LOException f[^x[XANZXɗOꍇB
	 */
	public static void delete(
		DataAccess dataAccess, String userID, String loID)
		throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormInteractionDataAccess.class,
			"HEAD delete(" + dataAccess + "," + userID + "," + loID + ")",
			DebugLog.ROW);
		try {
			// WHERE̐
			StringBuffer queryWhere = new StringBuffer();
			if (loID != null) {
				queryWhere.append(" and " + LOID + "='" + loID + "'" );
			}
			if (userID != null) {
				queryWhere.append(" and " + USERID + "='" + userID + "'" );
			}
			// 폜NG̐
			StringBuffer query = new StringBuffer();
			query.append("delete from " + TABLE_NAME );
			if (queryWhere.length() > 0) {
				query.append(" where " + queryWhere.substring(5) );
			}
			// 폜NG̎s
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			dataAccess.execute(queryString);
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class,
				e, DebugLog.HIGHT);
		}
		// \bhIO
		DebugLog.write(
			ScormInteractionDataAccess.class,
			"TAIL delete(" + dataAccess + "," + userID + "," + loID + ")",
			DebugLog.ROW);
	}

	/**
	 * LearnZbV񐔍ől擾܂B<br>
	 * w肵[UIDALOIDAwK񐔂̑gݍ킹ŁA
	 * ANeBreBʂɍő厎s񐔂̍őLearnZbV񐔂
	 * ̂QzƂĖ߂܂B
	 * Y郌R[h݂ȂꍇAvfO̔z߂܂B
	 * <br>
	 * @param dataAccess f[^ANZXIuWFNgB
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param studySession wK񐔁iJn|IłPPʂ̉񐔁j
	 * @return ȉ̂PzvfƂz߂܂B
	 * <table border="1">
	 * 	<tr>
	 * 		<th>CfbNX</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">0</td>
	 * 		<td>ANeBreBID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">1</td>
	 * 		<td>ANeBreB̒ōő̎s</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">2</td>
	 * 		<td>
	 * 			ANeBreB̒ōő̎s񐔂̒
	 * 			őLearnZbV
	 * 		</td>
	 * 	</tr>
	 * </table>
	 * <br>
	 * @throws LOException if[^x[XANZXjɃG[ꍇB
	 */
	public static String[][] getMaxLearnSessionCount(
			DataAccess dataAccess, String userID,
			String loID, int studySession)
			throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"HEAD getMaxLearnSessionCount("
				+ dataAccess + "," + userID
				+ "," + loID + "," + studySession + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		String[][] matrix = null;
		// NGʃZbg
		ResultSet resultSet = null;
		// tryubNɗOĂȂtOitrueOȂj
		boolean successFlag = false;
		try {
			////////////////////////////////////////////////////////////////////
			// NG̐
			StringBuffer query = new StringBuffer();
			query.append("select");
			// ANeBreBID
			query.append(" a." + ACTIVITYID + " as " + ACTIVITYID);
			// ő厎s
			query.append(",a." + ATTEMPT_COUNT + " as " + ATTEMPT_COUNT);
			// ̒̍őLearnZbV
			query.append(",max(a." + LEARN_SESSION_COUNT + ")"
							+ " as " + LEARN_SESSION_COUNT);
			query.append(" from " + TABLE_NAME + " a");
			query.append(" inner join (");
			// =================================================================
			// ő厎s񐔂擾邽߂̃TuNG
			query.append(	"select");
			query.append(	" " + USERID + " as " + USERID);
			query.append(	"," + LOID + " as " + LOID);
			query.append(	"," + STUDY_SESSION_COUNT);
			query.append(			" as " + STUDY_SESSION_COUNT);
			query.append(	"," + ACTIVITYID + " as " + ACTIVITYID);
			query.append(	",max(" + ATTEMPT_COUNT + ") as " + ATTEMPT_COUNT);
			query.append(	" from " + TABLE_NAME);
			// TuNGł̏
			// w肳ꂽ[UIDALOIDAwK񐔂ƈv郌R[h
			query.append(	" where " + USERID + "='" + userID + "'");
			query.append(	" and " + LOID + "='" + loID + "'");
			query.append(	" and " + STUDY_SESSION_COUNT );
			query.append(		"=" + studySession );
			// TuNGmax(AttemptCount)gp邽߂group by
			query.append(	" group by ");
			query.append(	" " + USERID);
			query.append(	"," + LOID);
			query.append(	"," + STUDY_SESSION_COUNT);
			query.append(	"," + ACTIVITYID);
			query.append(") b");
			// =================================================================
			// TuNGƂ̌
			// [UIDALOIDAwK񐔁AANeBreBIDvāA
			// s񐔂ől̃R[h
			query.append(" on a." + USERID + "=b." + USERID );
			query.append(" and a." + LOID + "=b." + LOID );
			query.append(" and a." + STUDY_SESSION_COUNT );
			query.append(		"=b." + STUDY_SESSION_COUNT );
			query.append(" and a." + ACTIVITYID + "=b." + ACTIVITYID );
			query.append(" and a." + ATTEMPT_COUNT + "=b." + ATTEMPT_COUNT );
			// =================================================================
			// where
			// w肳ꂽ[UIDALOIDAwK񐔂ƈv郌R[h
			query.append(" where a." + USERID + "='" + userID + "'");
			query.append(" and a." + LOID + "='" + loID + "'");
			query.append(" and a." + STUDY_SESSION_COUNT );
			query.append(		"=" + studySession );
			// =================================================================
			// max(LearnSessionCount)gp邽߂group by
			query.append(" group by");
			query.append(" a." + ACTIVITYID);
			query.append(",a." + ATTEMPT_COUNT);
			////////////////////////////////////////////////////////////////////
			// NGs
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			resultSet = dataAccess.executeQuery(queryString);
			////////////////////////////////////////////////////////////////////
			// NGʂ̃Xg
			List list = new ArrayList();
			while (resultSet.next()) {
				String[] record = new String[3];
				record[0] = resultSet.getString(ACTIVITYID).trim();
				record[1] = resultSet.getString(ATTEMPT_COUNT);
				record[2] = resultSet.getString(LEARN_SESSION_COUNT);

				list.add(record);
			}
			//Xgz
			matrix = new String[list.size()][];
			list.toArray(matrix);

			// tryubNŌ܂œB̂ŃtOtrueɕύX
			successFlag = true;
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class,
				e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		finally {
			// ʃZbg̃N[Y
			if (resultSet != null) {
				try {
					resultSet.close();
				}
				catch (SQLException e) {
					DebugLog.write(ScormAttemptDataAccess.class,
						e, DebugLog.HIGHT);
					// tryubNɂėOȂ΁AX[
					if (successFlag) {
						throw new LOException(e.getMessage());
					}
				}
			}
		}
		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL getMaxLearnSessionCount("
				+ dataAccess + "," + userID
				+ "," + loID + "," + studySession + ")",
			DebugLog.ROW);
		return matrix;
	}
}
