/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormLoURLMaker
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm;

import java.io.File;
import java.net.URLEncoder;
import java.util.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Map;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.lo.LoLogDataAccess;
import jp.co.ntt.lms.lo.LoLogSessionDataAccess;
import jp.co.ntt.lms.lo.LoPropertyDef;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.People.PeopleClient;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * SCORM LO ފwKJnURLNXB<br>
 * @author T.Nishiki
 */
public class ScormLoURLMaker {

	/**
	 * SCORM LOT[oN邽߂URL𐶐܂B<br>
	 *
	 * @param params p[^B
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>ScormLoPropertyDef.LOID</td>
	 * 		<td>wK鋳ނLOID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>ScormLoPropertyDef.USERID</td>
	 * 		<td>wK郆[UID</td>
	 * 	</tr>
	 * </table><br>
	 * @param dataAccess f[^ANZXNXB
	 * @return  SCORM LOT[oN邽߂URLB
	 * @throws LOException ۂɃf[^x[XANZX
	 *                      t@CANZXȂǂŎsꍇB
	 */
	public String makeStartLearnURL(Hashtable params, DataAccess dataAccess)
		throws LOException {
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD makeStartLearnURL("
				+ params + "," + dataAccess + ")",
			DebugLog.ROW);

		// ̃\bh̖߂lB
		String startScormLoServerURL = null;

		try {
			ScormLoEnv scormEnv = new ScormLoEnv();
			Hashtable macroParams = new Hashtable();

			////////////////////////////////////////////////////////////////////
			// [UIDALOID̎擾
			String userID = (String)params.get(LoPropertyDef.USER);
			String loID = (String)params.get(LoPropertyDef.LOID);
			macroParams.put(ScormLoConstant.START_PARAM_KEY_USERID, userID);
			macroParams.put(ScormLoConstant.START_PARAM_KEY_LOID, loID);
			////////////////////////////////////////////////////////////////////
			// [U擾܂B
			putUserInfo(macroParams, userID);
			////////////////////////////////////////////////////////////////////
			// ނ̏擾Ap[^Ɋi[
			putLoInfo(macroParams, loID);
			////////////////////////////////////////////////////////////////////
			// OwKZbV񐔂擾
			int previousStudySession = 0;
			// ScormSessione[uŏIwK̊wKZbV񐔂擾B
			previousStudySession =
				ScormSessionDataAccess.getLastStudySessionCount(
					userID,
					loID,
					dataAccess);
			////////////////////////////////////////////////////////////////////
			// wKJnĊJ𔻒fB
			String commandType = null;
//2005.08.11 MOD start NTTR-an wKĨGWNR}hI̒ǉ
			String launchMode = null;
			launchMode = scormEnv.getProperty("launchmode");
//			commandType = getCommandType(userID, loID,
//				previousStudySession, dataAccess);
			commandType = getCommandType(userID, loID,
			previousStudySession, dataAccess, launchMode);
			// }Np[^ƂĐݒ
			macroParams.put(ScormLoConstant.START_PARAM_KEY_COMD, commandType);
			////////////////////////////////////////////////////////////////////
			// 񕪂̊wKZbV񐔂m肷B
			// =================================================================
			String studySession = null;
			if (commandType.equals(ScormLoConstant.START_PARAM_COMD_NEW)) {
				studySession = Integer.toString(previousStudySession + 1);
			}
			else {
				studySession = Integer.toString(previousStudySession);
			}
			// }Np[^ƂĐݒ
			macroParams.put(
				ScormLoConstant.START_PARAM_KEY_STUDYSESSION,
				studySession);
			////////////////////////////////////////////////////////////////////
			// OCZbV
			// =================================================================
			// OCZbV񐔂擾
			LoLogDataAccess loLogDataAccess = new LoLogDataAccess();
			int previousLoginSession = 0;
			String loginSession = null;
			previousLoginSession =
				loLogDataAccess.getStudyCount(userID, loID, dataAccess);
			// }Np[^ƂĐݒ
			// 񕪂̃OCZbV񐔂́AO{P
			loginSession = Integer.toString(previousLoginSession + 1);
			macroParams.put(
				ScormLoConstant.START_PARAM_KEY_LOGINSESSION,
				loginSession);
			////////////////////////////////////////////////////////////////////
			// SCORM LOT[oI܂B
			ScormServerInfoControl control =
				ScormServerInfoControl.getInstance();
			ScormServerInfo serverInfo = null;
			serverInfo = control.getServerSelected(userID, loID);
			// }Np[^ƂĐݒ
			macroParams.put(
				ScormLoConstant.START_PARAM_KEY_SERVERNAME,
				serverInfo.getServerName());
			////////////////////////////////////////////////////////////////////
			// F؃L[擾܂B
			String authenticKey = null;
			Environment environment = new Environment();
			String hostName = environment.getServerName();
			authenticKey = ScormLoUtil.makeAuthenticKey(
					userID, loID, hostName);
			// }Np[^ƂĐݒ
			macroParams.put(
				ScormLoConstant.START_PARAM_KEY_AUTHKEY,
				authenticKey);
			////////////////////////////////////////////////////////////////////
			// wKIɌĂяoT[ubg擾
			String endLearnURL = null;
			endLearnURL = scormEnv.getEndLearnServletURL();
			// GR[h
			endLearnURL =
				URLEncoder.encode(endLearnURL, scormEnv.getCharsetUrlEncode());
			// }Np[^ƂĐݒ
			macroParams.put(
				ScormLoConstant.START_PARAM_KEY_END_URL, endLearnURL);
			////////////////////////////////////////////////////////////////////
			// ލ\`擾ɌĂяoT[ubg擾
			String studyInfoURL = null;
			studyInfoURL = scormEnv.getStudyInfoURL();
			// GR[h
			studyInfoURL =
				URLEncoder.encode(studyInfoURL, scormEnv.getCharsetUrlEncode());
			// }Np[^ƂĐݒ
			macroParams.put(
				ScormLoConstant.START_PARAM_KEY_STUDYINFO_URL, studyInfoURL);
			////////////////////////////////////////////////////////////////////
			// Jn擾܂B
			String startDateTime = getStartDateTime();
			// }Np[^ƂĐݒ
			macroParams.put(
				ScormLoConstant.START_PARAM_KEY_START_DATETIME, startDateTime);
			////////////////////////////////////////////////////////////////////
			// SCORM LOT[oNURL擾܂
			startScormLoServerURL =
				scormEnv.getStartScormLoServerURL(macroParams);
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL makeStartLearnURL("
				+ params + "," + dataAccess + ")"
				+ " return " + startScormLoServerURL,
			DebugLog.ROW);
		return startScormLoServerURL;
	}

	/**
	 * wKJnĊJf܂B
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param studySession wK񐔁B
	 * @param dataAccess f[^ANZXNXEIuWFNgB
	 * @return wKJn^ĊJ̃tOB
	 *
	 * @throws LOException f[^x[Xt@CANZXɎsꍇB
	 * @see ScormLoConstant#START_PARAM_COMD_NEW
	 * @see ScormLoConstant#START_PARAM_COMD_CONT
	 */
	private static String getCommandType(
//		String userID, String loID, int studySession, DataAccess dataAccess)
	    String userID, String loID, int studySession, DataAccess dataAccess, String launchMode)
		throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormLoURLMaker.class,
			"HEAD getCommandType("
				+ userID
				+ "," + loID
				+ "," + studySession
				+ "," + dataAccess
				+ "," + launchMode
				+ ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		String commandType = null;
		try {
			////////////////////////////////////////////////////////////////////
			// PDLoLogSessionAŏIwK̊wKJn^I擾B
			// @@R[h݂Ȃ->wKJn
			// @@JnāAI->wKJn
			// @@JnāAIȂ->wKĊJ
			// QDĊJƔfꍇAft@CmFB
			// @@t@C݂Ȃꍇ́AwKJnƔfB
			// =================================================================
			// LoLogSessionŏIJn擾
			LoLogSessionDataAccess loLogSessionDataAccess =
				new LoLogSessionDataAccess();
			String[] lastStudyDates =
				loLogSessionDataAccess.getStudyDateList(
					userID,	loID, dataAccess);
			String lastStartDate = lastStudyDates[0];
			String lastEndDate = lastStudyDates[1];
			// ŏIwKJn݂ȂR[hȂ->wKJn
			if (lastStartDate == null || lastStartDate.equals("")) {
				commandType = ScormLoConstant.START_PARAM_COMD_NEW;
			}
			// ŏIwKJnāAŏIwKJI݂Ȃ->wKĊJ
			else if (lastEndDate == null || lastEndDate.equals("")) {
				commandType = ScormLoConstant.START_PARAM_COMD_CONT;
			}
			// ŏIwKJn^IƂɑ݂->wKJn
			else {
//2005.08.11 ADD start NTTR-an wKĨGWNR}hI̒ǉ
			    if( launchMode.equals(ScormLoConstant.START_PARAM_COMD_NEW)) {
			        commandType = ScormLoConstant.START_PARAM_COMD_NEW;
			    }
			    else{
			        commandType = ScormLoConstant.START_PARAM_COMD_CONT;
			    }
//2005.08.11 ADD end
			}
			// =================================================================
			// ĊJ̏ꍇAft@C݂̑mFB
			if (commandType.equals(ScormLoConstant.START_PARAM_COMD_CONT)) {
				File resumeFile = null;
				resumeFile =
					ScormLoUtil.getResumeFile(userID, loID, studySession);
				if (resumeFile.isFile() == false) {
					commandType = ScormLoConstant.START_PARAM_COMD_NEW;
				}
			}
		}
		catch (SQLException e) {
			DebugLog.write(ScormLoURLMaker.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}

		// \bhIO
		DebugLog.write(
			ScormLoURLMaker.class,
			"TAIL getCommandType("
				+ userID
				+ "," + loID
				+ "," + studySession
				+ "," + dataAccess
				+ "," + launchMode
				+ ")"
				+ "return " + commandType,
			DebugLog.ROW);
		return commandType;
	}

	/**
	 * [U֘Ȁ擾Ap[^ƂĊi[܂B<br>
	 * @param macroParams i[p[^B
	 * @param userID [U擾郆[UIDB
	 * @throws LOException 擾ɗOꍇB
	 */
	private static void putUserInfo(Map macroParams, String userID)
			throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormLoURLMaker.class,
			"HEAD putUserInfo(" + macroParams + "," + userID + ")",
			DebugLog.ROW);

		try {
			PeopleClient people = null;
			people = new PeopleClient();
			people.setWhereUserID(userID);

			if (people.select() == false) {
				throw new LOException(people.getMessage());
			}
			if (people.next()) {
				ScormLoEnv scormEnv = new ScormLoEnv();
				String userName = people.getUserName();
				userName = URLEncoder.encode(
					userName, scormEnv.getCharsetUrlEncode());
				// }Np[^ƂĐݒ
				macroParams.put(
					ScormLoConstant.START_PARAM_KEY_STUDENT_NAME, userName);
			}
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(ScormLoURLMaker.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		// \bhIO
		DebugLog.write(
			ScormLoURLMaker.class,
			"TAIL putUserInfo(" + macroParams + "," + userID + ")",
			DebugLog.ROW);
	}

	/**
	 * [U֘Ȁ擾Ap[^ƂĊi[܂B<br>
	 * @param macroParams i[p[^B
	 * ̃\bhďo͈ȉ̒lݒ肳܂B<br>
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>ScormConstant.START_PARAM_KEY_FOREIGN_LOID</td>
	 * 		<td>wK鋳ނ̊OID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>ScormConstant.START_PARAM_KEY_MANIFESTID</td>
	 * 		<td>wK鋳ނ̋ID</td>
	 * 	</tr>
	 * </table><br>
	 *
	 * @param loID ޏ擾LOIDB
	 * @throws LOException 擾ɗOꍇB
	 */
	private static void putLoInfo(Map macroParams, String loID)
		throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormLoURLMaker.class,
			"HEAD putLoInfo(" + macroParams + "," + loID + ")",
			DebugLog.ROW);

		try {
			// OID擾
			LoClient client = new LoClient();
			client.setWhereLoID(loID);
			if (client.select() == false) {
				throw new LOException(client.getMessage());
			}
			if (client.next()) {
				String foreignID = client.getForeignID();
				macroParams.put(
					ScormLoConstant.START_PARAM_KEY_FOREIGN_LOID, foreignID);
			}
			// ID擾
			Hashtable condition = new Hashtable();
			condition.put(LoPropertyDef.LOID, loID);
			ScormLoDataAccess scormLoDataAccess = new ScormLoDataAccess();
			ScormLoData[] loData = scormLoDataAccess.getLoData(condition);
			if (loData.length == 0 ) {
				throw new LOException("Not Found Scorm Lo[" + loID + "]");
			}
			String materialID = loData[0].getMaterialID();
			macroParams.put(
				ScormLoConstant.START_PARAM_KEY_MANIFESTID, materialID);
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(ScormLoURLMaker.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}

		// \bhIO
		DebugLog.write(
			ScormLoURLMaker.class,
			"TAIL putLoInfo(" + macroParams + "," + loID + ")",
			DebugLog.ROW);
	}


	/**
	 * wKJn𕶎ƂĖ߂܂B<br>
	 * ݓ擾ĕɕϊĖ߂܂B<br>
	 *
	 * @return wKJnitH[}bg͈ȉQƁjB
	 * @see ScormLoConstant#START_STUDY_DATETIME_FORMAT
	 */
	private static String getStartDateTime() {
		// ̃\bh̖߂l
		String currentTime = null;
		// ݓ擾ĕϊ
		SimpleDateFormat dateFormat = null;
		dateFormat = new SimpleDateFormat(
			ScormLoConstant.START_STUDY_DATETIME_FORMAT);
		currentTime = dateFormat.format(new Date());
		return currentTime;
	}
}
