/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	XML샆[eBeBNX
//
//		ύX
//			2005.02.19  VK쐬   
//          2006.02.13  getIndexedNodeAttribute ̃WbNύX
//
//	@\
//
//	̃NXXML𑀍삷郆[eBeBNXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmf;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * XML샆[eBeBNX
 * 
 * ̃NXXML𑀍삷郆[eBeBNXłB
 * 
 * @author  
 * @version 1.0
 */
public class NodeUtil
{
	/**
	 * w肵m[heɂAw肵Õm[h̃Xg擾B
	 * 
	 * @param parent em[h
	 * @param nodeName m[h
	 * @return m[h̃Xg
	 */
	public static List getNamedChildElementList(Node parent, String nodeName)
	{
		if (parent == null) { return null; }

		List nodeList = new ArrayList();
		NodeList list = parent.getChildNodes();
		for (int i = 0; i < list.getLength(); i++)
		{
			Node node = list.item(i);
			if (node.getNodeType() == Node.ELEMENT_NODE)
			{
				if (node.getNodeName().equals(nodeName)) nodeList.add(node);
			}
		}
		return nodeList;
	}

	/**
	 * w肵m[heɎAw肳ꂽOm[h̃Xg擾B
	 * O𕡐w肷邱ƂłB
	 * 
	 * @param parent em[h
	 * @param nodeNames m[h̔z
	 * @return m[h̃Xg
	 */
	public static List getNamedChildElementList(Node parent, String[] nodeNames)
	{
		if (parent == null) { return null; }

		List nodeList = new ArrayList();
		NodeList list = parent.getChildNodes();
		for (int i = 0; i < list.getLength(); i++)
		{
			Node node = list.item(i);
			if (node.getNodeType() == Node.ELEMENT_NODE)
			{
				for (int j = 0; j < nodeNames.length; j++)
				{
					if (node.getNodeName().equals(nodeNames[j]))
					{
						nodeList.add(node);
						break;
					}
				}
			}
		}
		return nodeList;
	}

	/**
	 * w肵m[h̔zɂvfm[hȂ郊Xg擾B
	 * 
	 * @param parent em[h
	 * @return
	 */
	public static List getChildElementList(Node parent)
	{
		if (parent == null) { return null; }

		List nodeList = new ArrayList();
		NodeList list = parent.getChildNodes();
		for (int i = 0; i < list.getLength(); i++)
		{
			Node node = list.item(i);
			if (node.getNodeType() == Node.ELEMENT_NODE)
			{
				nodeList.add(node);
			}
		}
		return nodeList;
	}
	
	/**
	 * w肵m[heɂm[ĥAŏ̎w肵Õm[h擾B
	 * 
	 * @param parent em[h
	 * @param nodeName m[h
	 * @return m[h
	 * 			ȂꍇAnull ԂB
	 */
	public static Node getNamedFirstChildElement(Node parent, String nodeName)
	{
		if (parent == null) { return null; }

		NodeList list = parent.getChildNodes();
		for (int i = 0; i < list.getLength(); i++)
		{
			Node node = list.item(i);
			if (node.getNodeType() == Node.ELEMENT_NODE)
			{
				if (node.getNodeName().equals(nodeName)) return node;
			}
		}
		return null;
	}

	/**
	 * w肳ꂽm[hXg̒ACfbNXɂw肳ꂽm[h̑l擾B
	 * w肳ꂽȂ null ԋpB
	 * 
	 * @param nodeList m[hXg
	 * @param index CfbNX
	 * @param attrName 
	 * @return l
	 */
	public static String getIndexedNodeAttribute(List nodeList, int index,
			String attrName)
	{
		Node node = (Node) nodeList.get(index);
		return getAttribute(node, attrName);
	}

	/**
	 * w肳ꂽm[h̑l擾B
	 * 
	 * @param node m[h
	 * @param attrName 
	 * @return l
	 */
	public static String getAttribute(Node node, String attrName)
	{
		Node attr = node.getAttributes().getNamedItem(attrName);
		if (attr != null)
		{
			return attr.getNodeValue();
		}
		else
		{
			return null;
		}
	}
}