/*
 * 쐬: 2005/02/09
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
package jp.co.ntt.lms.xmf.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.co.ntt.lms.xms.framework.Constant;
import jp.co.ntt.lms.xms.framework.XmsBusinessAction;
import jp.co.ntt.lms.xms.framework.XmsBusinessBean;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsInnerException;
import jp.co.ntt.lms.xms.framework.XmsRequest;
import jp.co.ntt.lms.xms.framework.XmsResponse;
import jp.co.ntt.lms.xms.framework.XmsScreenAction;
import jp.co.ntt.lms.xms.framework.XmsScreenBean;
import jp.co.ntt.lms.xms.framework.XmsSystemException;
import jp.co.ntt.lms.xms.framework.XmsWarningException;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * @author Administrator
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class XmsAction extends Action {

	/**
	 * ANVNX̎s
	 * @param map
	 * @param request
	 * @param response
	 * @param bizAction
	 * @param scrAction
	 * @return
	 */
	protected ActionForward performXmsAction(ActionMapping map, HttpServletRequest request, HttpServletResponse response, XmsBusinessAction bizAction, XmsScreenAction scrAction) {

		// X|XIuWFNg̐
		XmsResponse xmsResponse = new XmsResponse();
		try {
			// NGXgIuWFNg̐
			XmsRequest xmsRequest = new XmsRequest(request, response);
			
			// BusinessActions
			if ( bizAction != null ) {
				performXmsBusinessAction(bizAction, xmsRequest, xmsResponse);
			}
			
			// ScreenActions
			if ( scrAction != null ) {
				performXmsScreenAction(scrAction, xmsRequest, xmsResponse);
			}

		} catch (XmsWarningException e) {
			request.setAttribute(Constant.KEY_ERROR, e);
			return map.findForward("warning");
		} catch (XmsInnerException e) {
			request.setAttribute(Constant.KEY_ERROR, e);
			return map.findForward("inner");
		} catch (XmsSystemException e) {
			request.setAttribute(Constant.KEY_ERROR, e);
			return map.findForward("system");
		} catch (Throwable th) {
			request.setAttribute(Constant.KEY_ERROR, th);
			return map.findForward("throwable");
		}

		String businessStatus = xmsResponse.getBusinessStatus();
		return map.findForward(businessStatus);
	}
	
	/**
	 * XmsBusinessAction̎s
	 * @param action
	 * @param xmsRequest
	 * @param xmsResponse
	 * @throws XmsException
	 */
	protected void performXmsBusinessAction(XmsBusinessAction action, XmsRequest xmsRequest, XmsResponse xmsResponse) throws XmsException {
		// s
		action.perform(xmsRequest, xmsResponse);
		
		// ԋplIuWFNgʏoB
		XmsBusinessBean bean = xmsResponse.getBusinessBean();

		// XR[vɂʏIuWFNg̐ݒ
		if( bean != null ) {
			HttpServletRequest request = xmsRequest.getRequest();
			// XR[vZbV̏ꍇ
			if( xmsResponse.getScope() == XmsResponse.SESSION ) {
				
				HttpSession session = request.getSession();
				session.setAttribute(xmsResponse.getBusinessBeanName(), bean);
			}
			// XR[vNGXg̏ꍇ
			else if( xmsResponse.getScope() == XmsResponse.REQUEST ) {
				request.setAttribute(xmsResponse.getBusinessBeanName(), bean);
			}
		}
	}
	
	/**
	 * XmsScreenAction̎s
	 * @param action
	 * @param xmsRequest
	 * @param xmsResponse
	 * @throws XmsException
	 */
	protected void performXmsScreenAction(XmsScreenAction action,
			XmsRequest xmsRequest, XmsResponse xmsResponse) throws XmsException {
		// s
		action.perform(xmsRequest, xmsResponse);

		// ԋplIuWFNgʏoB
		XmsScreenBean bean = xmsResponse.getScreenBean();

		// XR[vɂʏIuWFNg̐ݒ
		if (bean != null) {
			HttpServletRequest request = xmsRequest.getRequest();
			// XR[vZbV̏ꍇ
			if (xmsResponse.getScope() == XmsResponse.SESSION) {
				HttpSession session = request.getSession();
				session.setAttribute(xmsResponse.getScreenBeanName(), bean);
			}
			// XR[vNGXg̏ꍇ
			else if (xmsResponse.getScope() == XmsResponse.REQUEST) {
				request.setAttribute(xmsResponse.getScreenBeanName(), bean);
			}
		}
	}
	
}
