/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	Assignments ǗXMO f[^ANZXNX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//

package jp.co.ntt.lms.xmo.Assignments;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.lo.scorm.ScormAttemptDataAccess;
import jp.co.ntt.lms.lo.scorm.ScormObjectiveDataAccess;
import jp.co.ntt.lms.otm.OTMAssignInfo;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.MessageData;
import jp.co.ntt.lms.xmo.XMOException;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleTable;
import jp.co.ntt.lms.xmo.Message.Message;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.util.XMODate;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsSystemException;

/**
 * Assignments ǗXMO f[^ANZXNXłB<BR>
 * ̃NXAssignmentse[uւ̓o^ACA폜As܂B<BR>
 * DataAccessNXpAo^ACA폜APʂ
 * gUNVǗs܂B
 * @author T.Nijou
 * @version 0.0.0.1 2004/01/08
 */
public class AssignmentsDataAccess
	implements AssignmentsMessage, AssignmentsTable
{

	/** f[^ANZXNXŎgL[ */
	private static final String ASSIGN_USERID = "assing_userid";

	/**
	 * RXgN^łB<BR>
	 */
	public AssignmentsDataAccess() {
	}

	/**
	 * Assignmentse[u֓o^s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * Ȃe[u̎L[ȊOȗꍇ͏ȗtB[hɂ
	 * Nullli[܂B
	 * <PRE>
	 *			   key					   
	 *			---------------------------------------------
	 *			   MEMBER_SHIP_ID		   lXID
	 *			   MATERIAL_ID			   R|[lgID
	 *			   STUDY_START_DATE 	   Jn
	 *			   END_DATE 			   I
	 *			   ASSIGNER 			   ATC
	 *			   LEARN_AUTHORITY		   wK
	 *			   MANAGEMENT_AUTHORITY    Ǘ
	 *			---------------------------------------------
	 * </PRE>
	 * @param htData o^
	 * @return AssignmentsData (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public synchronized AssignmentsData insert( Hashtable htData )
		throws XMOException
	{

		// ATC󋵂i[邽߂̃f[^IuWFNg𐶐B
		AssignmentsData objData =  new AssignmentsData();

		// Assignmentsf[^null̂Ƃ
		if( htData == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );	
			// p[^G[X[
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htData );

			// ݃`FbNs܂
			if( isExitAssign( htData, objDataAccess ) ) {
				// łɑ݂ĂG[Ԃ܂
				throw new XMOException( getMessageData( ALREADY_ASSING_WAR ) );
			}

			// CT[gs\bhĂт܂
			objData = insertAction( htData, objDataAccess, objData );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		return objData;
	}

	/**
	 * o^s\bhłB<BR>
	 * ̃e[uɓo^sAO[vƐlǗXMO
	 * qO[v擾A݂AqO[vɂl
	 * o^s܂B
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam o^
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private AssignmentsData insertAction( Hashtable htbParam, DataAccess objDataAccess, AssignmentsData objData )
		throws XMOException, SQLException
	{

		// o^p̃f[^Zbg܂
		Hashtable htbData = setData( htbParam );

		// ݃`FbNsłɓo^Ăꍇ
		// Ɏq̓o^ɍs܂B
		String strAssignID = "";
		if( !isExitAssign( htbData, objDataAccess ) ) {
			// őAssignID擾
			strAssignID = getMaxAssignID(objDataAccess);
			// AssignIDo^ɃZbg܂
			htbData.put( ASSIGN_ID, strAssignID );

			// ATCΏۃ[UID擾
			String strAssignUserID = (String)htbParam.get( ASSIGN_USERID );
			if( strAssignUserID != null ) {
				objData.addAssignUser( strAssignUserID );
			}

			// o^SQL擾܂
			String strSQL = objDataAccess.getInsertSQL( htbData );

			// o^s
			objDataAccess.execute( strSQL );
		}

		//[h擾܂
		String strMode = (String)htbParam.get( MODE_KEY );

		// [hON̏ꍇ͈ȉ͍̏sȂ
		// O[vƐlǗXMOgpāAqO[vѐl݂邩s
		// ݂ꍇ͓l̓o^s܂
		if( strMode == null || !strMode.equals("on") ) {
			insertChild( htbData, objDataAccess, objData );
		}

		// o^ATCIDݒ肵ĕԂ܂
		objData.setAssignID( strAssignID );

		return objData;
	}

	/**
	 * O[vƐlǗXMOw肳ꂽo[VbvID̎qXg擾
	 * ݂ꍇ͎qɑ΂āAAssignmento^܂
	 * @param htbData p[^
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void insertChild( Hashtable htbData, DataAccess objDataAccess, AssignmentsData objData )
		throws XMOException, SQLException
	{
		try {
			// O[vƐlǗXMÕNCAgCX^X܂
			GroupAndPeopleClient objGroupAndPeople = new GroupAndPeopleClient();

			// o[VbvID擾܂
			String strMemberShipID = (String)htbData.get( MEMBER_SHIP_ID );

			// O[vƐlǗXMONCAgɃo[VbvIDݒ肵
			// s܂
			objGroupAndPeople.setWhereMemberShipID( strMemberShipID );
			// ݎgp̃RlNVCfbNXݒ肵܂
			objGroupAndPeople.setConnectionIndex( objDataAccess.getConnectionIndex() );

			if( !objGroupAndPeople.selectDatabase() ) {
				// Ɏsꍇ͌G[Ԃ܂
				throw new XMOException( objGroupAndPeople.getMessageData() );
			}

			// ʐ[vāAinsertĂяo܂
			if( objGroupAndPeople.next() ) {
				// o[VbvID茩R[h̎qIDL[ɂāAqXg擾
				String strParentID = objGroupAndPeople.getChildID();
				// p[^NA
				objGroupAndPeople.clear();
				// ݎgp̃RlNVCfbNXw肵܂
				objGroupAndPeople.setConnectionIndex( objDataAccess.getConnectionIndex() );
				// eIDݒ
				objGroupAndPeople.setWhereParentID( strParentID );

				// qXg
				if( !objGroupAndPeople.selectDatabase() ) {
					// Ɏsꍇ͌G[Ԃ܂
					throw new XMOException( objGroupAndPeople.getMessageData() );
				}

				// qXg[vĐeO[vƓLO蓖Ă܂B
				while( objGroupAndPeople.next() ) {

					// q̃o[VbvIDݒ肵܂
					Hashtable htbChildParam = setData( htbData );
					htbChildParam.put( MEMBER_SHIP_ID, objGroupAndPeople.getMemberShipID() );
					// qID[ȔꍇA[UATCɃ[UIDǉ
					if( !objGroupAndPeople.isGroup() ) {
						htbChildParam.put( ASSIGN_USERID, objGroupAndPeople.getChildID() );
					}
					// ATC̃CT[g̍ċAĂяos܂
					insertAction( htbChildParam, objDataAccess, objData );
				}
			}
		}
		catch( Exception e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
	}

	/**
	 * Assignmentse[u֍XVs܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * ȗtB[h͍XV܂B
	 * <PRE>
	 *			   key					   
	 *			---------------------------------------------
	 *			   MEMBER_SHIP_ID		   lXID
	 *			   MATERIAL_ID			   R|[lgID
	 *			   STUDY_START_DATE 	   Jn
	 *			   END_DATE 			   I
	 *			   ASSIGNER 			   ATC
	 *			   LEARN_AUTHORITY		   wK
	 *			   MANAGEMENT_AUTHORITY    Ǘ
	 *			---------------------------------------------
	 *			   CONDITION_KEY		   XV
	 *			---------------------------------------------
	 * </PRE>
	 * @param htData XV
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public synchronized String update( Hashtable htData )
		throws XMOException
	{
		// LOf[^null̂Ƃ
		if( htData == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );	
			// p[^G[X[
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans( htData );

			// XVs\bhs܂
			updateAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); }
			catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		// 펞󕶎ԋp
		return "";
	}

	/**
	 * XVs\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam XV
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void updateAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// XVp̃f[^Zbg܂
		Hashtable htbData = setData( htbParam );

		String strSQL = objDataAccess.getUpdateSQL(htbData);

		// ̎擾
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			strSQL += strCondition;
		}

		// XVs
		objDataAccess.execute( strSQL );

	}

	/**
	 * Assignmentse[u֍폜s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *			   key					   
	 *			---------------------------------------------
	 *			   CONDITION_KEY		   폜
	 *			---------------------------------------------
	 * </PRE>
	 * @param htData 폜
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public synchronized String delete( Hashtable htData )
		throws XMOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans( htData );

			// 폜s\bhs܂
			deleteAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
		return "";
	}

	/**
	 * 폜s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 폜
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private void deleteAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "DELETE FROM " + TABLE_NAME );

		// ̎擾
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}

		// 폜s
		objDataAccess.execute( sbSQL.toString() );
	}


	/**
	 * Assignmentse[u֌s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *			   key					   
	 *			---------------------------------------------
	 *			   CONDITION_KEY		   
	 *			---------------------------------------------
	 * </PRE>
	 * @param htData 
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public Vector select( Hashtable htData )
		throws XMOException
	{
		// Assignmentsf[^null̂Ƃ
		if( htData == null ) {
			DebugLog.write( this.getClass(), new Exception(), DebugLog.HIGHT );	
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// ߂l
		Vector vecReturn = new Vector();

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htData );

			// s\bh
			vecReturn = selectAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}
		return vecReturn;
	}

	/**
	 * s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 
	 * @return Vector 
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private Vector selectAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT * FROM " + TABLE_NAME );

		// ̎擾
		String strCondition = (String)htbParam.get( "condition_key" );
		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}
		// ̎擾
		String strOrderBy = (String)htbParam.get( "order_by" );
		if( strOrderBy != null ) {
			sbSQL.append( strOrderBy );
		}

		// NG[s܂
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		Vector vecReturn = new Vector();
		while(rs.next()) {
			// etB[h̒l擾܂
			String strAssignID = ChangeEncode.setChar( rs.getString( ASSIGN_ID ) );
			String strMemberShipID = ChangeEncode.setChar( rs.getString( MEMBER_SHIP_ID ) );
			String strMaterialID = ChangeEncode.setChar( rs.getString( MATERIAL_ID ) );
			String strStudyStartDate = XMODate.parseTime( rs.getTimestamp( STUDY_START_DATE ) );
			String strEndDate = XMODate.parseTime( rs.getTimestamp( END_DATE ) );
			String strAssigner = ChangeEncode.setChar( rs.getString( ASSIGNER ) );
			String strLearnAuthority = ChangeEncode.setChar( rs.getString( LEARN_AUTHORITY ) );
			String strManagementAuthority = ChangeEncode.setChar( rs.getString( MANAGEMENT_AUTHORITY ) );
// UgZbgVKǉJf[^擾B
			// wKJn
			Date openingDate = null;
			openingDate = rs.getTimestamp(OPENING_DATE);
			// wKI
			Date closingDate = null;
			closingDate = rs.getTimestamp(CLOSING_DATE);
			// wK
			String studyCount =null;
			studyCount = rs.getString(STUDY_COUNT);
			// wK
			String studyLimitCount =null;
			studyLimitCount = rs.getString(STUDY_LIMIT_COUNT);
			// \bhtO
			String methodFlag = null;
			methodFlag = rs.getString(METHOD_FLAG);
			
			// AssignmentsDataNX̃CX^X
			AssignmentsData objData = new AssignmentsData();
			// etB[hlZbg܂
			objData.setAssignID( strAssignID );
			objData.setMemberShipID( strMemberShipID );
			objData.setMaterialID( strMaterialID );
			objData.setStudyStartDate( strStudyStartDate );
			objData.setEndDate( strEndDate );
			objData.setAssigner( strAssigner );
			objData.setLearnAuthority( strLearnAuthority );
			objData.setManagementAuthority( strManagementAuthority );
			objData.setMethodFlag(methodFlag);
			
			// VKJf[^f[^NXɐݒ
			// wKJn
			objData.setOpeningDate( openingDate );
			// wKI
			objData.setClosingDate( closingDate );
			// wK
			objData.setStudyCount( studyCount );
			// wK
			objData.setStudyLimitCount( studyLimitCount );
			// ԋpxN^[AssignmentsDataNXǉ܂
			vecReturn.add( objData );
		}

		return vecReturn;

	}

	/**
	 * őAssignID擾
	 * @return String őAssignID
	 */
	private String getMaxAssignID( DataAccess objDataAccess )
		throws SQLException
	{
		String strSQL="";

		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			//Oraclȅꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				 strSQL = "select MAX(CONVERT(INT,assignID)) + 1 as maxassignid from Assignments";
			//SQLServeȑꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
				 strSQL = "select MAX(TO_NUMBER(assignID)) + 1 as maxassignid from Assignments";
			//PostgreSQL̏ꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				 strSQL = "select MAX(TO_NUMBER((assignID),'9999999999')) + 1 as maxassignid from Assignments";
			}
		}
		catch(Exception ex)
		{

		}

		String strMaxAssignID = "";
		DebugLog.write( this.getClass(), strSQL, DebugLog.ROW );
		ResultSet rs = objDataAccess.executeQuery(strSQL);
		while(rs.next()) {
			int intTemp = 0;
			intTemp = rs.getInt( "maxassignid" );
			strMaxAssignID = new Integer(intTemp).toString();
		}

		return strMaxAssignID;
	}

	/**
	 * ̑݃`FbNs܂
	 * @param htbParam p[^
	 * @param objDataAccess DBANZXNX
	 * @return boolean true: 蓖ĂĂ false: 蓖ĂĂȂ
	 * @exception SQLException DBG[
	 */
	private boolean isExitAssign( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{
		// lXID̎擾
		String strMemberShipID = (String)htbParam.get( MEMBER_SHIP_ID );
		// R|[lgID̎擾
		String strMaterialID = (String)htbParam.get( MATERIAL_ID );

		// ̑gݗ
		String strCondition = " WHERE " + MEMBER_SHIP_ID + "='" + StringEscapeUtils.escapeSql(strMemberShipID) + "' AND " + MATERIAL_ID + "='" + StringEscapeUtils.escapeSql(strMaterialID) + "'";

		return objDataAccess.isExit( strCondition, TABLE_NAME );
	}

	/**
	 * o^AXṼf[^gݗĂ܂
	 * @param htData
	 * @return Hashtable
	 */
	private Hashtable setData( Hashtable htbParam ) {

		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, MEMBER_SHIP_ID );
		putData( htbData, htbParam, MATERIAL_ID );
		putData( htbData, htbParam, STUDY_START_DATE );
		putData( htbData, htbParam, END_DATE );
		putData( htbData, htbParam, ASSIGNER );
		putData( htbData, htbParam, LEARN_AUTHORITY );
		putData( htbData, htbParam, MANAGEMENT_AUTHORITY );
// o^J̒ǉ
		putData( htbData, htbParam, OPENING_DATE );
		putData( htbData, htbParam, CLOSING_DATE );
		putData( htbData, htbParam, STUDY_COUNT );
		putData( htbData, htbParam, STUDY_LIMIT_COUNT );
		//	ADD 2005/03/28 START Kentaro Ishizaki [\bhǗǉ]
		putData( htbData, htbParam, METHOD_FLAG );
		//	ADD 2005/03/28 END Kentaro Ishizaki [\bhǗǉ]
		return htbData;
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData,  Hashtable htbParam, String strKey ) {
		String strValue = (String)htbParam.get( strKey );
		if( strValue != null ) {
			htbData.put( strKey, strValue );
		}
	}

	/**
	 * bZ[WIuWFNg쐬܂
	 * @param strMessageID bZ[WID
	 * @return MessageData bZ[WIuWFNg OnullԂ܂
	 */
	private MessageData getMessageData( String strMessageID) {
		MessageData objMessage = null;
		try {
			objMessage = Message.getInstance().getMessageData( strMessageID, MSG_FIEL_PATH, MSG_FILE_NAME );
		}
		catch( Exception e ) {

		}
		return objMessage;
	}
	/**
	 * ATC҂̌s܂
	 * @param strMaterialIDList MaterialIDXg
	 * @param strUserID [UID
	 * @param intAssignType ATC^Cv
	 * @return String[] ATC҃Xg
	 * @exception SQLException DBG[
	 */
	public String[] selectAssigner( String[] strMaterialIDList, String strUserID, int intAssignType )
		throws SQLException
	{

		DataAccess objDataAccess = new DataAccess();

		// ʕێVector
		Vector vecAssingerList = new Vector();
		try {
			// gUNV̊Jn
			objDataAccess.trans();

			int intMaxCount = strMaterialIDList.length;
			int intCount = 0;

			while( intCount < intMaxCount ) {

				StringBuffer sbMaterialSQL = new StringBuffer();
				// 100 in MateiralIDݒ肷
				while( ( intCount + 1 ) % 100 != 0 &&
						intCount < intMaxCount )
				{
					sbMaterialSQL.append( "'" + StringEscapeUtils.escapeSql(strMaterialIDList[intCount]) + "'" );
					sbMaterialSQL.append( "," );
					intCount++;
				}

				// Ō','菜
				String strMaterialSQL = sbMaterialSQL.substring( 0, sbMaterialSQL.length() - 1 );

				// ̏쐬
				String strAuthSQL = "";
				if( intAssignType == LEARN_TYPE ) {
					strAuthSQL = TABLE_NAME + "." + LEARN_AUTHORITY + "='1'";
				}
				else if( intAssignType == MANAGE_TYPE ) {
					strAuthSQL = TABLE_NAME + "." + MANAGEMENT_AUTHORITY + "='1'";
				}
				else {
					strAuthSQL = TABLE_NAME + "." + LEARN_AUTHORITY + "='1' AND " + TABLE_NAME + "." + MANAGEMENT_AUTHORITY + "='1'";
				}

				// SQL̍쐬 Assignment INNER JOIN GroupAndPeople ON Assignments.memberShipID = GroupAndPeople.memberShipID
				StringBuffer sbSQL = new StringBuffer();
				sbSQL.append( "SELECT " + TABLE_NAME + "." + ASSIGNER + " as " + ASSIGNER );
				sbSQL.append( " FROM " + TABLE_NAME + " INNER JOIN " + GroupAndPeopleTable.TABLE_NAME + " ON " );
				sbSQL.append( TABLE_NAME + "." + MEMBER_SHIP_ID + "=" + GroupAndPeopleTable.TABLE_NAME + "." + GroupAndPeopleTable.MEMBER_SHIP_ID );
				sbSQL.append( " WHERE " + GroupAndPeopleTable.TABLE_NAME + "." + GroupAndPeopleTable.CHILD_ID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " );
				sbSQL.append( TABLE_NAME + "." + MATERIAL_ID + " IN (" + strMaterialSQL + ") AND " );
				sbSQL.append( strAuthSQL );

				// NG[s܂
				ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

				while(rs.next()) {
					String strAssignerID = ChangeEncode.setChar(rs.getString( ASSIGNER ));
					if( !vecAssingerList.contains( strAssignerID ) ) {
						vecAssingerList.add( strAssignerID );
					}
				}
			}

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException se ) {
			try{ objDataAccess.rollback(); } catch( Exception ex ) {}
			throw se;
		}

		String[] strRes = new String[vecAssingerList.size()];
		vecAssingerList.copyInto( strRes );

		return strRes;

	}

	/**
	 * w肳ꂽ[UIDLOID̃ATCLE擾ĕԂB<BR>
	 * @param strUserID [UID
	 * @param strGroupID O[vIDinull̏ꍇׂ͌ĂΏ)
	 * @param strMaterialID MaterialID
	 * @return AssignUsableList
	 */
	public AssignUsableList getAssignUsable(
		String strUserID,
		String strGroupID,
		String strMaterialID) 
		throws SQLException
	{

		DataAccess dataAccess = new DataAccess();

		// ATC胊XgNX̃CX^X
		AssignUsableList list = new AssignUsableList();

		try {
			// gUNVJn
			dataAccess.trans();
			
			StringBuffer sbSQL = new StringBuffer();
			
			// SQL̍쐬(O[vIDnullłȂƂ̓O[vIDɎw肷)
			// SQLɌՂD悵āAR[fBOKƂ͈قȂLqĂ̂ŒӁI
			sbSQL.append( "SELECT " );
			sbSQL.append( "    lorel.parentID AS lo_parent_id, " );
			sbSQL.append( "    lorel.childID AS lo_child_id,   " );
			sbSQL.append( "    grp.ParentID AS group_id,       " );
			sbSQL.append( "    ass.opening_date AS opening_date,  " );
			sbSQL.append( "    ass.closing_date AS closing_date,  " );
			sbSQL.append( "    ass.study_limit_cnt AS study_limit_cnt,  " );
			sbSQL.append( "    ass.study_cnt AS study_cnt, " );
			sbSQL.append( "    ass.learn_authority AS learn_authority, " );
			sbSQL.append( "    ass.management_authority AS management_authority " );
			sbSQL.append( "FROM " );
			sbSQL.append( "    Assignments ass  " );
			sbSQL.append( "    INNER JOIN " );
			sbSQL.append( "    GroupAndPeople grp ON  " );
			sbSQL.append( "    ass.memberShipID = grp.memberShipID  " );
			sbSQL.append( "    RIGHT OUTER JOIN " );
			sbSQL.append( "    LORelation lorel ON  " );
			sbSQL.append( "    ass.materialID = lorel.materialID " );
			sbSQL.append( "WHERE " );
			sbSQL.append( "    lorel.materialID = '" + StringEscapeUtils.escapeSql(strMaterialID) + "' AND  " );
			sbSQL.append( "    grp.childID = '" + StringEscapeUtils.escapeSql(strUserID) + "' " );
			if( strGroupID != null ) 
			sbSQL.append( "    AND grp.ParentID = '" + StringEscapeUtils.escapeSql(strGroupID) + "' " );

			DebugLog.write( this.getClass(), sbSQL.toString(), DebugLog.ROW );
			ResultSet rs = dataAccess.executeQuery(sbSQL.toString());
			
			// ʃZbg[vi2ȏニ[v̂͌[UɓATCꍇ̂݁j
			while( rs.next() ) {
				AssignUsable usable = new AssignUsable();
				
				// ATCLO̐eID
				String assingLoParentID = ChangeEncode.setChar(rs.getString("lo_parent_id"));
				// ATCLO̎qID
				String assignLoChildID = ChangeEncode.setChar(rs.getString("lo_child_id"));
				// O[vID
				String groupID = ChangeEncode.setChar(rs.getString("group_id"));

				// wKATC
				String learnAuthority = ChangeEncode.setChar( rs.getString( "learn_authority" ) );
				// ǗATC
				String managementAuthority = ChangeEncode.setChar( rs.getString( "management_authority" ) );

				// JniIjava.util.Date ɃLXgj
				java.util.Date opendingDate = (java.util.Date)rs.getTimestamp("opening_date");
				// IiIjava.util.Date ɃLXgj
				java.util.Date closingDate = (java.util.Date)rs.getTimestamp("closing_date");
				// wK
				int studyLimitCnt = rs.getInt("study_limit_cnt");
				// wK
				int studyCnt = rs.getInt("study_cnt");
				
				usable.setAssignLoParentID(assingLoParentID);
				usable.setAssignLoChildID(assignLoChildID);
				usable.setGroupID(groupID);
				usable.setOpeningDate(opendingDate);
				usable.setClosingDate(closingDate);
				usable.setStudyLimitCnt(studyLimitCnt);
				usable.setStudyCnt(studyCnt);

				usable.setLearnAuthority(learnAuthority);
				usable.setManagementAuthority(managementAuthority);

				// Xgɒǉ
				list.add(usable);
			}
			
			// R~bg
			dataAccess.commit();
			
		}
		catch(SQLException se ) {
			try {
				dataAccess.rollback();
			}
			catch(SQLException sse ) {}

			throw se;
		}
		return list;
	}


	/**
	/**
	 * w肳ꂽ[UIDLOID̒̃ATCLE擾ĕԂB<BR>
	 * @param strMaterialID MaterialID
	 * @return AssignUsableList
	 * @param strUserID [UID
	 * @param strGroupID O[vIDinull̏ꍇׂ͌ĂΏ)
	 * @param strLoID LOID
	 * @return List
	 */
	public List getUnderAssignUsable(
		String strUserID,
		String strGroupID,
		String strLoID) 
			throws SQLException 	
	{

		DataAccess dataAccess = new DataAccess();

		// ATC胊XgNX̃CX^X
		ArrayList resultList = new ArrayList();

		try {
			// gUNVJn
			dataAccess.trans();
			
			// SQL̍쐬(O[vIDnullłȂƂ̓O[vIDɎw肷)
			// SQLɌՂD悵āAR[fBOKƂ͈قȂLqĂ̂ŒӁI
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append("SELECT ");
			sbSQL.append("    lorel.parentID AS lo_parent_id, ");
			sbSQL.append("    lorel.childID AS lo_child_id, ");
			sbSQL.append("    gras.ParentID AS group_id, ");
			sbSQL.append("    gras.ChildID AS user_id, ");
			sbSQL.append("    gras.materialID AS materialID, ");
			sbSQL.append("    gras.opening_date AS opening_date, ");
			sbSQL.append("    gras.closing_date AS closing_date, ");
			sbSQL.append("    gras.study_limit_cnt AS study_limit_cnt, ");
			sbSQL.append("    gras.study_cnt AS study_cnt ");
			sbSQL.append("FROM ");
			sbSQL.append("    LORelation lorel ");
			sbSQL.append("LEFT OUTER JOIN ");
			sbSQL.append("   (SELECT    grp.ParentID, ");
			sbSQL.append("          grp.ChildID, ");
			sbSQL.append("          ass.materialID, ");
			sbSQL.append("          ass.opening_date, ");
			sbSQL.append("          ass.closing_date, ");
			sbSQL.append("          ass.study_limit_cnt, ");
			sbSQL.append("          ass.study_cnt ");
			sbSQL.append("    FROM    Assignments ass ");
			sbSQL.append("    INNER JOIN ");
			sbSQL.append("          GroupAndPeople grp  ");
			sbSQL.append("    ON      ass.memberShipID = grp.memberShipID ");
			sbSQL.append("    WHERE   grp.childID = '" + StringEscapeUtils.escapeSql(strUserID) + "' ");
			if( strGroupID != null )
			sbSQL.append( "   AND     grp.ParentID = '" + StringEscapeUtils.escapeSql(strGroupID) + "' " );
			sbSQL.append("    ) gras ");
			sbSQL.append("ON      gras.materialID = lorel.materialID ");
			sbSQL.append("WHERE   lorel.parentID = '" + StringEscapeUtils.escapeSql(strLoID) + "' ");
			DebugLog.write( this.getClass(), sbSQL.toString(), DebugLog.ROW );
			ResultSet rs = dataAccess.executeQuery(sbSQL.toString());
			
			// ƗpMapIuWFNg
			HashMap work = new HashMap();
			
			// ʃZbg[vi2ȏニ[v̂͌[UɓATCꍇ̂݁j
			while( rs.next() ) {
				
				// ATCL(MaterialIDNULL̎̓ATC݂Ȃ)
				boolean assign = rs.getString("materialID") != null;
				// ATCLO̐eID
				String assingLoParentID = ChangeEncode.setChar(rs.getString("lo_parent_id"));
				// ATCLO̎qID
				String assignLoChildID = ChangeEncode.setChar(rs.getString("lo_child_id"));
				// O[vID
				String groupID = ChangeEncode.setChar(rs.getString("group_id"));
				// JniIjava.util.Date ɃLXgj
				java.util.Date opendingDate = (java.util.Date)rs.getTimestamp("opening_date");
				// IiIjava.util.Date ɃLXgj
				java.util.Date closingDate = (java.util.Date)rs.getTimestamp("closing_date");
				// wK
				int studyLimitCnt = rs.getInt("study_limit_cnt");
				// wK
				int studyCnt = rs.getInt("study_cnt");

				// ƗpMapLOIDL[ɂāCATCIuWFNgXgoB
				AssignUsableList usableList = (AssignUsableList)work.get(assignLoChildID);
				if( usableList == null ) {
					// ܂ƗpMapɓo^ĂȂꍇ͐VKɃCX^X
					usableList = new AssignUsableList();
					usableList.setLoID(assignLoChildID);
					usableList.setUserID(strUserID);
					
					// ƗpMapLOIDL[ɂĕۑ
					work.put(assignLoChildID, usableList);
					
					// ʃXgɂo^
					resultList.add( usableList );
				}
				
				if( assign ) {
					// ATC݂ꍇ̂݃ATCIuWFNg쐬ăXgɉB
					AssignUsable usable = new AssignUsable();
					
					usable.setLoID(assignLoChildID); // ATCƃ^[QbgLO͓
					usable.setAssignLoParentID(assingLoParentID);
					usable.setAssignLoChildID(assignLoChildID);
					usable.setGroupID(groupID);
					usable.setOpeningDate(opendingDate);
					usable.setClosingDate(closingDate);
					usable.setStudyLimitCnt(studyLimitCnt);
					usable.setStudyCnt(studyCnt);
					
					// Xgɒǉ
					usableList.add(usable);
				}
			}

			// R~bg
			dataAccess.commit();
			
		}
		catch(SQLException se ) {
			try {
				dataAccess.rollback();
			}
			catch(SQLException sse ) {}
			throw se;
		}
		return resultList;

	}


   /**
	* w肳ꂽO[vID܂̓[UIDLOID̃ATC擾ĕԋp܂B<BR>
	* @param inComponentList 	INƂR|[lgID
	* @param inGroupList 		INƂO[vID
	* @param strUserID 		[UID
	* 
	* @return resultList 		ʂi[AssignUsablẽXg
	*/
	public List getAssignInfo(
		String inComponentList,
		String inGroupList,
		String strUserID) 
		throws XmsException {

		DataAccess dataAccess = new DataAccess();
		ResultSet rs = null;
		boolean exceptionFlag = false;

		// ATC胊XgNX̃CX^X
		List resultList = new ArrayList();

		try {

			// `FbN̎擾
			Date checkDate = new Date();

			// gUNVJn
			dataAccess.trans();

			// SQL̍쐬(O[vIDnullłȂƂ̓O[vIDɎw肷)
			// SQLɌՂD悵āAR[fBOKƂ͈قȂLqĂ̂ŒӁI
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append( "SELECT " );
			sbSQL.append( "    gp.ParentID AS GroupID, " );	// O[vID
			sbSQL.append( "    gp.ChildID AS UserID, " );	// [UID
			sbSQL.append( "    a.materialID AS CompornentID, " );	// R|[lgID
			sbSQL.append( "    a.opening_date AS OpenPeriod, " );	// ATC Jn
			sbSQL.append( "    a.closing_date AS ClosePeriod, " );	// ATC I
			sbSQL.append( "    a.study_limit_cnt AS StudyLimitCount, " );	// wK
			sbSQL.append( "    a.study_cnt AS StudyCount " );	// wK
			sbSQL.append( "FROM " );
// Oracleł̓e[uʖasgpȂB
			sbSQL.append( " GroupAndPeople gp" );
			sbSQL.append( " INNER JOIN" );
			sbSQL.append( " Assignments a ON" );
			sbSQL.append( "    gp.memberShipID = a.memberShipID " );
			sbSQL.append( "WHERE " );
			sbSQL.append( "    a.learn_authority = '1' " );	//wK̃ATĈ
			sbSQL.append( "    AND " );

			// O[vE[UwǂłINƂ
			sbSQL.append( "    gp.ParentID " + inGroupList );
			// [Uw̏ꍇ
			if (strUserID != null) {			
				sbSQL.append( "    AND " );
				sbSQL.append( "    gp.ChildID = '" + StringEscapeUtils.escapeSql(strUserID) + "'");
			}
			sbSQL.append( "    AND " );						
			// R|[lgIDw
			sbSQL.append( "    a.materialID " + inComponentList );

			rs = dataAccess.executeQuery(sbSQL.toString());

			// ʃZbg[v
			while( rs.next() ) {
				
				// O[vID
				String assingGroupID = ChangeEncode.setChar(rs.getString("GroupID"));
				// [UID
				String assignUserID = ChangeEncode.setChar(rs.getString("UserID"));
				// R|[lgID
				String compornentID = ChangeEncode.setChar(rs.getString("CompornentID"));
				// JniIjava.util.Date ɃLXgj
				Date opendingDate = (Date)rs.getTimestamp("OpenPeriod");
				// IiIjava.util.Date ɃLXgj
				Date closingDate = (Date)rs.getTimestamp("ClosePeriod");
				// wK
				int studyLimitCount = rs.getInt("StudyLimitCount");
				// wK
				int studyCount = rs.getInt("StudyCount");


				// ATCIuWFNg쐬ăXgɉB
				AssignUsable usable = new AssignUsable();
				// O[vIDݒ
				usable.setGroupID(assingGroupID);
				// [UIDݒ
				usable.setUserID(assignUserID);
				// R|[lgIDݒ
				usable.setComponentId(compornentID);
				// Jn
				usable.setOpeningDate(opendingDate);
				// I
				usable.setClosingDate(closingDate);
				// wK
				usable.setStudyLimitCnt(studyLimitCount);
				// wK
				usable.setStudyCnt(studyCount);
				// `FbNݒ肷
				usable.setCheckDate( checkDate );
				// Xgɒǉ
				resultList.add(usable);
			}

			// R~bg
			dataAccess.commit();
			
		} catch (Exception e) {
			throw new XmsSystemException(e);
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (Exception e) {
					if (exceptionFlag == true) {
						throw new XmsSystemException(e);
					}
				}
				rs = null;
			}
		}
		return resultList;

	}

	/**
	 * w肵[UIDƃ}eAID̑gݍ킹̊wK񐔂PB<br>
	 * w肵[Úuv邱ƂɂAY郌R[hꍇA
	 * 烌R[hׂĂΏۂƂȂB
	 * @param userID [UIDB
	 * @param loID Ώۂ̋IDB
	 * @param loType Ώۂ̂knʁB
	 * @throws SQLException f[^x[XG[ꍇB
	 * @throws XMOException wlnʃG[ꍇB
	 * @throws Exception	̑G[ꍇB
	 */
// }eAID܂͋IDŃJEgAbvł悤ɏC
// }eAIDŎ󂯎ȂA܂knʂ󂯎悤ɏCB
	public void countupStudyCount(String userID, String loID, String loType)
			throws SQLException, XMOException, Exception {
		
		DataAccess dataAccess = null;
		boolean exceptionFlag = false;
		boolean transactionStartFlag = false;
		Environment environment = null;
		String dbType = null;

		StringBuffer stbWhere = null;
// knʂvasASmartForceAPerception̏ꍇAƎIDXMS2ւLOIDɕϊKv
// ̃WbNɕKvȕϐ

// ϐsvƂȂׁANGpStringBufferƕϊLOIDString폜
		// NGsɎ擾郊UgZbg
		ResultSet resultSet =null;

		try {

// \bhJnfobOOo
			DebugLog.write( this.getClass()
				, "HEAD countupStudyCount("
					+ " \""+ userID + "\""
					+ ", \"" + loID + "\""
					+ ", \"" + loType + "\")"
				, DebugLog.ROW);

			exceptionFlag = true;
			transactionStartFlag = false;
// f[^x[Xɂă[UID, LOID̕ύXȂ΂ȂȂׁA
// f[^x[X^Cv擾ʒuύX
			//==================================================================
			// f[^x[X^Cv̎
			environment = new Environment();		
			dbType = environment.getDBType();


			if ( userID == null || userID.length() == 0 ) {
				DebugLog.write( this.getClass(),
						"countupStudyCount():useID == null", DebugLog.HIGHT);
				throw new XMOException( "useID == null" );
			}
// }eAID܂͋IDŃJEgAbvł悤ɏC߁A
// O𔭐ύX

// ͋ID݂̂ɂ̂ŏύX
			// LOIDƂnull̏ꍇG[
			if ( loID == null || loID.length() == 0 ) {
				DebugLog.write( this.getClass(),
						"countupStudyCount():loID == null", DebugLog.HIGHT);
				throw new XMOException( "loID == null" );
			}			

// knʂvas̏ꍇAƎIDXMS2ւLOIDɕϊĂA
// LOIDgp悤ɂȂ̂ŕϊWbN͕KvłȂȂׁA폜B
			// =================================================================
			// RlNV擾EgUNVJn
			dataAccess = new DataAccess();
			dataAccess.trans();
			transactionStartFlag = true;
			// =================================================================
			// ̎擾
			stbWhere = new StringBuffer();

// SQLf[^x[Xł́Af[^̋󔒂`ŌvĂ邪A
// Oraclef[^x[X̏ꍇA󔒂f[^ƂĈĂ邱Ƃv
// sĂȂB
// ̂ƂAOraclȅꍇmemberShipIDɎwID̕񂪊܂܂Ă
// ̂悤ɏCB

			// MS SQL Server ̏ꍇ
			if ( dbType.equals( "0" ) == true ) {
// }eAID܂͋IDŃJEgAbvł悤ɏC

// LOIDŃJEgAbv悤ɍďC
// [UIDɂĂ󔒏֐ĂԂ߁ARDMSƂɋLq悤ɑ}
				// [UID
				stbWhere.append( " AND rtrim(" + MEMBER_SHIP_ID + ")" );
				stbWhere.append( " like '%" + StringEscapeUtils.escapeSql(userID) + "'" );
				// ID킽ꍇ͌vB
				stbWhere.append( " AND rtrim(" + MATERIAL_ID + ")" );
				stbWhere.append( " like '%" + StringEscapeUtils.escapeSql(loID) + "'" );

			}
			// Oracle ̏ꍇ or PostgreSQL ̏ꍇ
			else if ( dbType.equals( "1" ) == true || dbType.equals( "2" ) == true ) {

// LOIDŃJEgAbv悤ɍďC
// [UIDɂĂ󔒏֐ĂԂ߁ARDMSƂɋLq悤ɑ}
				// [UID
				stbWhere.append( " AND trim(" + MEMBER_SHIP_ID + ")" );
				stbWhere.append( " like '%" + StringEscapeUtils.escapeSql(userID) + "'" );
				// ID킽ꍇ͌vB
				stbWhere.append( " AND trim(" + MATERIAL_ID + ")" );
				stbWhere.append( " like '%" + StringEscapeUtils.escapeSql(loID) + "'" );

			}

// f[^x[Xɂă[UID, LOID̕ύXȂ΂ȂȂׁA
// f[^x[X^Cv擾ʒu{̑Oֈړ
			//==================================================================
			// f[^x[X^Cv̎
			// =================================================================
			// SQL̍쐬
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append( "update " + TABLE_NAME );
			sbSQL.append( " set " + STUDY_COUNT + "=" );
			// DBT[o[ɂNULLlϊ\bhقȂ邽߁A

			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();

			// MS SQL Serveȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbSQL.append( "isnull(" + STUDY_COUNT + ",0) + 1" );
			// Oraclȅꍇ
			} else if (objEnv.getDBType().equals( objEnv.DB_ORACLE)){
				sbSQL.append( "nvl(" + STUDY_COUNT + ",0) + 1" );
			// PostgreSQL̏ꍇ	
			} else if (objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				sbSQL.append( "COALESCE(" + STUDY_COUNT + ",0) + 1" );
			}

			// (擪AND)
			sbSQL.append(" WHERE ");
			sbSQL.append(stbWhere.substring(4));

// gUNVJnʒu葁iKɎ{
			DebugLog.write( this.getClass(), sbSQL.toString(), DebugLog.ROW );
			// =================================================================
			// rpks
			DebugLog.write(this.getClass(), sbSQL, DebugLog.MID);
			dataAccess.execute(sbSQL.toString());
			// =================================================================
			// R~bg
			dataAccess.commit();
			
			exceptionFlag = false;
		} finally {
// ʃZbg̃N[Y
			try {
				if ( resultSet != null ) {
					resultSet.close();
					resultSet = null;
				}
			} catch ( SQLException e ) {
				// łɗOĂ΁A̗OD悵A
				// ĂȂ΁AN[Y̗OX[B
				if ( exceptionFlag == false ) {
					exceptionFlag = true;
					throw e;
				}
			} finally {
				// OAAO̔gUNVJnȌꍇ
				// [obNsB
				if ( ( exceptionFlag == true ) && (transactionStartFlag == true ) ) {
					dataAccess.rollback();
					dataAccess = null;
				}
				// \bhIOo
				DebugLog.write( this.getClass()
					, "TAIL countupStudyCount("
						+ " \""+ userID + "\""
						+ ", \"" + loID + "\""
						+ ", \"" + loType + "\")"
					, DebugLog.ROW);
			}
		}
	}
}
