/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	AICCLogForCSV
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;

import org.xml.sax.SAXException;

/**
 *	AICCLogForCSV NX<br>
 *	CSV`AOCCLog̋ۃNX<br>
 */
public class AICCLogForCSV {
	/**
	 * ^CgsHashMapBL[StringŃ^CgA
	 * lɂ Integerŗԍi[
	 */
	private HashMap title;

	/** f[^sArrayListBString[]ōs̃f[^i[ */
	private ArrayList data;

	/** ArrayListString[]֕ϊۂɎgpconstl */
	private static String[] _toArray = new String[0];

	/**
	 * ftHgRXgN^
	 */
	public AICCLogForCSV() {}

	/**
	 * w肳ꂽCSV`AICCOt@Cǂݍ݁AsB<br>
	 * t@Csǂݍ݁A^Cgs(1s)ƃf[^s(2sڈȍ~)
	 * ɕsAꂼAHashMap titleArrayList data֊i[B<br>
	 * title̓L[Ƀ^CgAlɊY^Cg̗ԍIntegerŊi[<br>
	 * dataHashMapString[]^̔zŁAJ}ŕꂽf[^sɊi[<br>
	 *
	 * @param filename	CSV`AICCOt@Cw肷
	 */
	public void initialize(String filename)
		throws
			UnsupportedEncodingException,
			FileNotFoundException,
			IOException,
			ParserConfigurationException,
			SAXException,
			TransformerException,
			SystemException {

		String encoding = SG.get("LearningLogEncoding");

		BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));

		try {
			String line = br.readLine();

			if (line == null) {
				throw new SystemException(filename + " is no title line");
			}

			String[] _title = separate(line, 1, encoding);

			title = new HashMap(_title.length);

			for (int i = 0; i < _title.length; i++) {
				title.put(_title[i], new Integer(i));
			}

			data = new ArrayList();

			for (int lineNumber = 2;; lineNumber++) {
				line = br.readLine();

				if (line == null) {
					break;
				}

				String[] _data = separate(line, lineNumber, encoding);

				if (_data.length != title.size()) {
					throw new SystemException(
						line + "(" + lineNumber + ") [" + _data.length + ", " + title.size() + "]");
				}

				data.add(_data);
			}
		}
		finally {
			br.close();
		}
	}

	/**
	 * lineŎw肳ꂽ,ŕB<br><br>
	 * 1. ,,ڊԂ"ň͂܂Ă鎖<br>
	 * 2. "ڂɐݒ肷ꍇ""ŃGXP[vĂ鎖<br>
	 *
	 * @param	line	CSV`̕
	 * @return	,ŕꂽ̔zԋp
	 */
	private String[] separate(String line, int lineNumber, String encoding)
		throws SystemException, UnsupportedEncodingException {
		StringBuffer sb = new StringBuffer();
		ArrayList list = new ArrayList();

		int max = line.length();

		int status = 0;

		for (int i = 0; i < max; i++) {

			switch (status) {
				case 0 : /* check current position is (initial) " */

					if (line.charAt(i) != '\"') {
						throw new SystemException(
							line + "(" + lineNumber + ") - " + i + ":(" + (char)line.charAt(i) + ")");
					}

					status++;
					break;

				case 1 : /* find terminate " */
					if (line.charAt(i) == '\"') {

						if (i + 1 >= max) {
							status++;
							break;
						}

						if (line.charAt(i + 1) != '\"') {
							status++;
							break;
						}

						i++;
					}

					sb.append(line.charAt(i));
					break;

				case 2 : /* check current position is , */
					if (line.charAt(i) != ',') {
						throw new SystemException(
							line + "(" + lineNumber + ") - " + i + ":(" + (char)line.charAt(i) + ")");
					}

					list.add(URLDecoder.decode(sb.toString(), encoding));

					sb = new StringBuffer();

					status = 0;
					break;
			}
		}

		if (status != 2) {
			throw new SystemException(line + "(" + lineNumber + ") - status = " + status);
		}

		list.add(URLDecoder.decode(sb.toString(), encoding));

		return (String[])list.toArray(_toArray);
	}

	/**
	 * ^Cg̗擾
	 *
	 * @param	name	^Cgw肷
	 * @return	
	 */
	public int index(String name) {
		return ((Integer)title.get(name)).intValue();
	}

	/**
	 * f[^̍s擾
	 *
	 * @return	f[^̍s
	 */
	public int size() {
		return data.size();
	}

	/**
	 * indexŎw肳ꂽs̃f[^擾
	 *
	 * @param	row	sԓ
	 * @return	Ỹf[^String[]ŕԋp
	 */
	public String[] get(int row) {
		return (String[])data.get(row);
	}

	/**
	 * w肳ꂽAs̃f[^擾
	 *
	 * @param	row		sԍw肷
	 * @param	column	w肷
	 * @return	YsÃf[^ԋp
	 */
	public String get(int row, int column) {
		return get(row)[column];
	}

	/**
	 * w肳ꂽAs̃f[^擾
	 *
	 * @param	title	^Cgw肷
	 * @param	row		sԍw肷
	 * @return Ys̊Y^Cg̗̃f[^ԋp
	 */
	public String get(String title, int row) {
		return get(row)[index(title)];
	}
}
