/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.core.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.util.LoggerUtil;

/**
 * f[^x[X[eBeBNXB
 * @author T.Nishiki
 */
public class InstallerDatabaseUtil {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(InstallerDatabaseUtil.class);
	}


	/**
	 * SQLXe[ggN[Y܂B
	 * @param statement N[YΏۂ̃Xe[ggB
	 * @param throwFlag N[YɎsƂɗOX[ꍇ́AtrueB
	 * @throws InstallerException LQƁB
	 */
	public static void close(Statement statement, boolean throwFlag)
			throws InstallerException {
		// ^ppRlNṼN[Y
		if (statement != null) {
			try {
				statement.close();
			}
			catch (Exception e) {
				LoggerUtil.throwable(_logger, e);
				if (throwFlag) {
					throw new InstallerException(e);
				}
			}
		}
	}

	/**
	 * w肳ꂽNG[s܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param connection NGs邽߂̃f[^x[XڑIuWFNgB
	 * @param query sNG[B
	 * @throws InstallerException f[^x[XANZXɗOꍇB
	 */
	public static void executeOneQuery(
			InstallerValues values, Connection connection, String query)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"executeOneQuery(InstallerValues," +  query + ")");

		Statement statement = null;
		boolean successFlag = false;
		try {
			// Xe[gg擾Es
			statement = connection.createStatement();
			statement.execute(query);
			// Xe[ggN[Y
			InstallerDatabaseUtil.close(statement, true);
			// gUNVER~bg
			connection.commit();
			// tryubN[܂œB
			successFlag = true;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		finally {
			InstallerDatabaseUtil.close(statement, successFlag);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"executeOneQuery(InstallerValues," +  query + ")");
	}

	/**
	 * SQLXe[ggƌʃZbgN[Y܂B
	 * @param statement N[YΏۂ̃Xe[ggB
	 * @param resultSet N[YΏۂ̌ʃZbgB
	 * @param throwFlag N[YɎsƂɗOX[ꍇ́AtrueB
	 * @throws InstallerException LQƁB
	 */
	public static void close(
			Statement statement, ResultSet resultSet, boolean throwFlag)
			throws InstallerException {
		InstallerException thrownException = null;
		// ʃZbg̃N[Y
		if (resultSet != null) {
			try {
				resultSet.close();
			}
			catch (Exception e) {
				LoggerUtil.throwable(_logger, e);
				if (throwFlag) {
					thrownException = new InstallerException(e);
				}
			}
		}
		// Xe[gg̃N[Y
		if (statement != null) {
			try {
				statement.close();
			}
			catch (Exception e) {
				LoggerUtil.throwable(_logger, e);
				if (throwFlag && thrownException == null) {
					thrownException = new InstallerException(e);
				}
			}
		}
		// Oꍇ̓X[B
		if (thrownException != null) {
			throw thrownException;
		}
	}

	/**
	 * SQLʃZbgN[Y܂B
	 * @param resultSet N[YΏۂ̃Xe[ggB
	 * @param throwFlag N[YɎsƂɗOX[ꍇ́AtrueB
	 * @throws InstallerException LQƁB
	 */
	public static void close(ResultSet resultSet, boolean throwFlag)
			throws InstallerException {
		// ^ppRlNṼN[Y
		if (resultSet != null) {
			try {
				resultSet.close();
			}
			catch (Exception e) {
				LoggerUtil.throwable(_logger, e);
				if (throwFlag) {
					throw new InstallerException(e);
				}
			}
		}
	}

	/**
	 * f[^x[XڑIuWFNg擾܂B<br>
	 * @param values CXg[ʃf[^NXB
	 * @param dbHost f[^x[XEzXgB
	 * @param dbPort f[^x[X|[gԍB
	 * @param dbName f[^x[XB
	 * @param user ڑ[UB
	 * @param pass ڑpX[hB
	 * @param patternKey JDBC擾p̃L[́B
	 * @param autoCommit 쐬RlNVI[gR~bgƂꍇtrueB
	 * @return RlNV擾܂B
	 * @throws InstallerException RlNV擾Ɏsꍇ
	 */
	public static Connection getConnection(
			InstallerValues values,
			String dbHost, String dbPort, String dbName,
			String user, String pass, String patternKey, boolean autoCommit)
			throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"getConnection(InstallerValues,"
				+ dbHost + "," + dbPort + "," + dbName
				+ "," + user + "," + pass
				+ "," + patternKey + "," + autoCommit + ")");

		// ̃\bh̖߂l
		Connection connection = null;

		try {
			// JDBChCoNX擾
			String driverClassName = values.getDbProperty("jdbcDriver");
			Class.forName(driverClassName);
			////////////////////////////////////////////////////////////////////
			// RlNV擾
			// =================================================================
			// RlNṼp^[擾
			String connectionString	= values.getDbProperty(patternKey);
			// RlNṼp[^擾
			Object[] connectionParams = new Object[] {
				// f[^x[XzXg
				dbHost,
				// |[gԍ
				dbPort,
				// f[^x[X
				dbName,
			};
			// RlNV񐶐
			connectionString = MessageFormat.format(
				connectionString, connectionParams);
			_logger.info("connectionString=[" + connectionString + "]");
			// RlNV
			connection = DriverManager.getConnection(
					connectionString, user, pass);
			connection.setAutoCommit(autoCommit);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		LoggerUtil.methodTail(_logger,
			"getConnection(InstallerValues,"
				+ dbHost + "," + dbPort + "," + dbName
				+ "," + user + "," + pass
				+ "," + patternKey + "," + autoCommit + ")");
		return connection;
	}
}
