/** @ingroup testmodule
 * @file  checkPlugin.c
 * @brief test program for communicating with Bidi module.
 *
 * Usage: checkPlugin [printer device file] [PPD file]
 *
 * @date $Date: 2004/10/22 08:32:53 $
 * @version $Revision: 1.1.1.1 $
 *
 * Copyright (C) 2004 by Turbolinux,Inc.
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <bidiEntry.h>
#include <bidiParser.h>
#include <bidiEntryCUPS.h>

#include "backendCommon.h"

int main(int argc,char **argv)
{
  int deviceFD;
  int size;
  int status_size;
  char *ppd;
  BidiWrapperObj *bidiObj;
  infoCUPS *info;

  setbuf(stderr, NULL);
  
  /* -------------------------------------------- */

  if (argc != 3){
    fprintf(stderr,"Usage: %s device PPD\n",argv[0]); 
    exit(-1);
  }

  deviceFD = open(argv[1],O_RDWR|O_EXCL,0);
  if ( deviceFD < 0 ){
    perror("can not open device file");
    exit(-1);
  }
  ppd = argv[2];

  /* -------------------------------------------- */

  initSignal();
  bidiObj = initBidi(ppd,deviceFD,getLang());
  startBidiJob(bidiObj,100);

  while( (size=readBidiStatus(bidiObj)) > 0 ){
    status_size += size;
    fprintf(stderr,"read status...%d\n",status_size);
    sleep(bidiObj->bidiReadInterval);
  }

  if(status_size > 0){
    fprintf(stderr,"read well-formed XML info\n");
    if( info = parseXML(bidiObj) ){
      char state_mesg[1024];
      char mesg_buf[256];
      static count = 0;
      
      snprintf(state_mesg,6,"INFO:");
      fprintf(stderr,"STATE:\n");
      while(info){
	fprintf(stderr,"STATE:+%s\n",info->state_reason);
	if( strlen(state_mesg)+1+strlen(info->state_messages)+1+2 < STATE_MESG_SIZE ){
	  snprintf(mesg_buf,256,"%s\t",info->state_messages);
	  strncat(state_mesg,mesg_buf,strlen(info->state_messages)+1);
	}
	info = info->next;
      }
      if(strlen(state_mesg) > 6){
	fprintf(stderr,"INFO: \n"); /* clear print status */
	fprintf(stderr,"%s\n",state_mesg);
      }
    }
  }
  deleteBidi(bidiObj);
  deleteBidiObj(bidiObj);

  close(deviceFD);
  exit(0);
}
