/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @ingroup bidiformat
 * @file entryPrtAlert.c
 * @brief functions of EntryPrtAlert object.
 * @date $Date: 2004/10/22 08:32:53 $
 * @version $Revision: 1.1.1.1 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#include <string.h>
#include <stdlib.h>

#include "bidiEntry.h"

/**
  * constructor that creates an empty EntryPrtAlert object.
  *
  * @retval NULL Fail
  * @retval *EntryPrtAlert Success
  */
EntryPrtAlert *newEntryPrtAlert(void)
{
  EntryPrtAlert *self;
  self = xmlMalloc(sizeof(EntryPrtAlert)); 
  if(!self) return NULL;
  memset(self,'\0',sizeof(EntryPrtAlert)); 
  self->next = NULL;
  return self;
}

/**
  * destructor that delete EntryPrtAlert object.
  *
  * @param self Pointer to EntryPrtAlert object
  */
void deleteEntryPrtAlt(EntryPrtAlert *self)
{
  while(self){
    EntryPrtAlert *next;
    if(self->PrtAltDesc) xmlFree(self->PrtAltDesc);
    next = self->next;
    xmlFree(self);
    self=next;
  }
}

/**
  * Function to make new EntryPrtAlert object.
  *
  * @param self Pointer to EntryPrtAlert object
  * @retval NULL Fail
  * @retval *EntryPrtAlert Success
  */
EntryPrtAlert *addEntryPrtAlt(EntryPrtAlert *self)
{
  EntryPrtAlert *newentry;
  newentry = newEntryPrtAlert();
  if(!newentry) return NULL;
  
  if(self){
    EntryPrtAlert *tmp=self;
    while(tmp->next) tmp = tmp->next;
    tmp->next = newentry;
  }else{
    self = newentry;
  }
  return self;
}

/**
  * Function to set data to EntryPrtAlert object.
  *
  * @param entPrtAlt Pointer to EntryPrtAlert object
  * @param node_name Pointer to node name string
  * @param data      Pointer to data string
  */
void setEntryPrtAlt(EntryPrtAlert *entPrtAlt,xmlChar *node_name, xmlChar *data)
{
  EntryPrtAlert *entPrtAltPtr=entPrtAlt;
  while(entPrtAltPtr->next){
    entPrtAltPtr = entPrtAltPtr->next;
  }
  if(data){
    if (xmlStrcmp(node_name, "PrtAlertSeverityLevel") == 0) {
      entPrtAltPtr->PrtAltSevLevel = atoi(data);
    } else if (xmlStrcmp(node_name, "PrtAlertGroup") == 0) {
      entPrtAltPtr->PrtAltGrp = atoi(data);
    } else if (xmlStrcmp(node_name, "PrtAlertGroupIndex") == 0) {
      entPrtAltPtr->PrtAltGrpIndex = atol(data);
    } else if (xmlStrcmp(node_name, "PrtAlertCode") == 0) {
      entPrtAltPtr->PrtAltCode = atoi(data);
    } else if (xmlStrcmp(node_name, "PrtAlertDescription") == 0) {
      entPrtAltPtr->PrtAltDesc = xmlStrdup(data);
    }
  }
}
