/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @file entryPrtAlert.h
 * @brief Type definitions of EntryPrtAlert object.
 * @date $Date: 2004/10/22 08:32:53 $
 * @version $Revision: 1.1.1.1 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#ifndef ENTRY_PRTALERT_H
#define ENTRY_PRTALERT_H

#include <bidiTypes.h>

#ifdef __cplusplus
extern "C" {
#endif

  /**
   * PrtAlertGroupIndex enumeration
   *
   * @enum enumPrtAltGrpIndex.
   */
  typedef enum {
    PRTALT_INDEX_C = 1,
    PRTALT_INDEX_M = 2,
    PRTALT_INDEX_Y = 3,
    PRTALT_INDEX_K = 4
  }enumPrtAltGrpIndex;

  /**
   * PrtAlertSeverityLevel enumeration
   *
   * @enum enumPrtAltSevLevel.
   */
  typedef enum {
    PRTALT_SEVLEV_OTHER    = 1,
    PRTALT_SEVLEV_CRITICAL = 3,
    PRTALT_SEVLEV_WARNING  = 4
  }enumPrtAltSevLevel;

  /**
   * PrtAlertGroup enumeration
   *
   * @enum enumPrtAltGrp.
   */
  typedef enum {
    PRTALT_GRP_OTHER = 1,
    PRTALT_GRP_HR_MIB_STORAGE_T = 3,
    PRTALT_GRP_HR_MIB_DEVICE_T = 4,
    PRTALT_GRP_GENERAL_PRINTER = 5,
    PRTALT_GRP_COVER = 6,
    PRTALT_GRP_LOCALIZATION = 7,
    PRTALT_GRP_INPUT = 8,
    PRTALT_GRP_OUTPUT = 9,
    PRTALT_GRP_MARKER = 10,
    PRTALT_GRP_MARKER_SUPPLIES = 11,
    PRTALT_GRP_MARKER_COLORANT = 12,
    PRTALT_GRP_MEDIA_PATH = 13,
    PRTALT_GRP_CHANNEL = 14,
    PRTALT_GRP_INTERPRETER = 15,
    PRTALT_GRP_CONSOLE_DISP_BUFFER = 16,
    PRTALT_GRP_CONTENT_LENGTH = 17
  }enumPrtAltGrp;

  /**
   * PrtAlertCode enumeration.
   *
   * @enum enumPrtAltCode.
   */
  typedef enum {
    PRTALT_CODE_OTHER = 1,
    PRTALT_CODE_UNKNOWN = 2,
    PRTALT_CODE_COVER_OPEN = 3,
    PRTALT_CODE_COVER_CLOSED = 4,
    PRTALT_CODE_INTLOCK_OPEN = 5,
    PRTALT_CODE_INTLOCK_CLOSED = 6,
    PRTALT_CODE_CONFIG_CHANGED = 7,
    PRTALT_CODE_JAM = 8,
    PRTALT_CODE_DOOR_OPEN = 501,
    PRTALT_CODE_DOOR_CLOSED = 502,
    PRTALT_CODE_POWER_UP = 503,
    PRTALT_CODE_POWER_DOWN = 504,
    PRTALT_CODE_INPUT_MEDIASUPP_EMPTY = 808,
    PRTALT_CODE_IKN_EMPTY = 1102,
    PRTALT_CODE_IKN_ALMOST_EMPTY = 1105
  }enumPrtAltCode;

  /**
   * The structure that containing the PrtAlertEntry messages.
   *
   * @struct EntryPrtAlert.
   */
  typedef struct _EntryPrtAlert{
    struct _EntryPrtAlert *next;          /**< link to self. */      
    enumPrtAltSevLevel PrtAltSevLevel;    /**< PrtAlertSeverityLevel enumeration. */
    enumPrtAltGrp PrtAltGrp;         /**< PrtAlertGroup enumeration. */
    enumPrtAltGrpIndex PrtAltGrpIndex;  /**< PrtAlertGroupIndex enumeration. */
    enumPrtAltCode PrtAltCode;        /**< PrtAlertCode enumeration. */
    OSTRING *PrtAltDesc;   /**< PrtAlertDescription enumeration. */
  } EntryPrtAlert;

  //Prototypes
  
  EntryPrtAlert *newEntryPrtAlert(void);
  void deleteEntryPrtAlt(EntryPrtAlert*);
  EntryPrtAlert *addEntryPrtAlt(EntryPrtAlert*);
  void setEntryPrtAlt(EntryPrtAlert*,xmlChar*,xmlChar*);

#ifdef __cplusplus
}
#endif

#endif
