dnl
dnl This file is part of the 'OpenPrinting Japan' project
dnl $Id: libBidiPlugin.m4,v 1.1.1.1 2004/10/22 08:38:30 gishi Exp $
dnl
dnl Copyright (C) 2004 by Turbolinux,Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl AC_OPFC_CHECK_BIDIPLUGIN([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for bidiPlugin library, and define BIDIPLUGIN_CFLAGS,BIDIPLUGIN_LIBS
dnl
AC_DEFUN(AC_CHECK_OPFC_BIDIPLUGIN,
[dnl
dnl Save the original CFLAGS, LDFLAGS, and LIBS
dnl
plugin_save_CFLAGS="$CFLAGS"
plugin_save_LIBS="$LIBS"
plugin_save_LDFLAGS="$LDFLAGS"
plugin_found=yes

dnl
dnl Set default variable
dnl
BIDIPLUGIN_CFLAGS=""
BIDIPLUGIN_LIBS=""

dnl
dnl Get the CFLAGS and libraries
dnl
AC_ARG_WITH(bidiplugin,
	[  --with-bidiplugin=DIR   Prefix where bidi-plugin is installed (optional)], 
	bidiplugin_prefix="$withval", bidiplugin_prefix="")

AC_ARG_WITH(bidiplugin-includes,
	[  --with-bidiplugin-includes=DIR   Directory where libbidi-plugin header files are installed (optional)],
	bidiplugin_includes="$withval", bidiplugin_includes="")

AC_ARG_WITH(bidiplugin-libraries,
	[  --with-bidiplugin-libraries=DIR   Directory where libbidi-plugin library is installed (optional)],
	bidiplugin_libraries="$withval", bidiplugin_libraries="")

AC_ARG_ENABLE(plugintest,
	[  --disable-bidiplugintest       Do not try to compile and run a test bidiplugin program],
	[], enable_plugintest=yes)

AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
if test x"$PKG_CONFIG" = x"no" ; then
  AC_MSG_WARN([could not find bidiPlugin.pc on your system.Did you installed bidiPlugin-devel package?])
fi
BIDIPLUGIN_CFLAGS=`$PKG_CONFIG --cflags libBidiPlugin`
BIDIPLUGIN_LIBS=`$PKG_CONFIG --libs libBidiPlugin`

AC_MSG_CHECKING(for bidiPlugin)

dnl
dnl Now check bidiplugin headers and libraries
dnl
if test "x$enable_plugintest" = "xyes" ; then
  CFLAGS="$CFLAGS $BIDIPLUGIN_CFLAGS"
  LIBS="$LIBS $BIDIPLUGIN_LIBS"
AC_TRY_COMPILE([
#include <stdio.h>
#include <bidiPlugin.h>
#include <bidiDbg.h>
],[
  BidiC *p;
  p = bidiNew("bidiPluginName",0,0,NULL);
  exit(0);
],
  [AC_MSG_RESULT(found.)],
  [AC_MSG_RESULT(not present.)
   ifelse([$3], , [AC_MSG_ERROR(Sufficiently bidiPlugin library not found.)])
   plugin_found=no]
)
fi

if test "x$plugin_found" = "xno" ; then
   ifelse([$3], , :, [$3])
   BIDIPLUGIN_CFLAGS=""
   BIDIPLUGIN_LIBS=""
fi

CFLAGS="$plugin_save_CFLAGS"
LDFLAGS="$plugin_save_LDFLAGS"
LIBS="$plugin_save_LIBS"

AC_SUBST(BIDIPLUGIN_CFLAGS)
AC_SUBST(BIDIPLUGIN_LIBS)

])
