/**
 * @file  bidiDbg.h
 * @brief Header file of common debug function
 *
 * @date 2004/02/13
 * @version 1.0.0
 *
 * Copyright (c) 2002-2004, BBR Co.Ltd., All rights reserved.
 */
/*
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _BIDIDBG_H
#define _BIDIDBG_H

#ifdef DEBUG

#define _dbgPrint(msg) \
    fprintf(stderr, "bidi: %s(%d): %s\n", __FUNCTION__, __LINE__, msg)

#else // not DEBUG

/**
 * Function for the debug printing avaiable only in debug version.
 * @param msg Print message.
 */
#define _dbgPrint(msg)

#endif // DEBUG

#endif // _BIDIDBG_H
