/**
 * @file  testBidiPlugin.c
 * @brief Test program for Bi-di Plug-in caller API
 *
 * @date 2004/02/02
 * @version 0.1 beta
 *
 * Copyright (c) 2002-2003, BBR Co.Ltd., All rights reserved.
 */
/*
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "bidiPlugin.h"
#include "bidiDbg.h"

int main(int argc, char *argv[])
{
    int ret;

    // å
/*
    // Process type ѥƥȥ
    if (argc == 1) {
        fprintf(stderr, "** start testBidiPlugin for Proccess\n");
        // test bidiNew
        BidiC *p;
        p = bidiNew("testBidiProc", 1, 1, "urn:xxxx");
        if (p == 0) {
            fprintf(stderr, "** error in bidiNew.\n");
            exit(-1);
        }
        bidiDestroy(p);
        exit(0);
    }
*/
    if (argc != 3) {
        fprintf(stderr, "Usage: %s dev_file xml_file\n", argv[0]);
        exit(-1);
    }

    fprintf(stderr, "** start testBidiPlugin\n");

    // devեΥץ
    int fd = open(argv[1], O_RDWR, 0);
    if (fd < 0) {
        fprintf(stderr, "** dev file open error. [%s]\n", argv[1]);
        exit(fd);
    }

    // xmlϥեΥץ
    FILE *fp = fopen(argv[2], "w");
    if (fp == NULL) {
        fprintf(stderr, "** xml file open error. [%s]\n", argv[2]);
        exit(-1);
    }

    // test bidiNew
    BidiC *p;
    p = bidiNew("bidiPIXUS850i", fd, fd, NULL);
    if (p == 0) {
        fprintf(stderr, "** error in bidiNew.\n");
        exit(-1);
    }

    // test bidiGetCap
    ret = bidiGetCap(p, BIDI_CAP_WRITE);
    if (ret == BIDI_TRUE) {
        printf("** Cap Write OK!\n");
    } else {
        printf("** Cap Write NG!\n");
    }
    ret = bidiGetCap(p, BIDI_CAP_JOB);
    if (ret == BIDI_TRUE) {
        printf("** Cap Job OK!\n");
    } else {
        printf("** Cap Job NG!\n");
    }
    ret = bidiGetCap(p, BIDI_CAP_CTRL);
    if (ret == BIDI_TRUE) {
        printf("** Cap Ctrl OK!\n");
    } else {
        printf("** Cap Ctrl NG!\n");
    }

    // test bidiGetReadFD
    ret = bidiGetReadFD(p);
    printf("** read fd: %d\n", ret);

    // test bidiGetWriteFD
    ret = bidiGetWriteFD(p);
    printf("** write fd: %d\n", ret);

    bidiStartJob(p, 10);

    int i;
    char buf[513];
    for (i = 0; i < 2; i++) {
        printf("** read printer status\n");

        // test bidiStartRead
//        ret = bidiStartRead(p, BIDI_READ_PRT_MIB_SUMMARY, "ja_JP.UTF-8");
        ret = bidiStartRead(p, BIDI_READ_PRT_MIB_SUMMARY, "xx");
        if (ret == BIDI_ERROR) {
            fprintf(stderr, "** bidiStartRead error.\n");
            exit(-1);
        }

        // test bidiRead
        for (;;) {
            memset((void *)buf, 0, 513);
            ret = bidiRead(p, buf, 512);
            if (ret == 0) break;
            if (ret == BIDI_ERROR) {
                fprintf(stderr, "** bidiRead error.\n");
                exit(-1);
            }
            if (fputs(buf, fp) == EOF) {
                fprintf(stderr, "** fputs to xml file error.\n");
                exit(-1);
            }
            fflush(fp);
//            printf("%d: %s\n", ret, buf);
        }
        fputs("*** end of XML ***\n", fp);
        // test bidiEndRead
        ret = bidiEndRead(p);
        if (ret == BIDI_ERROR) {
            fprintf(stderr, "** bidiEndRead error.\n");
            exit(-1);
        }
        sleep(2);
    }

    while ((ret = bidiEndJob(p)) == BIDI_EPROGRESS) {
        printf("** printer is BUSY.\n");
        sleep(3);
    }

    bidiDestroy(p);
    fclose(fp);

    exit(0);
}
